/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.utils;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.component.track.commons.utils.TransactionTrackContextUtils;
import com.dtyunxi.tcbj.app.open.biz.config.NutritionConfig;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NutritionClient {
    private static final Logger logger = LoggerFactory.getLogger(NutritionClient.class);
    @Resource
    private NutritionConfig nutritionConfig;
    private static NutritionConfig NUTRITION_CONFIG;

    @PostConstruct
    public void init() {
        NutritionClient nutritionClient = new NutritionClient();
        NUTRITION_CONFIG = this.nutritionConfig;
    }

    public static String execute(String api, Object data) {
        logger.info("\u8425\u517b\u5bb6\u670d\u52a1\u8bf7\u6c42\uff1a{}\uff0c{}", (Object)api, (Object)(ObjectUtil.isNotEmpty((Object)data) ? JSON.toJSONString((Object)data) : "\u65e0\u5165\u53c2"));
        if (StringUtils.isBlank((CharSequence)api)) {
            throw new BizException("\u8bf7\u6c42api\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String url = NUTRITION_CONFIG.buildRequestServiceUrl(api);
        String bodyParams = JSON.toJSONString((Object)data);
        logger.info("\u8bf7\u6c42\u8def\u5f84\uff1a{}", (Object)url);
        logger.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)bodyParams);
        HttpRequest post = HttpUtil.createPost((String)url);
        post.body(bodyParams);
        TransactionTrackContextUtils.setTrackLogRequestData((String)"requestUrl", (Object)url);
        TransactionTrackContextUtils.setTrackLogRequestData((String)"requestData", (Object)bodyParams);
        Instant start = Instant.now();
        HttpResponse httpResponse = post.execute();
        String body = httpResponse.body();
        Instant end = Instant.now();
        logger.info("\u6267\u884c\u8425\u517b\u5bb6API\u8bf7\u6c42\u54cd\u5e94\uff0c\u8017\u65f6\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", (Object)Duration.between(start, end).toMillis(), (Object)body);
        return body;
    }
}

