/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.openapi.qimen.weizhi.util;

import com.dtyunxi.huieryun.log.LoggerFactory;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import liquibase.util.StringUtils;
import org.slf4j.Logger;

public class SignUtil {
    private static final Logger logger = LoggerFactory.getLogger(SignUtil.class);

    public static String signTopRequest(Map<String, String> params, String secret, String signMethod) throws Exception {
        byte[] bytes;
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder query = new StringBuilder();
        if ("md5".equals(signMethod)) {
            query.append(secret);
        }
        for (Object key : keys) {
            String value = params.get(key);
            if (!StringUtils.isNotEmpty((String)key) || !StringUtils.isNotEmpty((String)value) || "sign".equals(key)) continue;
            query.append((String)key).append(value);
        }
        if ("hmac".equals(signMethod)) {
            bytes = SignUtil.encryptHMAC(query.toString(), secret);
        } else {
            if ("hmac-sha256".equals(signMethod)) {
                return SignUtil.shaHMAC(query.toString(), secret);
            }
            query.append(secret);
            bytes = SignUtil.encryptMD5(query.toString());
        }
        return SignUtil.byte2hex(bytes);
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuilder hs = new StringBuilder();
        for (int n = 0; b != null && n < b.length; ++n) {
            String stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append('0');
            }
            hs.append(stmp);
        }
        return hs.toString().toLowerCase();
    }

    private static String shaHMAC(String message, String secret) {
        String hash = "";
        try {
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(secret.getBytes(), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            byte[] bytes = sha256_HMAC.doFinal(message.getBytes());
            hash = SignUtil.byteArrayToHexString(bytes);
            logger.info("shaHMAC:{}", (Object)hash.toUpperCase());
        }
        catch (Exception e) {
            logger.error("shaHMACError:{}", (Throwable)e);
        }
        return hash.toUpperCase();
    }

    public static byte[] encryptHMAC(String data, String secret) throws IOException {
        byte[] bytes = null;
        try {
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacMD5");
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            bytes = mac.doFinal(data.getBytes(StandardCharsets.UTF_8));
        }
        catch (GeneralSecurityException gse) {
            throw new IOException(gse.toString());
        }
        return bytes;
    }

    public static byte[] encryptMD5(String data) throws Exception {
        return SignUtil.encryptMD5(data.getBytes(StandardCharsets.UTF_8));
    }

    public static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        return sign.toString();
    }

    public static byte[] encryptMD5(byte[] bytes) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("md5");
        md.update(bytes);
        return md.digest();
    }

    public static Map<String, String> sortByKey(Map<String, String> map) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(String::compareTo);
        treeMap.putAll(map);
        return treeMap;
    }
}

