/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.pms.biz.service.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.pms.biz.model.AddLogicWarehouseParams;
import com.dtyunxi.tcbj.pms.biz.model.DeleteLogicWarehouseParams;
import com.dtyunxi.tcbj.pms.biz.model.DtoExchangeUtils;
import com.dtyunxi.tcbj.pms.biz.model.GetLogicWarehouseListPageParams;
import com.dtyunxi.tcbj.pms.biz.model.LogicWarehouseVO;
import com.dtyunxi.tcbj.pms.biz.model.UpdateLogicWarehouseStatusParams;
import com.dtyunxi.tcbj.pms.biz.service.InventoryCenterWarehouseBaseLogicService;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsWarehouseAddressAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class InventoryCenterWarehouseBaseLogicServiceServiceImpl
implements InventoryCenterWarehouseBaseLogicService {
    @Resource
    private ICsLogicWarehouseApi csLogicWarehouseApi;
    @Resource
    private ICsLogicWarehouseQueryApi csLogicWarehouseQueryApi;

    @Override
    public RestResponse<Object> addLogicWarehouse(@ApiParam(value="") @Valid @RequestBody(required=false) AddLogicWarehouseParams addLogicWarehouseParams) {
        CsWarehouseAddressAddReqDto warehouseAddress = addLogicWarehouseParams.getWarehouseAddress();
        CsLogicWarehouseAddReqDto csLogicWarehouseAddReqDto = DtoExchangeUtils.createDtoBySource(addLogicWarehouseParams, CsLogicWarehouseAddReqDto.class);
        csLogicWarehouseAddReqDto.setNegativeFlag(addLogicWarehouseParams.getWarehouseIsNegative());
        csLogicWarehouseAddReqDto.setWarehouseAddress(warehouseAddress);
        return new RestResponse((Object)this.csLogicWarehouseApi.addLogicWarehouse(csLogicWarehouseAddReqDto));
    }

    @Override
    public RestResponse<Object> deleteLogicWarehouse(@ApiParam(value="") @Valid @RequestBody(required=false) DeleteLogicWarehouseParams deleteLogicWarehouseParams) {
        for (String id : deleteLogicWarehouseParams.getWarehouseIds()) {
            RestResponse restResponse = this.csLogicWarehouseApi.delete(Long.valueOf(id));
            RestResponseHelper.extractData((RestResponse)restResponse);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<LogicWarehouseVO> getLogicWarehouseById(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        RestResponse restResponse = this.csLogicWarehouseQueryApi.queryByPrimaryKey(Long.valueOf(id));
        CsLogicWarehouseRespDto csLogicWarehouseRespDto = (CsLogicWarehouseRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
        if (csLogicWarehouseRespDto != null) {
            LogicWarehouseVO logicWarehouseVO = DtoExchangeUtils.createDtoBySource(csLogicWarehouseRespDto, LogicWarehouseVO.class);
            logicWarehouseVO.setWarehouseIsNegative(csLogicWarehouseRespDto.getNegativeFlag());
            return new RestResponse((Object)logicWarehouseVO);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<LogicWarehouseVO>> getLogicWarehouseListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetLogicWarehouseListPageParams getLogicWarehouseListPageParams) {
        CsLogicWarehouseQueryDto csLogicWarehouseQueryDto = DtoExchangeUtils.createDtoBySource(getLogicWarehouseListPageParams, CsLogicWarehouseQueryDto.class);
        RestResponse pageInfoRestResponse = this.csLogicWarehouseQueryApi.queryByPage(csLogicWarehouseQueryDto);
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        if (respDtoPageInfo != null) {
            PageInfo dtoPageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            List<LogicWarehouseVO> dtoList = DtoExchangeUtils.createDtoListBySource(respDtoPageInfo.getList(), LogicWarehouseVO.class);
            dtoPageInfo.setList(dtoList);
            return new RestResponse((Object)dtoPageInfo);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> updateLogicWarehouseStatus(@ApiParam(value="") @Valid @RequestBody(required=false) UpdateLogicWarehouseStatusParams updateLogicWarehouseStatusParams) {
        CsLogicWarehouseUpdateReqDto csLogicWarehouseUpdateReqDto = DtoExchangeUtils.createDtoBySource(updateLogicWarehouseStatusParams, CsLogicWarehouseUpdateReqDto.class);
        for (String id : updateLogicWarehouseStatusParams.getWarehouseIds()) {
            RestResponse restResponse = this.csLogicWarehouseApi.update(Long.valueOf(id), csLogicWarehouseUpdateReqDto);
            RestResponseHelper.extractData((RestResponse)restResponse);
        }
        return new RestResponse();
    }
}

