/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.portal.svr.service.impl.integration;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.tcbj.portal.svr.dto.request.UserPasswordRequestDto;
import com.dtyunxi.tcbj.portal.svr.dto.response.MarketingTokenResponseDto;
import com.dtyunxi.tcbj.portal.svr.service.impl.integration.MarketingTokenVerificationServiceImpl;
import com.dtyunxi.tcbj.portal.svr.service.integration.MarketingUpdatePasswordService;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class MarketingUpdatePasswordServiceImpl
implements MarketingUpdatePasswordService {
    private static final Logger logger = LoggerFactory.getLogger(MarketingTokenVerificationServiceImpl.class);
    @Value(value="${marketing.password.url}")
    private String passwordUrl;
    @Resource
    private RestTemplate restTemplate;

    @Override
    public MarketingTokenResponseDto updatePassword(UserPasswordRequestDto requestDto) {
        if (StringUtils.isBlank((CharSequence)requestDto.getUserId())) {
            throw new BizException("\u4f20\u5165\u7684userId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)requestDto.getOldPass())) {
            throw new BizException("\u4f20\u5165\u7684oldPass\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)requestDto.getNewPass())) {
            throw new BizException("\u4f20\u5165\u7684newPass\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)requestDto.getConfirmNewPass())) {
            throw new BizException("\u4f20\u5165\u7684confirmNewPass\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, UserPasswordRequestDto> map = new HashMap<String, UserPasswordRequestDto>();
        map.put("request", requestDto);
        logger.info("\u4fee\u6539\u5bc6\u7801\u53c2\u6570\u7ec4\u88c5\uff1a{}", (Object)JSONObject.toJSONString(map));
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        String param = JSONObject.toJSONString(map);
        HttpEntity formEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        String s = (String)this.restTemplate.postForObject(this.passwordUrl, (Object)formEntity, String.class, new Object[0]);
        MarketingTokenResponseDto marketingTokenResponseDto = (MarketingTokenResponseDto)JSON.parseObject((String)s, MarketingTokenResponseDto.class);
        logger.info("\u6253\u5370\u8425\u9500\u4e91\u8fd4\u56de\u7684\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)marketingTokenResponseDto));
        return marketingTokenResponseDto;
    }
}

