/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.partner.citic.util;

import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.util.MyHostnameVerifier;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class HttpsPost {
    private static Logger logger = LoggerFactory.getLogger(HttpsPost.class);

    public static KeyStore getKeyStore(String password, String keyStorePath) throws Exception {
        KeyStore ks = null;
        ks = KeyStore.getInstance("JKS");
        FileInputStream is = new FileInputStream(keyStorePath);
        ks.load(is, password.toCharArray());
        is.close();
        return ks;
    }

    public static SSLContext getSSLContext(String password, String keyStorePath, String trustStorePath) throws Exception {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore keyStore = HttpsPost.getKeyStore(password, keyStorePath);
        keyManagerFactory.init(keyStore, password.toCharArray());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore trustStore = HttpsPost.getKeyStore(password, trustStorePath);
        trustManagerFactory.init(trustStore);
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        return ctx;
    }

    public static void initHttpsURLConnection(String password, String keyStorePath, String trustStorePath) throws Exception {
        SSLContext sslContext = null;
        MyHostnameVerifier hnv = new MyHostnameVerifier();
        try {
            sslContext = HttpsPost.getSSLContext(password, keyStorePath, trustStorePath);
        }
        catch (GeneralSecurityException var6) {
            var6.printStackTrace();
        }
        if (sslContext != null) {
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        }
        HttpsURLConnection.setDefaultHostnameVerifier(hnv);
    }

    private static void trustAllHttpsCertificates() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[1];
        miTM tm = new miTM();
        trustAllCerts[0] = tm;
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    public static String post(String httpsUrl, String xmlStr) {
        if (StringUtils.isBlank((CharSequence)httpsUrl)) {
            logger.error("\u8bf7\u6c42url\u4e3a\u7a7a \uff01");
            return null;
        }
        if (StringUtils.isBlank((CharSequence)xmlStr)) {
            logger.error("\u53d1\u9001\u5185\u5bb9\u4e3a\u7a7a \uff01");
            return null;
        }
        HttpsURLConnection urlCon = null;
        try {
            String line;
            HttpsPost.trustAllHttpsCertificates();
            urlCon = (HttpsURLConnection)new URL(httpsUrl).openConnection();
            logger.info("executing request: " + urlCon.getURL());
            urlCon.setDoInput(true);
            urlCon.setDoOutput(true);
            urlCon.setRequestMethod("POST");
            urlCon.setRequestProperty("Content-Length", String.valueOf(xmlStr.getBytes().length));
            urlCon.setUseCaches(false);
            urlCon.getOutputStream().write(xmlStr.getBytes("UTF-8"));
            logger.info("HTTPS,POST\u8fc7\u53bb\u7684\u6570\u636e\u662f: \n" + xmlStr);
            urlCon.getOutputStream().flush();
            urlCon.getOutputStream().close();
            BufferedReader in = new BufferedReader(new InputStreamReader(urlCon.getInputStream()));
            StringBuilder strBuff = new StringBuilder();
            while ((line = in.readLine()) != null) {
                strBuff.append(line);
            }
            logger.info("HTTPS,\u670d\u52a1\u5668\u54cd\u5e94\u7ed3\u679c\u662f: \n" + strBuff.toString());
            return strBuff.toString();
        }
        catch (Exception e) {
            logger.error("HTTPS post error", (Throwable)e);
            return null;
        }
    }

    static class miTM
    implements TrustManager,
    X509TrustManager {
        miTM() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }
    }
}

