/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.gateway.swiftpass.impl;

import com.dtyunxi.tcbj.dao.eo.SwiftpassFinanceFileEo;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.TradeIdType;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.DefaultGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.CheckResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.NotifyAssitantVo;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.swiftpass.AbstractSpGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.swiftpass.AbstractSpQueryGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.swiftpass.SpGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.domain.notify.SpNotifyMsg;
import com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.domain.response.SpDownloadOrderResponse;
import com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.domain.response.SpPlaceResponse;
import com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.domain.response.SpQueryResponse;
import com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.domain.response.SpRefundQueryResponse;
import com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.domain.response.SpRefundResponse;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.RefundOrderEo;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="spGatewayService")
public class SpGatewayServiceImpl
extends DefaultGatewayService
implements SpGatewayService {
    @Resource
    private AbstractSpGatewayService<RefundOrderEo, SpRefundResponse> spRefundOrderCreateService;
    @Resource
    private AbstractSpGatewayService<PayOrderEo, SpPlaceResponse> spPayOrderCreateGatewayService;
    @Resource
    private AbstractSpGatewayService<NotifyAssitantVo, SpNotifyMsg> spPayOrderNotifyGatewayService;
    @Resource
    private AbstractSpQueryGatewayService<SpQueryResponse> spPayOrderQueryGatewayService;
    @Resource
    private AbstractSpQueryGatewayService<SpRefundQueryResponse> spRefundOrderQueryGatewayService;
    @Resource
    private AbstractSpGatewayService<SwiftpassFinanceFileEo, SpDownloadOrderResponse> spDownloadOrderServiceImpl;

    public CheckResult checkOrder(String tradeId) {
        return TradeIdType.verifyIdType((String)tradeId, (TradeIdType)TradeIdType.PAY) ? (CheckResult)this.spPayOrderQueryGatewayService.execute(tradeId) : (CheckResult)this.spRefundOrderQueryGatewayService.execute(tradeId);
    }

    public BaseGatewayResult handleNotify(Map<String, String> notify, String ntfyTradeId) throws Exception {
        return this.spPayOrderNotifyGatewayService.execute(new NotifyAssitantVo(ntfyTradeId, notify));
    }

    public BaseGatewayResult createPayTrade(PayOrderEo order) {
        return this.spPayOrderCreateGatewayService.execute(order);
    }

    public BaseGatewayResult createRefundTrade(RefundOrderEo order) {
        return this.spRefundOrderCreateService.execute(order);
    }

    public SpDownloadOrderResponse downloadSwiftpassOrderFile(SwiftpassFinanceFileEo swiftpassFinanceFileEo) throws Exception {
        return (SpDownloadOrderResponse)((Object)this.spDownloadOrderServiceImpl._execute(swiftpassFinanceFileEo));
    }
}

