/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.gateway.swiftpass.impl.trade;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.GatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.swiftpass.AbstractSpGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.domain.request.SpRefundRequest;
import com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.domain.response.SpRefundResponse;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.OrderAssistant;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.RefundOrderEo;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service(value="spRefundOrderCreateService")
@Transactional(transactionManager="paymentCenterDataSourceTransactionManager", rollbackFor={Exception.class})
public class SpRefundOrderCreateServiceImpl
extends AbstractSpGatewayService<RefundOrderEo, SpRefundResponse> {
    @Resource
    private ICommonsMqService commonsMqService;

    public BaseGatewayResult rechargeResult(final RefundOrderEo payRefundOrder, SpRefundResponse response) throws Exception {
        GatewayResult result = this.parseResponse(response, payRefundOrder.getRefundId());
        RefundOrderEo partnerOrder = OrderAssistant.createRefundOrder((String)response.getOutRefundNo(), (Date)new Date());
        if ("0".equals(response.getResultCode()) && "0".equals(response.getStatus())) {
            this.payRefundOrderProcessorService.handleAcceptOrder((Object)partnerOrder);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCommit() {
                    SpRefundOrderCreateServiceImpl.this.logger.info("\u9000\u6b3e\u7533\u8bf7\u5df2\u6210\u529f\uff0c\u7533\u8bf7\u4e8b\u52a1\u5df2\u63d0\u4ea4, \u53d1\u9001checkMQ\u68c0\u67e5\u9000\u6b3e\u72b6\u6001");
                    MessageResponse messageResponse = SpRefundOrderCreateServiceImpl.this.commonsMqService.sendDelaySingleMessage("YX_PAY_ORDER_CHECK", (Object)payRefundOrder.getRefundId(), Long.valueOf(10L));
                    SpRefundOrderCreateServiceImpl.this.logger.info("\u53d1\u9001checkMQ\u68c0\u67e5\u9000\u6b3e\u6210\u529f{}", (Object)JSON.toJSONString((Object)messageResponse));
                }
            });
        } else {
            if (!"0".equals(response.getStatus())) {
                payRefundOrder.setErrorCode(response.getStatus());
                payRefundOrder.setErrorMsg(response.getMessage());
            } else {
                payRefundOrder.setErrorCode(response.getErrCode());
                payRefundOrder.setErrorMsg(response.getErrMsg());
            }
            this.payRefundOrderProcessorService.handleFailOrder((Object)payRefundOrder);
        }
        return result;
    }

    public SpRefundResponse _execute(RefundOrderEo payRefundOrder) throws Exception {
        PartnerConfigEo config = (PartnerConfigEo)this.payPartnerConfigDas.selectByLogicKey((Object)payRefundOrder.getPartnerConfigCode());
        PayOrderEo payOrder = (PayOrderEo)this.payOrderDas.selectByLogicKey((Object)payRefundOrder.getTradeId());
        SpRefundRequest request = new SpRefundRequest();
        request.setMchId(config.getPtMerId());
        request.setService("unified.trade.refund");
        request.setOpUserId(config.getPtMerId());
        request.setOutRefundNo(payRefundOrder.getRefundId());
        request.setTotalFee(payOrder.getAmount().movePointRight(2).toString());
        request.setRefundFee(payRefundOrder.getAmount().movePointRight(2).toString());
        request.setOutTradeNo(OrderAssistant.getOutTradeNo((PayOrderEo)payOrder));
        request.setTransactionId(payOrder.getPartnerOrderId());
        request.setEncryptKey(config.getLcPrivKey());
        request.setDecryptKey(config.getPtPubKey());
        return (SpRefundResponse)((Object)this.spPartnerService.refundOrder((Object)request));
    }

    public void validate(RefundOrderEo payRefundOrder, SpRefundResponse response) throws Exception {
    }
}

