/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.unionpay.gateway.cscanb.impl.notify;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.OrderAssistant;
import com.dtyunxi.yundt.cube.center.payment.service.trade.processor.OrderProcessorService;
import com.dtyunxi.yundt.cube.center.payment.unionpay.config.UnionPayConfig;
import com.dtyunxi.yundt.cube.center.payment.unionpay.partner.domain.notify.BillPaymentDto;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.PayOrderDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderAttachInfoEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Service(value="cscanbPayNotifyGatewayServiceImpl")
public class CscanbPayNotifyGatewayServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(CscanbPayNotifyGatewayServiceImpl.class);
    @Resource
    private UnionPayConfig unionPayConfig;
    @Resource
    private PayOrderDas payOrderDas;
    @Resource
    protected OrderProcessorService<PayOrderEo, PayOrderAttachInfoEo> payOrderProcessorWrapperService;

    public String _execute(Map<String, String> map) throws Exception {
        String tradeId = map.get("billNo");
        if (StringUtils.isBlank((CharSequence)tradeId)) {
            log.error("\u6e20\u9053\u901a\u77e5\u5931\u8d25\uff0c\u8ba2\u5355\u4e0d\u5b58\u5728\u3002");
            return "FAILED";
        }
        if ("PAID".equals(map.get("billStatus"))) {
            String payTime = map.get("payTime");
            BillPaymentDto paymentDto = (BillPaymentDto)JSON.parseObject((String)map.get("billPayment"), BillPaymentDto.class);
            PayOrderEo partnerOrder = OrderAssistant.createPayOrder((String)tradeId, (Date)DateUtil.parseDate((String)payTime, (String)"yyyy-MM-dd HH:mm:ss"));
            PayOrderAttachInfoEo payOrderAttachInfoEo = PayOrderAttachInfoEo.newInstance();
            payOrderAttachInfoEo.setTradeId(tradeId);
            payOrderAttachInfoEo.setRemark1(paymentDto.getTargetOrderId());
            payOrderAttachInfoEo.setRemark2(map.get("seqId"));
            payOrderAttachInfoEo.setRemark3(map.get("notifyId"));
            payOrderAttachInfoEo.setRemark4(paymentDto.getTargetSys());
            payOrderAttachInfoEo.setExtension(JSON.toJSONString((Object)map.get("billPayment")));
            partnerOrder.setPartnerOrderId(paymentDto.getMerOrderId());
            BigDecimal amount = new BigDecimal(map.get("totalAmount"));
            BigDecimal aamount = amount.divide(new BigDecimal("100"), 2, 1);
            partnerOrder.setAmount(aamount);
            this.payOrderProcessorWrapperService.handleSuccOrder((Object)partnerOrder, (Object)payOrderAttachInfoEo);
            return "SUCCESS";
        }
        if ("CLOSED".equals(map.get("billStatus"))) {
            PayOrderEo partnerOrder = OrderAssistant.createPayOrder((String)tradeId);
            partnerOrder.setErrorCode("CLOSED");
            partnerOrder.setErrorMsg("\u8d26\u5355\u5173\u95ed");
            this.payOrderProcessorWrapperService.handleFailOrder((Object)partnerOrder);
            return "FAILED";
        }
        return "FAILED";
    }
}

