/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.unionpay.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class UnionPayUtil {
    public static String getMerOrderId(String msgSrcId) {
        return msgSrcId + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS") + RandomStringUtils.randomNumeric((int)7);
    }

    public static String getRefundOrderId(String msgSrcId) {
        return msgSrcId + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS") + RandomStringUtils.randomNumeric((int)7);
    }

    public static Map<String, String> getRequestParams(HttpServletRequest request) {
        Map params = request.getParameterMap();
        HashMap<String, String> params2 = new HashMap<String, String>();
        for (String key : params.keySet()) {
            String[] values = (String[])params.get(key);
            if (values.length <= 0) continue;
            params2.put(key, request.getParameter(key));
        }
        return params2;
    }

    public static String makeSign(String md5Key, Map<String, String> params) {
        String preStr = UnionPayUtil.buildSignString(params);
        String text = preStr + md5Key;
        System.out.println("\u5f85\u7b7e\u540d\u5b57\u7b26\u4e32\uff1a" + text);
        return DigestUtils.md5Hex((byte[])UnionPayUtil.getContentBytes(text)).toUpperCase();
    }

    public static String buildSignString(Map<String, String> params) {
        if (params == null || params.size() == 0) {
            return "";
        }
        ArrayList<String> keys = new ArrayList<String>(params.size());
        for (String key : params.keySet()) {
            if ("sign".equals(key) || StringUtils.isEmpty((CharSequence)params.get(key))) continue;
            keys.add(key);
        }
        Collections.sort(keys);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            if (i == keys.size() - 1) {
                buf.append(key + "=" + value);
                continue;
            }
            buf.append(key + "=" + value + "&");
        }
        return buf.toString();
    }

    public static byte[] getContentBytes(String content) {
        try {
            return content.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u7b7e\u540d\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef");
        }
    }

    public static String getAuthorization(String appid, String appkey, String timestamp, String nonce, String body) throws Exception {
        byte[] data = body.getBytes("utf-8");
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        String testSH = DigestUtils.sha256Hex((InputStream)is);
        String s1 = appid + timestamp + nonce + testSH;
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(appkey.getBytes("utf-8"), "HmacSHA256"));
        byte[] localSignature = mac.doFinal(s1.getBytes("utf-8"));
        String localSignatureStr = Base64.encodeBase64String((byte[])localSignature);
        return "OPEN-BODY-SIG AppId=\"" + appid + "\", Timestamp=\"" + timestamp + "\", Nonce=\"" + nonce + "\", Signature=\"" + localSignatureStr + "\"";
    }

    public static String getSignature(String appid, String appkey, String timestamp, String nonce, String body) throws Exception {
        byte[] data = body.getBytes("utf-8");
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        String testSH = DigestUtils.sha256Hex((InputStream)is);
        String s1 = appid + timestamp + nonce + testSH;
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(appkey.getBytes("utf-8"), "HmacSHA256"));
        byte[] localSignature = mac.doFinal(s1.getBytes("utf-8"));
        String localSignatureStr = Base64.encodeBase64String((byte[])localSignature);
        return localSignatureStr;
    }

    public static String getOpenBodySig(String appId, String appKey, String body, Date date) throws Exception {
        String timestamp = new SimpleDateFormat("yyyyMMddHHmmss").format(date);
        String nonce = UUID.randomUUID().toString().replace("-", "");
        byte[] data = body.getBytes("UTF-8");
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        String bodyDigest = UnionPayUtil.testSHA256(is);
        String str1_C = appId + timestamp + nonce + bodyDigest;
        byte[] localSignature = UnionPayUtil.hmacSHA256(str1_C.getBytes(), appKey.getBytes());
        String localSignatureStr = Base64.encodeBase64String((byte[])localSignature);
        System.out.println("Authorization:\nOPEN-BODY-SIG AppId=\"" + appId + "\", Timestamp=\"" + timestamp + "\", Nonce=\"" + nonce + "\", Signature=\"" + localSignatureStr + "\"\n");
        return "OPEN-BODY-SIG AppId=\"" + appId + "\", Timestamp=\"" + timestamp + "\", Nonce=\"" + nonce + "\", Signature=\"" + localSignatureStr + "\"";
    }

    private static String testSHA256(InputStream is) {
        try {
            return DigestUtils.sha256Hex((InputStream)is);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] hmacSHA256(byte[] data, byte[] key) throws NoSuchAlgorithmException, InvalidKeyException {
        String algorithm = "HmacSHA256";
        Mac mac = Mac.getInstance(algorithm);
        mac.init(new SecretKeySpec(key, algorithm));
        return mac.doFinal(data);
    }

    public static String getOpenBodySigForNetpay(String appId, String appKey, String timestamp, String nonce, String content) throws UnsupportedEncodingException, InvalidKeyException, NoSuchAlgorithmException {
        String bodyDigest = DigestUtils.sha256Hex((String)URLDecoder.decode(content, "UTF-8"));
        String str1_C = appId + timestamp + nonce + bodyDigest;
        byte[] localSignature = UnionPayUtil.hmacSHA256(str1_C.getBytes(), appKey.getBytes());
        String signature = Base64.encodeBase64String((byte[])localSignature);
        System.out.println("signature=" + signature);
        return "authorization=OPEN-FORM-PARAM&appId=" + appId + "&timestamp=" + timestamp + "&nonce=" + nonce + "&content=" + URLEncoder.encode(content, "UTF-8") + "&signature=" + URLEncoder.encode(signature, "UTF-8");
    }

    public static String getNewTradeId(String tradeId) {
        String a = StringUtils.substring((String)tradeId, (int)2, (int)12);
        String b = StringUtils.substring((String)tradeId, (int)14, (int)20);
        return "35FW" + a + b;
    }
}

