/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.unionpay.gateway.cscanb.impl.query;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.AbstractGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.GatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.OrderAssistant;
import com.dtyunxi.yundt.cube.center.payment.service.trade.processor.OrderProcessorService;
import com.dtyunxi.yundt.cube.center.payment.unionpay.config.UnionPayConfig;
import com.dtyunxi.yundt.cube.center.payment.unionpay.partner.domain.response.CscanbPayQueryResponse;
import com.dtyunxi.yundt.cube.center.payment.unionpay.util.UnionPayUtil;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.RefundOrderEo;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Service(value="cscanbRefundQueryGatewayServiceImpl")
public class CscanbRefundQueryGatewayServiceImpl
extends AbstractGatewayService<RefundOrderEo, CscanbPayQueryResponse> {
    @Resource
    private UnionPayConfig unionPayConfig;
    @Resource
    protected OrderProcessorService<RefundOrderEo, Object> payRefundOrderProcessorService;

    private GatewayResult parseBaseResponse(CscanbPayQueryResponse response, String tradeId) {
        GatewayResult result = new GatewayResult();
        result.setNotifyTradeId(tradeId);
        result.setDoneSucc(false);
        if ("SUCCESS".equals(response.getErrCode())) {
            result.setDoneSucc(true);
        } else {
            result.setErrorCode(response.getErrCode());
            result.setErrorMsg(response.getErrMsg());
            result.setDoneSucc(false);
        }
        return result;
    }

    public BaseGatewayResult rechargeResult(RefundOrderEo refundOrderEo, CscanbPayQueryResponse response) throws Exception {
        GatewayResult gatewayResult = this.parseBaseResponse(response, refundOrderEo.getTradeId());
        RefundOrderEo partnerOrder = OrderAssistant.createRefundOrder((String)refundOrderEo.getRefundId(), (Date)new Date());
        if ("REFUND".equals(response.getBillStatus())) {
            this.payRefundOrderProcessorService.handleSuccOrder((Object)partnerOrder);
            return gatewayResult;
        }
        if ("CLOSED".equals(response.getBillStatus())) {
            partnerOrder.setErrorCode("CLOSED");
            partnerOrder.setErrorMsg("\u8d26\u5355\u5173\u95ed");
            this.payRefundOrderProcessorService.handleFailOrder((Object)partnerOrder);
            return gatewayResult;
        }
        return gatewayResult;
    }

    public CscanbPayQueryResponse _execute(RefundOrderEo refundOrderEo) throws Exception {
        JSONObject json = new JSONObject();
        Date date = new Date();
        json.put("requestTimestamp", (Object)DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
        json.put("merOrderId", (Object)"1017201911051421202097207368");
        json.put("instMid", (Object)this.unionPayConfig.getInstMid());
        json.put("refundOrderId", (Object)refundOrderEo.getRefundId());
        json.put("mid", (Object)this.unionPayConfig.getMid());
        json.put("tid", (Object)this.unionPayConfig.getTid());
        System.out.println("\u8bf7\u6c42\u62a5\u6587:\n" + json);
        String send = this.send(this.unionPayConfig.getWebpayRefundQueryUrl(), json.toString(), date);
        this.logger.info("\u516c\u4f17\u53f7\u652f\u4ed8\u9000\u6b3e\u7ed3\u679c\u8fd4\u56de:{}", (Object)send);
        CscanbPayQueryResponse response = (CscanbPayQueryResponse)((Object)JSON.parseObject((String)send, CscanbPayQueryResponse.class));
        this.logger.info("\u516c\u4f17\u53f7\u652f\u4ed8\u9000\u6b3e\u7ed3\u679c:{}", (Object)JSON.toJsonString((Object)((Object)response)));
        return response;
    }

    public void validate(RefundOrderEo refundOrderEo, CscanbPayQueryResponse response) throws Exception {
    }

    public String send(String url, String entity, Date date) throws Exception {
        String authorization = UnionPayUtil.getOpenBodySig(this.unionPayConfig.getAppId(), this.unionPayConfig.getAppKey(), entity, date);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Authorization", authorization);
        StringEntity se = new StringEntity(entity, "UTF-8");
        se.setContentType("application/json");
        httpPost.setEntity((HttpEntity)se);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        HttpEntity entity1 = response.getEntity();
        String resStr = null;
        if (entity1 != null) {
            resStr = EntityUtils.toString((HttpEntity)entity1, (String)"UTF-8");
        }
        httpClient.close();
        response.close();
        this.logger.info("\u7ea2\u80bf\u597d\u652f\u4ed8\u67e5\u8be2\u9000\u6b3e\u7ed3\u679c:{}", (Object)resStr);
        return resStr;
    }
}

