/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.unionpay.gateway.webpay.impl.trade;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.GatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.OrderAssistant;
import com.dtyunxi.yundt.cube.center.payment.service.trade.processor.OrderProcessorService;
import com.dtyunxi.yundt.cube.center.payment.unionpay.config.UnionPayConfig;
import com.dtyunxi.yundt.cube.center.payment.unionpay.gateway.webpay.AbstractWebPayGatewayService;
import com.dtyunxi.yundt.cube.center.payment.unionpay.mq.dto.CscanbQrCodeCloseDto;
import com.dtyunxi.yundt.cube.center.payment.unionpay.partner.UnionPayPartnerService;
import com.dtyunxi.yundt.cube.center.payment.unionpay.partner.domain.response.UnionPayResponse;
import com.dtyunxi.yundt.cube.center.payment.unionpay.util.UnionPayUtil;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderAttachInfoEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Service(value="webPayOrderCreateGatewayServiceImpl")
public class WebPayOrderCreateGatewayServiceImpl
extends AbstractWebPayGatewayService<PayOrderEo, UnionPayResponse> {
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private UnionPayConfig unionPayConfig;
    @Resource
    protected OrderProcessorService<PayOrderEo, PayOrderAttachInfoEo> payOrderProcessorWrapperService;
    @Resource
    private UnionPayPartnerService unionPayPartnerService;

    public BaseGatewayResult rechargeResult(PayOrderEo payOrderEo, UnionPayResponse response) throws Exception {
        GatewayResult gatewayResult = this.parseBaseResponse(response, payOrderEo.getTradeId());
        PayOrderEo partnerOrder = OrderAssistant.createPayOrder((String)payOrderEo.getTradeId(), (Date)new Date());
        if ("SUCCESS".equals(response.getErrCode())) {
            HashMap<String, String> attach = new HashMap<String, String>();
            attach.put("outTradeNo", response.getBillNo());
            attach.put("webPayUrl", response.getWebPayUrl());
            attach.put("codeImgUrl", response.getWebPayUrl());
            gatewayResult.setData(attach);
            PayOrderAttachInfoEo payOrderAttachInfoEo = PayOrderAttachInfoEo.newInstance();
            payOrderAttachInfoEo.setTradeId(payOrderEo.getTradeId());
            payOrderAttachInfoEo.setPayInfo(JSON.toJSONString((Object)((Object)response)));
            this.payOrderProcessorService.handleAcceptOrder((Object)partnerOrder, (Object)payOrderAttachInfoEo);
            CscanbQrCodeCloseDto closeDto = new CscanbQrCodeCloseDto();
            closeDto.setTradeId(payOrderEo.getTradeId());
            closeDto.setQrCodeId(response.getQrCodeId());
            this.logger.info("\u53d1\u9001\u516c\u4f17\u53f7\u652f\u4ed8\u5173\u95ed\u5ef6\u8fdfMQ\uff0c{}", (Object)JSON.toJSONString((Object)closeDto));
            this.commonsMqService.sendDelaySingleMessageAsync("WEBPAY_EXPIRE_TAG", (Object)closeDto, Long.valueOf(Long.parseLong(response.getExpireTime()) + 10L));
        } else {
            this.logger.info("\u5411\u94f6\u8054\u53d1\u8d77\u516c\u4f17\u53f7\u652f\u4ed8\u5931\u8d25, \u4e2d\u53f0\u652f\u4ed8\u6d41\u6c34\u53f7: {}", (Object)payOrderEo.getTradeId());
            partnerOrder.setParentTradeId(payOrderEo.getParentTradeId());
            partnerOrder.setErrorCode(response.getErrCode());
            partnerOrder.setErrorMsg(response.getErrMsg());
            partnerOrder.setParentTradeId(payOrderEo.getParentTradeId());
            gatewayResult.setDoneSucc(false);
            gatewayResult.setErrorCode(response.getErrCode());
            gatewayResult.setErrorMsg(response.getErrMsg());
            this.payOrderProcessorWrapperService.handleFailOrder((Object)partnerOrder);
        }
        return gatewayResult;
    }

    private GatewayResult parseBaseResponse(UnionPayResponse response, String tradeId) {
        GatewayResult result = new GatewayResult();
        result.setNotifyTradeId(tradeId);
        result.setDoneSucc(false);
        if ("SUCCESS".equals(response.getErrCode())) {
            result.setDoneSucc(true);
        } else {
            result.setErrorCode(response.getErrCode());
            result.setErrorMsg(response.getErrMsg());
        }
        return result;
    }

    public UnionPayResponse _execute(PayOrderEo payOrderEo) throws Exception {
        JSONObject json = new JSONObject();
        Date date = new Date();
        json.put("requestTimestamp", (Object)DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
        json.put("mid", (Object)this.unionPayConfig.getMid());
        json.put("tid", (Object)this.unionPayConfig.getTid());
        json.put("instMid", (Object)this.unionPayConfig.getInstMid());
        json.put("totalAmount", (Object)new BigDecimal("100").multiply(payOrderEo.getAmount()).intValue());
        json.put("notifyUrl", (Object)this.unionPayConfig.getWebpayNotifyUrl());
        Integer expireTime = 1800;
        if (null != payOrderEo.getExpireTime()) {
            expireTime = payOrderEo.getExpireTime();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, expireTime);
        String expireTimes = DateUtil.getDateFormat((Date)calendar.getTime(), (String)"yyyy-MM-dd HH:mm:ss");
        this.logger.info("\u8fc7\u671f\u65f6\u95f4:{}", (Object)expireTimes);
        json.put("expireTime", (Object)expireTimes);
        String outTradeNo = UnionPayUtil.getNewTradeId(payOrderEo.getTradeId());
        this.updatePayOrderTradeId(payOrderEo, outTradeNo);
        payOrderEo.setTradeId(outTradeNo);
        json.put("merOrderId", (Object)payOrderEo.getTradeId());
        String timestamp = new SimpleDateFormat("yyyyMMddHHmmss").format(date);
        String nonce = UUID.randomUUID().toString().replace("-", "");
        String param = UnionPayUtil.getOpenBodySigForNetpay(this.unionPayConfig.getAppId(), this.unionPayConfig.getAppKey(), timestamp, nonce, json.toString());
        String URL2 = this.unionPayConfig.getWebPayUrl() + "?" + param;
        this.logger.info("\u5411\u6e20\u9053\u53d1\u8d77\u8bf7\u6c42\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c \u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)this.unionPayConfig.getWebPayUrl(), (Object)json.toJSONString());
        UnionPayResponse response = new UnionPayResponse();
        response.setErrCode("SUCCESS");
        response.setWebPayUrl(URL2);
        response.setExpireTime(expireTime.toString());
        return response;
    }

    private void updatePayOrderTradeId(PayOrderEo payOrderEo, String outTradeNo) {
        PayOrderEo updateEo = new PayOrderEo();
        updateEo.setId(payOrderEo.getId());
        updateEo.setTradeId(outTradeNo);
        this.payOrderDas.updateSelective((BaseEo)updateEo);
    }

    public void validate(PayOrderEo payOrderEo, UnionPayResponse unionPayResponse) throws Exception {
    }
}

