/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.unionpay.util;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    protected static Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    private static PoolingHttpClientConnectionManager cm;
    private static String EMPTY_STR;
    private static String UTF_8;

    private static void init() {
        if (cm == null) {
            cm = new PoolingHttpClientConnectionManager();
            cm.setMaxTotal(50);
            cm.setDefaultMaxPerRoute(5);
        }
    }

    public static CloseableHttpClient getHttpClient() {
        HttpUtils.init();
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
    }

    public static String httpGetRequest(String url) throws Exception {
        HttpGet httpGet = new HttpGet(url);
        return HttpUtils.getResult((HttpRequestBase)httpGet);
    }

    public static String httpGetRequest(String url, Map<String, Object> params) throws Exception {
        URIBuilder ub = new URIBuilder();
        ub.setPath(url);
        ArrayList<NameValuePair> pairs = HttpUtils.covertParams2NVPS(params);
        ub.setParameters(pairs);
        HttpGet httpGet = new HttpGet(ub.build());
        return HttpUtils.getResult((HttpRequestBase)httpGet);
    }

    public static String httpGetRequest(String url, Map<String, Object> headers, Map<String, Object> params) throws Exception {
        URIBuilder ub = new URIBuilder();
        ub.setPath(url);
        ArrayList<NameValuePair> pairs = HttpUtils.covertParams2NVPS(params);
        ub.setParameters(pairs);
        HttpGet httpGet = new HttpGet(ub.build());
        for (Map.Entry<String, Object> param : headers.entrySet()) {
            httpGet.addHeader(param.getKey(), String.valueOf(param.getValue()));
        }
        return HttpUtils.getResult((HttpRequestBase)httpGet);
    }

    public static String httpPostRequest(String url) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        return HttpUtils.getResult((HttpRequestBase)httpPost);
    }

    public static String httpPostRequest(String url, Map<String, Object> params) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        ArrayList<NameValuePair> pairs = HttpUtils.covertParams2NVPS(params);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, UTF_8));
        return HttpUtils.getResult((HttpRequestBase)httpPost);
    }

    public static String httpPostRequest(String url, Map<String, Object> headers, Map<String, Object> params) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        for (Map.Entry<String, Object> param : headers.entrySet()) {
            httpPost.addHeader(param.getKey(), String.valueOf(param.getValue()));
        }
        ArrayList<NameValuePair> pairs = HttpUtils.covertParams2NVPS(params);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, UTF_8));
        return HttpUtils.getResult((HttpRequestBase)httpPost);
    }

    public static String httpPostRequest(String url, Map<String, Object> headers, String strBody) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        for (Map.Entry<String, Object> param : headers.entrySet()) {
            httpPost.addHeader(param.getKey(), String.valueOf(param.getValue()));
        }
        httpPost.setEntity((HttpEntity)new StringEntity(strBody, UTF_8));
        return HttpUtils.getResult((HttpRequestBase)httpPost);
    }

    private static ArrayList<NameValuePair> covertParams2NVPS(Map<String, Object> params) {
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        for (Map.Entry<String, Object> param : params.entrySet()) {
            pairs.add((NameValuePair)new BasicNameValuePair(param.getKey(), String.valueOf(param.getValue())));
        }
        return pairs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getResult(HttpRequestBase request) throws Exception {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(5000).setSocketTimeout(60000).build();
        request.setConfig(requestConfig);
        CloseableHttpClient httpClient = HttpUtils.getHttpClient();
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            HttpEntity entity = response.getEntity();
            if (entity == null) return EMPTY_STR;
            String result = EntityUtils.toString((HttpEntity)entity);
            logger.info("result:{}", (Object)JSON.toJSONString((Object)result));
            response.close();
            return result;
        }
        catch (ClientProtocolException e) {
            logger.error("[maperror] HttpClientUtil ClientProtocolException : " + e.getMessage());
            throw new Exception("HttpClientUtil ClientProtocolException \uff1a" + e.getMessage());
        }
        catch (IOException e) {
            logger.error("[maperror] HttpClientUtil IOException : " + e.getMessage());
            throw new Exception("HttpClientUtil IOException \uff1a" + e.getMessage());
        }
    }

    static {
        EMPTY_STR = "";
        UTF_8 = "UTF-8";
    }
}

