/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.control.biz.service.impl;

import cn.hutool.core.lang.Assert;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.control.api.IControlOrderApi;
import com.dtyunxi.tcbj.center.control.api.dto.constant.RuleExitClashEnum;
import com.dtyunxi.tcbj.center.control.api.dto.request.BizControlOrderReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BizChangeRuleResultRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BizControlOrderRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlOrderAreaRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlOrderCustomerRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlOrderRespDto;
import com.dtyunxi.tcbj.center.control.api.query.IControlOrderAreaQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.IControlOrderCustomerQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.IControlOrderQueryApi;
import com.dtyunxi.tcbj.module.control.biz.service.IControlOrderService;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ControlOrderServiceImpl
implements IControlOrderService {
    @Resource
    private IControlOrderApi iControlOrderApi;
    @Resource
    private IControlOrderQueryApi iControlOrderQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IControlOrderCustomerQueryApi iControlOrderCustomerQueryApi;
    @Resource
    private IControlOrderAreaQueryApi iControlOrderAreaQueryApi;

    @Override
    public RestResponse addControlOrder(BizControlOrderReqDto addReqDto) {
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        Assert.notNull((Object)orgId, (String)"\u79df\u6237Id\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (Object[])new Object[0]);
        addReqDto.setOrgId(orgId);
        RestResponse result = this.iControlOrderApi.addControlOrder(addReqDto);
        StringBuilder desc = new StringBuilder("\u8be5\u5ba2\u6237\u7ef4\u5ea6\u5df2\u7ecf\u5b58\u5728\u8ba2\u5355\u7ba1\u63a7\u89c4\u5219\uff08\u4e14\u5df2\u542f\u7528\u72b6\u6001\uff09\uff0c\u4e0d\u80fd\u91cd\u590d\u521b\u5efa\u3002\n\u51b2\u7a81\u5185\u5bb9\uff1a");
        if (((BizChangeRuleResultRespDto)result.getData()).getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue())) {
            if (!ObjectUtils.isEmpty((Object)((BizChangeRuleResultRespDto)result.getData()).getAreaList())) {
                List collect = ((BizChangeRuleResultRespDto)result.getData()).getAreaList().stream().map(c -> c.getAreaName()).collect(Collectors.toList());
                desc.append("\u6307\u5b9a\u533a\u57df\uff1a" + collect);
            } else if (!ObjectUtils.isEmpty((Object)((BizChangeRuleResultRespDto)result.getData()).getCustomerList())) {
                List collect = ((BizChangeRuleResultRespDto)result.getData()).getCustomerList().stream().map(c -> c.getCustomerName()).collect(Collectors.toList());
                desc.append("\u6307\u5b9a\u5ba2\u6237\u5ba2\u6237\uff1a" + collect);
            } else {
                desc.append("\u5168\u90e8\u5ba2\u6237");
            }
        }
        return !((BizChangeRuleResultRespDto)result.getData()).getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue()) ? RestResponse.SUCCEED : new RestResponse("0001", desc.toString());
    }

    @Override
    public RestResponse modifyControlOrder(BizControlOrderReqDto modifyReqDto) {
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        Assert.notNull((Object)orgId, (String)"\u79df\u6237Id\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (Object[])new Object[0]);
        modifyReqDto.setOrgId(orgId);
        RestResponse result = this.iControlOrderApi.modifyControlOrder(modifyReqDto);
        StringBuilder desc = new StringBuilder("\u8be5\u5ba2\u6237\u7ef4\u5ea6\u5df2\u7ecf\u5b58\u5728\u8ba2\u5355\u7ba1\u63a7\u89c4\u5219\uff08\u4e14\u5df2\u542f\u7528\u72b6\u6001\uff09\uff0c\u4e0d\u80fd\u91cd\u590d\u521b\u5efa\u3002\n\u51b2\u7a81\u5185\u5bb9\uff1a");
        if (((BizChangeRuleResultRespDto)result.getData()).getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue())) {
            if (!ObjectUtils.isEmpty((Object)((BizChangeRuleResultRespDto)result.getData()).getAreaList())) {
                List collect = ((BizChangeRuleResultRespDto)result.getData()).getAreaList().stream().map(c -> c.getAreaName()).collect(Collectors.toList());
                desc.append("\u6307\u5b9a\u533a\u57df\uff1a" + collect);
            } else if (!ObjectUtils.isEmpty((Object)((BizChangeRuleResultRespDto)result.getData()).getCustomerList())) {
                List collect = ((BizChangeRuleResultRespDto)result.getData()).getCustomerList().stream().map(c -> c.getCustomerName()).collect(Collectors.toList());
                desc.append("\u6307\u5b9a\u5ba2\u6237\u5ba2\u6237\uff1a" + collect);
            } else {
                desc.append("\u5168\u90e8\u5ba2\u6237");
            }
        }
        return !((BizChangeRuleResultRespDto)result.getData()).getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue()) ? RestResponse.SUCCEED : new RestResponse("0001", desc.toString());
    }

    @Override
    public RestResponse<Void> removeControlOrder(String ids, Long instanceId) {
        return this.iControlOrderApi.removeControlOrder(ids, instanceId);
    }

    @Override
    public RestResponse setEnable(Long ruleId, Integer enableStatus) {
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        Assert.notNull((Object)orgId, (String)"\u79df\u6237Id\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (Object[])new Object[0]);
        RestResponse result = this.iControlOrderApi.setEnable(ruleId, enableStatus, orgId);
        StringBuilder desc = new StringBuilder("\u8be5\u5ba2\u6237\u7ef4\u5ea6\u5df2\u7ecf\u5b58\u5728\u8ba2\u5355\u7ba1\u63a7\u89c4\u5219\uff08\u4e14\u5df2\u542f\u7528\u72b6\u6001\uff09\uff0c\u4e0d\u80fd\u91cd\u590d\u521b\u5efa\u3002\n\u51b2\u7a81\u5185\u5bb9\uff1a");
        if (((BizChangeRuleResultRespDto)result.getData()).getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue())) {
            if (!ObjectUtils.isEmpty((Object)((BizChangeRuleResultRespDto)result.getData()).getAreaList())) {
                List collect = ((BizChangeRuleResultRespDto)result.getData()).getAreaList().stream().map(c -> c.getAreaName()).collect(Collectors.toList());
                desc.append("\u6307\u5b9a\u533a\u57df\uff1a" + collect);
            } else if (!ObjectUtils.isEmpty((Object)((BizChangeRuleResultRespDto)result.getData()).getCustomerList())) {
                List collect = ((BizChangeRuleResultRespDto)result.getData()).getCustomerList().stream().map(c -> c.getCustomerName()).collect(Collectors.toList());
                desc.append("\u6307\u5b9a\u5ba2\u6237\u5ba2\u6237\uff1a" + collect);
            } else {
                desc.append("\u5168\u90e8\u5ba2\u6237");
            }
        }
        return !((BizChangeRuleResultRespDto)result.getData()).getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue()) ? RestResponse.SUCCEED : new RestResponse("0001", desc.toString());
    }

    @Override
    public RestResponse<BizControlOrderRespDto> queryById(Long id) {
        return this.iControlOrderQueryApi.queryById(id);
    }

    @Override
    public RestResponse<PageInfo<ControlOrderRespDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        Assert.notNull((Object)orgId, (String)"\u79df\u6237Id\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.iControlOrderQueryApi.queryByPage(filter, orgId, pageNum, pageSize);
    }

    @Override
    public RestResponse<PageInfo<ControlOrderCustomerRespDto>> queryControlOrderCustomerByPage(String filter, Integer pageNum, Integer pageSize) {
        return this.iControlOrderCustomerQueryApi.queryByPage(filter, pageNum, pageSize);
    }

    @Override
    public RestResponse<List<ControlOrderAreaRespDto>> queryControlOrderAreaList(String filter) {
        return this.iControlOrderAreaQueryApi.queryControlOrderAreaList(filter);
    }
}

