/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.control.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.YesOrNoEnum;
import com.dtyunxi.tcbj.center.control.api.IControlInventoryApi;
import com.dtyunxi.tcbj.center.control.api.dto.constant.RuleExitClashEnum;
import com.dtyunxi.tcbj.center.control.api.dto.request.BizControlInventoryReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BizChangeRuleResultRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlInventoryAreaRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlInventoryCustomerRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlInventoryItemRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlInventoryRespDto;
import com.dtyunxi.tcbj.center.control.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.control.api.query.IControlInventoryAreaQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.IControlInventoryCustomerQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.IControlInventoryItemQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.IControlInventoryQueryApi;
import com.dtyunxi.tcbj.module.control.biz.dto.ImportBaseReqDto;
import com.dtyunxi.tcbj.module.control.biz.dto.export.InventoryItemImportDto;
import com.dtyunxi.tcbj.module.control.biz.dto.response.InventoryItemImportRespDto;
import com.dtyunxi.tcbj.module.control.biz.service.IControlInventoryService;
import com.dtyunxi.tcbj.module.control.biz.utils.BeanPropertyNullUtil;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailBaseInfoRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.dtyunxi.yundt.module.bitem.api.IBitemService;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.api.dto.request.ItemShopQueryReqDto;
import com.yx.tcbj.center.api.query.IItemCenterQueryApi;
import com.yx.tcbj.center.api.query.IItemExtQueryApi;
import com.yx.tcbj.center.customer.api.query.ICustomerAreaQueryExtApi;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class ControlInventoryServiceImpl
implements IControlInventoryService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IControlInventoryApi iControlInventoryApi;
    @Resource
    private IControlInventoryQueryApi iControlInventoryQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IControlInventoryItemQueryApi iControlInventoryItemQueryApi;
    @Resource
    private IControlInventoryCustomerQueryApi iControlInventoryCustomerQueryApi;
    @Resource
    private IControlInventoryAreaQueryApi iControlInventoryAreaQueryApi;
    @Resource
    private IBitemService bitemService;
    @Resource
    private IItemExtQueryApi itemExtQueryApi;
    @Resource
    private HttpServletRequest request;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IContext context;
    @Resource
    private ISellerExtQueryApi sellerExtQueryApi;
    @Resource
    private IItemCenterQueryApi itemCenterQueryApi;
    @Resource
    private IShopExtQueryApi shopExtQueryApi;
    @Resource
    private ICustomerAreaQueryExtApi customerAreaQueryExtApi;

    public String headerOrgId() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        this.logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        return organizationId;
    }

    @Override
    public RestResponse addControlInventory(BizControlInventoryReqDto addReqDto) {
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        Assert.notNull((Object)orgId, (String)"\u79df\u6237Id\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (Object[])new Object[0]);
        addReqDto.setOrgId(orgId);
        RestResponse result = this.iControlInventoryApi.addControlInventory(addReqDto);
        StringBuilder desc = new StringBuilder("\u8be5\u5ba2\u6237\u7ef4\u5ea6\u5df2\u7ecf\u5b58\u5728\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u89c4\u5219\uff08\u4e14\u5df2\u542f\u7528\u72b6\u6001\uff09\uff0c\u4e0d\u80fd\u91cd\u590d\u521b\u5efa\u3002\n\u51b2\u7a81\u5185\u5bb9\uff1a");
        if (((BizChangeRuleResultRespDto)result.getData()).getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue())) {
            if (!ObjectUtils.isEmpty((Object)((BizChangeRuleResultRespDto)result.getData()).getAreaList())) {
                List collect = ((BizChangeRuleResultRespDto)result.getData()).getAreaList().stream().map(c -> c.getAreaName()).collect(Collectors.toList());
                desc.append("\u6307\u5b9a\u533a\u57df\uff1a" + collect);
            } else if (!ObjectUtils.isEmpty((Object)((BizChangeRuleResultRespDto)result.getData()).getCustomerList())) {
                List collect = ((BizChangeRuleResultRespDto)result.getData()).getCustomerList().stream().map(c -> c.getCustomerName()).collect(Collectors.toList());
                desc.append("\u6307\u5b9a\u5ba2\u6237\u5ba2\u6237\uff1a" + collect);
            } else {
                desc.append("\u5168\u90e8\u5ba2\u6237");
            }
        }
        return !((BizChangeRuleResultRespDto)result.getData()).getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue()) ? RestResponse.SUCCEED : new RestResponse("0001", desc.toString());
    }

    @Override
    public RestResponse modifyControlInventory(BizControlInventoryReqDto modifyReqDto) {
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        Assert.notNull((Object)orgId, (String)"\u79df\u6237Id\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (Object[])new Object[0]);
        modifyReqDto.setOrgId(orgId);
        RestResponse result = this.iControlInventoryApi.modifyControlInventory(modifyReqDto);
        StringBuilder desc = new StringBuilder("\u8be5\u5ba2\u6237\u7ef4\u5ea6\u5df2\u7ecf\u5b58\u5728\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u89c4\u5219\uff08\u4e14\u5df2\u542f\u7528\u72b6\u6001\uff09\uff0c\u4e0d\u80fd\u91cd\u590d\u521b\u5efa\u3002\n\u51b2\u7a81\u5185\u5bb9\uff1a");
        if (((BizChangeRuleResultRespDto)result.getData()).getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue())) {
            if (!ObjectUtils.isEmpty((Object)((BizChangeRuleResultRespDto)result.getData()).getAreaList())) {
                List collect = ((BizChangeRuleResultRespDto)result.getData()).getAreaList().stream().map(c -> c.getAreaName()).collect(Collectors.toList());
                desc.append("\u6307\u5b9a\u533a\u57df\uff1a" + collect);
            } else if (!ObjectUtils.isEmpty((Object)((BizChangeRuleResultRespDto)result.getData()).getCustomerList())) {
                List collect = ((BizChangeRuleResultRespDto)result.getData()).getCustomerList().stream().map(c -> c.getCustomerName()).collect(Collectors.toList());
                desc.append("\u6307\u5b9a\u5ba2\u6237\u5ba2\u6237\uff1a" + collect);
            } else {
                desc.append("\u5168\u90e8\u5ba2\u6237");
            }
        }
        return !((BizChangeRuleResultRespDto)result.getData()).getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue()) ? RestResponse.SUCCEED : new RestResponse("0001", desc.toString());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse removeControlInventory(String ids, Long instanceId) {
        return this.iControlInventoryApi.removeControlInventory(ids, instanceId);
    }

    @Override
    public RestResponse setEnable(Long ruleId, Integer enableStatus) {
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        Assert.notNull((Object)orgId, (String)"\u79df\u6237Id\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (Object[])new Object[0]);
        RestResponse result = this.iControlInventoryApi.setEnable(ruleId, enableStatus, orgId);
        StringBuilder desc = new StringBuilder("\u8be5\u5ba2\u6237\u7ef4\u5ea6\u5df2\u7ecf\u5b58\u5728\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u89c4\u5219\uff08\u4e14\u5df2\u542f\u7528\u72b6\u6001\uff09\uff0c\u4e0d\u80fd\u91cd\u590d\u521b\u5efa\u3002\n\u51b2\u7a81\u5185\u5bb9\uff1a");
        if (((BizChangeRuleResultRespDto)result.getData()).getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue())) {
            if (!ObjectUtils.isEmpty((Object)((BizChangeRuleResultRespDto)result.getData()).getAreaList())) {
                List collect = ((BizChangeRuleResultRespDto)result.getData()).getAreaList().stream().map(c -> c.getAreaName()).collect(Collectors.toList());
                desc.append("\u6307\u5b9a\u533a\u57df\uff1a" + collect);
            } else if (!ObjectUtils.isEmpty((Object)((BizChangeRuleResultRespDto)result.getData()).getCustomerList())) {
                List collect = ((BizChangeRuleResultRespDto)result.getData()).getCustomerList().stream().map(c -> c.getCustomerName()).collect(Collectors.toList());
                desc.append("\u6307\u5b9a\u5ba2\u6237\u5ba2\u6237\uff1a" + collect);
            } else {
                desc.append("\u5168\u90e8\u5ba2\u6237");
            }
        }
        return !((BizChangeRuleResultRespDto)result.getData()).getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue()) ? RestResponse.SUCCEED : new RestResponse("0001", desc.toString());
    }

    @Override
    public RestResponse<ControlInventoryRespDto> queryById(Long id) {
        ControlInventoryRespDto controlInventoryRespDto = (ControlInventoryRespDto)RestResponseHelper.extractData((RestResponse)this.iControlInventoryQueryApi.queryById(id));
        ArrayList customerList = Lists.newArrayList();
        ArrayList customerBlackList = Lists.newArrayList();
        List controlInventoryCustomerRespDtos = controlInventoryRespDto.getCustomerList();
        if (CollectionUtils.isNotEmpty((Collection)controlInventoryCustomerRespDtos)) {
            List customerIdList = controlInventoryCustomerRespDtos.stream().map(ControlInventoryCustomerRespDto::getCustomerId).distinct().collect(Collectors.toList());
            Map customerAreaMap = (Map)RestResponseHelper.extractData((RestResponse)this.customerAreaQueryExtApi.getCustomerAreaByCustomerIdMap(customerIdList));
            this.logger.info("\u6839\u636e\u5ba2\u6237id\u67e5\u8be2\u5ba2\u6237\u533a\u57df\u540d\u79f0\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)customerAreaMap));
            Long orgId = controlInventoryRespDto.getOrgId();
            for (ControlInventoryCustomerRespDto customerRespDto : controlInventoryCustomerRespDtos) {
                List respDtos;
                if (!customerAreaMap.isEmpty() && customerAreaMap.containsKey(customerRespDto.getCustomerId()) && CollectionUtils.isNotEmpty(respDtos = ((List)customerAreaMap.get(customerRespDto.getCustomerId())).stream().filter(dto -> dto.getOrgInfoId().compareTo(orgId) == 0).collect(Collectors.toList()))) {
                    String areaNames = respDtos.stream().map(CustomerAreaRespDto::getName).collect(Collectors.joining(";"));
                    customerRespDto.setCustomerArea(areaNames);
                }
                if (Objects.equals(customerRespDto.getBlacklistStatus(), YesOrNoEnum.YES.getCode())) {
                    customerBlackList.add(customerRespDto);
                    continue;
                }
                customerList.add(customerRespDto);
            }
        }
        controlInventoryRespDto.setCustomerList((List)customerList);
        controlInventoryRespDto.setCustomerBlackList((List)customerBlackList);
        return new RestResponse((Object)controlInventoryRespDto);
    }

    @Override
    public RestResponse<PageInfo<ControlInventoryRespDto>> queryByPage(BizControlInventoryReqDto controlInventoryReqDto) {
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        Assert.notNull((Object)orgId, (String)"\u79df\u6237Id\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (Object[])new Object[0]);
        controlInventoryReqDto.setOrgId(orgId);
        return this.iControlInventoryQueryApi.queryByPage(controlInventoryReqDto);
    }

    @Override
    public RestResponse<PageInfo<ControlInventoryItemRespDto>> controlInventoryItemQueryByPage(String filter, Integer pageNum, Integer pageSize) {
        return this.iControlInventoryItemQueryApi.queryByPage(filter, pageNum, pageSize);
    }

    @Override
    public RestResponse<PageInfo<ControlInventoryCustomerRespDto>> controlInventoryCustomerQueryByPage(String filter, Integer pageNum, Integer pageSize) {
        return this.iControlInventoryCustomerQueryApi.queryByPage(filter, pageNum, pageSize);
    }

    @Override
    public RestResponse<PageInfo<ControlInventoryAreaRespDto>> controlInventoryAreaQueryByPage(String filter, Integer pageNum, Integer pageSize) {
        return this.iControlInventoryAreaQueryApi.queryByPage(filter, pageNum, pageSize);
    }

    @Override
    public InventoryItemImportRespDto inventoryItemImport(ImportBaseReqDto importReqDto) {
        List shopBaseDtos;
        this.logger.info("\u5bfc\u5165\u6587\u4ef6\u5730\u5740:{}", (Object)importReqDto.getFileUrl());
        String fileUrl = importReqDto.getFileUrl();
        Long orgId = importReqDto.getOrgId();
        AssertUtils.notEmpty((String)fileUrl, (String)"\u5bfc\u5165\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        if (Objects.isNull(orgId)) {
            String orgIdStr = this.headerOrgId();
            AssertUtils.notEmpty((String)orgIdStr, (String)"\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\u4e3a\u7a7a");
            orgId = Long.valueOf(orgIdStr);
        }
        InventoryItemImportRespDto resultDto = new InventoryItemImportRespDto();
        List<Object> importDtos = Lists.newArrayList();
        try {
            InputStream is = this.getInputStream(fileUrl);
            ExcelImportResult objectExcelImportResult = EasyPoiExportUtil.importExcel((InputStream)is, (Integer)0, (Integer)1, InventoryItemImportDto.class);
            importDtos = objectExcelImportResult.getList();
            importDtos = BeanPropertyNullUtil.getAllFieldNullList(importDtos);
        }
        catch (Exception e) {
            throw new BizException("\u5bfc\u5165\u5546\u54c1\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
        }
        this.logger.info("\u5bfc\u5165\u7684\u6570\u636e==>{}", (Object)JSONObject.toJSONString((Object)importDtos));
        if (CollectionUtils.isEmpty((Collection)importDtos)) {
            throw new BizException("\u5bfc\u5165\u7684\u8868\u683c\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8868\u683c\u540e\u91cd\u65b0\u5bfc\u5165");
        }
        resultDto.setTotalSize(importDtos.size());
        List itemCodeList = importDtos.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getItemCode())).map(InventoryItemImportDto::getItemCode).distinct().collect(Collectors.toList());
        Map<Object, Object> itemInfoMap = new HashMap(itemCodeList.size() * 4 / 3 + 2);
        if (CollectionUtils.isNotEmpty(itemCodeList) && CollectionUtils.isNotEmpty((Collection)(shopBaseDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopExtQueryApi.queryShopListBySellerOrgId(orgId))))) {
            ItemShopQueryReqDto itemShopQueryReqDto = new ItemShopQueryReqDto();
            itemShopQueryReqDto.setItemCodes(itemCodeList);
            itemShopQueryReqDto.setShopId(((ShopBaseDto)shopBaseDtos.get(0)).getId());
            itemShopQueryReqDto.setTargetType(Integer.valueOf(2));
            List itemInfoList = (List)RestResponseHelper.extractData((RestResponse)this.itemCenterQueryApi.queryShopItemList(itemShopQueryReqDto));
            if (CollectionUtils.isNotEmpty((Collection)itemInfoList)) {
                itemInfoMap = itemInfoList.stream().collect(Collectors.toMap(ItemDetailBaseInfoRespDto::getCode, Function.identity(), (k1, k2) -> k1));
            }
        }
        HashMap<String, ControlInventoryItemRespDto> itemRestMap = new HashMap<String, ControlInventoryItemRespDto>();
        List<Object> resultList = Lists.newArrayList();
        for (InventoryItemImportDto inventoryItemImportDto : importDtos) {
            if (StringUtils.isEmpty((CharSequence)inventoryItemImportDto.getItemCode())) {
                inventoryItemImportDto.setErrorReason("\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a;");
                continue;
            }
            if (itemInfoMap.isEmpty() || !itemInfoMap.containsKey(inventoryItemImportDto.getItemCode())) {
                inventoryItemImportDto.setErrorReason("\u5546\u54c1\u7f16\u7801\u9519\u8bef\u6216\u672a\u6388\u6743;");
                continue;
            }
            if (StringUtils.isNotEmpty((CharSequence)inventoryItemImportDto.getFloorInventoryCount()) && !this.checkNum(inventoryItemImportDto.getFloorInventoryCount())) {
                inventoryItemImportDto.setErrorReason("\u5b89\u5168\u5e93\u5b58\u6570\u91cf\u683c\u5f0f\u9519\u8bef:\u5e94\u4e3a1-99999999\u8303\u56f4\u5185\u7684\u6574\u6570;");
                continue;
            }
            String key = inventoryItemImportDto.getItemCode();
            if (itemRestMap.isEmpty() || !itemRestMap.containsKey(key)) {
                Map extFields;
                ItemDetailBaseInfoRespDto itemRespDto = (ItemDetailBaseInfoRespDto)itemInfoMap.get(inventoryItemImportDto.getItemCode());
                ControlInventoryItemRespDto result = new ControlInventoryItemRespDto();
                result.setItemId(itemRespDto.getId());
                result.setItemCode(itemRespDto.getCode());
                result.setItemName(itemRespDto.getName());
                result.setDirName(itemRespDto.getShopDirName());
                result.setSkuName(itemRespDto.getAttrs());
                if (StringUtils.isNotEmpty((CharSequence)inventoryItemImportDto.getFloorInventoryCount())) {
                    result.setFloorInventoryCount(Integer.valueOf(inventoryItemImportDto.getFloorInventoryCount()));
                }
                if ((extFields = itemRespDto.getExtFields()) != null && !extFields.isEmpty() && extFields.containsKey("subType") && Objects.nonNull(extFields.get("subType"))) {
                    Integer subType = Integer.valueOf(extFields.get("subType").toString());
                    result.setSubType(subType);
                }
                itemRestMap.put(key, result);
                continue;
            }
            if (StringUtils.isNotEmpty((CharSequence)inventoryItemImportDto.getFloorInventoryCount())) {
                ((ControlInventoryItemRespDto)itemRestMap.get(key)).setFloorInventoryCount(Integer.valueOf(inventoryItemImportDto.getFloorInventoryCount()));
                continue;
            }
            ((ControlInventoryItemRespDto)itemRestMap.get(key)).setFloorInventoryCount(null);
        }
        if (!itemRestMap.isEmpty()) {
            resultList = itemRestMap.values().stream().collect(Collectors.toList());
        }
        resultDto.setResultList(resultList);
        List list = importDtos.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getErrorReason())).collect(Collectors.toList());
        resultDto.setFailSize(list.size());
        if (CollectionUtils.isNotEmpty(list)) {
            String string = "\u5bfc\u5165\u5b89\u5168\u5e93\u5b58\u5546\u54c1\u8fd4\u56de\u7ed3\u679c";
            String fileName = "cube/" + string + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            try {
                String exportUrl = EasyPoiExportUtil.getExportUrl(list, InventoryItemImportDto.class, null, (String)fileName, (String)"xls");
                resultDto.setErrorFileUrl(exportUrl);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BizException("\u5bfc\u51fa\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
        resultDto.setSuccessSize(resultDto.getTotalSize() - resultDto.getFailSize());
        return resultDto;
    }

    private InputStream getInputStream(String fileUrl) throws IOException {
        URL url = new URL(fileUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        return conn.getInputStream();
    }

    private boolean checkNum(String str) {
        String patent = "[1-9]{1}\\d{0,7}";
        return Pattern.matches(patent, str);
    }
}

