/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.control.biz.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.control.api.ITrControlItemAmountConfigApi;
import com.dtyunxi.tcbj.center.control.api.ITrControlItemAmountImportApi;
import com.dtyunxi.tcbj.center.control.api.ITrControlItemAmountRecordApi;
import com.dtyunxi.tcbj.center.control.api.ITrControlItemAmountRuleApi;
import com.dtyunxi.tcbj.center.control.api.dto.constant.RuleExitClashEnum;
import com.dtyunxi.tcbj.center.control.api.dto.request.BizControlItemAmountReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.BizImportDataReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlItemAmountConfigReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlItemAmountImportReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlItemAmountRecordReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlItemAmountRuleReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BizChangeRuleResultRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BizImportRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlItemAmountConfigRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlItemAmountRecordRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlItemAmountRuleRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.vo.ItemAmountVo;
import com.dtyunxi.tcbj.center.control.api.dto.vo.ItemSurplusAmountVo;
import com.dtyunxi.tcbj.center.control.api.query.ITrControlItemAmountConfigQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.ITrControlItemAmountRecordQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.ITrControlItemAmountRuleQueryApi;
import com.dtyunxi.tcbj.module.control.biz.service.IControlItemAmountService;
import com.dtyunxi.tcbj.module.control.biz.utils.BeanPropertyNullUtil;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ControlItemAmountServiceImpl
implements IControlItemAmountService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IContext context;
    @Resource
    private ITrControlItemAmountRuleApi iTrControlItemAmountRuleApi;
    @Resource
    private ITrControlItemAmountRuleQueryApi iTrControlItemAmountRuleQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ITrControlItemAmountRecordQueryApi iTrControlItemAmountRecordQueryApi;
    @Resource
    private ITrControlItemAmountRecordApi iTrControlItemAmountRecordApi;
    @Resource
    private ITrControlItemAmountConfigApi iTrControlItemAmountConfigApi;
    @Resource
    private ITrControlItemAmountConfigQueryApi iTrControlItemAmountConfigQueryApi;
    @Resource
    private ITrControlItemAmountImportApi controlItemAmountImportApi;

    @Override
    public RestResponse addTrControlItemAmountRule(BizControlItemAmountReqDto addReqDto) {
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        addReqDto.getItemAmountList().forEach(c -> c.setOrgId(orgId));
        RestResponse result = this.iTrControlItemAmountRuleApi.addTrControlItemAmountRule(addReqDto);
        StringBuilder desc = new StringBuilder("\u8be5\u5ba2\u6237\u5df2\u5b58\u5728\u6708\u8ba2\u8d27\u989d\u5ea6\u89c4\u5219\uff0c\u4e0d\u80fd\u91cd\u590d\u521b\u5efa\u3002\n\u51b2\u7a81\u5185\u5bb9\uff1a");
        if (((BizChangeRuleResultRespDto)result.getData()).getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue()) && !ObjectUtils.isEmpty((Object)((BizChangeRuleResultRespDto)result.getData()).getConflictRuleList())) {
            List collect = ((BizChangeRuleResultRespDto)result.getData()).getConflictRuleList().stream().map(c -> c.getCustomerCode()).distinct().collect(Collectors.toList());
            List collect1 = ((BizChangeRuleResultRespDto)result.getData()).getConflictRuleList().stream().map(c -> c.getAmountTime()).collect(Collectors.toList());
            desc.append("\u6307\u5b9a\u5ba2\u6237\uff1a" + collect);
            desc.append("\u6307\u5b9a\u5e74\u6708\u4efd\uff1a" + collect1);
        }
        return !((BizChangeRuleResultRespDto)result.getData()).getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue()) ? RestResponse.SUCCEED : new RestResponse("0001", desc.toString());
    }

    @Override
    public RestResponse<Void> modifyTrControlItemAmountRule(TrControlItemAmountRuleReqDto modifyReqDto) {
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        modifyReqDto.setOrgId(orgId);
        return this.iTrControlItemAmountRuleApi.modifyTrControlItemAmountRule(modifyReqDto);
    }

    @Override
    public RestResponse<Void> removeTrControlItemAmountRule(String ids) {
        return this.iTrControlItemAmountRuleApi.removeTrControlItemAmountRule(ids, null);
    }

    @Override
    public RestResponse<BizImportRespDto> importItemAmountByExcel(MultipartFile file) {
        BizImportDataReqDto bizImportDataReqDto = new BizImportDataReqDto();
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), ItemAmountVo.class, (ImportParams)importParams);
            List allFieldNullList = BeanPropertyNullUtil.getAllFieldNullList(result.getList());
            bizImportDataReqDto.setExcelImportResult(allFieldNullList);
        }
        catch (Exception var6) {
            var6.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        bizImportDataReqDto.setOrgId(orgId);
        bizImportDataReqDto.setTenantId(this.context.tenantId());
        TrControlItemAmountImportReqDto controlItemAmountImportReqDto = new TrControlItemAmountImportReqDto();
        controlItemAmountImportReqDto.setFileName(file.getOriginalFilename());
        controlItemAmountImportReqDto.setOrgId(orgId);
        this.logger.info("\u63d2\u5165\u6587\u4ef6\u5bfc\u5165\u8bb0\u5f55:{}", (Object)JSON.toJSONString((Object)controlItemAmountImportReqDto));
        RestResponse longRestResponse = this.controlItemAmountImportApi.addTrControlItemAmountImport(controlItemAmountImportReqDto);
        bizImportDataReqDto.setImportId((Long)longRestResponse.getData());
        return this.iTrControlItemAmountRuleApi.importItemAmountByExcel(bizImportDataReqDto);
    }

    @Override
    public RestResponse<BizImportRespDto> importSurplusAmountByExcel(MultipartFile file) {
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        BizImportDataReqDto bizImportDataReqDto = new BizImportDataReqDto();
        bizImportDataReqDto.setOrgId(orgId);
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), ItemSurplusAmountVo.class, (ImportParams)importParams);
            List collect = result.getList().stream().filter(c -> !BeanPropertyNullUtil.isAllFieldNull(c)).collect(Collectors.toList());
            bizImportDataReqDto.setExcelImportResult(collect);
        }
        catch (Exception var6) {
            var6.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        TrControlItemAmountImportReqDto controlItemAmountImportReqDto = new TrControlItemAmountImportReqDto();
        controlItemAmountImportReqDto.setFileName(file.getOriginalFilename());
        controlItemAmountImportReqDto.setOrgId(orgId);
        bizImportDataReqDto.setTenantId(this.context.tenantId());
        this.logger.info("\u63d2\u5165\u6587\u4ef6\u5bfc\u5165\u8bb0\u5f55:{}", (Object)JSON.toJSONString((Object)controlItemAmountImportReqDto));
        RestResponse longRestResponse = this.controlItemAmountImportApi.addTrControlItemAmountImport(controlItemAmountImportReqDto);
        bizImportDataReqDto.setImportId((Long)longRestResponse.getData());
        return this.iTrControlItemAmountRuleApi.importSurplusAmountVoByExcel(bizImportDataReqDto);
    }

    @Override
    public RestResponse<TrControlItemAmountRuleRespDto> queryById(Long id) {
        return this.iTrControlItemAmountRuleQueryApi.queryById(id);
    }

    @Override
    public RestResponse<PageInfo<TrControlItemAmountRuleRespDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        TrControlItemAmountRuleReqDto trControlItemAmountRuleReqDto = (TrControlItemAmountRuleReqDto)JSON.parseObject((String)filter, TrControlItemAmountRuleReqDto.class);
        trControlItemAmountRuleReqDto.setOrgId(orgId);
        return this.iTrControlItemAmountRuleQueryApi.queryByPage(JSON.toJSONString((Object)trControlItemAmountRuleReqDto), pageNum, pageSize);
    }

    @Override
    public RestResponse<PageInfo<TrControlItemAmountRecordRespDto>> queryRecordByPage(String filter, Integer pageNum, Integer pageSize) {
        TrControlItemAmountRecordReqDto trControlItemAmountRecordReqDto = (TrControlItemAmountRecordReqDto)JSON.parseObject((String)filter, TrControlItemAmountRecordReqDto.class);
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        trControlItemAmountRecordReqDto.setOrgId(orgId);
        return this.iTrControlItemAmountRecordQueryApi.queryByPage(JSON.toJSONString((Object)trControlItemAmountRecordReqDto), pageNum, pageSize);
    }

    @Override
    public RestResponse<Void> saveOrUpdateTrControlItemAmountConfig(TrControlItemAmountConfigReqDto modifyReqDto) {
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        modifyReqDto.setOrgId(orgId);
        return this.iTrControlItemAmountConfigApi.saveOrUpdateTrControlItemAmountConfig(modifyReqDto);
    }

    @Override
    public RestResponse<TrControlItemAmountConfigRespDto> queryByOrgId() {
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        return this.iTrControlItemAmountConfigQueryApi.queryByOrgId(orgId);
    }

    @Override
    public RestResponse<Void> modifyItemAmount(TrControlItemAmountRuleReqDto modifyReqDto) {
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        modifyReqDto.setOrgId(orgId);
        return this.iTrControlItemAmountRuleApi.modifyItemAmount(modifyReqDto);
    }

    @Override
    public RestResponse<String> getTemplateExcel(String type) {
        return this.iTrControlItemAmountRuleApi.getTemplateExcel(type);
    }
}

