/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.control.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.control.api.dto.request.BizRecordQueryReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.CustomerGiftAmountReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.CustomerGiftAmountRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.GiftAmountItemRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlGiftRecordRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlGiftResultRespDto;
import com.dtyunxi.tcbj.center.control.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.control.api.query.IControlOptQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.ITrControlGiftRecordQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.ITrControlGiftResultQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.ITrControlGiftRuleQueryApi;
import com.dtyunxi.tcbj.module.control.biz.dto.request.GiftAmountReqDto;
import com.dtyunxi.tcbj.module.control.biz.service.ICustomerAreaService;
import com.dtyunxi.tcbj.module.control.biz.service.IGiftAmountService;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ParentAreCodeReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GiftAmountServiceImpl
implements IGiftAmountService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GiftAmountServiceImpl.class);
    private static final Integer SALESMAN = 1;
    @Resource
    private IControlOptQueryApi controlOptQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ITrControlGiftResultQueryApi giftResultQueryApi;
    @Resource
    private ITrControlGiftRuleQueryApi controlGiftRuleQueryApi;
    @Resource
    private ITrControlGiftRecordQueryApi giftRecordQueryApi;
    @Resource
    private ICustomerAreaService customerAreaService;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IContext context;
    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;

    @Override
    public RestResponse<Map<Long, CustomerGiftAmountRespDto>> queryCustomerAmountForOrder(List<GiftAmountReqDto> reqDtos) {
        LOGGER.info("\u67e5\u8be2\u5ba2\u6237\u8d2d\u4e70\u8d60\u54c1\u65f6\u7684\u8d60\u54c1\u989d\u5ea6\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString(reqDtos));
        if (CollectionUtils.isEmpty(reqDtos)) {
            LOGGER.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u63d0\u4ea4\u7684\u53c2\u6570\u4e3a\u7a7a");
            return null;
        }
        List shopIds = reqDtos.stream().map(GiftAmountReqDto::getShopId).collect(Collectors.toList());
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerRespDto(shopIds));
        AssertUtils.notEmpty((Collection)customerRespDtos, (String)"\u67e5\u8be2\u5e97\u94fa\u5ba2\u6237\u4fe1\u606f\u5f02\u5e38\uff01");
        Map customerMap = Optional.ofNullable(customerRespDtos).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity()));
        LOGGER.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u67e5\u8be2\u5e97\u94fa({})\u5230\u5ba2\u6237\u7684\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString(shopIds), (Object)JSON.toJSONString((Object)customerRespDtos));
        List customerIdList = reqDtos.stream().map(GiftAmountReqDto::getCustomerId).distinct().collect(Collectors.toList());
        List customerInfoList = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByCustomerIds(customerIdList));
        Map customerInfoMap = customerInfoList.stream().collect(Collectors.toMap(BaseRespDto::getId, Function.identity(), (k1, k2) -> k1));
        ArrayList paramList = Lists.newArrayList();
        for (GiftAmountReqDto giftAmountReqDto : reqDtos) {
            CustomerRespDto customerRespDto = (CustomerRespDto)customerInfoMap.get(giftAmountReqDto.getCustomerId());
            List regionCodeList = Optional.ofNullable(customerRespDto.getRegionCodeList()).orElse(Lists.newArrayList()).stream().filter(e -> StringUtils.isNotEmpty((String)e)).collect(Collectors.toList());
            List<Object> parentAreaCodeList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(regionCodeList) && CollectionUtils.isNotEmpty(regionCodeList)) {
                ParentAreCodeReqDto parentAreCodeReqDto = new ParentAreCodeReqDto();
                parentAreCodeReqDto.setCodes(regionCodeList);
                parentAreaCodeList = (List)RestResponseHelper.extractData((RestResponse)this.customerAreaQueryApi.queryAllParentCode(parentAreCodeReqDto));
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)parentAreaCodeList)) {
                    parentAreaCodeList = parentAreaCodeList.stream().distinct().collect(Collectors.toList());
                }
            }
            LOGGER.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011[{}]\u67e5\u8be2\u5230\u5ba2\u6237\u7684\u4fe1\u606f\u4e3a\uff1a{}", (Object)Thread.currentThread().getName(), (Object)JSON.toJSONString((Object)customerRespDto));
            CustomerGiftAmountReqDto customerGiftAmountReqDto = new CustomerGiftAmountReqDto();
            customerGiftAmountReqDto.setItemList(giftAmountReqDto.getItemList());
            customerGiftAmountReqDto.setGiftList(giftAmountReqDto.getGiftList());
            customerGiftAmountReqDto.setCustomerCode(customerRespDto.getCode());
            customerGiftAmountReqDto.setOrgId(customerRespDto.getMerchantId());
            customerGiftAmountReqDto.setAreaCodeList((List)parentAreaCodeList);
            paramList.add(customerGiftAmountReqDto);
        }
        List giftAmountRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.controlOptQueryApi.queryCustomersAmountForOrder((List)paramList));
        LOGGER.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u67e5\u8be2\u5230\u5ba2\u6237\u5269\u4f59\u989d\u5ea6\u7684\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)giftAmountRespDtoList));
        HashMap respDtoMap = Maps.newHashMap();
        Optional.ofNullable(giftAmountRespDtoList).ifPresent(giftAmountList -> giftAmountList.forEach(item -> {
            CustomerRespDto customerRespDto = (CustomerRespDto)customerMap.get(item.getCustomerCode());
            if (customerRespDto != null) {
                respDtoMap.put(customerRespDto.getId(), item);
            }
        }));
        return new RestResponse((Object)respDtoMap);
    }

    @Override
    public RestResponse<List<TrControlGiftResultRespDto>> queryCustomerAmount() {
        LOGGER.info("\u900f\u4f20\u7528\u6237id\uff1a{}", (Object)this.context.userId());
        List customers = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryCustomerIdsByUserId(this.context.userId()));
        LOGGER.info("\u5ba2\u6237id\uff1a{}", (Object)JSON.toJSONString((Object)customers));
        List customerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByCustomerIds(customers));
        if (CollectionUtils.isEmpty((Collection)customerRespDtoList)) {
            LOGGER.info("\u5ba2\u6237\u4fe1\u606f\u5f02\u5e38\uff0c\u5ba2\u6237id\uff1a{}", (Object)JSON.toJSONString((Object)customers));
            return null;
        }
        Map<String, CustomerRespDto> customerHashMap = customerRespDtoList.stream().collect(Collectors.toMap(CustomerRespDto::getCode, item -> item, (oldVal, newVal) -> newVal));
        List customerCodeList = customerRespDtoList.stream().map(CustomerRespDto::getCode).collect(Collectors.toList());
        RestResponse listRestResponse = this.giftResultQueryApi.queryListByCustomer(customerCodeList);
        List giftResultRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        if (CollectionUtils.isNotEmpty((Collection)giftResultRespDtos)) {
            List merchantIdList = customerRespDtoList.stream().map(CustomerRespDto::getMerchantId).distinct().collect(Collectors.toList());
            CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
            searchReqDto.setOrgInfoIds(merchantIdList);
            List merchantList = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryByList(JSON.toJSONString((Object)searchReqDto)));
            Map<Long, CustomerRespDto> merchantHashMap = merchantList.stream().collect(Collectors.toMap(CustomerRespDto::getOrgInfoId, item -> item, (oldVal, newVal) -> newVal));
            for (TrControlGiftResultRespDto dto : giftResultRespDtos) {
                CustomerRespDto merchantDto;
                CustomerRespDto customerRespDto = customerHashMap.get(dto.getCustomerCode());
                if (customerRespDto == null || (merchantDto = merchantHashMap.get(customerRespDto.getMerchantId())) == null) continue;
                dto.setMerchantId(merchantDto.getOrgInfoId());
                dto.setMerchantName(merchantDto.getName());
            }
        }
        return new RestResponse((Object)giftResultRespDtos);
    }

    @Override
    public RestResponse<PageInfo<GiftAmountItemRespDto>> queryRulePageByCustomerCode(String customerCode, Integer status, Integer pageNum, Integer pageSize) {
        return this.controlGiftRuleQueryApi.queryRulePageByCustomerCode(customerCode, status, pageNum, pageSize);
    }

    @Override
    public RestResponse<TrControlGiftResultRespDto> queryById(Long id) {
        TrControlGiftResultRespDto giftResultRespDto = (TrControlGiftResultRespDto)RestResponseHelper.extractData((RestResponse)this.giftResultQueryApi.queryById(id));
        if (Objects.nonNull(giftResultRespDto)) {
            Long merchantId = giftResultRespDto.getOrgId();
            CustomerSearchReqDto sellerCustomerQuery = new CustomerSearchReqDto();
            sellerCustomerQuery.setOrgInfoIds((List)Lists.newArrayList((Object[])new Long[]{merchantId}));
            List merchantList = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryByList(JSON.toJSONString((Object)sellerCustomerQuery)));
            if (CollectionUtils.isNotEmpty((Collection)merchantList)) {
                giftResultRespDto.setMerchantId(((CustomerRespDto)merchantList.get(0)).getOrgInfoId());
                giftResultRespDto.setMerchantName(((CustomerRespDto)merchantList.get(0)).getName());
            }
        }
        return new RestResponse((Object)giftResultRespDto);
    }

    @Override
    public RestResponse<PageInfo<TrControlGiftRecordRespDto>> queryPageByRule(BizRecordQueryReqDto reqDto) {
        return this.giftRecordQueryApi.queryPageByRule(reqDto);
    }
}

