/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl.operation;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.dto.request.BaseDefinedParamDto;
import com.dtyunxi.tcbj.module.export.biz.dto.request.BaseImportInfoReqDto;
import com.dtyunxi.tcbj.module.export.biz.dto.request.CreditRepayPlanImportReqDto;
import com.dtyunxi.tcbj.module.export.biz.impl.ImportService;
import com.dtyunxi.yundt.cube.center.credit.api.account.ICreditRepayPlanImportApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditAccountSearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditEntitySearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditRepayPlanSearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.PageDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditAccountPageRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditEntityPageRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditRepayPlanRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditTermModelRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.AllowAddEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditRepayPlanStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.query.ICreditAccountQueryApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.query.ICreditEntityQueryApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.query.ICreditRepayPlanQueryApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.query.ICreditTermModelQueryApi;
import com.dtyunxi.yundt.cube.center.credit.api.dto.request.CreditRepayPlanImportInfoReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.response.OrderBizRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.response.OrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.query.IOrderBizQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="creditRepayPlanImportService")
public class CreditRepayPlanImportService
extends ImportService {
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICreditEntityQueryApi creditEntityQueryApi;
    @Resource
    private ICreditTermModelQueryApi creditTermModelQueryApi;
    @Resource
    private ICreditAccountQueryApi creditAccountQueryApi;
    @Resource
    private ICreditRepayPlanImportApi creditRepayPlanImportApi;
    @Resource
    private ICreditRepayPlanQueryApi creditRepayPlanQueryApi;
    @Resource
    private IOrderBizQueryApi orderBizQueryApi;

    @Override
    public void definedImport(BaseDefinedParamDto baseDefinedParamDto, Object list, List<BaseImportInfoReqDto> errorList, Set<String> importDataUniquekeySet) {
        Long organizationId = baseDefinedParamDto.getOrganizationId();
        List creditApplyImportReqDtos = (List)list;
        ArrayList customerCodes = Lists.newArrayList();
        ArrayList formCodes = Lists.newArrayList();
        for (CreditRepayPlanImportReqDto creditApplyImportReqDto : creditApplyImportReqDtos) {
            Optional.ofNullable(creditApplyImportReqDto.getCustomerCode()).ifPresent(customerCodes::add);
            Optional.ofNullable(creditApplyImportReqDto.getOrderNo()).ifPresent(formCodes::add);
        }
        Map<Object, Object> customerRespDtoMap = Maps.newHashMap();
        Map<Object, Object> creditEntityMap = Maps.newHashMap();
        Map<Object, Object> creditAccountEoMap = Maps.newHashMap();
        Map<Object, Object> creditTermModelMap = Maps.newHashMap();
        Map<Object, Object> planRespDtoMap = Maps.newHashMap();
        Map<Object, Object> orderMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)customerCodes)) {
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerListByCodes((List)customerCodes));
            customerRespDtoMap = customerRespDtos.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity(), (e1, e2) -> e1));
            if (CollectionUtil.isNotEmpty((Collection)customerRespDtos)) {
                List customerIds = customerRespDtos.stream().map(com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto::getId).collect(Collectors.toList());
                CreditEntitySearchReqDto creditEntitySearchReqDto = new CreditEntitySearchReqDto();
                creditEntitySearchReqDto.setIds(customerIds);
                PageInfo creditEntityPageRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.creditEntityQueryApi.pageCreditEntity(creditEntitySearchReqDto, Integer.valueOf(1), Integer.valueOf(customerIds.size())));
                if (creditEntityPageRespDtoPageInfo != null && CollectionUtil.isNotEmpty((Collection)creditEntityPageRespDtoPageInfo.getList())) {
                    creditEntityMap = creditEntityPageRespDtoPageInfo.getList().stream().collect(Collectors.toMap(CreditEntityPageRespDto::getId, Function.identity(), (e1, e2) -> e1));
                }
                CreditAccountSearchReqDto creditAccountSearchReqDto = new CreditAccountSearchReqDto();
                creditAccountSearchReqDto.setAccountIds(customerIds);
                List creditAccountPageRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.creditAccountQueryApi.queryAccountByEntityIds(creditAccountSearchReqDto));
                creditAccountEoMap = creditAccountPageRespDtos.stream().collect(Collectors.toMap(CreditAccountPageRespDto::getCreditEntityId, Function.identity(), (e1, e2) -> e1));
                List creditTermModelIds = creditAccountPageRespDtos.stream().map(CreditAccountPageRespDto::getCreditTermModelId).filter(Objects::nonNull).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(creditTermModelIds)) {
                    List creditTermModelEoList = (List)RestResponseHelper.extractData((RestResponse)this.creditTermModelQueryApi.queryByIds(creditTermModelIds));
                    creditTermModelMap = creditTermModelEoList.stream().collect(Collectors.toMap(BaseRespDto::getId, Function.identity(), (e1, e2) -> e1));
                }
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)formCodes)) {
            CreditRepayPlanSearchReqDto creditRepayPlanSearchReqDto = new CreditRepayPlanSearchReqDto();
            creditRepayPlanSearchReqDto.setPageNum(Integer.valueOf(1));
            creditRepayPlanSearchReqDto.setPageSize(Integer.valueOf(formCodes.size()));
            creditRepayPlanSearchReqDto.setFormCodes((List)formCodes);
            PageInfo creditRepayPlanRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.creditRepayPlanQueryApi.queryPage((PageDto)creditRepayPlanSearchReqDto));
            if (creditRepayPlanRespDtoPageInfo != null && CollectionUtil.isNotEmpty((Collection)creditRepayPlanRespDtoPageInfo.getList())) {
                planRespDtoMap = creditRepayPlanRespDtoPageInfo.getList().stream().collect(Collectors.toMap(CreditRepayPlanRespDto::getFormCode, Function.identity(), (e1, e2) -> e1));
            }
            OrderQueryReqDto orderQueryReqDto = new OrderQueryReqDto();
            orderQueryReqDto.setTradeNos((List)formCodes);
            orderQueryReqDto.setOrganizationId(organizationId);
            PageInfo orderPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.orderBizQueryApi.queryByPageOnPost(orderQueryReqDto, Integer.valueOf(1), Integer.valueOf(formCodes.size())));
            if (orderPageInfo != null && CollectionUtil.isNotEmpty((Collection)orderPageInfo.getList())) {
                orderMap = orderPageInfo.getList().stream().collect(Collectors.toMap(OrderRespDto::getOrderNo, Function.identity(), (e1, e2) -> e1));
            }
        }
        ArrayList planImportInfoReqDtos = Lists.newArrayList();
        for (CreditRepayPlanImportReqDto planImportReqDto : creditApplyImportReqDtos) {
            CreditRepayPlanRespDto creditRepayPlanRespDto;
            OrderBizRespDto orderBizRespDto;
            StringBuilder sb = new StringBuilder(80);
            if (StringUtils.isBlank((CharSequence)planImportReqDto.getOrderNo())) {
                sb.append("\u9500\u552e\u8ba2\u5355\u53f7\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)planImportReqDto.getCustomerCode())) {
                sb.append("\u5ba2\u6237\u7f16\u53f7\u4e3a\u7a7a\uff1b");
            }
            if (!importDataUniquekeySet.add(planImportReqDto.getOrderNo())) {
                sb.append("\u9500\u552e\u8ba2\u5355\u53f7\u5bfc\u5165\u91cd\u590d\uff1b");
            }
            if ((orderBizRespDto = (OrderBizRespDto)orderMap.get(planImportReqDto.getOrderNo())) == null) {
                sb.append("\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728\uff1b");
            }
            if ((creditRepayPlanRespDto = (CreditRepayPlanRespDto)planRespDtoMap.get(planImportReqDto.getOrderNo())) != null) {
                sb.append("\u9500\u552e\u5355\u5df2\u5b58\u5728\u6388\u4fe1\u8d26\u5355\uff0c\u4e0d\u80fd\u91cd\u590d\u5bfc\u5165\uff1b");
            }
            Integer cycleTotalNum = null;
            if (!StringUtils.isNumeric((CharSequence)planImportReqDto.getCycleTotalNum())) {
                sb.append("\u603b\u671f\u6570\u5fc5\u987b\u4e3a\u6b63\u6574\u6570\uff1b");
            } else {
                cycleTotalNum = Integer.valueOf(planImportReqDto.getCycleTotalNum());
            }
            Integer cycleNum = null;
            if (!StringUtils.isNumeric((CharSequence)planImportReqDto.getCycleNum())) {
                sb.append("\u672c\u671f\u671f\u6570\u5fc5\u987b\u4e3a\u6b63\u6574\u6570\uff1b");
            } else {
                cycleNum = Integer.valueOf(planImportReqDto.getCycleNum());
            }
            if (cycleNum != null && cycleTotalNum != null && cycleNum > cycleTotalNum) {
                sb.append("\u672c\u671f\u671f\u6570\u4e0d\u80fd\u5927\u4e8e\u603b\u671f\u6570");
            }
            BigDecimal paidAmount = super.tryConverBigDecimalAndCheckScale(sb, planImportReqDto.getPaidAmount(), "\u5b9e\u4ed8\u91d1\u989d", DEF_SCALE, false, false);
            BigDecimal refundAmount = super.tryConverBigDecimalAndCheckScale(sb, planImportReqDto.getRefundAmount(), "\u9000\u6b3e\u91d1\u989d", DEF_SCALE, true, false);
            BigDecimal receivedAmount = super.tryConverBigDecimalAndCheckScale(sb, planImportReqDto.getReceivedAmount(), "\u5df2\u8fd8\u6b3e\u91d1\u989d", DEF_SCALE, true, false);
            Date startDate = null;
            if (StringUtils.isBlank((CharSequence)planImportReqDto.getStartDate())) {
                sb.append("\u8d77\u7b97\u65e5\u671f\u4e3a\u7a7a\uff1b");
            } else if (!super.isValidDateFormat(planImportReqDto.getStartDate())) {
                sb.append("\u8d77\u7b97\u65e5\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528yyyy-MM-dd\u683c\u5f0f\uff1b");
            } else {
                startDate = DateUtil.parseDate((String)planImportReqDto.getStartDate(), (String)"yyyy-MM-dd");
            }
            Date endDate = null;
            if (StringUtils.isBlank((CharSequence)planImportReqDto.getEndDate())) {
                sb.append("\u5230\u671f\u65e5\u4e3a\u7a7a\uff1b");
            } else if (!super.isValidDateFormat(planImportReqDto.getEndDate())) {
                sb.append("\u5230\u671f\u65e5\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528yyyy-MM-dd\u683c\u5f0f\uff1b");
            } else {
                endDate = DateUtil.parseDate((String)planImportReqDto.getEndDate(), (String)"yyyy-MM-dd");
            }
            CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtoMap.get(planImportReqDto.getCustomerCode());
            CreditAccountPageRespDto creditAccountEo = null;
            CreditTermModelRespDto creditTermModelEo = null;
            if (customerRespDto == null || !Objects.equals(customerRespDto.getMerchantId(), organizationId)) {
                sb.append("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff1b");
            } else {
                CreditEntityPageRespDto entity = (CreditEntityPageRespDto)creditEntityMap.get(customerRespDto.getId());
                if (entity == null || AllowAddEnum.YES.getCode().equals(entity.getAllowAdd())) {
                    sb.append("\u5ba2\u6237\u6388\u4fe1\u672a\u51c6\u5165\uff0c\u5148\u8fdb\u884c\u5ba2\u6237\u51c6\u5165\u64cd\u4f5c\uff1b");
                }
                if ((creditAccountEo = (CreditAccountPageRespDto)creditAccountEoMap.get(entity.getId())) == null) {
                    sb.append("\u4fe1\u7528\u8d26\u6237\u4e0d\u5b58\u5728\uff1b");
                } else {
                    if (creditAccountEo.getCreditTermModelId() == null) {
                        sb.append("\u4fe1\u7528\u8d26\u6237\u7f3a\u5931\u6a21\u578b\uff0c\u9700\u8981\u5148\u7ed1\u5b9a\uff1b");
                    } else {
                        creditTermModelEo = (CreditTermModelRespDto)creditTermModelMap.get(creditAccountEo.getCreditTermModelId());
                        if (creditTermModelEo == null) {
                            sb.append("\u4fe1\u7528\u6a21\u578b\u4e0d\u5b58\u5728\uff1b");
                        }
                    }
                    if (creditAccountEo.getQuotaStrategyId() == null) {
                        sb.append("\u4fe1\u7528\u8d26\u6237\u7f3a\u5931\u989d\u5ea6\u6821\u9a8c\u7b56\u7565\uff0c\u9700\u8981\u5148\u914d\u7f6e\uff1b");
                    }
                    if (creditAccountEo.getOverdueStrategyId() == null) {
                        sb.append("\u4fe1\u7528\u8d26\u6237\u7f3a\u5931\u903e\u671f\u6821\u9a8c\u7b56\u7565\uff0c\u9700\u8981\u5148\u914d\u7f6e\uff1b");
                    }
                }
            }
            if (StringUtils.isBlank((CharSequence)sb.toString())) {
                BigDecimal accountQuota = Optional.ofNullable(creditAccountEo.getAccountQuota()).orElse(BigDecimal.ZERO);
                BigDecimal accountUsedQuota = Optional.ofNullable(creditAccountEo.getAccountUsedQuota()).orElse(BigDecimal.ZERO);
                CreditRepayPlanImportInfoReqDto planImportInfoReqDto = new CreditRepayPlanImportInfoReqDto();
                planImportInfoReqDto.setCreditAccountId(creditAccountEo.getId());
                planImportInfoReqDto.setCustomerId(customerRespDto.getId());
                planImportInfoReqDto.setCreditTermModelId(creditAccountEo.getCreditTermModelId());
                planImportInfoReqDto.setCreditTermType(creditTermModelEo.getType());
                Integer afterDays = Optional.ofNullable(creditTermModelEo.getAfterDays()).orElse(0);
                planImportInfoReqDto.setBeginDateType("\u53d1\u8d27\u65e5" + (afterDays > 0 ? "+" + afterDays : ""));
                planImportInfoReqDto.setIsHolidayDelay(creditTermModelEo.getIsHolidayDelay());
                planImportInfoReqDto.setFormCode(planImportReqDto.getOrderNo());
                planImportInfoReqDto.setAvaBalance(accountQuota.subtract(accountUsedQuota));
                planImportInfoReqDto.setOccupyQuota(paidAmount);
                planImportInfoReqDto.setPaidAmount(paidAmount);
                planImportInfoReqDto.setReceivedAmount(receivedAmount);
                planImportInfoReqDto.setRefundAmount(refundAmount);
                planImportInfoReqDto.setStartDate(startDate);
                planImportInfoReqDto.setEndDate(endDate);
                planImportInfoReqDto.setFinalRefundDate(null);
                planImportInfoReqDto.setFinalOverDueDateNum(null);
                planImportInfoReqDto.setCreditRepayPlanStatus(this.judgmentCreditRepayPlanStatus(paidAmount, receivedAmount, refundAmount));
                planImportInfoReqDto.setOrgInfoId(organizationId);
                planImportInfoReqDto.setCycleTotalNum(cycleTotalNum);
                planImportInfoReqDto.setCycleNum(cycleNum);
                planImportInfoReqDto.setQuotaStrategyId(creditAccountEo.getQuotaStrategyId());
                planImportInfoReqDto.setOverdueStrategyId(creditAccountEo.getOverdueStrategyId());
                planImportInfoReqDtos.add(planImportInfoReqDto);
                continue;
            }
            planImportReqDto.setErrorMsg(sb.toString());
            errorList.add(planImportReqDto);
        }
        if (CollectionUtil.isNotEmpty((Collection)planImportInfoReqDtos)) {
            RestResponseHelper.extractData((RestResponse)this.creditRepayPlanImportApi.batchImportPlans((List)planImportInfoReqDtos));
        }
    }

    private Integer judgmentCreditRepayPlanStatus(BigDecimal paidAmount, BigDecimal receivedAmount, BigDecimal refundAmount) {
        Integer status = null;
        status = paidAmount.compareTo(receivedAmount.add(refundAmount)) == 0 ? CreditRepayPlanStatusEnum.RECEIVABLE.getCode() : (receivedAmount.compareTo(BigDecimal.ZERO) == 0 ? CreditRepayPlanStatusEnum.NOT_RECEIVABLE.getCode() : CreditRepayPlanStatusEnum.PART_RECEIVABLE.getCode());
        return status;
    }
}

