/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.google.common.collect.Sets;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.tcbj.center.settlement.api.exception.AssertUtils;
import com.dtyunxi.tcbj.module.export.biz.constant.ImportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.dto.request.BaseDefinedParamDto;
import com.dtyunxi.tcbj.module.export.biz.dto.request.BaseImportInfoReqDto;
import com.dtyunxi.tcbj.module.export.biz.dto.request.BaseImportReqDto;
import com.dtyunxi.tcbj.module.export.biz.dto.response.BaseImportRespDto;
import com.dtyunxi.tcbj.module.export.biz.utils.BeanPropertyNullUtil;
import com.dtyunxi.tcbj.module.export.biz.utils.EasyPoiExportUtil;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ImportService {
    private static final Logger logger = LoggerFactory.getLogger(ImportService.class);
    private static final Integer PAGE_SIZE = 1000;
    private static final String YMD = "yyyy-MM-dd";
    protected static final String YMDHMS = "yyyy-MM-dd HH:mm:ss";
    protected static final Integer DEF_SCALE = 2;

    public BaseImportRespDto execute(BaseImportReqDto baseImportReqDto) {
        logger.info("\u4e1a\u52a1\u5bfc\u5165\u64cd\u4f5c\u5165\u53c2\u6570\uff1a{}", JSON.toJSON((Object)((Object)baseImportReqDto)));
        BaseImportRespDto importRespDto = new BaseImportRespDto();
        importRespDto.setOrganizationId(baseImportReqDto.getOrganizationId());
        try {
            InputStream is = this.getInputStream(baseImportReqDto.getFileUrl());
            ImportTypeEnum importTypeEnum = ImportTypeEnum.forCode(baseImportReqDto.getBusinessCode());
            AssertUtils.notNull((Object)((Object)importTypeEnum), (String)"\u5f53\u524d\u5bfc\u5165\u4e1a\u52a1\u679a\u4e3e\u914d\u7f6e\u5f02\u5e38");
            ImportParams params = new ImportParams();
            params.setTitleRows(0);
            params.setHeadRows(1);
            List importList = ExcelImportUtil.importExcel((InputStream)is, (Class)importTypeEnum.getImportClazz(), (ImportParams)params);
            importList = BeanPropertyNullUtil.getAllFieldNullList(importList);
            if (CollectionUtil.isEmpty(importList)) {
                throw new BizException("\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            }
            AtomicInteger lineNo = new AtomicInteger(1);
            List finalImportList = importList.stream().peek(info -> info.setRow(lineNo.incrementAndGet())).collect(Collectors.toList());
            ArrayList errorList = Lists.newArrayList();
            HashSet singleCustomerCodes = Sets.newHashSet();
            Stream.iterate(0, n -> n + 1).limit(ImportService.getCount(importList.size()).intValue()).forEach(page -> {
                List list = finalImportList.stream().skip(page * PAGE_SIZE).limit(PAGE_SIZE.intValue()).collect(Collectors.toList());
                this.definedImport(this.converParamDto(baseImportReqDto), list, errorList, singleCustomerCodes);
            });
            if (CollectionUtil.isNotEmpty((Collection)errorList)) {
                importRespDto.setFailNum(errorList.size());
                String title = importTypeEnum.getName() + "\u5bfc\u5165\u9519\u8bef\u4fe1\u606f";
                String fileName = title + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmssSSS");
                String exportUrl = EasyPoiExportUtil.getExportUrl(errorList, importTypeEnum.getErrorClazz(), null, fileName, "xls");
                importRespDto.setErrorFile(exportUrl);
            }
            importRespDto.setNum(importList.size());
            importRespDto.setSuccessNum(importRespDto.getNum() - importRespDto.getFailNum());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff0c" + e.getMessage());
        }
        return importRespDto;
    }

    protected BaseDefinedParamDto converParamDto(BaseImportReqDto baseImportReqDto) {
        BaseDefinedParamDto baseDefinedParamDto = new BaseDefinedParamDto();
        baseDefinedParamDto.setOrganizationId(baseImportReqDto.getOrganizationId());
        return baseDefinedParamDto;
    }

    public abstract void definedImport(BaseDefinedParamDto var1, Object var2, List<BaseImportInfoReqDto> var3, Set<String> var4);

    private InputStream getInputStream(String fileUrl) throws IOException {
        URL url = new URL(fileUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        return conn.getInputStream();
    }

    private static Integer getCount(Integer size) {
        return (PAGE_SIZE + size - 1) / PAGE_SIZE;
    }

    public boolean isValidDateFormat(String input) {
        return this.isValidDateFormat(input, YMD);
    }

    public boolean isValidDateFormat(String input, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setLenient(false);
        try {
            sdf.parse(input);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected BigDecimal tryConverBigDecimalAndCheckScale(StringBuilder sb, String fieldsValue, String fieldsName, Integer limitScale, boolean allowZero, boolean allowLessZero) {
        limitScale = limitScale == null ? DEF_SCALE : limitScale;
        BigDecimal amount = null;
        if (!NumberUtil.isNumber((CharSequence)fieldsValue)) {
            sb.append(fieldsName).append("\u5fc5\u987b\u8f93\u5165\u6570\u5b57\uff1b");
        } else {
            amount = new BigDecimal(fieldsValue);
            if (!allowZero && amount.compareTo(BigDecimal.ZERO) == 0) {
                sb.append(fieldsName).append("\u4e0d\u80fd\u4e3a0\uff1b");
            }
            if (amount.stripTrailingZeros().scale() > limitScale) {
                sb.append(fieldsName).append("\u4e0d\u80fd\u5927\u4e8e").append(limitScale).append("\u4f4d\u5c0f\u6570\uff1b");
            }
        }
        return amount;
    }
}

