/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.impl.ExportService;
import com.dtyunxi.tcbj.module.export.biz.utils.ThreadPoolUtil;
import com.dtyunxi.tcbj.module.export.biz.vo.item.ItemCustomizeExportVo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.api.dto.request.ItemExportQueryReqDto;
import com.yx.tcbj.center.api.dto.response.ItemExportQueryRespDto;
import com.yx.tcbj.center.api.query.IItemCenterQueryApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="itemExportService")
public class ItemExportService {
    private static final Logger logger = LoggerFactory.getLogger(ItemExportService.class);
    @Resource
    private ExportService exportService;
    @Resource
    private IContext context;
    @Resource
    private IItemCenterQueryApi iItemCenterQueryApi;

    public RestResponse<Object> exportItem(ItemExportQueryReqDto reqDto) {
        logger.info("\u5546\u54c1\u5bfc\u51fa\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        String fileName = "\u5546\u54c1\u5217\u8868_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        Long id = this.exportService.init(fileName, ExportTypeEnum.ITEM);
        ThreadPoolUtil.executorService.submit(() -> {
            logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\uff1a{}", (Object)fileName);
            try {
                PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iItemCenterQueryApi.queryExportPage(reqDto));
                if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                    List list = pageInfo.getList();
                    ArrayList<ItemCustomizeExportVo> exportVoList = new ArrayList<ItemCustomizeExportVo>();
                    for (ItemExportQueryRespDto queryRespDto : list) {
                        ItemCustomizeExportVo vo = new ItemCustomizeExportVo();
                        vo.setItemCode(queryRespDto.getItemCode());
                        vo.setExternalCode(queryRespDto.getExternalCode());
                        vo.setSubType(Objects.nonNull(queryRespDto.getSubType()) ? String.valueOf(queryRespDto.getSubType()) : "");
                        vo.setBrand(queryRespDto.getBrand());
                        vo.setItemName(queryRespDto.getItemName());
                        vo.setGiftBox(Objects.nonNull(queryRespDto.getGiftBox()) ? String.valueOf(queryRespDto.getGiftBox()) : "1");
                        vo.setLongCode(queryRespDto.getLongCode());
                        if (Objects.nonNull(queryRespDto.getItemStatus())) {
                            vo.setItemStatus(String.valueOf(queryRespDto.getItemStatus()));
                        }
                        vo.setShopName(queryRespDto.getShopName());
                        exportVoList.add(vo);
                    }
                    String excelName = "cube/" + fileName;
                    try {
                        String exportUrl = EasyPoiExportUtil.getExportUrl(exportVoList, ItemCustomizeExportVo.class, null, (String)excelName, (String)"xls");
                        this.exportService.success(id, exportUrl);
                        return;
                    }
                    catch (Exception e) {
                        logger.error("\u5bfc\u51fa\u5546\u54c1\u4fe1\u606f-\u9519\u8bef:{}", (Throwable)e);
                        this.exportService.fail(id, "\u5bfc\u51fa\u5546\u54c1\u4fe1\u606f-\u9519\u8bef1:" + e);
                        return;
                    }
                }
                this.exportService.fail(id, "\u5bfc\u51fa\u5546\u54c1\u4fe1\u606f,\u6570\u636e\u4e3a\u7a7a:");
                return;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.exportService.fail(id, "\u5bfc\u51fa\u5546\u54c1\u4fe1\u606f-\u9519\u8bef2:" + e);
                return;
            }
        });
        return new RestResponse("0", "\u5bfc\u51fa\u5546\u54c1\u4fe1\u606f\u6210\u529f");
    }
}

