/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.dto.response.TcbjOrderInfoExcelRespDto;
import com.dtyunxi.tcbj.module.export.biz.dto.response.TcbjOrderPrintInfoRespDto;
import com.dtyunxi.tcbj.module.export.biz.vo.order.OrderDetailVo;
import com.dtyunxi.tcbj.module.export.biz.vo.order.OrderItemDetailVo;
import com.dtyunxi.tcbj.module.export.biz.vo.order.PrintfItemVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerExtDetailRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.IItemAuthQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.SubTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OptTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderAddressSimpleRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderAddressQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserEmployeeQueryRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserEmployeeQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.trade.api.ILogService;
import com.dtyunxi.yundt.module.trade.api.IOrderService;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.OrderListQueryReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.ItemRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OptLogRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderListRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderListTotalRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderLogRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.PayRecordAppRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="orderExportService")
public class OrderExportService {
    @Autowired
    private IOrderService orderService;
    @Resource
    private IItemAuthQueryApi itemAuthQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ILogService logService;
    @Resource
    private IContext context;
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private IOrderAddressQueryApi addressQueryApi;
    private static final Logger logger = LoggerFactory.getLogger(OrderExportService.class);

    public RestResponse<Object> exportOrderInfo(String orderNo) {
        OrderRespDto orderRespDto = this.orderService.getMgmtOrderDetail(orderNo);
        try {
            if (!CollectionUtils.isEmpty((Collection)orderRespDto.getItemList())) {
                String exportUrl;
                String remark = StringUtils.isNotEmpty((CharSequence)orderRespDto.getBuyerRemark()) ? orderRespDto.getBuyerRemark() : "\u65e0";
                ArrayList<TcbjOrderInfoExcelRespDto> rList = new ArrayList<TcbjOrderInfoExcelRespDto>();
                List itemList = orderRespDto.getItemList();
                if (!CollectionUtils.isEmpty((Collection)orderRespDto.getGiftItems())) {
                    itemList.addAll(orderRespDto.getGiftItems());
                }
                ArrayList<Long> skuIds = new ArrayList<Long>();
                ArrayList<Long> shopIds = new ArrayList<Long>();
                for (ItemRespDto itemRespDto : itemList) {
                    skuIds.add(itemRespDto.getSkuId());
                    shopIds.add(itemRespDto.getSkuShopId());
                }
                ItemAuthReqDto itemAuthReqDto = new ItemAuthReqDto();
                itemAuthReqDto.setTargetType(Integer.valueOf(2));
                itemAuthReqDto.setTargetIdList(shopIds);
                itemAuthReqDto.setBusinessIdList(skuIds);
                RestResponse listRestResponse = this.itemAuthQueryApi.queryByTargetIds(itemAuthReqDto);
                HashMap map = CollectionUtils.isEmpty((Collection)((Collection)listRestResponse.getData())) ? new HashMap() : ((List)listRestResponse.getData()).stream().collect(Collectors.toMap(t -> t.getTargetId() + "-" + t.getBusinessId(), t -> t.getExternalCode(), (last, next) -> next));
                TcbjOrderInfoExcelRespDto tcbjOrderInfoExcelRespDto = null;
                for (ItemRespDto itemRespDto : itemList) {
                    tcbjOrderInfoExcelRespDto = new TcbjOrderInfoExcelRespDto();
                    String externalCode = map.containsKey(itemRespDto.getSkuShopId() + "-" + itemRespDto.getSkuId()) ? (String)map.get(itemRespDto.getSkuShopId() + "-" + itemRespDto.getSkuId()) : "\u65e0";
                    tcbjOrderInfoExcelRespDto.setCustomerName(orderRespDto.getCustomerName());
                    tcbjOrderInfoExcelRespDto.setAddress(orderRespDto.getAddress().getAddress());
                    tcbjOrderInfoExcelRespDto.setBuyerRemark(remark);
                    tcbjOrderInfoExcelRespDto.setItemCode(externalCode);
                    tcbjOrderInfoExcelRespDto.setItemName(itemRespDto.getItemName());
                    tcbjOrderInfoExcelRespDto.setSkuName(itemRespDto.getSkuName());
                    tcbjOrderInfoExcelRespDto.setUnitName(itemRespDto.getUnitName());
                    tcbjOrderInfoExcelRespDto.setItemPrice(itemRespDto.getItemPrice());
                    tcbjOrderInfoExcelRespDto.setItemNum(itemRespDto.getItemNum());
                    tcbjOrderInfoExcelRespDto.setSubTotal(itemRespDto.getSubTotal());
                    tcbjOrderInfoExcelRespDto.setBrandSuggestedRetailPrice(itemRespDto.getBrandSuggestedRetailPrice());
                    rList.add(tcbjOrderInfoExcelRespDto);
                }
                Long customerId = orderRespDto.getCustomerId();
                CustomerExtDetailRespDto customerExtDetailRespDto = (CustomerExtDetailRespDto)this.customerExtQueryApi.queryById(customerId).getData();
                String excelName = "cube/" + customerExtDetailRespDto.getName() + "-\u8ba2\u5355\u5546\u54c1\u660e\u7ec6Excel-" + DateUtil.getDateFormat((Date)orderRespDto.getPlaceTime(), (String)"yyyyMMddHHmmss");
                try {
                    exportUrl = EasyPoiExportUtil.getExportUrl(rList, TcbjOrderInfoExcelRespDto.class, null, (String)excelName, (String)"xls");
                }
                catch (Exception e) {
                    logger.error("\u5bfc\u51fa\u8ba2\u5355\u8be6\u60c5-\u9519\u8bef:{}", (Object)e.toString());
                    return new RestResponse("-1", "\u5bfc\u51fa\u8ba2\u5355\u8be6\u60c5-\u9519\u8bef:" + e);
                }
                return new RestResponse("0", "\u5bfc\u51fa\u8ba2\u5355\u8be6\u60c5\u6210\u529f", (Object)exportUrl);
            }
            return new RestResponse("-1", "\u5bfc\u51fa\u8ba2\u5355\u8be6\u60c5,\u6570\u636e\u4e3a\u7a7a", null);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new RestResponse("-1", "\u5bfc\u51fa\u5931\u8d25", null);
        }
    }

    public RestResponse<Object> exportOrderInfoForCustomer(String orderNo) {
        RestResponse response;
        block10: {
            response = null;
            try {
                OrderRespDto orderRespDto = this.orderService.getOrderDetail(orderNo, null, new boolean[]{true});
                if (!CollectionUtils.isEmpty((Collection)orderRespDto.getItemList())) {
                    String remark = StringUtils.isNotBlank((CharSequence)orderRespDto.getBuyerRemark()) ? orderRespDto.getBuyerRemark() : "\u65e0";
                    ArrayList<OrderDetailVo> rList = new ArrayList<OrderDetailVo>();
                    List itemList = orderRespDto.getItemList();
                    if (!CollectionUtils.isEmpty((Collection)orderRespDto.getGiftItems())) {
                        itemList.addAll(orderRespDto.getGiftItems());
                    }
                    Long customerId = orderRespDto.getCustomerId();
                    CustomerExtDetailRespDto customerExtDetailRespDto = (CustomerExtDetailRespDto)this.customerExtQueryApi.queryById(customerId).getData();
                    OrderDetailVo detailVo = new OrderDetailVo();
                    detailVo.setOrderNo(orderRespDto.getOrderNo());
                    detailVo.setPlaceTime(orderRespDto.getPlaceTime());
                    detailVo.setOrderTradeStatusName(orderRespDto.getOrderTradeStatusName());
                    detailVo.setShopName(orderRespDto.getShopName());
                    detailVo.setCustomerCode(customerExtDetailRespDto.getCode());
                    detailVo.setCustomerName(orderRespDto.getCustomerName());
                    detailVo.setDeliveryName(orderRespDto.getAddress().getDeliveryName());
                    detailVo.setDeliveryMobile(orderRespDto.getAddress().getDeliveryMobile());
                    detailVo.setAddress(orderRespDto.getAddress().getAddress());
                    detailVo.setBuyerRemark(remark);
                    ArrayList<OrderItemDetailVo> orderItemDetailVoList = new ArrayList<OrderItemDetailVo>();
                    rList.add(detailVo);
                    for (ItemRespDto itemRespDto : itemList) {
                        OrderItemDetailVo itemDetailVo = new OrderItemDetailVo();
                        itemDetailVo.setItemCode(itemRespDto.getItemCode());
                        itemDetailVo.setItemName(itemRespDto.getItemName());
                        itemDetailVo.setSkuName(itemRespDto.getSkuName());
                        itemDetailVo.setItemPrice(itemRespDto.getRetailPrice());
                        itemDetailVo.setItemNum(itemRespDto.getItemNum());
                        itemDetailVo.setSubTotal(itemRespDto.getRetailPrice().multiply(new BigDecimal(itemRespDto.getItemNum())));
                        orderItemDetailVoList.add(itemDetailVo);
                    }
                    detailVo.setOrderItemDetailVoList(orderItemDetailVoList);
                    this.addDisplayAmount(orderRespDto.getTotalAmount(), "\u5171 " + orderRespDto.getTotalItemNum() + " \u4ef6\uff0c\u5546\u54c1\u603b\u989d", rList, "\uffe5");
                    this.addDisplayAmount(orderRespDto.getGiftDeductionAmount(), "\u514d\u8d39\u8d60\u54c1", rList, null);
                    this.addDisplayAmount(orderRespDto.getDiscountAmount(), "\u4fc3\u9500\u4f18\u60e0", rList, null);
                    this.addDisplayAmount(orderRespDto.getTotalRebateAmount(), "\u6298\u6263\u652f\u4ed8", rList, null);
                    if (!CollectionUtils.isEmpty((Collection)orderRespDto.getPayRecordList())) {
                        for (PayRecordAppRespDto payRecord : orderRespDto.getPayRecordList()) {
                            this.addDisplayAmount(payRecord.getPayAmount(), payRecord.getPayMethodName(), rList, null);
                        }
                    }
                    this.addDisplayAmount(orderRespDto.getAlreadyPayAmount(), "\u5b9e\u4ed8\u91d1\u989d", rList, "\uffe5");
                    this.addDisplayAmount(orderRespDto.getRemainAmount(), "\u5269\u4f59\u5f85\u652f\u4ed8", rList, "\uffe5");
                    String excelName = "cube/" + customerExtDetailRespDto.getName() + "-\u8ba2\u5355[" + orderRespDto.getOrderNo() + "]\u660e\u7ec6Excel-" + DateUtil.getDateFormat((Date)orderRespDto.getPlaceTime(), (String)"yyyyMMddHHmmss");
                    String exportUrl = null;
                    try {
                        exportUrl = EasyPoiExportUtil.getExportUrl(rList, OrderDetailVo.class, null, (String)excelName, (String)"xls");
                    }
                    catch (Exception e) {
                        logger.error("\u5bfc\u51fa\u8ba2\u5355\u8be6\u60c5-\u9519\u8bef:{}", (Object)e.toString());
                        response = new RestResponse("-1", "\u5bfc\u51fa\u8ba2\u5355\u8be6\u60c5-\u9519\u8bef:" + e);
                    }
                    if (response == null) {
                        response = new RestResponse("0", "\u5bfc\u51fa\u8ba2\u5355\u8be6\u60c5\u6210\u529f", (Object)exportUrl);
                    }
                    break block10;
                }
                response = new RestResponse("-1", "\u5bfc\u51fa\u8ba2\u5355\u8be6\u60c5,\u6570\u636e\u4e3a\u7a7a", null);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                response = new RestResponse("-1", "\u5bfc\u51fa\u5931\u8d25:" + e.getMessage(), null);
            }
        }
        return response;
    }

    public RestResponse<Object> exportOrderInfoForCustomerSearch(OrderListQueryReqDto reqDto) {
        RestResponse response = null;
        try {
            Long total = null;
            double num = 0.0;
            Integer pageNum = 1;
            Integer pageSize = 5000;
            ArrayList rList = Lists.newArrayList();
            while (total == null || (double)pageNum.intValue() <= num) {
                logger.info("\u6267\u884c\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6\u53c2\u6570:{},pageNum:{},pageSize:{}", new Object[]{JSONObject.toJSONString((Object)reqDto), pageNum, pageSize});
                OrderListTotalRespDto orderListTotalRespDto = this.orderService.getOrderListTotal(reqDto, pageNum, pageSize);
                if (orderListTotalRespDto.getPageInfo() == null || CollectionUtils.isEmpty((Collection)orderListTotalRespDto.getPageInfo().getList())) {
                    return new RestResponse("-1", "\u5bfc\u51fa\u8ba2\u5355\u8be6\u60c5,\u6570\u636e\u4e3a\u7a7a", null);
                }
                if (total == null) {
                    total = orderListTotalRespDto.getPageInfo().getList().size();
                    num = Math.ceil(Double.valueOf(total.longValue()) / (double)pageSize.intValue());
                    logger.info("\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6\u603b\u6570:{},\u4e00\u5171\u9700\u8981\u5206\u6279:{}\u6b21", (Object)total, (Object)num);
                }
                pageNum = pageNum + 1;
                Set orderNoSet = orderListTotalRespDto.getPageInfo().getList().stream().map(e -> e.getOrderNo()).collect(Collectors.toSet());
                List addressList = (List)this.addressQueryApi.queryByOrderNos(orderNoSet).getData();
                Map<String, OrderAddressSimpleRespDto> addressMap = addressList.stream().collect(Collectors.toMap(e -> e.getOrderNo(), e -> e));
                List customerIds = orderListTotalRespDto.getPageInfo().getList().stream().map(e -> e.getCustomerId()).distinct().collect(Collectors.toList());
                List customerRespDtoList = (List)this.customerExtQueryApi.queryListOnPostByCustomerIds(customerIds).getData();
                Map<Long, CustomerRespDto> customerMap = customerRespDtoList.stream().collect(Collectors.toMap(e -> e.getId(), e -> e));
                for (OrderListRespDto orderRespDto : orderListTotalRespDto.getPageInfo().getList()) {
                    List itemList = orderRespDto.getItemList();
                    itemList.addAll(orderRespDto.getGiftItems());
                    OrderDetailVo detailVo = new OrderDetailVo();
                    detailVo.setOrderNo(orderRespDto.getOrderNo());
                    detailVo.setPlaceTime(orderRespDto.getPlaceTime());
                    detailVo.setOrderTradeStatusName(orderRespDto.getOrderTradeStatusName());
                    detailVo.setShopName(orderRespDto.getShopName());
                    detailVo.setCustomerCode(customerMap.get(orderRespDto.getCustomerId()) == null ? null : customerMap.get(orderRespDto.getCustomerId()).getCode());
                    detailVo.setCustomerName(orderRespDto.getCustomerName());
                    OrderAddressSimpleRespDto addressDto = addressMap.get(orderRespDto.getOrderNo());
                    if (addressDto != null) {
                        detailVo.setDeliveryName(addressDto.getDeliveryName());
                        detailVo.setDeliveryMobile(addressDto.getDeliveryMobile());
                        detailVo.setAddress(addressDto.getAddress());
                    }
                    detailVo.setBuyerRemark(StringUtils.isNotBlank((CharSequence)orderRespDto.getBuyerRemark()) ? orderRespDto.getBuyerRemark() : "\u65e0");
                    rList.add(detailVo);
                    ArrayList<OrderItemDetailVo> orderItemDetailVoList = new ArrayList<OrderItemDetailVo>();
                    detailVo.setOrderItemDetailVoList(orderItemDetailVoList);
                    for (ItemRespDto itemRespDto : itemList) {
                        OrderItemDetailVo itemDetailVo = new OrderItemDetailVo();
                        itemDetailVo.setItemCode(itemRespDto.getItemCode());
                        itemDetailVo.setItemName(itemRespDto.getItemName());
                        itemDetailVo.setSkuName(itemRespDto.getSkuName());
                        itemDetailVo.setItemPrice(itemRespDto.getRetailPrice());
                        itemDetailVo.setItemNum(itemRespDto.getItemNum());
                        itemDetailVo.setSubTotal(itemRespDto.getRetailPrice().multiply(new BigDecimal(itemRespDto.getItemNum())));
                        orderItemDetailVoList.add(itemDetailVo);
                    }
                }
                orderListTotalRespDto.getPageInfo().getList().clear();
            }
            if (CollectionUtils.isEmpty((Collection)rList)) {
                response = new RestResponse("-1", "\u5bfc\u51fa\u8ba2\u5355\u8be6\u60c5-\u5931\u8d25:\u6570\u636e\u4e3a\u7a7a");
            } else {
                String excelName = "cube/Web\u5546\u57ce\u5bfc\u51fa\u8ba2\u5355\u660e\u7ec6Excel-" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
                String exportUrl = null;
                try {
                    exportUrl = EasyPoiExportUtil.getExportUrl((List)rList, OrderDetailVo.class, null, (String)excelName, (String)"xls");
                    response = new RestResponse("0", "\u5bfc\u51fa\u8ba2\u5355\u8be6\u60c5\u6210\u529f", (Object)exportUrl);
                }
                catch (Exception e2) {
                    logger.error("\u5bfc\u51fa\u8ba2\u5355\u8be6\u60c5-\u9519\u8bef:{}", (Object)e2.toString());
                    response = new RestResponse("-1", "\u5bfc\u51fa\u8ba2\u5355\u8be6\u60c5-\u9519\u8bef:" + e2);
                }
            }
        }
        catch (Exception e3) {
            logger.error(e3.getMessage(), (Throwable)e3);
            response = new RestResponse("-1", "\u5bfc\u51fa\u5931\u8d25:" + e3.getMessage(), null);
        }
        return response;
    }

    public RestResponse<TcbjOrderPrintInfoRespDto> printf(String orderNo) {
        OrderRespDto orderRespDto = this.orderService.getMgmtOrderDetail(orderNo);
        TcbjOrderPrintInfoRespDto orderApply = new TcbjOrderPrintInfoRespDto();
        if (!CollectionUtils.isEmpty((Collection)orderRespDto.getItemList())) {
            List itemList = orderRespDto.getItemList();
            if (!CollectionUtils.isEmpty((Collection)orderRespDto.getGiftItems())) {
                itemList.addAll(orderRespDto.getGiftItems());
            }
            ArrayList<PrintfItemVo> products = new ArrayList<PrintfItemVo>();
            ArrayList<PrintfItemVo> materials = new ArrayList<PrintfItemVo>();
            ArrayList<PrintfItemVo> giveAways = new ArrayList<PrintfItemVo>();
            for (ItemRespDto itemRespDto : itemList) {
                PrintfItemVo product = new PrintfItemVo();
                product.setItemCode(itemRespDto.getItemCode());
                product.setItemName(itemRespDto.getItemName());
                product.setSkuName(itemRespDto.getSkuName());
                product.setUnitName(itemRespDto.getUnitName());
                product.setRetailPrice(Optional.ofNullable(itemRespDto.getRetailPrice()).orElse(new BigDecimal("0.00")));
                product.setItemNum(itemRespDto.getItemNum());
                product.setSubTotal(Optional.ofNullable(itemRespDto.getRetailPrice()).orElse(new BigDecimal("0.00")).multiply(BigDecimal.valueOf(product.getItemNum().intValue())));
                product.setItemTypeName(itemRespDto.getItemTypeName());
                if (SubTypeEnum.MATERIEL.getDesc().equals(itemRespDto.getItemTypeName())) {
                    materials.add(product);
                    continue;
                }
                if (SubTypeEnum.GIFT.getDesc().equals(itemRespDto.getItemTypeName())) {
                    giveAways.add(product);
                    continue;
                }
                products.add(product);
            }
            this.countSum(orderApply, products, SubTypeEnum.PRODUCT);
            this.countSum(orderApply, materials, SubTypeEnum.MATERIEL);
            this.countSum(orderApply, giveAways, SubTypeEnum.GIFT);
            orderApply.setProductList(products.size() > 0 ? products : null);
            orderApply.setMaterialList(materials.size() > 0 ? materials : null);
            orderApply.setGiveAwayList(giveAways.size() > 0 ? giveAways : null);
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        orderApply.setShopName(orderRespDto.getShopName());
        orderApply.setPlaceTime(format.format(orderRespDto.getPlaceTime()));
        orderApply.setOrderNo(orderRespDto.getOrderNo());
        orderApply.setOrderTradeStatusName(orderRespDto.getOrderTradeStatusName());
        orderApply.setCustomerName(orderRespDto.getCustomerName());
        orderApply.setAddress(orderRespDto.getAddress().getAddress());
        orderApply.setDeliveryName(orderRespDto.getAddress().getDeliveryName());
        orderApply.setDeliveryMobile(orderRespDto.getAddress().getDeliveryMobile());
        orderApply.setBuyerRemark(StringUtils.isNotBlank((CharSequence)orderRespDto.getBuyerRemark()) ? orderRespDto.getBuyerRemark() : "\u65e0");
        orderApply.setTotalAmount(orderRespDto.getTotalAmount());
        orderApply.setTotalItemNum(orderRespDto.getTotalItemNum());
        orderApply.setPayAmount(orderRespDto.getPayAmount());
        orderApply.setDiscountAmount(orderRespDto.getDiscountAmount());
        orderApply.setTotalRebateAmount(orderRespDto.getTotalRebateAmount());
        orderApply.setGiftDeductionAmount(orderRespDto.getGiftDeductionAmount());
        OrderLogRespDto orderLogRespDto = this.logService.getMgmtOrderLog(orderNo);
        String userName = Optional.ofNullable(orderLogRespDto.getOptLogList()).orElseGet(() -> new ArrayList(0)).stream().filter(optLog -> OptTypeEnum.ORDER_CUSTOMER_AUDIT.getType().equals(optLog.getOptType())).sorted(Comparator.comparing(OptLogRespDto::getOptTime, Comparator.nullsFirst(Date::compareTo))).collect(Collectors.toMap(t -> t.getOptType(), t -> t.getOptPerson(), (v1, v2) -> v2)).get(OptTypeEnum.ORDER_CUSTOMER_AUDIT.getType());
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            UserEmployeeQueryReqDto reqDto = new UserEmployeeQueryReqDto();
            reqDto.setUserName(userName);
            reqDto.setInstanceId(this.context.instanceId());
            String reqStr = JSON.toJSONString((Object)reqDto);
            RestResponse userResp = this.userQueryApi.queryPageByUserAndEmployeeInfo(reqStr, Integer.valueOf(1), Integer.valueOf(10));
            if (userResp != null && userResp.getData() != null && ((PageInfo)userResp.getData()).getList() != null && ((PageInfo)userResp.getData()).getList().size() > 0) {
                orderApply.setApproverName(((UserEmployeeQueryRespDto)((PageInfo)userResp.getData()).getList().get(0)).getEmployeeName());
            }
        }
        return new RestResponse((Object)orderApply);
    }

    private void countSum(TcbjOrderPrintInfoRespDto orderApply, List<PrintfItemVo> item, SubTypeEnum en) {
        if (item.size() > 0) {
            PrintfItemVo vo = new PrintfItemVo();
            vo.setSubTotal(item.stream().filter(t -> en.getDesc().equals(t.getItemTypeName())).map(PrintfItemVo::getSubTotal).reduce(BigDecimal::add).get());
            vo.setItemNum(item.stream().filter(t -> en.getDesc().equals(t.getItemTypeName())).map(PrintfItemVo::getItemNum).reduce(Integer::sum).get());
            item.add(vo);
        }
    }

    private void addDisplayAmount(BigDecimal displayAmount, String displayName, List<OrderDetailVo> rList, String flag) {
        if (ObjectUtils.isNotEmpty((Object)displayAmount) && displayAmount.compareTo(BigDecimal.ZERO) != 0) {
            OrderDetailVo detailVo = new OrderDetailVo();
            detailVo.setAddress(displayName + "\uff1a");
            detailVo.setBuyerRemark((StringUtils.isBlank((CharSequence)flag) ? "-\uffe5" : flag) + String.format("%.2f", displayAmount));
            rList.add(detailVo);
        }
    }
}

