/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.utils;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.format.DatePrinter;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.http.HttpException;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.tcbj.module.export.biz.vo.ExcelSheetVo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import jodd.util.StringUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import sun.misc.BASE64Encoder;

public class ExcelFileUtil {
    private static final Logger logger = LoggerFactory.getLogger(ExcelFileUtil.class);

    public static boolean checkFileSize(Long len, int size, String unit) {
        double fileSize = 0.0;
        if ("B".equals(unit.toUpperCase())) {
            fileSize = len.longValue();
        } else if ("K".equals(unit.toUpperCase())) {
            fileSize = (double)len.longValue() / 1024.0;
        } else if ("M".equals(unit.toUpperCase())) {
            fileSize = (double)len.longValue() / 1048576.0;
        } else if ("G".equals(unit.toUpperCase())) {
            fileSize = (double)len.longValue() / 1.073741824E9;
        }
        return !(fileSize > (double)size);
    }

    public static Workbook getWorkBook(InputStream is) throws IOException {
        HSSFWorkbook hssfWorkbook = null;
        try {
            hssfWorkbook = new HSSFWorkbook(is);
        }
        catch (Exception ex) {
            hssfWorkbook = new XSSFWorkbook(is);
        }
        return hssfWorkbook;
    }

    public static Workbook getWorkBook(MultipartFile file) throws IOException {
        InputStream is = file.getInputStream();
        HSSFWorkbook hssfWorkbook = null;
        try {
            hssfWorkbook = new HSSFWorkbook(is);
        }
        catch (Exception ex) {
            is = file.getInputStream();
            hssfWorkbook = new XSSFWorkbook(is);
        }
        return hssfWorkbook;
    }

    public static <T> List<T> importExcel(InputStream inputStream, int sheetIndex, Integer titleRows, Integer headerRows, Class<T> pojoClass) {
        ImportParams params = new ImportParams();
        params.setStartSheetIndex(sheetIndex);
        params.setTitleRows(titleRows.intValue());
        params.setHeadRows(headerRows.intValue());
        List list = null;
        try {
            list = ExcelImportUtil.importExcel((InputStream)inputStream, pojoClass, (ImportParams)params);
        }
        catch (NoSuchElementException e) {
            logger.error("\u6a21\u677f\u4e0d\u4e3a\u7a7a", (Throwable)e);
            throw new BizException("\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6excel\u6587\u4ef6\u51fa\u9519", (Throwable)e);
            throw new BizException("\u8bfb\u53d6excel\u6587\u4ef6\u51fa\u9519");
        }
        return list;
    }

    public static String byte2Base64(byte[] bytes) {
        return Base64.encodeBase64String((byte[])bytes);
    }

    public static byte[] base64Str2Byte(String base64) {
        return Base64.decodeBase64((String)base64);
    }

    public static boolean isExcel2003(String filePath) {
        return filePath.matches("^.+\\.(?i)(xls)$");
    }

    public static boolean isExcel2007(String filePath) {
        return filePath.matches("^.+\\.(?i)(xlsx)$");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String buildFileBase64(List<ExcelSheetVo> sheetVos, Class<?> clazz) {
        if (CollectionUtil.isEmpty(sheetVos)) {
            return null;
        }
        Workbook workBook = null;
        ByteArrayOutputStream outputStream = null;
        try {
            String base64;
            ArrayList sheetsList = new ArrayList();
            for (int i = 0; i < sheetVos.size(); ++i) {
                int sheetIndex = i + 1;
                ExcelSheetVo excelSheetVo = sheetVos.get(i);
                ExportParams exportParams = new ExportParams();
                exportParams.setSheetName(StringUtil.isBlank((CharSequence)excelSheetVo.getSheetName()) ? "Sheet" + sheetIndex : excelSheetVo.getSheetName());
                if (StringUtil.isNotBlank((CharSequence)excelSheetVo.getSheetTitle())) {
                    exportParams.setTitle(excelSheetVo.getSheetTitle());
                }
                HashMap<String, Object> exportMap = new HashMap<String, Object>();
                exportMap.put("title", exportParams);
                exportMap.put("entity", clazz);
                exportMap.put("data", excelSheetVo.getSheetObject());
                sheetsList.add(exportMap);
            }
            workBook = ExcelExportUtil.exportExcel(sheetsList, (ExcelType)ExcelType.HSSF);
            outputStream = new ByteArrayOutputStream();
            workBook.write((OutputStream)outputStream);
            outputStream.flush();
            byte[] byteArray = outputStream.toByteArray();
            String string = base64 = ExcelFileUtil.byte2Base64(byteArray);
            return string;
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5bfc\u51faExcel\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (Objects.nonNull(outputStream)) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95edByteArrayOutputStream\u5931\u8d25", (Throwable)e);
                }
            }
            if (Objects.nonNull(workBook)) {
                try {
                    workBook.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95edWorkbook\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return null;
    }

    public static String multipartFile2Base64(MultipartFile mFiles) {
        File file = null;
        FileInputStream inputStream = null;
        String encoded = null;
        try {
            file = File.createTempFile("tmp", null);
            mFiles.transferTo(file);
            file.deleteOnExit();
            inputStream = new FileInputStream(file);
            byte[] buffer = new byte[(int)file.length()];
            inputStream.read(buffer);
            inputStream.close();
            String base64 = new BASE64Encoder().encode(buffer);
            encoded = base64.replaceAll("[\\s*\t\n\r]", "");
        }
        catch (HttpException e) {
            logger.error("HttpException\u9519\u8bef", (Throwable)e);
            throw new BizException("HttpException\u9519\u8bef");
        }
        catch (IOException e) {
            logger.error("IOException\u9519\u8bef", (Throwable)e);
            throw new BizException("IOException\u9519\u8bef");
        }
        finally {
            if (Objects.nonNull(inputStream)) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95edInputStream\u9519\u8bef", (Throwable)e);
                    throw new BizException("\u5173\u95edInputStream\u9519\u8bef");
                }
            }
        }
        return encoded;
    }

    public static String now() {
        return DateUtil.format((Date)new DateTime(), (DatePrinter)DatePattern.PURE_DATETIME_FORMAT);
    }

    public static String filePrefix(String fileName) {
        return FileNameUtil.getPrefix((String)fileName);
    }

    public static String fileSuffix(String fileName) {
        return FileNameUtil.getSuffix((String)fileName);
    }
}

