/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.company.CompanyVerifyRespDto;
import com.dtyunxi.tcbj.module.export.biz.constant.ImportLogStatusEnum;
import com.dtyunxi.tcbj.module.export.biz.constant.ImportLogTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.dto.request.ImportReqDto;
import com.dtyunxi.tcbj.module.export.biz.dto.response.CustomerInfoUpdateImportDto;
import com.dtyunxi.tcbj.module.export.biz.dto.response.CustomerItemAuthImportDto;
import com.dtyunxi.tcbj.module.export.biz.impl.CustomerAddImportService;
import com.dtyunxi.tcbj.module.export.biz.impl.ImportLogService;
import com.dtyunxi.tcbj.module.export.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.tcbj.module.export.dao.eo.ImportLogEo;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.constant.SubjectTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerExtApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CompanyInfoDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerStatusReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerStatusRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerTypeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerStatusQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.entity.NacosPropertiesOrgEntity;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerAreaListExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerQueryV3Api;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeRegionQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseSupplyRelRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.IAuthItemRuleApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.AuthItemRuleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.CustomerAuthItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.AuthItemRuleRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.CustomerAuthItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BrandRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailBaseInfoRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuInfoRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.api.util.BeanPropertyNullUtil;
import com.dtyunxi.yundt.module.bitem.biz.service.IAuthItemRuleService;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.demo.center.data.query.IAreaExtQueryApi;
import com.yx.tcbj.center.api.ItemBrandAuthApi;
import com.yx.tcbj.center.api.dto.request.ItemShopQueryReqDto;
import com.yx.tcbj.center.api.query.IItemCenterQueryApi;
import com.yx.tcbj.center.customer.api.dto.request.CustomerExtReqDto;
import com.yx.tcbj.center.customer.api.dto.request.CustomerSearchExtThreeReqDto;
import com.yx.tcbj.center.customer.api.dto.response.CustomerExtRespDto;
import com.yx.tcbj.center.customer.api.query.ICustomerExtThreeQueryApi;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import com.yx.tcbj.center.price.api.IPrBaseDiscountApi;
import com.yx.tcbj.center.price.api.dto.request.PrBaseDiscountAddEditReqDto;
import com.yx.tcbj.center.price.api.dto.request.PrBaseDiscountBrandReqDto;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CustomerInfoUpdateImportService {
    public final Logger logger = LoggerFactory.getLogger(CustomerInfoUpdateImportService.class);
    @Resource
    private IContext context;
    @Resource
    private ImportLogService importLogService;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private IEmployeeRegionQueryApi employeeRegionQueryApi;
    @Resource
    private ICustomerQueryV3Api customerQueryV3Api;
    @Resource
    private ICustomerExtApi customerExtApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private HttpServletRequest request;
    @Resource
    private NacosPropertiesOrgEntity nacosPropertiesOrgEntity;
    @Resource
    private CustomerAddImportService customerAddImportService;
    @Resource
    private IAreaExtQueryApi areaExtQueryApi;
    @Resource
    private ICustomerExtThreeQueryApi customerExtThreeQueryApi;
    @Resource
    private IShopExtQueryApi shopExtQueryApi;
    @Resource
    private IItemCenterQueryApi itemCenterQueryApi;
    @Resource
    private IAuthItemRuleApi authItemRuleApi;
    @Resource
    private IAuthItemRuleService authItemRuleService;
    @Resource
    private ItemBrandAuthApi itemBrandAuthApi;
    @Resource
    private IPrBaseDiscountApi prBaseDiscountApi;
    @Resource
    private ICustomerStatusQueryApi customerStatusQueryApi;

    Long getTenantId() {
        Long tenantId = ServiceContext.getContext().getRequestTenantId();
        if (Objects.isNull(tenantId)) {
            tenantId = 1L;
        }
        return tenantId;
    }

    Long getInstanceId() {
        Long instanceId = ServiceContext.getContext().getRequestInstanceId();
        if (Objects.isNull(instanceId)) {
            instanceId = 1254039287584232622L;
        }
        return instanceId;
    }

    public String getHeaderOrgId() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        this.logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        return organizationId;
    }

    public void customerInfoUpdateImport(ImportReqDto importReqDto) {
        this.logger.info("\u5ba2\u5546\u7ba1\u7406\u5bfc\u5165\u5ba2\u6237\u4fee\u6539:{}", (Object)JSON.toJSONString((Object)importReqDto));
        String fileUrl = importReqDto.getFileUrl();
        AssertUtil.assertNotBlank((String)fileUrl, (String)"\u5bfc\u5165\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        AssertUtil.assertNotBlank((String)fileUrl, (String)"\u5bfc\u5165\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        String b2bOrgIdStr = this.getHeaderOrgId();
        if (StringUtils.isEmpty((CharSequence)b2bOrgIdStr)) {
            b2bOrgIdStr = this.nacosPropertiesOrgEntity.orgId();
            this.logger.info("nacos\u914d\u7f6e\u7684\u7ec4\u7ec7ID\uff1a{}", (Object)b2bOrgIdStr);
        }
        AssertUtil.assertNotBlank((String)b2bOrgIdStr, (String)"\u8bf7\u6c42\u5934[yes-req-cus-b2b-organizationId]\u503c\u4e3a\u7a7a");
        Long b2bOrgId = Long.valueOf(b2bOrgIdStr);
        List importDtos = Lists.newArrayList();
        try {
            InputStream is = this.getInputStream(fileUrl);
            ExcelImportResult objectExcelImportResult = EasyPoiExportUtil.importExcel(is, 0, 1, CustomerInfoUpdateImportDto.class);
            importDtos = objectExcelImportResult.getList();
            importDtos = BeanPropertyNullUtil.getAllFieldNullList((List)importDtos);
        }
        catch (Exception e) {
            throw new BizException("\u5bfc\u5165\u5ba2\u6237\u4fee\u6539\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
        }
        Long requestTenantId = this.getTenantId();
        Long requestInstanceId = this.getInstanceId();
        this.logger.info("\u5bfc\u5165\u7684\u6570\u636e==>{}", (Object)JSONObject.toJSONString((Object)importDtos));
        ImportLogEo initLog = ImportLogEo.newInstance();
        initLog.setImportFileUrl(importReqDto.getFileUrl());
        String fileName = importReqDto.getFileName();
        if (StringUtils.isEmpty((CharSequence)importReqDto.getFileName())) {
            fileName = StringUtils.substringAfter((String)importReqDto.getFileUrl(), (String)"cube//");
        }
        initLog.setFileName(fileName);
        initLog.setImportType(ImportLogTypeEnum.CUSTOMER.getCode());
        initLog.setTotalNum(Integer.valueOf(importDtos.size()));
        initLog.setOrganizationId(b2bOrgId);
        initLog.setInstanceId(requestInstanceId);
        initLog.setTenantId(requestTenantId);
        Long importLogId = this.importLogService.init(initLog);
        List finalImportDtos = importDtos;
        CompletableFuture.runAsync(() -> {
            try {
                this.logger.info("\u5f02\u6b65\u5bfc\u5165\u5ba2\u6237\u4fee\u6539\u5f00\u59cb,\u65e5\u5fd7id[{}],\u65f6\u95f4[{}]", (Object)importLogId, (Object)System.currentTimeMillis());
                this.doImportSyn(requestTenantId, requestInstanceId, finalImportDtos, importLogId, null, b2bOrgId);
                this.logger.info("\u5f02\u6b65\u5bfc\u5165\u5ba2\u6237\u4fee\u6539\u7ed3\u675f,\u65e5\u5fd7id[{}],\u65f6\u95f4[{}]", (Object)importLogId, (Object)System.currentTimeMillis());
            }
            catch (Exception e) {
                this.importLogService.fail(importLogId, e.getMessage(), "", finalImportDtos.size());
                e.printStackTrace();
                this.logger.info("\u5f02\u6b65\u5bfc\u5165\u5ba2\u6237\u4fee\u6539\u65e5\u5fd7id[{}],\u5f02\u5e38\u4fe1\u606f{}", (Object)importLogId, (Object)e.getMessage());
            }
        });
    }

    private InputStream getInputStream(String fileUrl) throws IOException {
        URL url = new URL(fileUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        return conn.getInputStream();
    }

    private void doImportSyn(Long requestTenantId, Long requestInstanceId, List<CustomerInfoUpdateImportDto> importDtos, Long importLogId, Long sellerId, Long orgId) {
        Object customerTypeDtos;
        List customerTypeList;
        this.checkData(importDtos, sellerId, orgId, requestTenantId, requestInstanceId);
        List successList = importDtos.stream().filter(dto -> StringUtils.isEmpty((CharSequence)dto.getErrorReason())).collect(Collectors.toList());
        this.logger.info("\u7b5b\u9009\u6210\u529f\u7684\u6570\u636e:{}", (Object)successList.size());
        Map<String, Object> customerTypeInfoMap = new HashMap<String, CustomerTypeRespDto>();
        if (CollectionUtils.isNotEmpty(successList) && CollectionUtils.isNotEmpty(customerTypeList = successList.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getCustomerTypeName())).map(CustomerInfoUpdateImportDto::getCustomerTypeName).collect(Collectors.toList())) && CollectionUtils.isNotEmpty((Collection)(customerTypeDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryV3Api.getCustomerTypeByNames(customerTypeList))))) {
            customerTypeInfoMap = customerTypeDtos.stream().collect(Collectors.toMap(CustomerTypeRespDto::getName, Function.identity(), (k1, k2) -> k1));
        }
        String failReason = "";
        for (CustomerInfoUpdateImportDto importDto : importDtos) {
            if (StringUtils.isNotEmpty((CharSequence)importDto.getErrorReason())) continue;
            try {
                this.updateCustomer(importDto, orgId, requestTenantId, requestInstanceId, customerTypeInfoMap);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.info("\u5ba2\u6237\u4fee\u6539\u5931\u8d25:{}", (Object)e.getMessage());
                importDto.setErrorReason(e.getMessage());
            }
        }
        List errorList = importDtos.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getErrorReason())).collect(Collectors.toList());
        int errorSize = errorList.size();
        int totalSize = importDtos.size();
        this.logger.info("\u66f4\u65b0\u5bfc\u5165\u5ba2\u6237\u4fee\u6539\u5931\u8d25\u6570:{},\u603b\u6570:{}", (Object)errorSize, (Object)totalSize);
        if (errorSize == 0) {
            this.importLogService.success(importLogId, ImportLogStatusEnum.SUCCEED, totalSize, "", "", 0);
        } else {
            String title = "\u5bfc\u5165\u5ba2\u6237\u4fee\u6539\u8fd4\u56de\u7ed3\u679c";
            String fileName = title + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmssSSS");
            String exportUrl = "";
            try {
                Thread.sleep(2000L);
                exportUrl = EasyPoiExportUtil.getExportUrl(importDtos, CustomerInfoUpdateImportDto.class, null, fileName, "xls");
            }
            catch (Exception e) {
                e.printStackTrace();
                failReason = failReason + "\u5bfc\u51fa\u5f02\u5e38\uff1a" + e.getMessage();
                this.logger.info(failReason);
            }
            if (errorSize < totalSize) {
                this.importLogService.success(importLogId, ImportLogStatusEnum.PART_SUCCESS, totalSize - errorSize, failReason, exportUrl, errorSize);
            } else {
                this.importLogService.fail(importLogId, failReason, exportUrl, errorSize);
            }
        }
    }

    private void checkData(List<CustomerInfoUpdateImportDto> importDtos, Long sellerId, Long orgId, Long requestTenantId, Long requestInstanceId) {
        List allCustomerStatuses = null;
        try {
            CustomerStatusReqDto statusQuery = new CustomerStatusReqDto();
            statusQuery.setRecordStatus(Integer.valueOf(1));
            allCustomerStatuses = (List)RestResponseHelper.extractData((RestResponse)this.customerStatusQueryApi.queryByList(JSON.toJSONString((Object)statusQuery)));
            this.logger.info("\u83b7\u53d6\u5230\u6709\u6548\u7684\u5ba2\u6237\u72b6\u6001\u5217\u8868, \u6570\u91cf: {}", (Object)(CollectionUtils.isNotEmpty((Collection)allCustomerStatuses) ? allCustomerStatuses.size() : 0));
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5ba2\u6237\u72b6\u6001\u5217\u8868\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
        }
        Set<Object> validCustomerStatusNames = new HashSet();
        if (CollectionUtils.isNotEmpty(allCustomerStatuses)) {
            validCustomerStatusNames = allCustomerStatuses.stream().map(CustomerStatusRespDto::getName).collect(Collectors.toSet());
        }
        for (CustomerInfoUpdateImportDto importDto : importDtos) {
            Integer toLegalCardType;
            String[] areaNameArr;
            List uniqueAreaNames;
            StringBuffer errorMsg = new StringBuffer();
            if (StringUtils.isEmpty((CharSequence)importDto.getCode())) {
                errorMsg.append("\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a;");
            } else {
                CustomerExtReqDto reqDto = new CustomerExtReqDto();
                reqDto.setCodes((List)Lists.newArrayList((Object[])new String[]{importDto.getCode()}));
                List customerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerInfoByOrg(reqDto));
                if (CollectionUtils.isEmpty((Collection)customerRespDtoList)) {
                    errorMsg.append("\u5ba2\u6237\u7f16\u7801\u4e0d\u5b58\u5728;");
                }
            }
            if (StringUtils.isEmpty((CharSequence)importDto.getStandardDiscountRate())) {
                errorMsg.append("\u6807\u51c6\u6263\u7387\u4e3a\u7a7a;");
            } else {
                try {
                    BigDecimal rate = new BigDecimal(importDto.getStandardDiscountRate());
                    if (rate.compareTo(BigDecimal.ZERO) <= 0 || rate.compareTo(new BigDecimal(1)) > 0) {
                        errorMsg.append("\u6807\u51c6\u6263\u7387\u5fc5\u987b\u5927\u4e8e0\u4e14\u5c0f\u4e8e\u7b49\u4e8e1;");
                    }
                }
                catch (NumberFormatException e) {
                    errorMsg.append("\u6807\u51c6\u6263\u7387\u683c\u5f0f\u9519\u8bef;");
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getCustomerStatus()) && !validCustomerStatusNames.isEmpty() && !validCustomerStatusNames.contains(importDto.getCustomerStatus())) {
                errorMsg.append("\u5ba2\u6237\u72b6\u6001\u4e0d\u5b58\u5728\uff0c\u6709\u6548\u7684\u72b6\u6001: ").append(String.join((CharSequence)", ", validCustomerStatusNames)).append(";");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getSalesArea()) && StringUtils.isNotEmpty((CharSequence)importDto.getLargeArea()) && StringUtils.isNotEmpty((CharSequence)importDto.getRegionName()) && StringUtils.isNotEmpty((CharSequence)importDto.getRegionName()) && (uniqueAreaNames = Arrays.stream(areaNameArr = importDto.getRegionName().split(";")).distinct().collect(Collectors.toList())).size() < areaNameArr.length) {
                this.logger.warn("\u5ba2\u6237\u533a\u57df\u5b58\u5728\u91cd\u590d\u8bb0\u5f55: {}", (Object)importDto.getRegionName());
                errorMsg.append("\u5ba2\u6237\u533a\u57df\u5b58\u5728\u91cd\u590d\u503c\uff0c\u5df2\u81ea\u52a8\u5904\u7406;");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getMultiBrandDiscount())) {
                String[] brandDiscounts;
                for (String brandDiscount : brandDiscounts = importDto.getMultiBrandDiscount().split(",")) {
                    if (!brandDiscount.contains(":")) {
                        errorMsg.append("\u591a\u54c1\u724c\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u4e3a\u54c1\u724c\u540d\u79f0:\u6263\u7387;");
                        break;
                    }
                    String[] parts = brandDiscount.split(":");
                    if (parts.length != 2) {
                        errorMsg.append("\u591a\u54c1\u724c\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u4e3a\u54c1\u724c\u540d\u79f0:\u6263\u7387;");
                        break;
                    }
                    try {
                        BigDecimal rate = new BigDecimal(parts[1]);
                        if (rate.compareTo(BigDecimal.ZERO) > 0 && rate.compareTo(new BigDecimal(1)) <= 0) continue;
                        errorMsg.append("\u591a\u54c1\u724c\u6263\u7387\u5fc5\u987b\u5927\u4e8e0\u4e14\u5c0f\u4e8e\u7b49\u4e8e1;");
                    }
                    catch (NumberFormatException e) {
                        errorMsg.append("\u591a\u54c1\u724c\u6263\u7387\u5fc5\u987b\u4e3a\u6570\u5b57;");
                    }
                    break;
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getSubjectType()) && StringUtils.isEmpty((CharSequence)this.toSubjectType(importDto.getSubjectType()))) {
                errorMsg.append("\u4e3b\u4f53\u7c7b\u578b\u9519\u8bef;");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getBusinessLicenseType()) && this.toBusinessLicenseType(importDto.getBusinessLicenseType()) == 0) {
                errorMsg.append("\u6267\u7167\u7c7b\u578b\u9519\u8bef;");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getBusinessTermType())) {
                String toBusinessTermType = this.toBusinessTermType(importDto.getBusinessTermType());
                if (toBusinessTermType.equals("0")) {
                    errorMsg.append("\u8425\u4e1a\u671f\u9650\u7c7b\u578b\u9519\u8bef;");
                } else if (toBusinessTermType.equals("1")) {
                    if (StringUtils.isEmpty((CharSequence)importDto.getTermBeginTime())) {
                        errorMsg.append("\u8425\u4e1a\u671f\u9650\u8d77\u4e3a\u7a7a;");
                    }
                    if (StringUtils.isEmpty((CharSequence)importDto.getTermEndTime())) {
                        errorMsg.append("\u8425\u4e1a\u671f\u9650\u6b62\u4e3a\u7a7a;");
                    }
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getLegalCardType()) && (toLegalCardType = this.toLegalCardType(importDto.getLegalCardType())).equals(0)) {
                errorMsg.append("\u6cd5\u4eba\u8bc1\u4ef6\u7c7b\u578b\u9519\u8bef;");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getCardEffectType())) {
                Integer toCardEffectType = this.toCardEffectType(importDto.getCardEffectType());
                if (toCardEffectType.equals(0)) {
                    errorMsg.append("\u6cd5\u4eba\u8bc1\u4ef6\u6709\u6548\u671f\u7c7b\u578b\u9519\u8bef;");
                } else if (toCardEffectType.equals(1)) {
                    if (Objects.isNull(importDto.getCardEffectBeginTime())) {
                        errorMsg.append("\u6cd5\u4eba\u8bc1\u4ef6\u6709\u6548\u671f\u8d77\u4e3a\u7a7a;");
                    }
                    if (Objects.isNull(importDto.getCardEffectEndTime())) {
                        errorMsg.append("\u6cd5\u4eba\u8bc1\u4ef6\u6709\u6548\u671f\u6b62\u4e3a\u7a7a;");
                    }
                }
            }
            if (Objects.nonNull(importDto.getEffectiveTime()) && Objects.nonNull(importDto.getExpirationTime()) && importDto.getExpirationTime().before(importDto.getEffectiveTime())) {
                errorMsg.append("\u5230\u671f\u65f6\u95f4\u5fc5\u987b\u665a\u4e8e\u751f\u6548\u65f6\u95f4;");
            }
            if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
                importDto.setErrorReason(errorMsg.toString());
            }
            importDto.setSellerId(sellerId);
            importDto.setOrgId(orgId);
            importDto.setInstanceId(requestInstanceId);
        }
    }

    private void updateCustomer(CustomerInfoUpdateImportDto importDto, Long orgId, Long requestTenantId, Long requestInstanceId, Map<String, CustomerTypeRespDto> customerTypeInfoMap) {
        String regionNames;
        CustomerExtReqDto customerQuery = new CustomerExtReqDto();
        customerQuery.setCodes((List)Lists.newArrayList((Object[])new String[]{importDto.getCode()}));
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerInfoByOrg(customerQuery));
        if (CollectionUtils.isEmpty((Collection)customerRespDtos)) {
            throw new BizException("\u5ba2\u6237\u7f16\u7801\u4e0d\u5b58\u5728;");
        }
        CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtos.get(0);
        CustomerTypeRespDto customerTypeRespDto = null;
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCustomerTypeName())) {
            if (customerTypeInfoMap.isEmpty() || !customerTypeInfoMap.containsKey(importDto.getCustomerTypeName())) {
                throw new BizException("\u5ba2\u6237\u7c7b\u578b\u6570\u636e\u9519\u8bef;");
            }
            customerTypeRespDto = customerTypeInfoMap.get(importDto.getCustomerTypeName());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getRegionName())) {
            String[] areaNameArr = importDto.getRegionName().split(";");
            List<String> areaNameList = Arrays.asList(areaNameArr);
            importDto.setRegionNameList(areaNameList);
            CustomerAreaListExtReqDto customerAreaQuery = new CustomerAreaListExtReqDto();
            customerAreaQuery.setNameList(areaNameList);
            customerAreaQuery.setOrgInfoId(orgId);
            List areaList = (List)RestResponseHelper.extractData((RestResponse)this.employeeRegionQueryApi.queryCustomerAreaByNames(customerAreaQuery));
            if (CollectionUtils.isEmpty((Collection)areaList)) {
                throw new BizException("\u5ba2\u6237\u533a\u57df\u6570\u636e\u9519\u8bef;");
            }
            if (CollectionUtils.isEmpty(areaList = areaList.stream().filter(dto -> dto.getOrgInfoId() != null && dto.getOrgInfoId().equals(orgId)).collect(Collectors.toList()))) {
                throw new BizException("\u5ba2\u6237\u533a\u57df\u7ec4\u7ec7\u6570\u636e\u9519\u8bef;");
            }
            List<String> areaCodeList = areaList.stream().map(CustomerAreaRespDto::getCode).collect(Collectors.toList());
            importDto.setRegionCodeList(areaCodeList);
        }
        List<Object> addressList = Lists.newArrayList();
        addressList.add(importDto.getProvince());
        addressList.add(importDto.getCity());
        addressList.add(importDto.getCounty());
        addressList.add(importDto.getOrgProvince());
        addressList.add(importDto.getOrgCity());
        addressList.add(importDto.getOrgDistrict());
        addressList = addressList.stream().filter(s -> StringUtils.isNotEmpty((CharSequence)s)).distinct().collect(Collectors.toList());
        Map<Object, Object> addressInfoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)addressList)) {
            AreaDto districtDto;
            AreaDto cityDto;
            AreaDto cityDto2;
            AreaDto provinceDto;
            List addressAreaList = (List)RestResponseHelper.extractData((RestResponse)this.areaExtQueryApi.getAreaByNames((List)addressList));
            if (CollectionUtils.isEmpty((Collection)addressAreaList)) {
                throw new BizException("\u5730\u533a\u540d\u79f0\u6570\u636e\u9519\u8bef;");
            }
            addressInfoMap = addressAreaList.stream().collect(Collectors.toMap(AreaDto::getName, Function.identity(), (k1, k2) -> k1));
            if (StringUtils.isNotEmpty((CharSequence)importDto.getProvince()) && !addressInfoMap.containsKey(importDto.getProvince())) {
                throw new BizException("\u6240\u5c5e\u7701\u4efd\u6570\u636e\u9519\u8bef");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getCity()) && !addressInfoMap.containsKey(importDto.getCity())) {
                throw new BizException("\u6240\u5c5e\u57ce\u5e02\u6570\u636e\u9519\u8bef");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getCounty()) && !addressInfoMap.containsKey(importDto.getCounty())) {
                throw new BizException("\u6240\u5c5e\u5730\u533a\u6570\u636e\u9519\u8bef");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getOrgProvince()) && !addressInfoMap.containsKey(importDto.getOrgProvince())) {
                throw new BizException("\u516c\u53f8\u6240\u5c5e\u7701\u4efd\u6570\u636e\u9519\u8bef");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getOrgCity()) && !addressInfoMap.containsKey(importDto.getOrgCity())) {
                throw new BizException("\u516c\u53f8\u6240\u5c5e\u57ce\u5e02\u6570\u636e\u9519\u8bef");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getOrgDistrict()) && !addressInfoMap.containsKey(importDto.getOrgDistrict())) {
                throw new BizException("\u516c\u53f8\u6240\u5c5e\u5730\u533a\u6570\u636e\u9519\u8bef");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getProvince()) && StringUtils.isNotEmpty((CharSequence)importDto.getCity())) {
                provinceDto = (AreaDto)addressInfoMap.get(importDto.getProvince());
                cityDto2 = (AreaDto)addressInfoMap.get(importDto.getCity());
                if (provinceDto != null && cityDto2 != null && !cityDto2.getParentCode().equals(provinceDto.getCode())) {
                    this.logger.warn("\u57ce\u5e02[{}]\u4e0d\u5c5e\u4e8e\u7701\u4efd[{}]", (Object)importDto.getCity(), (Object)importDto.getProvince());
                    throw new BizException("\u57ce\u5e02[" + importDto.getCity() + "]\u4e0d\u5c5e\u4e8e\u7701\u4efd[" + importDto.getProvince() + "];");
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getCity()) && StringUtils.isNotEmpty((CharSequence)importDto.getCounty())) {
                cityDto = (AreaDto)addressInfoMap.get(importDto.getCity());
                districtDto = (AreaDto)addressInfoMap.get(importDto.getCounty());
                if (cityDto != null && districtDto != null && !districtDto.getParentCode().equals(cityDto.getCode())) {
                    this.logger.warn("\u5730\u533a[{}]\u4e0d\u5c5e\u4e8e\u57ce\u5e02[{}]", (Object)importDto.getCounty(), (Object)importDto.getCity());
                    throw new BizException("\u5730\u533a[" + importDto.getCounty() + "]\u4e0d\u5c5e\u4e8e\u57ce\u5e02[" + importDto.getCity() + "];");
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getOrgProvince()) && StringUtils.isNotEmpty((CharSequence)importDto.getOrgCity())) {
                provinceDto = (AreaDto)addressInfoMap.get(importDto.getOrgProvince());
                cityDto2 = (AreaDto)addressInfoMap.get(importDto.getOrgCity());
                if (provinceDto != null && cityDto2 != null && !cityDto2.getParentCode().equals(provinceDto.getCode())) {
                    this.logger.warn("\u516c\u53f8\u57ce\u5e02[{}]\u4e0d\u5c5e\u4e8e\u7701\u4efd[{}]", (Object)importDto.getOrgCity(), (Object)importDto.getOrgProvince());
                    throw new BizException("\u516c\u53f8\u57ce\u5e02[" + importDto.getOrgCity() + "]\u4e0d\u5c5e\u4e8e\u7701\u4efd[" + importDto.getOrgProvince() + "];");
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getOrgCity()) && StringUtils.isNotEmpty((CharSequence)importDto.getOrgDistrict())) {
                cityDto = (AreaDto)addressInfoMap.get(importDto.getOrgCity());
                districtDto = (AreaDto)addressInfoMap.get(importDto.getOrgDistrict());
                if (cityDto != null && districtDto != null && !districtDto.getParentCode().equals(cityDto.getCode())) {
                    this.logger.warn("\u516c\u53f8\u5730\u533a[{}]\u4e0d\u5c5e\u4e8e\u57ce\u5e02[{}]", (Object)importDto.getOrgDistrict(), (Object)importDto.getOrgCity());
                    throw new BizException("\u516c\u53f8\u5730\u533a[" + importDto.getOrgDistrict() + "]\u4e0d\u5c5e\u4e8e\u57ce\u5e02[" + importDto.getOrgCity() + "];");
                }
            }
        }
        CompanyInfoDto companyInfoDto = null;
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCreditCode())) {
            try {
                this.logger.info("\u67e5\u8be2\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u7801CreditCode={},orgId={},requestTenantId={},requestInstanceId={}", new Object[]{importDto.getCreditCode(), orgId, requestTenantId, requestInstanceId});
                companyInfoDto = (CompanyInfoDto)RestResponseHelper.extractData((RestResponse)this.customerQueryV3Api.queryCompanyInfoByCreditCode(importDto.getCreditCode(), orgId, requestTenantId, requestInstanceId, customerRespDto.getId()));
                this.logger.info("\u67e5\u8be2\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u7801\u516c\u53f8\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)companyInfoDto));
            }
            catch (Exception e) {
                throw new BizException("\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u7801\u516c\u53f8\u4fe1\u606f:" + e.getMessage());
            }
        }
        CustomerReqDto updateCustomerDto = new CustomerReqDto();
        CubeBeanUtils.copyProperties((Object)updateCustomerDto, (Object)customerRespDto, (String[])new String[]{"companyInfoDto", "regionCodeList", "regionNameList", "salesmanIds"});
        updateCustomerDto.setId(customerRespDto.getId());
        updateCustomerDto.setMerchantId(orgId);
        updateCustomerDto.setInstanceId(requestInstanceId);
        updateCustomerDto.setTenantId(requestTenantId);
        updateCustomerDto.setOrgId(orgId);
        updateCustomerDto.setRegionCodeList(customerRespDto.getRegionCodeList());
        HashMap<String, String> extendFields = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)importDto.getSalesArea())) {
            extendFields.put("salesArea", importDto.getSalesArea());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getLargeArea())) {
            extendFields.put("largeArea", importDto.getLargeArea());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getDeliveryMethod())) {
            extendFields.put("deliveryMethod", importDto.getDeliveryMethod());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getMinOrderQuantity())) {
            extendFields.put("minOrderQuantity", importDto.getMinOrderQuantity());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getStandardDiscountRate())) {
            extendFields.put("standardDiscountRate", importDto.getStandardDiscountRate());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getMultiBrandDiscount())) {
            extendFields.put("multiBrandDiscount", importDto.getMultiBrandDiscount());
        }
        if (!extendFields.isEmpty()) {
            String extendFieldsJson = JSON.toJSONString(extendFields);
            updateCustomerDto.setExtension(extendFieldsJson);
        }
        if (StringUtils.isNotEmpty((CharSequence)(regionNames = customerRespDto.getRegionNames()))) {
            String[] regionNameArr = regionNames.split(",");
            List<String> regionNameList = Arrays.asList(regionNameArr);
            updateCustomerDto.setRegionNameList(regionNameList);
        }
        if (StringUtils.isNotEmpty((CharSequence)customerRespDto.getSalesmanIds())) {
            String[] salesmanIdArr = customerRespDto.getSalesmanIds().split(",");
            List<String> salesmanIdList = Arrays.asList(salesmanIdArr);
            List salesmanIds = salesmanIdList.stream().map(x -> Long.valueOf(x)).collect(Collectors.toList());
            updateCustomerDto.setSalesmanIds(salesmanIds);
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getName())) {
            updateCustomerDto.setName(importDto.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getEasCode())) {
            updateCustomerDto.setEasCode(importDto.getEasCode());
        }
        if (CollectionUtils.isNotEmpty(importDto.getRegionCodeList())) {
            updateCustomerDto.setRegionCodeList(importDto.getRegionCodeList());
        }
        if (CollectionUtils.isNotEmpty(importDto.getRegionNameList())) {
            updateCustomerDto.setRegionNameList(importDto.getRegionNameList());
        }
        if (Objects.nonNull(customerTypeRespDto)) {
            updateCustomerDto.setCustomerTypeId(customerTypeRespDto.getId());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getProvince())) {
            updateCustomerDto.setProvince(importDto.getProvince());
            updateCustomerDto.setProvinceCode(((AreaDto)addressInfoMap.get(importDto.getProvince())).getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCity())) {
            updateCustomerDto.setCity(importDto.getCity());
            updateCustomerDto.setCityCode(((AreaDto)addressInfoMap.get(importDto.getCity())).getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCounty())) {
            updateCustomerDto.setCounty(importDto.getCounty());
            updateCustomerDto.setCountyCode(((AreaDto)addressInfoMap.get(importDto.getCounty())).getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getAddress())) {
            updateCustomerDto.setAddress(importDto.getAddress());
        }
        if (Objects.nonNull(importDto.getEffectiveTime())) {
            updateCustomerDto.setEffectiveStartTime(importDto.getEffectiveTime());
        }
        if (Objects.nonNull(importDto.getExpirationTime())) {
            updateCustomerDto.setEffectiveEndTime(importDto.getExpirationTime());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCustomerStatus())) {
            CustomerStatusReqDto customerStatusReqDto = new CustomerStatusReqDto();
            customerStatusReqDto.setRecordStatus(Integer.valueOf(1));
            customerStatusReqDto.setName(importDto.getCustomerStatus());
            try {
                this.logger.info("\u67e5\u8be2\u5ba2\u6237\u72b6\u6001\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)customerStatusReqDto));
                List customerStatusRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerStatusQueryApi.queryByList(JSON.toJSONString((Object)customerStatusReqDto)));
                if (CollectionUtils.isNotEmpty((Collection)customerStatusRespDtos)) {
                    updateCustomerDto.setStatusId(((CustomerStatusRespDto)customerStatusRespDtos.get(0)).getId());
                    this.logger.info("\u8bbe\u7f6e\u5ba2\u6237\u72b6\u6001ID: {}, \u72b6\u6001\u540d\u79f0: {}", (Object)((CustomerStatusRespDto)customerStatusRespDtos.get(0)).getId(), (Object)importDto.getCustomerStatus());
                } else {
                    this.logger.warn("\u672a\u627e\u5230\u5339\u914d\u7684\u5ba2\u6237\u72b6\u6001: {}", (Object)importDto.getCustomerStatus());
                }
            }
            catch (Exception e) {
                this.logger.error("\u67e5\u8be2\u5ba2\u6237\u72b6\u6001\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
                throw new BizException("\u67e5\u8be2\u5ba2\u6237\u72b6\u6001\u5f02\u5e38:" + e.getMessage());
            }
        }
        CompanyInfoDto newCompanyInfo = new CompanyInfoDto();
        CompanyInfoDto oldCompanyInfoDto = customerRespDto.getCompanyInfoDto();
        CubeBeanUtils.copyProperties((Object)newCompanyInfo, (Object)oldCompanyInfoDto, (String[])new String[0]);
        if (Objects.nonNull(companyInfoDto)) {
            CubeBeanUtils.copyProperties((Object)newCompanyInfo, (Object)companyInfoDto, (String[])new String[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getOrgName())) {
            newCompanyInfo.setOrgName(importDto.getOrgName());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getSubjectType())) {
            newCompanyInfo.setSubjectType(this.toSubjectType(importDto.getSubjectType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCreditCode())) {
            newCompanyInfo.setCreditCode(importDto.getCreditCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getBusinessLicenseType())) {
            newCompanyInfo.setBusinessLicenseType(this.toBusinessLicenseType(importDto.getBusinessLicenseType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getBusinessTermType())) {
            newCompanyInfo.setBusinessTermType(this.toBusinessTermType(importDto.getBusinessTermType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getTermBeginTime())) {
            Date termBeginTime = DateUtil.parseDate((String)importDto.getTermBeginTime(), (String)"yyyy-MM-dd");
            newCompanyInfo.setTermBeginTime(termBeginTime);
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getTermEndTime())) {
            Date termEndTime = DateUtil.parseDate((String)importDto.getTermEndTime(), (String)"yyyy-MM-dd");
            newCompanyInfo.setTermBeginTime(termEndTime);
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getOrgProvince())) {
            newCompanyInfo.setProvince(importDto.getOrgProvince());
            newCompanyInfo.setProvinceCode(((AreaDto)addressInfoMap.get(importDto.getOrgProvince())).getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCity())) {
            newCompanyInfo.setCity(importDto.getCity());
            newCompanyInfo.setCityCode(((AreaDto)addressInfoMap.get(importDto.getCity())).getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getOrgDistrict())) {
            newCompanyInfo.setDistrict(importDto.getOrgDistrict());
            newCompanyInfo.setDistrictCode(((AreaDto)addressInfoMap.get(importDto.getOrgDistrict())).getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getOrgAddress())) {
            newCompanyInfo.setAddress(importDto.getOrgAddress());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getLegalName())) {
            newCompanyInfo.setLegalName(importDto.getLegalName());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getLegalCardType())) {
            newCompanyInfo.setLegalCardType(this.toLegalCardType(importDto.getLegalCardType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getLegalCardNum())) {
            newCompanyInfo.setLegalCardNum(importDto.getLegalCardNum());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCardEffectType())) {
            newCompanyInfo.setCardEffectType(this.toCardEffectType(importDto.getCardEffectType()));
        }
        if (Objects.nonNull(importDto.getCardEffectBeginTime())) {
            newCompanyInfo.setCardEffectBeginTime(importDto.getCardEffectBeginTime());
        }
        if (Objects.nonNull(importDto.getCardEffectEndTime())) {
            newCompanyInfo.setCardEffectEndTime(importDto.getCardEffectEndTime());
        }
        updateCustomerDto.setCompanyInfoDto(newCompanyInfo);
        CompanyVerifyRespDto companyVerifyRespDto = this.customerAddImportService.queryStoreVerify(newCompanyInfo.getCreditCode(), newCompanyInfo.getOrgName(), newCompanyInfo.getLegalName());
        if (1 != companyVerifyRespDto.getResult()) {
            throw new BizException(companyVerifyRespDto.getRemark());
        }
        ServiceContext.getContext().setAttachment("yes.req.tenantId", requestTenantId.toString());
        ServiceContext.getContext().setAttachment("yes.req.instanceId", requestInstanceId.toString());
        this.logger.info("\u4fee\u6539\u5ba2\u6237\u8bf7\u6c42\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)updateCustomerDto));
        RestResponseHelper.extractData((RestResponse)this.customerExtApi.update(updateCustomerDto));
        if (StringUtils.isNotEmpty((CharSequence)importDto.getStandardDiscountRate())) {
            this.updateCustomerDiscounts(customerRespDto.getId(), importDto, orgId, requestTenantId, requestInstanceId);
        }
    }

    private void updateCustomerDiscounts(Long customerId, CustomerInfoUpdateImportDto importDto, Long orgId, Long requestTenantId, Long requestInstanceId) {
        try {
            List<PrBaseDiscountBrandReqDto> brandDiscounts;
            this.logger.info("\u5f00\u59cb\u66f4\u65b0\u5ba2\u6237\u6807\u51c6\u6263\u7387\u548c\u591a\u54c1\u724c\u6263\u7387, \u5ba2\u6237ID: {}", (Object)customerId);
            PrBaseDiscountAddEditReqDto discountAddEditReqDto = new PrBaseDiscountAddEditReqDto();
            discountAddEditReqDto.setCustomerId(customerId);
            discountAddEditReqDto.setCustomerName(importDto.getName());
            discountAddEditReqDto.setCustomerCode(importDto.getCode());
            discountAddEditReqDto.setMerchantId(orgId);
            discountAddEditReqDto.setOrgInfoId(orgId);
            discountAddEditReqDto.setTenantId(requestTenantId);
            discountAddEditReqDto.setInstanceId(requestInstanceId);
            if (StringUtils.isNotEmpty((CharSequence)importDto.getStandardDiscountRate())) {
                try {
                    BigDecimal standardDiscount = new BigDecimal(importDto.getStandardDiscountRate());
                    discountAddEditReqDto.setStandardDiscount(standardDiscount);
                }
                catch (NumberFormatException e) {
                    this.logger.error("\u6807\u51c6\u6263\u7387[{}]\u683c\u5f0f\u9519\u8bef", (Object)importDto.getStandardDiscountRate());
                    return;
                }
            } else {
                this.logger.error("\u6807\u51c6\u6263\u7387\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0\u5ba2\u6237\u6263\u7387\u4fe1\u606f");
                return;
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getMultiBrandDiscount()) && !(brandDiscounts = this.parseBrandDiscounts(importDto.getMultiBrandDiscount())).isEmpty()) {
                discountAddEditReqDto.setBrandDiscountList(brandDiscounts);
            }
            this.logger.info("\u66f4\u65b0\u5ba2\u6237\u6807\u51c6\u6263\u7387\u548c\u591a\u54c1\u724c\u6263\u7387, \u53c2\u6570: {}", (Object)JSON.toJSONString((Object)discountAddEditReqDto));
            RestResponseHelper.extractData((RestResponse)this.prBaseDiscountApi.add(discountAddEditReqDto));
            this.logger.info("\u5ba2\u6237[{}]\u6807\u51c6\u6263\u7387\u548c\u591a\u54c1\u724c\u6263\u7387\u66f4\u65b0\u6210\u529f", (Object)importDto.getName());
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u5ba2\u6237\u6807\u51c6\u6263\u7387\u548c\u591a\u54c1\u724c\u6263\u7387\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private List<PrBaseDiscountBrandReqDto> parseBrandDiscounts(String multiBrandDiscountStr) {
        ArrayList<PrBaseDiscountBrandReqDto> result = new ArrayList<PrBaseDiscountBrandReqDto>();
        if (StringUtils.isEmpty((CharSequence)multiBrandDiscountStr)) {
            return result;
        }
        try {
            String[] brandDiscounts;
            for (String brandDiscount : brandDiscounts = multiBrandDiscountStr.split(",")) {
                String[] parts = brandDiscount.split(":");
                if (parts.length != 2) continue;
                String brandName = parts[0].trim();
                BigDecimal discountRate = new BigDecimal(parts[1].trim());
                PrBaseDiscountBrandReqDto brandDiscountDto = new PrBaseDiscountBrandReqDto();
                brandDiscountDto.setBrandName(brandName);
                brandDiscountDto.setBrandDiscount(discountRate);
                try {
                    ArrayList<String> brandNameList = new ArrayList<String>();
                    brandNameList.add(brandName);
                    List nonExistingBrands = (List)RestResponseHelper.extractData((RestResponse)this.itemBrandAuthApi.checkBrandsExist(brandNameList));
                    if (CollectionUtils.isEmpty((Collection)nonExistingBrands)) {
                        Long brandId = this.getBrandIdByName(brandName);
                        if (brandId == null) continue;
                        brandDiscountDto.setBrandId(brandId);
                        result.add(brandDiscountDto);
                        continue;
                    }
                    this.logger.warn("\u54c1\u724c[{}]\u4e0d\u5b58\u5728\uff0c\u5ffd\u7565\u8be5\u54c1\u724c\u6263\u7387", (Object)brandName);
                }
                catch (Exception e) {
                    this.logger.error("\u83b7\u53d6\u54c1\u724c[{}]ID\u5f02\u5e38: {}", (Object)brandName, (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u89e3\u6790\u591a\u54c1\u724c\u6263\u7387\u5f02\u5e38: {}", (Object)e.getMessage());
        }
        return result;
    }

    private Long getBrandIdByName(String brandName) {
        try {
            List brands = (List)RestResponseHelper.extractData((RestResponse)this.itemBrandAuthApi.queryBrandsByName(brandName));
            if (CollectionUtils.isNotEmpty((Collection)brands)) {
                return ((BrandRespDto)brands.get(0)).getId();
            }
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u540d\u79f0\u67e5\u8be2\u54c1\u724cID\u5f02\u5e38: {}", (Object)e.getMessage());
        }
        return null;
    }

    private String toSubjectType(String name) {
        if (SubjectTypeEnum.COMPANY.getName().equals(name)) {
            return SubjectTypeEnum.COMPANY.getType();
        }
        if (SubjectTypeEnum.INDIVIDUAL.getName().equals(name)) {
            return SubjectTypeEnum.INDIVIDUAL.getType();
        }
        if (SubjectTypeEnum.ZOOID.getName().equals(name)) {
            return SubjectTypeEnum.ZOOID.getType();
        }
        return "";
    }

    private Integer toBusinessLicenseType(String name) {
        if ("\u591a\u8bc1\u5408\u4e00\u8425\u4e1a\u6267\u7167".equals(name)) {
            return 1;
        }
        if ("\u666e\u901a\u8425\u4e1a\u6267\u7167".equals(name)) {
            return 2;
        }
        return 0;
    }

    private String toBusinessTermType(String name) {
        if ("\u77ed\u671f\u6709\u6548".equals(name)) {
            return "1";
        }
        if ("\u957f\u671f\u6709\u6548".equals(name)) {
            return "2";
        }
        return "0";
    }

    private Integer toLegalCardType(String name) {
        if ("\u5927\u9646\u5c45\u6c11\u8eab\u4efd\u8bc1".equals(name)) {
            return 1;
        }
        if ("\u6e2f\u6fb3\u53f0\uff08\u8eab\u4efd\u8bc1\u3001\u5c45\u6c11\u901a\u884c\u8bc1\uff09".equals(name)) {
            return 2;
        }
        if ("\u62a4\u7167\uff08\u9650\u5883\u5916\u4eba\u58eb\uff09".equals(name)) {
            return 3;
        }
        return 0;
    }

    private Integer toCardEffectType(String name) {
        if ("\u77ed\u671f\u6709\u6548".equals(name)) {
            return 1;
        }
        if ("\u957f\u671f\u6709\u6548".equals(name)) {
            return 2;
        }
        return 0;
    }

    public void customerItemAuthImport(ImportReqDto importReqDto) {
        this.logger.info("\u5546\u54c1\u6388\u6743\u5bfc\u5165\uff1a{}", (Object)JSON.toJSONString((Object)importReqDto));
        AssertUtil.assertNotBlank((String)importReqDto.getFileUrl(), (String)"\u5bfc\u5165\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        String b2bOrgIdStr = this.getHeaderOrgId();
        if (StringUtils.isEmpty((CharSequence)b2bOrgIdStr)) {
            b2bOrgIdStr = this.nacosPropertiesOrgEntity.orgId();
            this.logger.info("nacos\u914d\u7f6e\u7684\u7ec4\u7ec7ID\uff1a{}", (Object)b2bOrgIdStr);
        }
        AssertUtil.assertNotBlank((String)b2bOrgIdStr, (String)"\u8bf7\u6c42\u5934[yes-req-cus-b2b-organizationId]\u503c\u4e3a\u7a7a");
        Long b2bOrgId = Long.valueOf(b2bOrgIdStr);
        Long requestTenantId = this.getTenantId();
        Long requestInstanceId = this.getInstanceId();
        List importDtoList = new ArrayList();
        try {
            InputStream is = this.getInputStream(importReqDto.getFileUrl());
            ExcelImportResult objectExcelImportResult = EasyPoiExportUtil.importExcel(is, 0, 1, CustomerItemAuthImportDto.class);
            importDtoList = objectExcelImportResult.getList();
            importDtoList = BeanPropertyNullUtil.getAllFieldNullList(importDtoList);
        }
        catch (Exception e) {
            throw new BizException("\u5bfc\u5165\u5ba2\u6237\u4fee\u6539\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
        }
        this.logger.info("\u5546\u54c1\u6388\u6743\u5bfc\u5165\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(importDtoList));
        ImportLogEo initLog = ImportLogEo.newInstance();
        initLog.setImportFileUrl(importReqDto.getFileUrl());
        String fileName = importReqDto.getFileName();
        if (StringUtils.isEmpty((CharSequence)importReqDto.getFileName())) {
            fileName = StringUtils.substringAfter((String)importReqDto.getFileUrl(), (String)"cube//");
        }
        initLog.setFileName(fileName);
        initLog.setImportType(ImportLogTypeEnum.CUSTOMER.getCode());
        initLog.setTotalNum(Integer.valueOf(importDtoList.size()));
        initLog.setOrganizationId(b2bOrgId);
        initLog.setInstanceId(requestInstanceId);
        initLog.setTenantId(requestTenantId);
        Long importLogId = this.importLogService.init(initLog);
        List finalImportDtos = importDtoList;
        CompletableFuture.runAsync(() -> {
            block5: {
                try {
                    this.logger.info("\u5546\u54c1\u6388\u6743\u5bfc\u5165\u5f00\u59cb,\u65e5\u5fd7id[{}],\u65f6\u95f4[{}]", (Object)importLogId, (Object)System.currentTimeMillis());
                    List<CustomerItemAuthImportDto> errorList = this.doCustomerItemAuthImport(requestTenantId, requestInstanceId, finalImportDtos, importLogId, null, b2bOrgId);
                    this.logger.info("\u5546\u54c1\u6388\u6743\u5bfc\u5165\u7ed3\u675f,\u65e5\u5fd7id[{}],\u65f6\u95f4[{}]", (Object)importLogId, (Object)System.currentTimeMillis());
                    if (CollectionUtils.isNotEmpty(errorList)) {
                        this.importLogService.success(importLogId, ImportLogStatusEnum.SUCCEED, finalImportDtos.size(), "", "", 0);
                        break block5;
                    }
                    String exportUrl = "";
                    try {
                        String title = "\u5546\u54c1\u6388\u6743\u5bfc\u5165\u5f02\u5e38\u7ed3\u679c";
                        String errorFileName = title + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmssSSS");
                        exportUrl = EasyPoiExportUtil.getExportUrl(errorList, CustomerItemAuthImportDto.class, title, errorFileName, "xls");
                    }
                    catch (Exception e) {
                        this.logger.error("\u5546\u54c1\u6388\u6743\u5bfc\u5165\u5f02\u5e38\u7ed3\u679c\u751f\u6210\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                    this.importLogService.success(importLogId, ImportLogStatusEnum.PART_SUCCESS, finalImportDtos.size() - errorList.size(), "\u5bfc\u5165\u5f02\u5e38", exportUrl, errorList.size());
                }
                catch (Exception e) {
                    this.logger.error("\u5546\u54c1\u6388\u6743\u5bfc\u5165\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    this.logger.error(e.getMessage(), (Throwable)e);
                    this.importLogService.fail(importLogId, e.getMessage(), "", finalImportDtos.size());
                }
            }
        });
    }

    private List<CustomerItemAuthImportDto> doCustomerItemAuthImport(Long requestTenantId, Long requestInstanceId, List<CustomerItemAuthImportDto> importDtoList, Long importLogId, Long sellerId, Long orgId) {
        this.logger.info("\u5546\u54c1\u6388\u6743\u5bfc\u5165doCustomerItemAuthImport\uff1a{}", (Object)JSON.toJSONString(importDtoList));
        this.logger.info("orgId\uff1a{}", (Object)orgId);
        List customerCodeList = importDtoList.stream().map(CustomerItemAuthImportDto::getCustomerCode).distinct().collect(Collectors.toList());
        int pageNum = 1;
        int pageSize = customerCodeList.size() + 1;
        Map<String, List<CustomerItemAuthImportDto>> collect = importDtoList.stream().collect(Collectors.groupingBy(CustomerItemAuthImportDto::getCustomerCode));
        ArrayList<CustomerItemAuthImportDto> errorList = new ArrayList<CustomerItemAuthImportDto>();
        collect.forEach((k, v) -> {
            CustomerSearchExtThreeReqDto customerSearchExtThreeReqDto = new CustomerSearchExtThreeReqDto();
            customerSearchExtThreeReqDto.setListFlag(Boolean.valueOf(true));
            customerSearchExtThreeReqDto.setChannel(Integer.valueOf(2));
            customerSearchExtThreeReqDto.setType(Integer.valueOf(3));
            customerSearchExtThreeReqDto.setCode(k);
            PageInfo customerExtRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.customerExtThreeQueryApi.queryByPage(JSON.toJSONString((Object)customerSearchExtThreeReqDto), Integer.valueOf(pageNum), Integer.valueOf(pageSize)));
            if (ObjectUtils.isEmpty((Object)customerExtRespDtoPageInfo) || CollectionUtils.isEmpty((Collection)customerExtRespDtoPageInfo.getList())) {
                v.stream().forEach(dto -> dto.setErrorReason("\u627e\u4e0d\u5230\u5ba2\u6237\u4fe1\u606f"));
                errorList.addAll((Collection<CustomerItemAuthImportDto>)v);
            } else {
                CustomerExtRespDto customer = (CustomerExtRespDto)customerExtRespDtoPageInfo.getList().get(0);
                List<String> itemCodeList = v.stream().map(CustomerItemAuthImportDto::getItemCode).distinct().collect(Collectors.toList());
                Map<String, ItemDetailBaseInfoRespDto> itemMap = this.queryAuthItem(itemCodeList, orgId);
                ArrayList<CustomerAuthItemReqDto> authItemReqDtoList = new ArrayList<CustomerAuthItemReqDto>();
                for (CustomerItemAuthImportDto itemAuthImportDto : v) {
                    ItemDetailBaseInfoRespDto itemDetailBaseInfoRespDto = itemMap.get(itemAuthImportDto.getItemCode());
                    if (ObjectUtils.isEmpty((Object)itemDetailBaseInfoRespDto)) {
                        itemAuthImportDto.setErrorReason("\u627e\u4e0d\u5230\u5546\u54c1\u4fe1\u606f");
                        continue;
                    }
                    CustomerAuthItemReqDto authItemReqDto = new CustomerAuthItemReqDto();
                    authItemReqDto.setItemId(itemDetailBaseInfoRespDto.getId());
                    authItemReqDto.setItemCode(itemDetailBaseInfoRespDto.getCode());
                    authItemReqDto.setItemName(itemDetailBaseInfoRespDto.getName());
                    if (CollectionUtils.isNotEmpty((Collection)itemDetailBaseInfoRespDto.getItemSkuList())) {
                        ItemSkuInfoRespDto sku = (ItemSkuInfoRespDto)itemDetailBaseInfoRespDto.getItemSkuList().get(0);
                        authItemReqDto.setSkuId(sku.getId());
                        authItemReqDto.setSkuCode(sku.getCode());
                    }
                    authItemReqDtoList.add(authItemReqDto);
                }
                AuthItemRuleRespDto alreadyAuthItemRule = (AuthItemRuleRespDto)RestResponseHelper.extractData((RestResponse)this.authItemRuleService.queryByCustomerId(customerSearchExtThreeReqDto.getId()));
                try {
                    AuthItemRuleReqDto authItemRuleReqDto = new AuthItemRuleReqDto();
                    authItemRuleReqDto.setCustomerAuthItemReqDtos(authItemReqDtoList);
                    authItemRuleReqDto.setAuthType(Integer.valueOf(2));
                    if (CollectionUtils.isNotEmpty((Collection)customer.getDeliveryWarehouses())) {
                        authItemRuleReqDto.setOrganizationId(((WarehouseSupplyRelRespDto)customer.getDeliveryWarehouses().get(0)).getOrganizationId());
                    }
                    authItemRuleReqDto.setCustomerCode(customer.getCode());
                    authItemRuleReqDto.setCustomerId(customer.getId());
                    authItemRuleReqDto.setCustomerName(customer.getName());
                    if (ObjectUtils.isEmpty(authItemReqDtoList)) {
                        this.logger.info("\u65b0\u589e\u6388\u6743\uff1a{}", (Object)JSON.toJSONString((Object)authItemRuleReqDto));
                        RestResponseHelper.extractData((RestResponse)this.authItemRuleApi.addAuthItemRule(authItemRuleReqDto));
                    } else {
                        if (alreadyAuthItemRule.getAuthType() == 2 && CollectionUtils.isNotEmpty((Collection)alreadyAuthItemRule.getCustomerAuthItemRespDtos())) {
                            List addItemCodeList = authItemRuleReqDto.getCustomerAuthItemReqDtos().stream().map(CustomerAuthItemReqDto::getItemCode).collect(Collectors.toList());
                            List<CustomerAuthItemRespDto> differenceList = alreadyAuthItemRule.getCustomerAuthItemRespDtos().stream().filter(f -> !addItemCodeList.contains(f.getItemCode())).collect(Collectors.toList());
                            if (CollectionUtils.isNotEmpty(differenceList)) {
                                differenceList.forEach(d -> {
                                    CustomerAuthItemReqDto authItemReqDto = (CustomerAuthItemReqDto)BeanUtil.copyProperties((Object)d, CustomerAuthItemReqDto.class, (String[])new String[0]);
                                    authItemRuleReqDto.getCustomerAuthItemReqDtos().add(authItemReqDto);
                                });
                            }
                        }
                        authItemRuleReqDto.setId(alreadyAuthItemRule.getId());
                        this.logger.info("\u7f16\u8f91\u6388\u6743\uff1a{}", (Object)JSON.toJSONString((Object)authItemRuleReqDto));
                        RestResponseHelper.extractData((RestResponse)this.authItemRuleApi.modifyAuthItemRule(authItemRuleReqDto));
                    }
                }
                catch (Exception e) {
                    this.logger.error("\u64cd\u4f5c\u5165\u5e93\u5f02\u5e38\uff1a{}\uff0c{}\uff0c{}", new Object[]{k, JSON.toJSONString((Object)v), e.getMessage()});
                    this.logger.error(e.getMessage(), (Throwable)e);
                    v.forEach(dto -> dto.setErrorReason("\u64cd\u4f5c\u5165\u5e93\u5f02\u5e38\uff1a" + e.getMessage()));
                }
                v.forEach(dto -> {
                    if (StringUtils.isNotBlank((CharSequence)dto.getErrorReason())) {
                        errorList.add((CustomerItemAuthImportDto)dto);
                    }
                });
            }
        });
        return errorList;
    }

    private Map<String, ItemDetailBaseInfoRespDto> queryAuthItem(List<String> itemCodeList, Long orgId) {
        List shopBaseDtoList;
        Map<String, Object> map = new HashMap<String, ItemDetailBaseInfoRespDto>();
        if (CollectionUtils.isNotEmpty(itemCodeList) && CollectionUtils.isNotEmpty((Collection)(shopBaseDtoList = (List)RestResponseHelper.extractData((RestResponse)this.shopExtQueryApi.queryShopListBySellerOrgId(orgId))))) {
            ItemShopQueryReqDto itemShopQueryReqDto = new ItemShopQueryReqDto();
            itemShopQueryReqDto.setItemCodes(itemCodeList);
            itemShopQueryReqDto.setShopId(((ShopBaseDto)shopBaseDtoList.get(0)).getId());
            itemShopQueryReqDto.setTargetType(Integer.valueOf(2));
            List itemInfoList = (List)RestResponseHelper.extractData((RestResponse)this.itemCenterQueryApi.queryShopItemList(itemShopQueryReqDto));
            if (CollectionUtils.isNotEmpty((Collection)itemInfoList)) {
                map = itemInfoList.stream().collect(Collectors.toMap(ItemDetailBaseInfoRespDto::getCode, Function.identity(), (k1, k2) -> k1));
            }
        }
        return map;
    }
}

