/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportStatusEnum;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.dto.request.ExportQueryReqDto;
import com.dtyunxi.tcbj.module.export.biz.dto.response.ExportQueryRespDto;
import com.dtyunxi.tcbj.module.export.dao.das.ExportDas;
import com.dtyunxi.tcbj.module.export.dao.eo.ExportEo;
import com.dtyunxi.tcbj.module.export.dao.mapper.ExportMapper;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="exportService")
public class ExportService {
    private static final Logger logger = LoggerFactory.getLogger(ExportService.class);
    @Resource
    private IContext context;
    @Resource
    private ExportDas exportDas;
    @Resource
    private ExportMapper exportMapper;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;

    public RestResponse<PageInfo<ExportQueryRespDto>> queryPage(ExportQueryReqDto queryDto) {
        logger.info("\u83b7\u53d6\u5bfc\u51fa\u5217\u8868-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
        Integer pageNum = queryDto.getPageNum() == null ? 1 : queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize() == null ? 10 : queryDto.getPageSize();
        PageHelper.startPage((int)pageNum, (int)pageSize);
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)queryDto.getFileName())) {
            wrapper.eq((Object)"file_name", (Object)queryDto.getFileName());
        }
        if (queryDto.getExportStatus() != null) {
            wrapper.eq((Object)"status", (Object)queryDto.getExportStatus());
        }
        if (ObjectUtil.isNotEmpty((Object)queryDto.getExportTimeStart())) {
            wrapper.ge((Object)"export_time", (Object)queryDto.getExportTimeStart());
        }
        if (ObjectUtil.isNotEmpty((Object)queryDto.getExportType())) {
            wrapper.eq((Object)"export_type", (Object)queryDto.getExportType());
        }
        if (ObjectUtil.isNotEmpty((Object)queryDto.getExportTimeEnd())) {
            wrapper.le((Object)"export_time", (Object)queryDto.getExportTimeEnd());
        }
        wrapper.eq((Object)"organization_id", (Object)orgId);
        wrapper.orderByDesc((Object)"create_time");
        List list = this.exportMapper.selectList((Wrapper)wrapper);
        PageInfo info = new PageInfo(list);
        List rList = list.stream().map(t -> {
            ExportQueryRespDto dto = new ExportQueryRespDto();
            BeanUtils.copyProperties((Object)t, (Object)dto);
            dto.setExportTypeStr(dto.getExportType());
            ExportTypeEnum exportTypeEnum = ExportTypeEnum.fromCode(dto.getExportType());
            if (exportTypeEnum != null) {
                dto.setExportTypeStr(exportTypeEnum.getName());
            }
            return dto;
        }).collect(Collectors.toList());
        PageInfo result = new PageInfo(rList);
        BeanUtils.copyProperties((Object)info, (Object)result);
        result.setList(rList);
        logger.info("\u83b7\u53d6\u5bfc\u51fa\u5217\u8868-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)result));
        return new RestResponse("0", "success", (Object)result);
    }

    public Long init(String fileName, ExportTypeEnum exportType) {
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
        ExportEo eo = new ExportEo();
        eo.setFileName(fileName);
        eo.setExportType(exportType.getCode());
        eo.setExportTime(new Date());
        eo.setExportStatus(ExportStatusEnum.RUNNING.getCode());
        eo.setExportPerson(this.context.userName());
        eo.setOrganizationId(orgId);
        this.exportDas.insert((BaseEo)eo);
        return eo.getId();
    }

    public Long initNew(Long orgId, String fileName, ExportTypeEnum exportType) {
        ExportEo eo = new ExportEo();
        eo.setFileName(fileName);
        eo.setExportType(exportType.getCode());
        eo.setExportTime(new Date());
        eo.setExportStatus(ExportStatusEnum.RUNNING.getCode());
        eo.setExportPerson(this.context.userName());
        eo.setOrganizationId(orgId);
        this.exportDas.insert((BaseEo)eo);
        return eo.getId();
    }

    public void success(Long id, String url) {
        ExportEo exportEo = (ExportEo)this.exportDas.selectByPrimaryKey(id);
        if (Objects.nonNull(exportEo)) {
            exportEo.setFileUrl(url);
            exportEo.setExportSuccessTime(new Date());
            exportEo.setExportStatus(ExportStatusEnum.SUCCEED.getCode());
            this.update(exportEo);
        }
    }

    public void success(Long id, String url, String remark) {
        ExportEo exportEo = (ExportEo)this.exportDas.selectByPrimaryKey(id);
        if (Objects.nonNull(exportEo)) {
            exportEo.setFileUrl(url);
            exportEo.setExportSuccessTime(new Date());
            exportEo.setExportStatus(ExportStatusEnum.SUCCEED.getCode());
            exportEo.setFailReason(remark);
            this.update(exportEo);
        }
    }

    public void fail(Long id, String failReason) {
        logger.info("\u66f4\u65b0\u5bfc\u51fa\u5931\u8d25\u5165\u53c2\uff1a{}=={}", (Object)id, (Object)failReason);
        ExportEo exportEo = (ExportEo)this.exportDas.selectByPrimaryKey(id);
        if (Objects.nonNull(exportEo)) {
            logger.info("\u5f00\u59cb\u6267\u884c\uff1a{}", (Object)JSON.toJSONString((Object)exportEo));
            exportEo.setExportStatus(ExportStatusEnum.FAIL.getCode());
            exportEo.setFailReason(failReason);
            this.update(exportEo);
        }
    }

    public void update(ExportEo record) {
        this.exportDas.update((BaseEo)record);
    }
}

