/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.utils;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.format.DatePrinter;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.tcbj.module.export.biz.BizExceptionCode;
import com.dtyunxi.tcbj.module.export.biz.dto.request.UploadFileReqDto;
import com.dtyunxi.tcbj.module.export.biz.utils.ExcelFileUtil;
import com.dtyunxi.tcbj.module.export.biz.vo.ExcelSheetVo;
import com.dtyunxi.tcbj.module.export.biz.vo.customer.ItemAuthExcelVo;
import com.dtyunxi.yundt.cube.center.user.api.util.BeanPropertyNullUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import javax.xml.bind.DatatypeConverter;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OssFileUtil {
    private static final Logger logger = LoggerFactory.getLogger(OssFileUtil.class);
    public static final String CUSTOMER_SHEET = "0";
    public static final String ITEM_SHEET = "1";
    @Resource
    private IObjectStorageService objectStorageService;
    @Resource
    private OssRegistryVo ossRegistryVo;

    public String executeUpload(UploadFileReqDto reqDto) {
        long startTime1 = System.currentTimeMillis();
        byte[] bytes = DatatypeConverter.parseBase64Binary((String)reqDto.getFileData());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        logger.info("\u6587\u4ef6\uff1a{}\u5f00\u59cb\u4e0a\u4f20\u5230oss\u670d\u52a1\u5668...", (Object)(this.ossRegistryVo.getEndpoint() + "/cube/" + reqDto.getFileName()));
        try {
            this.objectStorageService.put(this.ossRegistryVo.getBucketName(), reqDto.getFileName(), (InputStream)inputStream);
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20oss\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BizException(BizExceptionCode.ITEMAUTH_UPLOAD_OSS_ERROR.getCode(), BizExceptionCode.ITEMAUTH_UPLOAD_OSS_ERROR.getMsg());
        }
        finally {
            try {
                long startTime2 = System.currentTimeMillis();
                logger.info("\u6587\u4ef6\u8fdb\u884c\u6574\u7406\u5b8c\u6bd5,\u82b1\u8d39[{}]\u8c6a\u79d2", (Object)(startTime2 - startTime1));
                inputStream.close();
            }
            catch (Exception e) {
                logger.error("\u5173\u95ed\u6d41\u51fa\u73b0\u5f02\u5e38");
            }
        }
        String downloadUrl = this.ossRegistryVo.getEndpoint() + "/cube/" + reqDto.getFileName();
        logger.info("\u6587\u4ef6\u4e0a\u4f20\u5230oss\u670d\u52a1\u5668\u5b8c\u6bd5,\u4e0b\u8f7d\u94fe\u63a5\uff1a{},\u4e0a\u4f20\u6587\u4ef6\u5165\u53c2\uff1a{}", (Object)downloadUrl, (Object)JSON.toJSONString((Object)reqDto));
        return downloadUrl;
    }

    public String buildOssFileUrl(String base64, String fileName) {
        String ossFileUrl = null;
        if (StringUtil.isNotBlank((CharSequence)base64)) {
            UploadFileReqDto uploadFileReqDto = new UploadFileReqDto();
            uploadFileReqDto.setFileData(base64);
            uploadFileReqDto.setFileName(ExcelFileUtil.filePrefix(fileName) + "_" + ExcelFileUtil.now() + "." + ExcelFileUtil.fileSuffix(fileName));
            ossFileUrl = this.executeUpload(uploadFileReqDto);
        }
        return ossFileUrl;
    }

    public String buildOssFileUrl(List<ExcelSheetVo> objectList, Date createTime, String fileName, Class<?> clazz) {
        String ossFileUrl = null;
        String now = Objects.isNull(createTime) ? DateUtil.format((Date)new DateTime(), (DatePrinter)DatePattern.PURE_DATETIME_FORMAT) : DateUtil.format((Date)createTime, (DatePrinter)DatePattern.PURE_DATETIME_FORMAT);
        String base64 = ExcelFileUtil.buildFileBase64(objectList, clazz);
        if (StringUtil.isNotBlank((CharSequence)base64)) {
            UploadFileReqDto uploadFileReqDto = new UploadFileReqDto();
            uploadFileReqDto.setFileData(base64);
            uploadFileReqDto.setFileName(ExcelFileUtil.filePrefix(fileName) + "_" + now + ".xlsx");
            ossFileUrl = this.executeUpload(uploadFileReqDto);
        }
        logger.info("\u4e0a\u4f20\u6821\u9a8c\u5931\u8d25\u7684\u6587\u4ef6\u5230OSS\uff0c\u6587\u4ef6\u94fe\u63a5\uff1a{}", ossFileUrl);
        return ossFileUrl;
    }

    public void buildSheetMap(Map<String, List<ItemAuthExcelVo>> map, String importFileUrl, String sheetType) {
        String sheetTypeKey = CUSTOMER_SHEET.equals(sheetType) ? CUSTOMER_SHEET : ITEM_SHEET;
        String msgType = CUSTOMER_SHEET.equals(sheetType) ? "\u5ba2\u6237" : "\u5546\u54c1";
        int sheetIndex = CUSTOMER_SHEET.equals(sheetType) ? Integer.parseInt(CUSTOMER_SHEET) : Integer.parseInt(ITEM_SHEET);
        OutputStream outputStream = this.objectStorageService.get(importFileUrl);
        ByteArrayOutputStream baos = (ByteArrayOutputStream)outputStream;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(baos.toByteArray());
        try {
            List vos = ExcelFileUtil.importExcel(inputStream, sheetIndex, 0, 1, ItemAuthExcelVo.class);
            vos = BeanPropertyNullUtil.getAllFieldNullList(vos);
            map.put(sheetTypeKey, vos);
            logger.info("\u5bfc\u5165\u7684" + msgType + "sheet\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)vos));
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u4e0a\u4f20\u7684\u6587\u4ef6\u51fa\u9519", (Throwable)e);
            throw new BizException("\u8bfb\u53d6\u4e0a\u4f20\u7684\u6587\u4ef6\u51fa\u9519");
        }
        finally {
            if (Objects.nonNull(inputStream)) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed" + msgType + "sheet\u6570\u636e\u6d41\u5931\u8d25", (Throwable)e);
                    throw new BizException("\u5173\u95ed" + msgType + "sheet\u6570\u636e\u6d41\u5931\u8d25");
                }
            }
            if (Objects.nonNull(baos)) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed" + msgType + "sheet\u6570\u636e\u6d41ByteArrayOutputStream\u5931\u8d25", (Throwable)e);
                    throw new BizException("\u5173\u95ed" + msgType + "sheet\u6570\u636e\u6d41ByteArrayOutputStream\u5931\u8d25");
                }
            }
        }
        inputStream = null;
        baos = null;
        outputStream = null;
    }

    public int fileAvailable(String importFileUrl) {
        int available = 0;
        OutputStream outputStream = null;
        ByteArrayOutputStream baos = null;
        ByteArrayInputStream inputStream = null;
        try {
            outputStream = this.objectStorageService.get(importFileUrl);
            baos = (ByteArrayOutputStream)outputStream;
            inputStream = new ByteArrayInputStream(baos.toByteArray());
            available = inputStream.available();
        }
        catch (Exception e) {
            throw new BizException("\u83b7\u53d6\u6587\u4ef6\u5927\u5c0f\u51fa\u9519");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new BizException("\u83b7\u53d6\u6587\u4ef6\u5927\u5c0f\u51fa\u9519");
            }
            try {
                baos.close();
            }
            catch (IOException e) {
                throw new BizException("\u83b7\u53d6\u6587\u4ef6\u5927\u5c0f\u51fa\u9519");
            }
            try {
                outputStream.close();
            }
            catch (IOException e) {
                throw new BizException("\u83b7\u53d6\u6587\u4ef6\u5927\u5c0f\u51fa\u9519");
            }
        }
        return available;
    }
}

