/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.impl.BaseExportService;
import com.dtyunxi.tcbj.module.export.biz.impl.ExportService;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.rebate.api.dto.request.OfflineBalanceAccountReqDto;
import com.yx.tcbj.center.rebate.api.dto.request.OfflineBalanceFlowReqDto;
import com.yx.tcbj.center.rebate.api.dto.response.OfflineBalanceAccountRespDto;
import com.yx.tcbj.center.rebate.api.dto.response.OfflineBalanceFlowRespDto;
import com.yx.tcbj.center.rebate.api.query.IOfflineBalanceAccountQueryApi;
import com.yx.tcbj.center.rebate.api.query.IOfflineBalanceFlowQueryApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OfflineBalanceExportService {
    private static final Logger logger = LoggerFactory.getLogger(OfflineBalanceExportService.class);
    @Resource
    private IContext context;
    @Resource
    private ExportService exportService;
    @Resource
    private IOfflineBalanceAccountQueryApi offlineBalanceAccountQueryApi;
    @Resource
    private IOfflineBalanceFlowQueryApi offlineBalanceFlowQueryApi;
    @Resource
    private HttpServletRequest request;

    public String headerOrgId() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        return organizationId;
    }

    public RestResponse<Object> exportOfflineBalanceAccountSyn(String filter) {
        OfflineBalanceAccountReqDto offlineBalanceAccountReqDto = (OfflineBalanceAccountReqDto)JSON.parseObject((String)filter, OfflineBalanceAccountReqDto.class);
        if (Objects.isNull(offlineBalanceAccountReqDto.getMerchantId())) {
            String orgIdStr = this.headerOrgId();
            logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)orgIdStr);
            if (StringUtils.isNotEmpty((CharSequence)orgIdStr)) {
                offlineBalanceAccountReqDto.setMerchantId(Long.valueOf(orgIdStr));
            }
        }
        String finalFilter = com.dtyunxi.huieryun.core.util.JSON.toJsonString((Object)offlineBalanceAccountReqDto);
        String name = ExportTypeEnum.BALANCE_ACCOUNT.getName();
        BaseExportService baseExportService = new BaseExportService(name, ExportTypeEnum.BALANCE_ACCOUNT);
        baseExportService.executor(req -> {
            Long total = null;
            double num = 0.0;
            Integer pageNum = 1;
            Integer pageSize = 5000;
            ArrayList rList = Lists.newArrayList();
            while (total == null || (double)pageNum.intValue() <= num) {
                PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.offlineBalanceAccountQueryApi.queryByPage(finalFilter, pageNum, pageSize));
                if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                    logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2{}\u7ed3\u679c:{},UUID:{}", new Object[]{name, pageInfo.getList().size(), baseExportService.getId()});
                    rList.addAll(pageInfo.getList());
                }
                if (total == null) {
                    total = pageInfo.getTotal();
                    num = Math.ceil(Double.valueOf(total.longValue()) / (double)pageSize.intValue());
                    logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u521d\u59cb\u5316UUID:{},\u67e5\u8be2{}\u603b\u6570:{},\u4e00\u5171\u9700\u8981\u5206\u6279:{}\u6b21", new Object[]{baseExportService.getId(), name, total, num});
                }
                pageNum = pageNum + 1;
            }
            logger.info(name + "\u5217\u8868\u67e5\u8be2\u6570\u636e\u8f6c\u6362\u7ed3\u679c\u5927\u5c0f:{},UUID:{}", (Object)rList.size(), (Object)baseExportService.getId());
            if (CollectionUtils.isNotEmpty((Collection)rList)) {
                baseExportService.exportUrl(rList, OfflineBalanceAccountRespDto.class);
            } else {
                this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + name + "\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
            }
            return null;
        }, finalFilter);
        return new RestResponse("0", "\u5bfc\u51fa" + name + "\u6210\u529f");
    }

    public RestResponse<Object> exportOfflineBalanceFlowSyn(String filter, String type) {
        String name = ExportTypeEnum.BALANCE_FLOW.getName();
        BaseExportService baseExportService = new BaseExportService(name, ExportTypeEnum.BALANCE_FLOW);
        OfflineBalanceFlowReqDto offlineBalanceFlowReqDto = (OfflineBalanceFlowReqDto)com.dtyunxi.huieryun.core.util.JSON.parseObject((String)filter, OfflineBalanceFlowReqDto.class);
        if (Objects.isNull(offlineBalanceFlowReqDto.getMerchantId())) {
            String orgIdStr = this.headerOrgId();
            logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)orgIdStr);
            if (StringUtils.isNotEmpty((CharSequence)orgIdStr)) {
                offlineBalanceFlowReqDto.setMerchantId(Long.valueOf(orgIdStr));
            }
        }
        baseExportService.executor(req -> {
            Long total = null;
            double num = 0.0;
            Integer pageNum = 1;
            Integer pageSize = 5000;
            ArrayList rList = Lists.newArrayList();
            while (total == null || (double)pageNum.intValue() <= num) {
                PageInfo pageInfo;
                if ("ALL".equals(type)) {
                    offlineBalanceFlowReqDto.setPageNum(pageNum);
                    offlineBalanceFlowReqDto.setPageSize(pageSize);
                    pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.offlineBalanceFlowQueryApi.queryByFlowPage(offlineBalanceFlowReqDto));
                } else {
                    pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.offlineBalanceFlowQueryApi.queryByPage(filter, pageNum, pageSize));
                }
                if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                    logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2{}\u7ed3\u679c:{},UUID:{}", new Object[]{name, pageInfo.getList().size(), baseExportService.getId()});
                    rList.addAll(pageInfo.getList());
                }
                if (total == null) {
                    total = pageInfo.getTotal();
                    num = Math.ceil(Double.valueOf(total.longValue()) / (double)pageSize.intValue());
                    logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u521d\u59cb\u5316UUID:{},\u67e5\u8be2{}\u603b\u6570:{},\u4e00\u5171\u9700\u8981\u5206\u6279:{}\u6b21", new Object[]{baseExportService.getId(), name, total, num});
                }
                pageNum = pageNum + 1;
            }
            logger.info(name + "\u5217\u8868\u67e5\u8be2\u6570\u636e\u8f6c\u6362\u7ed3\u679c\u5927\u5c0f:{},UUID:{}", (Object)rList.size(), (Object)baseExportService.getId());
            if (CollectionUtils.isNotEmpty((Collection)rList)) {
                baseExportService.exportUrl(rList, OfflineBalanceFlowRespDto.class);
            } else {
                this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + name + "\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
            }
            return null;
        }, filter);
        return new RestResponse("0", "\u5bfc\u51fa" + name + "\u6210\u529f");
    }
}

