/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl.operation;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.abs.ReportExportAbstract;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.dto.request.ItemAuthCustomerExportReqDto;
import com.dtyunxi.tcbj.module.export.biz.vo.operation.ItemAuthCustomerVo;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.MatchAuthItemRuleReqDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ItemAuthCustomerRespDto;
import com.dtyunxi.yundt.module.bitem.biz.service.IAuthItemRuleService;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ItemAuthCustomerService
extends ReportExportAbstract<ItemAuthCustomerRespDto, ItemAuthCustomerExportReqDto, ItemAuthCustomerVo> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAuthItemRuleService authItemRuleService;

    @Override
    public ExportTypeEnum getExportType() {
        return ExportTypeEnum.ITEM_AUTH_CUSTOMER;
    }

    @Override
    public PageInfo<ItemAuthCustomerRespDto> queryData(ItemAuthCustomerExportReqDto itemAuthCustomerExportReqDto) {
        MatchAuthItemRuleReqDto matchAuthItemRuleReqDto = new MatchAuthItemRuleReqDto();
        BeanUtils.copyProperties((Object)((Object)itemAuthCustomerExportReqDto), (Object)matchAuthItemRuleReqDto);
        return (PageInfo)RestResponseHelper.extractData((RestResponse)this.authItemRuleService.queryRulePageByCondition(matchAuthItemRuleReqDto));
    }

    @Override
    public ItemAuthCustomerExportReqDto definePrams(ItemAuthCustomerExportReqDto itemAuthCustomerExportReqDto) {
        return itemAuthCustomerExportReqDto;
    }

    @Override
    public Gson buildGson() {
        return new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").create();
    }

    @Override
    public List<ItemAuthCustomerVo> getExportDtoList(List<ItemAuthCustomerRespDto> exportDtoList, Class<ItemAuthCustomerVo> vo) {
        if (CollectionUtils.isEmpty(exportDtoList)) {
            return Lists.newArrayList();
        }
        ArrayList itemAuthCustomerVos = Lists.newArrayList();
        for (ItemAuthCustomerRespDto orderRespDto : exportDtoList) {
            ItemAuthCustomerVo itemAuthCustomerVo = new ItemAuthCustomerVo();
            CubeBeanUtils.copyProperties((Object)itemAuthCustomerVo, (Object)orderRespDto, (String[])new String[0]);
            itemAuthCustomerVos.add(itemAuthCustomerVo);
        }
        return itemAuthCustomerVos;
    }
}

