/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.company.CompanyVerifyRespDto;
import com.dtyunxi.tcbj.module.export.biz.constant.ImportLogStatusEnum;
import com.dtyunxi.tcbj.module.export.biz.dto.request.ImportReqDto;
import com.dtyunxi.tcbj.module.export.biz.dto.response.CustomerUpdateImportDto;
import com.dtyunxi.tcbj.module.export.biz.impl.CustomerAddImportService;
import com.dtyunxi.tcbj.module.export.biz.impl.CustomerInfoUpdateImportService;
import com.dtyunxi.tcbj.module.export.biz.impl.ImportLogService;
import com.dtyunxi.tcbj.module.export.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.constant.SubjectTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerExtApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CompanyInfoDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerTypeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.entity.NacosPropertiesOrgEntity;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerAreaListExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerSearchExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerQueryV3Api;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeRegionQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BrandRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import com.yx.demo.center.data.query.IAreaExtQueryApi;
import com.yx.tcbj.center.api.ItemBrandAuthApi;
import com.yx.tcbj.center.customer.api.dto.request.ComputeCustomerNameRateReqDto;
import com.yx.tcbj.center.customer.api.dto.request.CustomerExtReqDto;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import com.yx.tcbj.center.customer.api.query.IStoreQueryApi;
import com.yx.tcbj.center.price.api.IPrBaseDiscountApi;
import com.yx.tcbj.center.price.api.dto.request.PrBaseDiscountAddEditReqDto;
import com.yx.tcbj.center.price.api.dto.request.PrBaseDiscountBrandReqDto;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CustomerUpdateImportService {
    public final Logger logger = LoggerFactory.getLogger(CustomerUpdateImportService.class);
    @Resource
    private IContext context;
    @Resource
    private ImportLogService importLogService;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private IEmployeeRegionQueryApi employeeRegionQueryApi;
    @Resource
    private ICustomerQueryV3Api customerQueryV3Api;
    @Resource
    private ICustomerExtApi customerExtApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private HttpServletRequest request;
    @Resource
    private NacosPropertiesOrgEntity nacosPropertiesOrgEntity;
    @Resource
    private CustomerAddImportService customerAddImportService;
    @Resource
    private IAreaExtQueryApi areaExtQueryApi;
    @Resource
    private ItemBrandAuthApi itemBrandAuthApi;
    @Resource
    private IPrBaseDiscountApi prBaseDiscountApi;
    @Resource
    private IStoreQueryApi storeQueryApi;
    @Resource
    CustomerInfoUpdateImportService customerInfoUpdateImportService;

    Long getTenantId() {
        Long tenantId = ServiceContext.getContext().getRequestTenantId();
        if (Objects.isNull(tenantId)) {
            tenantId = 1L;
        }
        return tenantId;
    }

    Long getInstanceId() {
        Long instanceId = ServiceContext.getContext().getRequestInstanceId();
        if (Objects.isNull(instanceId)) {
            instanceId = 1254039287584232622L;
        }
        return instanceId;
    }

    public void customerUpdateImport(ImportReqDto importReqDto) {
        this.customerInfoUpdateImportService.customerInfoUpdateImport(importReqDto);
    }

    private InputStream getInputStream(String fileUrl) throws IOException {
        URL url = new URL(fileUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        return conn.getInputStream();
    }

    private void doImportSyn(Long requestTenantId, Long requestInstanceId, List<CustomerUpdateImportDto> importDtos, Long importLogId, Long sellerId, Long orgId) {
        Object customerTypeDtos;
        List customerTypeList;
        this.checkData(importDtos, sellerId, orgId, requestTenantId, requestInstanceId);
        List successList = importDtos.stream().filter(dto -> StringUtils.isEmpty((CharSequence)dto.getErrorReason())).collect(Collectors.toList());
        this.logger.info("\u7b5b\u9009\u6210\u529f\u7684\u6570\u636e:{}", (Object)successList.size());
        HashMap<String, CustomerTypeRespDto> customerTypeInfoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(successList) && CollectionUtils.isNotEmpty(customerTypeList = successList.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getCustomerTypeName())).map(CustomerUpdateImportDto::getCustomerTypeName).collect(Collectors.toList())) && CollectionUtils.isNotEmpty((Collection)(customerTypeDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryV3Api.getCustomerTypeByNames(customerTypeList))))) {
            customerTypeInfoMap = customerTypeDtos.stream().collect(Collectors.toMap(CustomerTypeRespDto::getName, Function.identity(), (k1, k2) -> k1));
        }
        String failReason = "";
        for (CustomerUpdateImportDto importDto : importDtos) {
            if (StringUtils.isNotEmpty((CharSequence)importDto.getErrorReason())) continue;
            try {
                List<Object> addressList = Lists.newArrayList();
                addressList.add(importDto.getProvince());
                addressList.add(importDto.getCity());
                addressList.add(importDto.getCounty());
                addressList.add(importDto.getOrgProvince());
                addressList.add(importDto.getOrgCity());
                addressList.add(importDto.getOrgDistrict());
                addressList = addressList.stream().filter(s -> StringUtils.isNotEmpty((CharSequence)s)).distinct().collect(Collectors.toList());
                Map<String, Object> addressInfoMap = new HashMap<String, AreaDto>();
                if (CollectionUtils.isNotEmpty((Collection)addressList)) {
                    List addressAreaList = (List)RestResponseHelper.extractData((RestResponse)this.areaExtQueryApi.getAreaByNames((List)addressList));
                    if (CollectionUtils.isEmpty((Collection)addressAreaList)) {
                        throw new BizException("\u5730\u533a\u540d\u79f0\u6570\u636e\u9519\u8bef;");
                    }
                    addressInfoMap = addressAreaList.stream().collect(Collectors.toMap(AreaDto::getName, Function.identity(), (k1, k2) -> k1));
                    if (StringUtils.isNotEmpty((CharSequence)importDto.getProvince()) && !addressInfoMap.containsKey(importDto.getProvince())) {
                        throw new BizException("\u6240\u5c5e\u7701\u4efd\u6570\u636e\u9519\u8bef");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)importDto.getCity()) && !addressInfoMap.containsKey(importDto.getCity())) {
                        throw new BizException("\u6240\u5c5e\u57ce\u5e02\u6570\u636e\u9519\u8bef");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)importDto.getCounty()) && !addressInfoMap.containsKey(importDto.getCounty())) {
                        throw new BizException("\u6240\u5c5e\u5730\u533a\u6570\u636e\u9519\u8bef");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)importDto.getOrgProvince()) && !addressInfoMap.containsKey(importDto.getOrgProvince())) {
                        throw new BizException("\u516c\u53f8\u6240\u5c5e\u7701\u4efd\u6570\u636e\u9519\u8bef");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)importDto.getOrgCity()) && !addressInfoMap.containsKey(importDto.getOrgCity())) {
                        throw new BizException("\u516c\u53f8\u6240\u5c5e\u57ce\u5e02\u6570\u636e\u9519\u8bef");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)importDto.getOrgDistrict()) && !addressInfoMap.containsKey(importDto.getOrgDistrict())) {
                        throw new BizException("\u516c\u53f8\u6240\u5c5e\u5730\u533a\u6570\u636e\u9519\u8bef");
                    }
                }
                this.updateCustomerWithAddress(importDto, customerTypeInfoMap, addressInfoMap, orgId, requestTenantId, requestInstanceId);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.info("\u5ba2\u6237\u4fee\u6539\u5931\u8d25:{}", (Object)e.getMessage());
                importDto.setErrorReason(e.getMessage());
            }
        }
        List errorList = importDtos.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getErrorReason())).collect(Collectors.toList());
        int errorSize = errorList.size();
        int totalSize = importDtos.size();
        this.logger.info("\u66f4\u65b0\u5bfc\u5165\u5ba2\u6237\u4fee\u6539\u5931\u8d25\u6570:{},\u603b\u6570:{}", (Object)errorSize, (Object)totalSize);
        if (errorSize == 0) {
            this.importLogService.success(importLogId, ImportLogStatusEnum.SUCCEED, totalSize, "", "", 0);
        } else {
            String title = "\u5bfc\u5165\u5ba2\u6237\u4fee\u6539\u8fd4\u56de\u7ed3\u679c";
            String fileName = title + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmssSSS");
            String exportUrl = "";
            try {
                Thread.sleep(2000L);
                exportUrl = EasyPoiExportUtil.getExportUrl(importDtos, CustomerUpdateImportDto.class, null, fileName, "xls");
            }
            catch (Exception e) {
                e.printStackTrace();
                failReason = failReason + "\u5bfc\u51fa\u5f02\u5e38\uff1a" + e.getMessage();
                this.logger.info(failReason);
            }
            if (errorSize < totalSize) {
                this.importLogService.success(importLogId, ImportLogStatusEnum.PART_SUCCESS, totalSize - errorSize, failReason, exportUrl, errorSize);
            } else {
                this.importLogService.fail(importLogId, failReason, exportUrl, errorSize);
            }
        }
    }

    private void checkData(List<CustomerUpdateImportDto> importDtos, Long sellerId, Long orgId, Long requestTenantId, Long requestInstanceId) {
        for (CustomerUpdateImportDto importDto : importDtos) {
            Integer toLegalCardType;
            String[] areaNameArr;
            List uniqueAreaNames;
            List customerRespDtoList;
            CustomerExtReqDto reqDto;
            StringBuffer errorMsg = new StringBuffer();
            this.preProcessImportData(importDto);
            if (StringUtils.isEmpty((CharSequence)importDto.getCode())) {
                errorMsg.append("\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a;");
            } else {
                reqDto = new CustomerExtReqDto();
                reqDto.setCode(importDto.getCode());
                reqDto.setMerchantId(orgId);
                customerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerInfoByOrg(reqDto));
                if (CollectionUtils.isEmpty((Collection)customerRespDtoList)) {
                    errorMsg.append("\u5ba2\u6237\u7f16\u7801\u4e0d\u5b58\u5728\u4e8e\u5f53\u524d\u7ec4\u7ec7;");
                } else {
                    importDto.setCustomerId(((CustomerRespDto)customerRespDtoList.get(0)).getId());
                    importDto.setOrgInfoIds(customerRespDtoList.stream().map(CustomerRespDto::getOrgInfoId).distinct().collect(Collectors.toList()));
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getEasCode())) {
                reqDto = new CustomerExtReqDto();
                reqDto.setEasCode(importDto.getEasCode());
                customerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerInfoByOrg(reqDto));
                if (CollectionUtils.isEmpty((Collection)customerRespDtoList)) {
                    errorMsg.append("\u5916\u90e8\u7f16\u7801\u4e0d\u5bf9\u5e94\u4efb\u4f55\u5ba2\u6237;");
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getSalesArea()) && StringUtils.isNotEmpty((CharSequence)importDto.getLargeArea()) && StringUtils.isNotEmpty((CharSequence)importDto.getRegionName()) && StringUtils.isNotEmpty((CharSequence)importDto.getRegionName()) && (uniqueAreaNames = Arrays.stream(areaNameArr = importDto.getRegionName().split(";")).distinct().collect(Collectors.toList())).size() < areaNameArr.length) {
                this.logger.warn("\u5ba2\u6237\u533a\u57df\u5b58\u5728\u91cd\u590d\u8bb0\u5f55: {}", (Object)importDto.getRegionName());
                errorMsg.append("\u5ba2\u6237\u533a\u57df\u5b58\u5728\u91cd\u590d\u503c\uff0c\u5df2\u81ea\u52a8\u5904\u7406;");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getStandardDiscountRate())) {
                try {
                    BigDecimal standardDiscount = this.convertToDiscount(importDto.getStandardDiscountRate());
                    if (standardDiscount == null) {
                        errorMsg.append("\u6807\u51c6\u6263\u7387\u683c\u5f0f\u9519\u8bef;");
                    }
                }
                catch (NumberFormatException e) {
                    errorMsg.append("\u6807\u51c6\u6263\u7387\u683c\u5f0f\u9519\u8bef;");
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getAreaType()) && !"\u6536\u8d27\u5730\u5740".equals(importDto.getAreaType()) && !"\u6536\u7968\u5730\u5740".equals(importDto.getAreaType())) {
                errorMsg.append("\u5730\u533a\u7c7b\u578b\u586b\u5199\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u4e3a\u6536\u8d27\u5730\u5740\u6216\u6536\u7968\u5730\u5740;");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getBrandDiscount())) {
                String[] brandDiscounts;
                for (String brandDiscount : brandDiscounts = importDto.getBrandDiscount().replace("\uff0c", ",").split(",")) {
                    if (!brandDiscount.contains(":")) {
                        errorMsg.append("\u591a\u54c1\u724c\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u4e3a\u54c1\u724c\u540d\u79f0:\u6263\u7387;");
                        break;
                    }
                    String[] parts = brandDiscount.split(":");
                    if (parts.length != 2) {
                        errorMsg.append("\u591a\u54c1\u724c\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u4e3a\u54c1\u724c\u540d\u79f0:\u6263\u7387;");
                        break;
                    }
                    try {
                        BigDecimal discountRate = this.convertToDiscount(parts[1].trim());
                        if (discountRate != null) continue;
                        errorMsg.append("\u591a\u54c1\u724c\u6263\u7387\u683c\u5f0f\u9519\u8bef;");
                    }
                    catch (NumberFormatException e) {
                        errorMsg.append("\u591a\u54c1\u724c\u6263\u7387\u5fc5\u987b\u4e3a\u6570\u5b57;");
                    }
                    break;
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getSubjectType()) && StringUtils.isEmpty((CharSequence)this.toSubjectType(importDto.getSubjectType()))) {
                errorMsg.append("\u4e3b\u4f53\u7c7b\u578b\u9519\u8bef;");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getBusinessLicenseType()) && this.toBusinessLicenseType(importDto.getBusinessLicenseType()) == 0) {
                errorMsg.append("\u6267\u7167\u7c7b\u578b\u9519\u8bef;");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getBusinessTermType())) {
                String toBusinessTermType = this.toBusinessTermType(importDto.getBusinessTermType());
                if (toBusinessTermType.equals("0")) {
                    errorMsg.append("\u8425\u4e1a\u671f\u9650\u7c7b\u578b\u9519\u8bef;");
                } else if (toBusinessTermType.equals("1")) {
                    if (StringUtils.isEmpty((CharSequence)importDto.getTermBeginTime())) {
                        errorMsg.append("\u8425\u4e1a\u671f\u9650\u8d77\u4e3a\u7a7a;");
                    }
                    if (StringUtils.isEmpty((CharSequence)importDto.getTermEndTime())) {
                        errorMsg.append("\u8425\u4e1a\u671f\u9650\u6b62\u4e3a\u7a7a;");
                    }
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getLegalCardType()) && (toLegalCardType = this.toLegalCardType(importDto.getLegalCardType())).equals(0)) {
                errorMsg.append("\u6cd5\u4eba\u8bc1\u4ef6\u7c7b\u578b\u9519\u8bef;");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getLegalCardType())) {
                Integer toCardEffectType = this.toCardEffectType(importDto.getCardEffectType());
                if (toCardEffectType.equals(0)) {
                    errorMsg.append("\u6cd5\u4eba\u8bc1\u4ef6\u6709\u6548\u671f\u7c7b\u578b\u9519\u8bef;");
                } else if (toCardEffectType.equals(1)) {
                    if (Objects.isNull(importDto.getCardEffectBeginTime())) {
                        errorMsg.append("\u6cd5\u4eba\u8bc1\u4ef6\u6709\u6548\u671f\u8d77\u4e3a\u7a7a;");
                    }
                    if (Objects.isNull(importDto.getCardEffectEndTime())) {
                        errorMsg.append("\u6cd5\u4eba\u8bc1\u4ef6\u6709\u6548\u671f\u6b62\u4e3a\u7a7a;");
                    }
                }
            }
            if (Objects.nonNull(importDto.getEffectBeginTime()) && Objects.nonNull(importDto.getEffectEndTime()) && importDto.getEffectEndTime().before(importDto.getEffectBeginTime())) {
                errorMsg.append("\u5931\u6548\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u751f\u6548\u65f6\u95f4;");
            }
            if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
                importDto.setErrorReason(errorMsg.toString());
            }
            importDto.setSellerId(sellerId);
            importDto.setOrgId(orgId);
            importDto.setInstanceId(requestInstanceId);
        }
    }

    private void updateCustomerWithAddress(CustomerUpdateImportDto importDto, Map<String, CustomerTypeRespDto> customerTypeInfoMap, Map<String, AreaDto> addressInfoMap, Long orgId, Long requestTenantId, Long requestInstanceId) {
        String regionNames;
        AreaDto districtDto;
        AreaDto cityDto;
        AreaDto cityDto2;
        AreaDto provinceDto;
        CustomerExtReqDto customerQuery = new CustomerExtReqDto();
        customerQuery.setCode(importDto.getCode());
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerInfoByOrg(customerQuery));
        if (CollectionUtils.isEmpty((Collection)customerRespDtos)) {
            throw new BizException("\u5ba2\u6237\u7f16\u7801\u4e0d\u5b58\u5728;");
        }
        CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtos.get(0);
        CustomerTypeRespDto customerTypeRespDto = null;
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCustomerTypeName())) {
            if (customerTypeInfoMap.isEmpty() || !customerTypeInfoMap.containsKey(importDto.getCustomerTypeName())) {
                throw new BizException("\u5ba2\u6237\u7c7b\u578b\u6570\u636e\u9519\u8bef;");
            }
            customerTypeRespDto = customerTypeInfoMap.get(importDto.getCustomerTypeName());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getSalesArea()) && StringUtils.isNotEmpty((CharSequence)importDto.getLargeArea())) {
            ArrayList areaHierarchyList = Lists.newArrayList((Object[])new String[]{importDto.getSalesArea(), importDto.getLargeArea()});
            CustomerAreaListExtReqDto areaHierarchyQuery = new CustomerAreaListExtReqDto();
            areaHierarchyQuery.setNameList((List)areaHierarchyList);
            areaHierarchyQuery.setOrgInfoId(orgId);
            List areaHierarchyResult = (List)RestResponseHelper.extractData((RestResponse)this.employeeRegionQueryApi.queryCustomerAreaByNames(areaHierarchyQuery));
            areaHierarchyResult = areaHierarchyResult.stream().filter(r -> r.getOrgInfoId() != null && r.getOrgInfoId().equals(orgId)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(areaHierarchyResult)) {
                throw new BizException("\u9500\u552e\u533a\u6216\u5927\u533a\u6570\u636e\u9519\u8bef;");
            }
            Map areaHierarchyMap = areaHierarchyResult.stream().collect(Collectors.toMap(CustomerAreaRespDto::getName, Function.identity(), (k1, k2) -> k1));
            if (!areaHierarchyMap.containsKey(importDto.getSalesArea())) {
                throw new BizException("\u9500\u552e\u533a\u4e0d\u5b58\u5728;");
            }
            if (!areaHierarchyMap.containsKey(importDto.getLargeArea())) {
                throw new BizException("\u5927\u533a\u4e0d\u5b58\u5728;");
            }
            CustomerAreaRespDto salesAreaDto = (CustomerAreaRespDto)areaHierarchyMap.get(importDto.getSalesArea());
            CustomerAreaRespDto largeAreaDto = (CustomerAreaRespDto)areaHierarchyMap.get(importDto.getLargeArea());
            if (!largeAreaDto.getParentCode().equals(salesAreaDto.getCode())) {
                throw new BizException("\u5927\u533a\u4e0d\u5c5e\u4e8e\u6240\u9009\u9500\u552e\u533a;");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getRegionName())) {
            String[] areaNameArr = importDto.getRegionName().split(";");
            List<String> uniqueAreaNameList = Arrays.stream(areaNameArr).distinct().collect(Collectors.toList());
            importDto.setRegionNameList(uniqueAreaNameList);
            if (uniqueAreaNameList.size() < areaNameArr.length) {
                this.logger.info("\u5ba2\u6237[{}]\u5bfc\u5165\u533a\u57df\u5b58\u5728\u91cd\u590d\u8bb0\u5f55\uff0c\u539f\u59cb\u533a\u57df\u6570\u91cf:{}, \u53bb\u91cd\u540e\u533a\u57df\u6570\u91cf:{}", new Object[]{importDto.getName(), areaNameArr.length, uniqueAreaNameList.size()});
            }
            CustomerAreaListExtReqDto customerAreaQuery = new CustomerAreaListExtReqDto();
            customerAreaQuery.setNameList(uniqueAreaNameList);
            customerAreaQuery.setOrgInfoId(orgId);
            List areaList = (List)RestResponseHelper.extractData((RestResponse)this.employeeRegionQueryApi.queryCustomerAreaByNames(customerAreaQuery));
            if (CollectionUtils.isEmpty((Collection)areaList)) {
                throw new BizException("\u5ba2\u6237\u533a\u57df\u6570\u636e\u9519\u8bef;");
            }
            if (CollectionUtils.isEmpty(areaList = areaList.stream().filter(dto -> dto.getOrgInfoId() != null && dto.getOrgInfoId().equals(orgId)).collect(Collectors.toList()))) {
                throw new BizException("\u5ba2\u6237\u533a\u57df\u7ec4\u7ec7\u6570\u636e\u9519\u8bef;");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getLargeArea())) {
                CustomerAreaListExtReqDto largeAreaQuery = new CustomerAreaListExtReqDto();
                largeAreaQuery.setNameList((List)Lists.newArrayList((Object[])new String[]{importDto.getLargeArea()}));
                largeAreaQuery.setOrgInfoId(orgId);
                List largeAreaResult = (List)RestResponseHelper.extractData((RestResponse)this.employeeRegionQueryApi.queryCustomerAreaByNames(largeAreaQuery));
                largeAreaResult = largeAreaResult.stream().filter(r -> r.getOrgInfoId() != null && r.getOrgInfoId().equals(orgId)).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(largeAreaResult)) {
                    CustomerAreaRespDto largeAreaDto = (CustomerAreaRespDto)largeAreaResult.get(0);
                    for (CustomerAreaRespDto areaDto : areaList) {
                        if (areaDto.getParentCode().equals(largeAreaDto.getCode())) continue;
                        throw new BizException("\u533a\u57df[" + areaDto.getName() + "]\u4e0d\u5c5e\u4e8e\u6240\u9009\u5927\u533a;");
                    }
                }
            }
            List<String> areaCodeList = areaList.stream().map(CustomerAreaRespDto::getCode).collect(Collectors.toList());
            importDto.setRegionCodeList(areaCodeList);
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getBrandDiscount())) {
            CustomerAreaListExtReqDto brandDiscounts = importDto.getBrandDiscount().split(",");
            ArrayList<String> brandNameList = new ArrayList<String>();
            for (CustomerAreaListExtReqDto brandDiscount : brandDiscounts) {
                String[] parts = brandDiscount.split(":");
                if (parts.length != 2) continue;
                brandNameList.add(parts[0]);
            }
            if (!brandNameList.isEmpty()) {
                try {
                    List nonExistingBrands = (List)RestResponseHelper.extractData((RestResponse)this.itemBrandAuthApi.checkBrandsExist(brandNameList));
                    if (CollectionUtils.isNotEmpty((Collection)nonExistingBrands)) {
                        this.logger.warn("\u5ba2\u6237[{}]\u591a\u54c1\u724c\u4e2d\u5305\u542b\u4e0d\u5b58\u5728\u7684\u54c1\u724c: {}", (Object)importDto.getName(), (Object)nonExistingBrands);
                        throw new BizException("\u591a\u54c1\u724c\u4e2d\u5305\u542b\u4e0d\u5b58\u5728\u7684\u54c1\u724c: " + String.join((CharSequence)", ", nonExistingBrands));
                    }
                }
                catch (Exception e) {
                    this.logger.error("\u9a8c\u8bc1\u54c1\u724c\u5f02\u5e38", (Throwable)e);
                    throw new BizException("\u9a8c\u8bc1\u54c1\u724c\u5f02\u5e38: " + e.getMessage());
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getProvince()) && StringUtils.isNotEmpty((CharSequence)importDto.getCity())) {
            provinceDto = addressInfoMap.get(importDto.getProvince());
            cityDto2 = addressInfoMap.get(importDto.getCity());
            if (provinceDto != null && cityDto2 != null && !cityDto2.getParentCode().equals(provinceDto.getCode())) {
                this.logger.warn("\u57ce\u5e02[{}]\u4e0d\u5c5e\u4e8e\u7701\u4efd[{}]", (Object)importDto.getCity(), (Object)importDto.getProvince());
                throw new BizException("\u57ce\u5e02[" + importDto.getCity() + "]\u4e0d\u5c5e\u4e8e\u7701\u4efd[" + importDto.getProvince() + "];");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCity()) && StringUtils.isNotEmpty((CharSequence)importDto.getCounty())) {
            cityDto = addressInfoMap.get(importDto.getCity());
            districtDto = addressInfoMap.get(importDto.getCounty());
            if (cityDto != null && districtDto != null && !districtDto.getParentCode().equals(cityDto.getCode())) {
                this.logger.warn("\u5730\u533a[{}]\u4e0d\u5c5e\u4e8e\u57ce\u5e02[{}]", (Object)importDto.getCounty(), (Object)importDto.getCity());
                throw new BizException("\u5730\u533a[" + importDto.getCounty() + "]\u4e0d\u5c5e\u4e8e\u57ce\u5e02[" + importDto.getCity() + "];");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getOrgProvince()) && StringUtils.isNotEmpty((CharSequence)importDto.getOrgCity())) {
            provinceDto = addressInfoMap.get(importDto.getOrgProvince());
            cityDto2 = addressInfoMap.get(importDto.getOrgCity());
            if (provinceDto != null && cityDto2 != null && !cityDto2.getParentCode().equals(provinceDto.getCode())) {
                this.logger.warn("\u516c\u53f8\u57ce\u5e02[{}]\u4e0d\u5c5e\u4e8e\u7701\u4efd[{}]", (Object)importDto.getOrgCity(), (Object)importDto.getOrgProvince());
                throw new BizException("\u516c\u53f8\u57ce\u5e02[" + importDto.getOrgCity() + "]\u4e0d\u5c5e\u4e8e\u7701\u4efd[" + importDto.getOrgProvince() + "];");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getOrgCity()) && StringUtils.isNotEmpty((CharSequence)importDto.getOrgDistrict())) {
            cityDto = addressInfoMap.get(importDto.getOrgCity());
            districtDto = addressInfoMap.get(importDto.getOrgDistrict());
            if (cityDto != null && districtDto != null && !districtDto.getParentCode().equals(cityDto.getCode())) {
                this.logger.warn("\u516c\u53f8\u5730\u533a[{}]\u4e0d\u5c5e\u4e8e\u57ce\u5e02[{}]", (Object)importDto.getOrgDistrict(), (Object)importDto.getOrgCity());
                throw new BizException("\u516c\u53f8\u5730\u533a[" + importDto.getOrgDistrict() + "]\u4e0d\u5c5e\u4e8e\u57ce\u5e02[" + importDto.getOrgCity() + "];");
            }
        }
        CompanyInfoDto companyInfoDto = null;
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCreditCode())) {
            try {
                this.logger.info("\u67e5\u8be2\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u7801CreditCode={},orgId={},requestTenantId={},requestInstanceId={}", new Object[]{importDto.getCreditCode(), orgId, requestTenantId, requestInstanceId});
                ArrayList creditCodes = Lists.newArrayList((Object[])new String[]{importDto.getCreditCode()});
                List storeRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.storeQueryApi.querySocialCreditNums((List)creditCodes));
                if (CollectionUtils.isEmpty((Collection)storeRespDtos)) {
                    this.logger.info("\u901a\u8fc7\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u672a\u67e5\u8be2\u5230\u516c\u53f8\u4fe1\u606f:{}", (Object)importDto.getCreditCode());
                    companyInfoDto = (CompanyInfoDto)RestResponseHelper.extractData((RestResponse)this.customerQueryV3Api.queryCompanyInfoByCreditCode(importDto.getCreditCode(), orgId, requestTenantId, requestInstanceId, customerRespDto.getId()));
                } else {
                    StoreRespDto storeRespDto = (StoreRespDto)storeRespDtos.get(0);
                    companyInfoDto = new CompanyInfoDto();
                    companyInfoDto.setOrgName(storeRespDto.getStoreName());
                    companyInfoDto.setCreditCode(storeRespDto.getSocialCreditNum());
                    companyInfoDto.setLegalName(storeRespDto.getLegalPersonName());
                    if (StringUtils.isNotEmpty((CharSequence)storeRespDto.getProvince())) {
                        companyInfoDto.setProvince(storeRespDto.getProvince());
                        companyInfoDto.setProvinceCode(storeRespDto.getProvinceCode());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)storeRespDto.getCity())) {
                        companyInfoDto.setCity(storeRespDto.getCity());
                        companyInfoDto.setCityCode(storeRespDto.getCityCode());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)storeRespDto.getDistrict())) {
                        companyInfoDto.setDistrict(storeRespDto.getDistrict());
                        companyInfoDto.setDistrictCode(storeRespDto.getDistrictCode());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)storeRespDto.getStoreAddr())) {
                        companyInfoDto.setAddress(storeRespDto.getStoreAddr());
                    }
                    this.logger.info("\u901a\u8fc7\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u67e5\u8be2\u5230\u516c\u53f8\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)storeRespDto));
                }
                this.logger.info("\u67e5\u8be2\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u7801\u516c\u53f8\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)companyInfoDto));
            }
            catch (Exception e) {
                throw new BizException("\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u7801\u516c\u53f8\u4fe1\u606f:" + e.getMessage());
            }
        }
        CustomerReqDto updateCustomerDto = new CustomerReqDto();
        CubeBeanUtils.copyProperties((Object)updateCustomerDto, (Object)customerRespDto, (String[])new String[]{"companyInfoDto", "regionCodeList", "regionNameList", "salesmanIds"});
        updateCustomerDto.setId(customerRespDto.getId());
        updateCustomerDto.setMerchantId(orgId);
        updateCustomerDto.setInstanceId(requestInstanceId);
        updateCustomerDto.setTenantId(requestTenantId);
        updateCustomerDto.setOrgId(orgId);
        updateCustomerDto.setRegionCodeList(customerRespDto.getRegionCodeList());
        HashMap<String, String> extendFields = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)importDto.getSalesArea())) {
            extendFields.put("salesArea", importDto.getSalesArea());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getLargeArea())) {
            extendFields.put("largeArea", importDto.getLargeArea());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getAreaType())) {
            extendFields.put("areaType", importDto.getAreaType());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getStandardDiscountRate())) {
            extendFields.put("standardDiscountRate", importDto.getStandardDiscountRate());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getBrandDiscount())) {
            extendFields.put("brandDiscount", importDto.getBrandDiscount());
        }
        if (!extendFields.isEmpty()) {
            String extendFieldsJson = JSON.toJSONString(extendFields);
            updateCustomerDto.setExtension(extendFieldsJson);
        }
        if (Objects.nonNull(importDto.getEffectEndTime())) {
            updateCustomerDto.setEffectiveEndTime(importDto.getEffectEndTime());
            updateCustomerDto.setEndDate(importDto.getEffectEndTime());
        }
        if (Objects.nonNull(importDto.getEffectBeginTime())) {
            updateCustomerDto.setStartDate(importDto.getEffectBeginTime());
        }
        if (StringUtils.isNotEmpty((CharSequence)(regionNames = customerRespDto.getRegionNames()))) {
            String[] regionNameArr = regionNames.split(",");
            List<String> regionNameList = Arrays.asList(regionNameArr);
            updateCustomerDto.setRegionNameList(regionNameList);
        }
        if (StringUtils.isNotEmpty((CharSequence)customerRespDto.getSalesmanIds())) {
            String[] salesmanIdArr = customerRespDto.getSalesmanIds().split(",");
            List<String> salesmanIdList = Arrays.asList(salesmanIdArr);
            List salesmanIds = salesmanIdList.stream().map(x -> Long.valueOf(x)).collect(Collectors.toList());
            updateCustomerDto.setSalesmanIds(salesmanIds);
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getName())) {
            updateCustomerDto.setName(importDto.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getEasCode())) {
            updateCustomerDto.setEasCode(importDto.getEasCode());
        }
        if (CollectionUtils.isNotEmpty(importDto.getRegionCodeList())) {
            updateCustomerDto.setRegionCodeList(importDto.getRegionCodeList());
        }
        if (CollectionUtils.isNotEmpty(importDto.getRegionNameList())) {
            updateCustomerDto.setRegionNameList(importDto.getRegionNameList());
        }
        if (Objects.nonNull(customerTypeRespDto)) {
            updateCustomerDto.setCustomerTypeId(customerTypeRespDto.getId());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getProvince())) {
            updateCustomerDto.setProvince(importDto.getProvince());
            updateCustomerDto.setProvinceCode(addressInfoMap.get(importDto.getProvince()).getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCity())) {
            updateCustomerDto.setCity(importDto.getCity());
            updateCustomerDto.setCityCode(addressInfoMap.get(importDto.getCity()).getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCounty())) {
            updateCustomerDto.setCounty(importDto.getCounty());
            updateCustomerDto.setCountyCode(addressInfoMap.get(importDto.getCounty()).getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getAddress())) {
            updateCustomerDto.setAddress(importDto.getAddress());
        }
        CompanyInfoDto newCompanyInfo = new CompanyInfoDto();
        CompanyInfoDto oldCompanyInfoDto = customerRespDto.getCompanyInfoDto();
        CubeBeanUtils.copyProperties((Object)newCompanyInfo, (Object)oldCompanyInfoDto, (String[])new String[0]);
        if (Objects.nonNull(companyInfoDto)) {
            CubeBeanUtils.copyProperties((Object)newCompanyInfo, (Object)companyInfoDto, (String[])new String[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getOrgName())) {
            newCompanyInfo.setOrgName(importDto.getOrgName());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getSubjectType())) {
            newCompanyInfo.setSubjectType(this.toSubjectType(importDto.getSubjectType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCreditCode())) {
            newCompanyInfo.setCreditCode(importDto.getCreditCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getBusinessLicenseType())) {
            newCompanyInfo.setBusinessLicenseType(this.toBusinessLicenseType(importDto.getBusinessLicenseType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getBusinessTermType())) {
            newCompanyInfo.setBusinessTermType(this.toBusinessTermType(importDto.getBusinessTermType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getTermBeginTime())) {
            Date termBeginTime = DateUtil.parseDate((String)importDto.getTermBeginTime(), (String)"yyyy-MM-dd");
            newCompanyInfo.setTermBeginTime(termBeginTime);
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getTermEndTime())) {
            Date termEndTime = DateUtil.parseDate((String)importDto.getTermEndTime(), (String)"yyyy-MM-dd");
            newCompanyInfo.setTermBeginTime(termEndTime);
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getOrgProvince())) {
            newCompanyInfo.setProvince(importDto.getOrgProvince());
            newCompanyInfo.setProvinceCode(addressInfoMap.get(importDto.getOrgProvince()).getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCity())) {
            newCompanyInfo.setCity(importDto.getCity());
            newCompanyInfo.setCityCode(addressInfoMap.get(importDto.getCity()).getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getOrgDistrict())) {
            newCompanyInfo.setDistrict(importDto.getOrgDistrict());
            newCompanyInfo.setDistrictCode(addressInfoMap.get(importDto.getOrgDistrict()).getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getOrgAddress())) {
            newCompanyInfo.setAddress(importDto.getOrgAddress());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getLegalName())) {
            newCompanyInfo.setLegalName(importDto.getLegalName());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getLegalCardType())) {
            newCompanyInfo.setLegalCardType(this.toLegalCardType(importDto.getLegalCardType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getLegalCardNum())) {
            newCompanyInfo.setLegalCardNum(importDto.getLegalCardNum());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCardEffectType())) {
            newCompanyInfo.setCardEffectType(this.toCardEffectType(importDto.getCardEffectType()));
        }
        if (Objects.nonNull(importDto.getCardEffectBeginTime())) {
            newCompanyInfo.setCardEffectBeginTime(importDto.getCardEffectBeginTime());
        }
        if (Objects.nonNull(importDto.getCardEffectEndTime())) {
            newCompanyInfo.setCardEffectEndTime(importDto.getCardEffectEndTime());
        }
        if (Objects.nonNull(importDto.getCardEffectBeginTime())) {
            newCompanyInfo.setCardEffectBeginTime(importDto.getCardEffectBeginTime());
        }
        updateCustomerDto.setCompanyInfoDto(newCompanyInfo);
        CompanyVerifyRespDto companyVerifyRespDto = this.customerAddImportService.queryStoreVerify(newCompanyInfo.getCreditCode(), newCompanyInfo.getOrgName(), newCompanyInfo.getLegalName());
        if (1 != companyVerifyRespDto.getResult()) {
            throw new BizException(companyVerifyRespDto.getRemark());
        }
        ServiceContext.getContext().setAttachment("yes.req.tenantId", requestTenantId.toString());
        ServiceContext.getContext().setAttachment("yes.req.instanceId", requestInstanceId.toString());
        this.logger.info("\u4fee\u6539\u5ba2\u6237\u8bf7\u6c42\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)updateCustomerDto));
        RestResponseHelper.extractData((RestResponse)this.customerExtApi.update(updateCustomerDto));
        if (StringUtils.isNotEmpty((CharSequence)importDto.getStandardDiscountRate()) || StringUtils.isNotEmpty((CharSequence)importDto.getBrandDiscount())) {
            this.updateCustomerDiscounts(customerRespDto.getId(), importDto, requestTenantId, requestInstanceId);
        }
    }

    private String toSubjectType(String name) {
        if (SubjectTypeEnum.COMPANY.getName().equals(name)) {
            return SubjectTypeEnum.COMPANY.getType();
        }
        if (SubjectTypeEnum.INDIVIDUAL.getName().equals(name)) {
            return SubjectTypeEnum.INDIVIDUAL.getType();
        }
        if (SubjectTypeEnum.ZOOID.getName().equals(name)) {
            return SubjectTypeEnum.ZOOID.getType();
        }
        return "";
    }

    private Integer toBusinessLicenseType(String name) {
        if ("\u591a\u8bc1\u5408\u4e00\u8425\u4e1a\u6267\u7167".equals(name)) {
            return 1;
        }
        if ("\u666e\u901a\u8425\u4e1a\u6267\u7167".equals(name)) {
            return 2;
        }
        return 0;
    }

    private String toBusinessTermType(String name) {
        if ("\u77ed\u671f\u6709\u6548".equals(name)) {
            return "1";
        }
        if ("\u957f\u671f\u6709\u6548".equals(name)) {
            return "2";
        }
        return "0";
    }

    private Integer toLegalCardType(String name) {
        if ("\u5927\u9646\u5c45\u6c11\u8eab\u4efd\u8bc1".equals(name)) {
            return 1;
        }
        if ("\u6e2f\u6fb3\u53f0\uff08\u8eab\u4efd\u8bc1\u3001\u5c45\u6c11\u901a\u884c\u8bc1\uff09".equals(name)) {
            return 2;
        }
        if ("\u62a4\u7167\uff08\u9650\u5883\u5916\u4eba\u58eb\uff09".equals(name)) {
            return 3;
        }
        return 0;
    }

    private Integer toCardEffectType(String name) {
        if ("\u77ed\u671f\u6709\u6548".equals(name)) {
            return 1;
        }
        if ("\u957f\u671f\u6709\u6548".equals(name)) {
            return 2;
        }
        return 0;
    }

    private void updateCustomerDiscounts(Long customerId, CustomerUpdateImportDto importDto, Long requestTenantId, Long requestInstanceId) {
        try {
            List<PrBaseDiscountBrandReqDto> brandDiscounts;
            CustomerSearchExtReqDto customerQuery = new CustomerSearchExtReqDto();
            customerQuery.setIdList((List)Lists.newArrayList((Object[])new Long[]{customerId}));
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryV3Api.queryCustomerByExtDtoList(customerQuery));
            if (CollectionUtils.isEmpty((Collection)customerRespDtos)) {
                this.logger.error("\u5ba2\u6237[{}]\u66f4\u65b0\u6263\u7387\u65f6\u672a\u627e\u5230\u5ba2\u6237\u4fe1\u606f", (Object)customerId);
                return;
            }
            String customerCode = ((CustomerRespDto)customerRespDtos.get(0)).getCode();
            PrBaseDiscountAddEditReqDto discountAddEditReqDto = new PrBaseDiscountAddEditReqDto();
            discountAddEditReqDto.setCustomerId(customerId);
            discountAddEditReqDto.setCustomerName(((CustomerRespDto)customerRespDtos.get(0)).getName());
            discountAddEditReqDto.setCustomerCode(customerCode);
            discountAddEditReqDto.setMerchantId(((CustomerRespDto)customerRespDtos.get(0)).getMerchantId());
            discountAddEditReqDto.setOrgInfoId(((CustomerRespDto)customerRespDtos.get(0)).getOrgInfoId());
            discountAddEditReqDto.setTenantId(requestTenantId);
            discountAddEditReqDto.setInstanceId(requestInstanceId);
            if (StringUtils.isNotEmpty((CharSequence)importDto.getStandardDiscountRate())) {
                try {
                    BigDecimal standardDiscount = this.convertToDiscount(importDto.getStandardDiscountRate());
                    if (standardDiscount == null) {
                        this.logger.error("\u6807\u51c6\u6263\u7387[{}]\u8f6c\u6362\u5931\u8d25", (Object)importDto.getStandardDiscountRate());
                        return;
                    }
                    discountAddEditReqDto.setStandardDiscount(standardDiscount);
                    this.logger.info("\u6807\u51c6\u6263\u7387[{}]\u8f6c\u6362\u4e3a: {}", (Object)importDto.getStandardDiscountRate(), (Object)standardDiscount);
                }
                catch (NumberFormatException e) {
                    this.logger.error("\u6807\u51c6\u6263\u7387[{}]\u683c\u5f0f\u9519\u8bef", (Object)importDto.getStandardDiscountRate());
                    return;
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getBrandDiscount()) && !(brandDiscounts = this.parseBrandDiscounts(importDto.getBrandDiscount())).isEmpty()) {
                discountAddEditReqDto.setBrandDiscountList(brandDiscounts);
            }
            this.logger.info("\u66f4\u65b0\u5ba2\u6237\u6807\u51c6\u6263\u7387\u548c\u591a\u54c1\u724c\u6263\u7387, \u53c2\u6570: {}", (Object)JSON.toJSONString((Object)discountAddEditReqDto));
            RestResponseHelper.extractData((RestResponse)this.prBaseDiscountApi.updateOrInsert((List)Lists.newArrayList((Object[])new PrBaseDiscountAddEditReqDto[]{discountAddEditReqDto})));
            this.logger.info("\u5ba2\u6237[{}]\u6807\u51c6\u6263\u7387\u548c\u591a\u54c1\u724c\u6263\u7387\u66f4\u65b0\u6210\u529f", (Object)((CustomerRespDto)customerRespDtos.get(0)).getName());
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u5ba2\u6237\u6807\u51c6\u6263\u7387\u548c\u591a\u54c1\u724c\u6263\u7387\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private List<PrBaseDiscountBrandReqDto> parseBrandDiscounts(String brandDiscountStr) {
        ArrayList<PrBaseDiscountBrandReqDto> result = new ArrayList<PrBaseDiscountBrandReqDto>();
        if (StringUtils.isEmpty((CharSequence)brandDiscountStr)) {
            return result;
        }
        try {
            String[] brandDiscounts;
            for (String brandDiscount : brandDiscounts = brandDiscountStr.replace("\uff0c", ",").split(",")) {
                String[] parts = brandDiscount.split(":");
                if (parts.length != 2) continue;
                String brandName = parts[0].trim();
                String discountRateStr = parts[1].trim();
                try {
                    BigDecimal discountRate = this.convertToDiscount(discountRateStr);
                    if (discountRate == null) {
                        this.logger.error("\u54c1\u724c[{}]\u6263\u7387[{}]\u8f6c\u6362\u5931\u8d25", (Object)brandName, (Object)discountRateStr);
                        continue;
                    }
                    PrBaseDiscountBrandReqDto brandDiscountDto = new PrBaseDiscountBrandReqDto();
                    brandDiscountDto.setBrandName(brandName);
                    brandDiscountDto.setBrandDiscount(discountRate);
                    try {
                        ArrayList<String> brandNameList = new ArrayList<String>();
                        brandNameList.add(brandName);
                        List nonExistingBrands = (List)RestResponseHelper.extractData((RestResponse)this.itemBrandAuthApi.checkBrandsExist(brandNameList));
                        if (CollectionUtils.isEmpty((Collection)nonExistingBrands)) {
                            Long brandId = this.getBrandIdByName(brandName);
                            if (brandId == null) continue;
                            brandDiscountDto.setBrandId(brandId);
                            result.add(brandDiscountDto);
                            this.logger.info("\u54c1\u724c[{}]\u6263\u7387[{}]\u8f6c\u6362\u4e3a: {}", new Object[]{brandName, discountRateStr, discountRate});
                            continue;
                        }
                        this.logger.warn("\u54c1\u724c[{}]\u4e0d\u5b58\u5728\uff0c\u5ffd\u7565\u8be5\u54c1\u724c\u6263\u7387", (Object)brandName);
                    }
                    catch (Exception e) {
                        this.logger.error("\u83b7\u53d6\u54c1\u724c[{}]ID\u5f02\u5e38: {}", (Object)brandName, (Object)e.getMessage());
                    }
                }
                catch (NumberFormatException e) {
                    this.logger.error("\u54c1\u724c[{}]\u6263\u7387[{}]\u683c\u5f0f\u9519\u8bef: {}", new Object[]{brandName, discountRateStr, e.getMessage()});
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u89e3\u6790\u591a\u54c1\u724c\u6263\u7387\u5f02\u5e38: {}", (Object)e.getMessage());
        }
        return result;
    }

    private Long getBrandIdByName(String brandName) {
        try {
            JSONObject filter = new JSONObject();
            filter.put("name", (Object)brandName);
            List brands = (List)RestResponseHelper.extractData((RestResponse)this.itemBrandAuthApi.queryBrandsByName(brandName));
            if (CollectionUtils.isNotEmpty((Collection)brands)) {
                return ((BrandRespDto)brands.get(0)).getId();
            }
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u540d\u79f0\u67e5\u8be2\u54c1\u724cID\u5f02\u5e38: {}", (Object)e.getMessage());
        }
        return null;
    }

    private String validateCityBelongsToProvince(Map<String, AreaDto> addressInfoMap, String province, String city) {
        AreaDto provinceDto = addressInfoMap.get(province);
        AreaDto cityDto = addressInfoMap.get(city);
        if (!cityDto.getParentCode().equals(provinceDto.getCode())) {
            this.logger.warn("\u57ce\u5e02[{}]\u4e0d\u5c5e\u4e8e\u7701\u4efd[{}]", (Object)city, (Object)province);
            return "\u57ce\u5e02[" + city + "]\u4e0d\u5c5e\u4e8e\u7701\u4efd[" + province + "];";
        }
        return null;
    }

    private String validateDistrictBelongsToCity(Map<String, AreaDto> addressInfoMap, String city, String district) {
        AreaDto cityDto = addressInfoMap.get(city);
        AreaDto districtDto = addressInfoMap.get(district);
        if (!districtDto.getParentCode().equals(cityDto.getCode())) {
            this.logger.warn("\u5730\u533a[{}]\u4e0d\u5c5e\u4e8e\u57ce\u5e02[{}]", (Object)district, (Object)city);
            return "\u5730\u533a[" + district + "]\u4e0d\u5c5e\u4e8e\u57ce\u5e02[" + city + "];";
        }
        return null;
    }

    private void validateCustomerNameMatching(String creditCode, String oldName, String newName) {
        if (StringUtils.isEmpty((CharSequence)creditCode) || StringUtils.isEmpty((CharSequence)oldName) || StringUtils.isEmpty((CharSequence)newName)) {
            this.logger.warn("\u9a8c\u8bc1\u5ba2\u6237\u540d\u79f0\u5339\u914d\u5ea6\u53c2\u6570\u4e0d\u5b8c\u6574: creditCode={}, oldName={}, newName={}", new Object[]{creditCode, oldName, newName});
            return;
        }
        if (oldName.equals(newName)) {
            return;
        }
        try {
            ComputeCustomerNameRateReqDto reqDto = ComputeCustomerNameRateReqDto.builder().orgName(newName).cusName(oldName).creditCode(creditCode).build();
            this.logger.info("\u9a8c\u8bc1\u5ba2\u6237\u540d\u79f0\u5339\u914d\u5ea6: {}", (Object)JSON.toJSONString((Object)reqDto));
            this.logger.info("\u5ba2\u6237\u540d\u79f0\u5339\u914d\u5ea6\u9a8c\u8bc1\u901a\u8fc7");
        }
        catch (Exception e) {
            this.logger.error("\u5ba2\u6237\u540d\u79f0\u5339\u914d\u5ea6\u9a8c\u8bc1\u5931\u8d25: {}", (Object)e.getMessage());
            throw new BizException("\u5ba2\u6237\u540d\u79f0\u5339\u914d\u5ea6\u4f4e\u4e8e50%\uff0c\u8bf7\u68c0\u67e5\u540d\u79f0\u662f\u5426\u6b63\u786e: " + e.getMessage());
        }
    }

    private BigDecimal convertToDiscount(String discountStr) {
        if (StringUtils.isEmpty((CharSequence)discountStr)) {
            return null;
        }
        String standardDiscountStr = discountStr.trim();
        try {
            if (standardDiscountStr.endsWith("%")) {
                standardDiscountStr = standardDiscountStr.substring(0, standardDiscountStr.length() - 1);
                BigDecimal percentage = new BigDecimal(standardDiscountStr);
                return percentage.divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP);
            }
            BigDecimal standardDiscount = new BigDecimal(standardDiscountStr);
            if (standardDiscount.compareTo(BigDecimal.ONE) > 0) {
                standardDiscount = standardDiscount.divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP);
            }
            return standardDiscount;
        }
        catch (NumberFormatException e) {
            this.logger.error("\u6263\u7387\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38: {}", (Object)e.getMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void preProcessImportData(CustomerUpdateImportDto importDto) {
        String[] areaNameArr;
        List uniqueAreaNames;
        if (StringUtils.isNotEmpty((CharSequence)importDto.getStandardDiscountRate())) {
            try {
                BigDecimal standardDiscount = this.convertToDiscount(importDto.getStandardDiscountRate());
                if (standardDiscount == null) {
                    // empty if block
                }
            }
            catch (Exception e) {
                this.logger.warn("\u6807\u51c6\u6263\u7387[{}]\u683c\u5f0f\u9519\u8bef", (Object)importDto.getStandardDiscountRate());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getBrandDiscount())) {
            importDto.setBrandDiscount(importDto.getBrandDiscount().replace("\uff0c", ","));
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getRegionName()) && (uniqueAreaNames = Arrays.stream(areaNameArr = importDto.getRegionName().split(";")).distinct().collect(Collectors.toList())).size() < areaNameArr.length) {
            this.logger.warn("\u5ba2\u6237\u533a\u57df\u5b58\u5728\u91cd\u590d\u8bb0\u5f55: {}", (Object)importDto.getRegionName());
            importDto.setRegionName(String.join((CharSequence)";", uniqueAreaNames));
        }
    }
}

