/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.StoreSearchReqDto;
import com.dtyunxi.tcbj.api.dto.response.StoreSearchRespDto;
import com.dtyunxi.tcbj.api.query.IStoreSearchQueryApi;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.dto.request.SllerExportReqDto;
import com.dtyunxi.tcbj.module.export.biz.impl.BaseExportService;
import com.dtyunxi.tcbj.module.export.biz.impl.ExportService;
import com.dtyunxi.tcbj.module.export.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.tcbj.module.export.biz.utils.MyEasyPoiExportUtil;
import com.dtyunxi.tcbj.module.export.biz.utils.ThreadPoolUtil;
import com.dtyunxi.tcbj.module.export.biz.vo.customer.AddressExportVo;
import com.dtyunxi.tcbj.module.export.biz.vo.customer.CustomerInfoExportVo;
import com.dtyunxi.tcbj.module.export.biz.vo.customer.SellerCustomerExportVo;
import com.dtyunxi.tcbj.module.export.biz.vo.customer.StoreExportVo;
import com.dtyunxi.tcbj.module.export.biz.vo.customer.StoreSellerGovernExportExtVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.AuditStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CompanyInfoDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.AddressQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.AddressRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.IAddressQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.GovernTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerSearchExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreSellerGovernQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerQueryV3Api;
import com.dtyunxi.yundt.cube.center.customer.api.query.IStoreSellerGovernContentQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.query.IStoreSellerGovernQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.enums.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.request.CustomerExtReqDto;
import com.yx.tcbj.center.customer.api.dto.request.CustomerSearchExtThreeReqDto;
import com.yx.tcbj.center.customer.api.dto.response.CustomerExtRespDto;
import com.yx.tcbj.center.customer.api.query.ICustomerExtThreeQueryApi;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="customerExportService")
public class CustomerExportService {
    @Resource
    private IContext context;
    @Resource
    private ExportService exportService;
    @Resource
    private IStoreSearchQueryApi storeSearchQueryApi;
    @Resource
    private IStoreSellerGovernQueryApi storeSellerGovernQueryApi;
    @Resource
    private IStoreSellerGovernContentQueryApi storeSellerGovernContentQueryApi;
    private static final Logger logger = LoggerFactory.getLogger(CustomerExportService.class);
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerQueryV3Api customerQueryV3Api;
    @Resource
    private IAddressQueryApi addressQueryApi;
    @Resource
    private HttpServletRequest request;
    @Resource
    private ICustomerExtThreeQueryApi customerExtThreeQueryApi;

    public RestResponse<Object> exportSellerGovern(StoreSellerGovernQueryReqDto reqDto) {
        String name = "\u7ba1\u8f96\u836f\u5e97\u5206\u914d";
        BaseExportService baseExportService = new BaseExportService(name, ExportTypeEnum.SELLER_GOVERN);
        baseExportService.executor(req -> {
            List list = (List)RestResponseHelper.extractData((RestResponse)this.storeSellerGovernQueryApi.queryExcel(req));
            logger.info(name + "\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{}", (Object)com.dtyunxi.huieryun.core.util.JSON.toJsonString((Object)list));
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                ArrayList rList = Lists.newArrayList();
                for (StoreSellerGovernRespDto govern : list) {
                    if (StringUtils.isNotBlank((CharSequence)govern.getAreaCode())) {
                        List<String> areaCodes = Arrays.asList(govern.getAreaCode().split(";"));
                        List<String> areaNames = Arrays.asList(govern.getAreaName().split(";"));
                        areaCodes.forEach(c -> {
                            StoreSellerGovernExportExtVo vo = new StoreSellerGovernExportExtVo();
                            CubeBeanUtils.copyProperties((Object)vo, (Object)govern, (String[])new String[0]);
                            vo.setType(GovernTypeEnum.AREA.getCode());
                            vo.setCode((String)c);
                            vo.setName((String)areaNames.get(areaCodes.indexOf(c)));
                            rList.add(vo);
                        });
                    }
                    if (StringUtils.isNotBlank((CharSequence)govern.getStoreName())) {
                        List<String> storeNames = Arrays.asList(govern.getStoreName().split(";"));
                        List<String> storeSocialCredits = Arrays.asList(govern.getStoreSocialCredit().split(";"));
                        storeNames.forEach(c -> {
                            StoreSellerGovernExportExtVo vo = new StoreSellerGovernExportExtVo();
                            CubeBeanUtils.copyProperties((Object)vo, (Object)govern, (String[])new String[0]);
                            vo.setType(GovernTypeEnum.STORE.getCode());
                            vo.setName((String)c);
                            vo.setCode((String)storeSocialCredits.get(storeNames.indexOf(c)));
                            rList.add(vo);
                        });
                    }
                    if (StringUtils.isNotBlank((CharSequence)govern.getBlackList())) {
                        List<String> blackList = Arrays.asList(govern.getBlackList().split(";"));
                        List<String> blackListSocialCredit = Arrays.asList(govern.getBlackListSocialCredit().split(";"));
                        blackList.forEach(c -> {
                            StoreSellerGovernExportExtVo vo = new StoreSellerGovernExportExtVo();
                            CubeBeanUtils.copyProperties((Object)vo, (Object)govern, (String[])new String[0]);
                            vo.setType(GovernTypeEnum.BLACKLIST.getCode());
                            vo.setName((String)c);
                            vo.setCode((String)blackListSocialCredit.get(blackList.indexOf(c)));
                            rList.add(vo);
                        });
                    }
                    if (!StringUtils.isNotBlank((CharSequence)govern.getStoreParentList())) continue;
                    List<String> storeParentList = Arrays.asList(govern.getStoreParentList().split(";"));
                    List<String> storeParentListSocialCredit = Arrays.asList(govern.getStoreParentListSocialCredit().split(";"));
                    storeParentList.forEach(c -> {
                        StoreSellerGovernExportExtVo vo = new StoreSellerGovernExportExtVo();
                        CubeBeanUtils.copyProperties((Object)vo, (Object)govern, (String[])new String[0]);
                        vo.setType(GovernTypeEnum.STOREPARENT.getCode());
                        vo.setName((String)c);
                        vo.setCode((String)storeParentListSocialCredit.get(storeParentList.indexOf(c)));
                        rList.add(vo);
                    });
                }
                baseExportService.exportUrl(rList, StoreSellerGovernExportExtVo.class);
            } else {
                this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + name + "\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
            }
            return null;
        }, reqDto);
        return new RestResponse("0", "\u5bfc\u51fa" + name + "\u6210\u529f");
    }

    public RestResponse<Object> exportStoreListSearch(StoreSearchReqDto storeSearchReqDto) {
        String fileName = "\u836f\u5e97\u5217\u8868_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        Long id = this.exportService.init(fileName, ExportTypeEnum.STORE);
        Long uesrId = this.context.userId();
        String organization = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationId");
        ThreadPoolUtil.executorService.submit(() -> {
            String uuid = UUID.randomUUID().toString().replace("-", "");
            ServiceContext.getContext().set("yes.req.requestId", (Object)uuid);
            this.context.userId(uesrId);
            logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\uff1a{},UUID:{}", (Object)fileName, (Object)uuid);
            try {
                if (Objects.nonNull(organization)) {
                    storeSearchReqDto.setOrgId(Long.valueOf(organization.toString()));
                }
                Long total = null;
                double num = 0.0;
                Integer pageNum = 1;
                Integer pageSize = 5000;
                ArrayList rList = Lists.newArrayList();
                while (total == null || (double)pageNum.intValue() <= num) {
                    storeSearchReqDto.setPageNum(pageNum.intValue());
                    storeSearchReqDto.setPageSize(pageSize.intValue());
                    logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2\u836f\u5e97\u53c2\u6570:{},UUID:{}", (Object)JSONObject.toJSONString((Object)storeSearchReqDto), (Object)uuid);
                    PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.storeSearchQueryApi.queryStoreListSearch(storeSearchReqDto));
                    if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                        logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2\u836f\u5e97\u7ed3\u679c:{},UUID:{}", (Object)pageInfo.getList().size(), (Object)uuid);
                    }
                    if (total == null) {
                        total = pageInfo.getTotal();
                        num = Math.ceil(Double.valueOf(total.longValue()) / (double)pageSize.intValue());
                        logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u521d\u59cb\u5316UUID:{},\u67e5\u8be2\u836f\u5e97\u603b\u6570:{},\u4e00\u5171\u9700\u8981\u5206\u6279:{}\u6b21", new Object[]{uuid, total, num});
                    }
                    pageNum = pageNum + 1;
                    if (!CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) continue;
                    logger.info("\u836f\u5e97\u5217\u8868\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{},UUID:{}", (Object)pageInfo.getList().size(), (Object)uuid);
                    for (int i = 0; i < pageInfo.getList().size(); ++i) {
                        StoreSearchRespDto store = (StoreSearchRespDto)pageInfo.getList().get(i);
                        StoreExportVo storeExportVo = new StoreExportVo();
                        CubeBeanUtils.copyProperties((Object)storeExportVo, (Object)store, (String[])new String[]{"ifSupply", "ifCustomer", "ifParentCustomer"});
                        storeExportVo.setIfSupply(store.getIfSupply() == 1 ? "\u662f" : "\u5426");
                        storeExportVo.setIfCustomer(store.getIfCustomer() == 1 ? "\u662f" : "\u5426");
                        storeExportVo.setIfParentCustomer(store.getIfParentCustomer() == 1 ? "\u662f" : "\u5426");
                        rList.add(storeExportVo);
                    }
                    pageInfo.getList().clear();
                    System.gc();
                }
                logger.info("\u836f\u5e97\u5217\u8868\u67e5\u8be2\u6570\u636e\u8f6c\u6362\u7ed3\u679c\u5927\u5c0f:{},UUID:{}", (Object)rList.size(), (Object)uuid);
                if (CollectionUtils.isNotEmpty((Collection)rList)) {
                    String excelName = "cube/" + fileName;
                    try {
                        logger.info("\u6267\u884c\u836f\u5e97\u67e5\u8be2\u7ed3\u679c\u5bfc\u51fa\u5927\u5c0f\u4e3a:{},UUID:{}", (Object)rList.size(), (Object)uuid);
                        String exportUrl = MyEasyPoiExportUtil.getExportUrl(rList, StoreExportVo.class, null, excelName, "xlsx");
                        this.exportService.success(id, exportUrl);
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("\u5bfc\u51fa\u836f\u5e97\u5217\u8868-\u9519\u8bef:{}", (Object)e.toString());
                        this.exportService.fail(id, "\u5bfc\u51fa\u836f\u5e97\u5217\u8868-\u9519\u8bef1:" + e);
                        return;
                    }
                }
                this.exportService.fail(id, "\u5bfc\u51fa\u989d\u5ea6\u8d26\u6237,\u6570\u636e\u4e3a\u7a7a");
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u5bfc\u51fa\u836f\u5e97\u5217\u8868-\u9519\u8bef2:{}", (Object)e.toString());
                this.exportService.fail(id, "\u5bfc\u51fa\u836f\u5e97\u5217\u8868-\u9519\u8bef2:" + e);
                return;
            }
        });
        return new RestResponse("0", "\u5bfc\u51fa\u836f\u5e97\u5217\u8868\u6210\u529f");
    }

    public RestResponse<Object> exportSellerCustomer(SllerExportReqDto sllerExportReqDto) {
        AssertUtil.assertNotEmpty(sllerExportReqDto.getOrgIdList(), (String)"\u6240\u9009\u5546\u5bb6id\u4e3a\u7a7a");
        String fileName = "\u5546\u5bb6\u5ba2\u6237_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        Long id = this.exportService.init(fileName, ExportTypeEnum.SELLER_CUSTOMER);
        Long uesrId = this.context.userId();
        String organization = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationId");
        ThreadPoolUtil.executorService.submit(() -> {
            String uuid = UUID.randomUUID().toString().replace("-", "");
            ServiceContext.getContext().set("yes.req.requestId", (Object)uuid);
            this.context.userId(uesrId);
            logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\uff1a{},UUID:{}", (Object)fileName, (Object)uuid);
            try {
                CustomerExtReqDto customerExtReqDto = new CustomerExtReqDto();
                customerExtReqDto.setMerchantIdList(sllerExportReqDto.getOrgIdList());
                customerExtReqDto.setExportStatus(YesOrNoEnum.NO.getStatus().intValue());
                customerExtReqDto.setType(CustomerTypeEnum.RETAILER.getCode());
                customerExtReqDto.setAuditStatus(AuditStatusEnum.AUDIT_PASS.getCode());
                logger.info("\u5546\u5bb6\u5e97\u94fa\u67e5\u8be2\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)customerExtReqDto));
                List list = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerInfoByOrg(customerExtReqDto));
                logger.info("\u5546\u5bb6\u5e97\u94fa\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{},UUID:{}", (Object)list.size(), (Object)uuid);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    ArrayList rList = Lists.newArrayList();
                    for (CustomerRespDto customerRespDto : list) {
                        SellerCustomerExportVo vo = new SellerCustomerExportVo();
                        CubeBeanUtils.copyProperties((Object)vo, (Object)customerRespDto, (String[])new String[]{"companyInfoDto"});
                        CompanyInfoDto companyInfoDto = customerRespDto.getCompanyInfoDto();
                        if (Objects.nonNull(companyInfoDto)) {
                            vo.setSubjectType(companyInfoDto.getSubjectType() == null ? "" : companyInfoDto.getSubjectType());
                            vo.setOrgName(companyInfoDto.getOrgName() == null ? "" : companyInfoDto.getOrgName());
                            vo.setCreditCode(companyInfoDto.getCreditCode() == null ? "" : companyInfoDto.getCreditCode());
                            vo.setBusinessTermType(companyInfoDto.getBusinessTermType());
                            vo.setBusinessLicenseType(companyInfoDto.getBusinessLicenseType());
                            vo.setTermBeginTime(companyInfoDto.getTermBeginTime());
                            vo.setTermEndTime(companyInfoDto.getTermEndTime());
                            vo.setOrgAddress(companyInfoDto.getAddress() == null ? "\u65e0" : companyInfoDto.getAddress());
                            vo.setOrgProvince(companyInfoDto.getProvince());
                            vo.setOrgCity(companyInfoDto.getCity());
                            vo.setOrgAddress(companyInfoDto.getAddress());
                            vo.setLegalName(companyInfoDto.getLegalName());
                            vo.setLegalCardNum(companyInfoDto.getLegalCardNum() == null ? "" : companyInfoDto.getLegalCardNum());
                            vo.setLegalCardType(companyInfoDto.getLegalCardType());
                            vo.setCardEffectType(companyInfoDto.getCardEffectType());
                            vo.setCardEffectBeginTime(companyInfoDto.getCardEffectBeginTime());
                            vo.setCardEffectEndTime(companyInfoDto.getCardEffectEndTime());
                        } else {
                            vo.setSubjectType("");
                            vo.setBusinessTermType("");
                            vo.setBusinessLicenseType(0);
                            vo.setLegalCardType(0);
                            vo.setCardEffectType(0);
                        }
                        rList.add(vo);
                    }
                    String excelName = fileName;
                    try {
                        String exportUrl = EasyPoiExportUtil.getExportUrl(rList, SellerCustomerExportVo.class, null, excelName, "xls");
                        this.exportService.success(id, exportUrl);
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("\u5bfc\u51fa\u5546\u5bb6\u5ba2\u6237-\u9519\u8bef1:{}", (Object)e.toString());
                        this.exportService.fail(id, "\u5bfc\u51fa\u5546\u5bb6\u5ba2\u6237-\u9519\u8bef1:" + e);
                        return;
                    }
                }
                this.exportService.fail(id, "\u5bfc\u51fa\u5546\u5bb6\u5ba2\u6237,\u6570\u636e\u4e3a\u7a7a");
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u5bfc\u51fa\u5546\u5bb6\u5ba2\u6237-\u9519\u8bef2:{}", (Object)e.toString());
                this.exportService.fail(id, "\u5bfc\u51fa\u5546\u5bb6\u5ba2\u6237-\u9519\u8bef2:" + e);
                return;
            }
        });
        return new RestResponse("0", "\u5bfc\u51fa\u5546\u5bb6\u5ba2\u6237\u64cd\u4f5c\u6210\u529f");
    }

    public RestResponse<Object> exportCustomerInfo(CustomerSearchExtReqDto searchReqDto) {
        String fileName = "\u5ba2\u6237\u5217\u8868_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        Long id = this.exportService.init(fileName, ExportTypeEnum.CUSTOMER);
        Long uesrId = this.context.userId();
        String organization = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationId");
        ThreadPoolUtil.executorService.submit(() -> {
            String uuid = UUID.randomUUID().toString().replace("-", "");
            ServiceContext.getContext().set("yes.req.requestId", (Object)uuid);
            this.context.userId(uesrId);
            logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\uff1a{},UUID:{}", (Object)fileName, (Object)uuid);
            try {
                Long total = null;
                double num = 0.0;
                Integer pageNum = 1;
                Integer pageSize = 5000;
                if (Objects.nonNull(organization)) {
                    searchReqDto.setUserOrgId(Long.valueOf(organization.toString()));
                }
                ArrayList list = Lists.newArrayList();
                while (total == null || (double)pageNum.intValue() <= num) {
                    searchReqDto.setPageNum(pageNum);
                    searchReqDto.setPageSize(pageSize);
                    logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2\u5ba2\u6237\u53c2\u6570:{},UUID:{}", (Object)JSONObject.toJSONString((Object)searchReqDto), (Object)uuid);
                    PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.customerQueryV3Api.queryByPageExport(searchReqDto));
                    if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                        logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2\u836f\u5e97\u7ed3\u679c:{},UUID:{}", (Object)pageInfo.getList().size(), (Object)uuid);
                        list.addAll(pageInfo.getList());
                    }
                    if (total == null) {
                        total = pageInfo.getTotal();
                        num = Math.ceil(Double.valueOf(total.longValue()) / (double)pageSize.intValue());
                        logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u521d\u59cb\u5316UUID:{},\u67e5\u8be2\u5ba2\u6237\u603b\u6570:{},\u4e00\u5171\u9700\u8981\u5206\u6279:{}\u6b21", new Object[]{uuid, total, num});
                    }
                    pageNum = pageNum + 1;
                }
                logger.info("\u5ba2\u5546\u7ba1\u7406\u5ba2\u6237\u5217\u8868\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{},UUID:{}", (Object)list.size(), (Object)uuid);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    ArrayList rList = Lists.newArrayList();
                    for (com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerExtRespDto dto : list) {
                        CustomerInfoExportVo vo = new CustomerInfoExportVo();
                        CubeBeanUtils.copyProperties((Object)vo, (Object)dto, (String[])new String[]{"companyInfoDto"});
                        CompanyInfoDto companyInfoDto = dto.getCompanyInfoDto();
                        if (Objects.nonNull(companyInfoDto)) {
                            vo.setSubjectType(companyInfoDto.getSubjectType() == null ? "" : companyInfoDto.getSubjectType());
                            vo.setOrgName(companyInfoDto.getOrgName() == null ? "" : companyInfoDto.getOrgName());
                            vo.setCreditCode(companyInfoDto.getCreditCode() == null ? "" : companyInfoDto.getCreditCode());
                            vo.setBusinessTermType(companyInfoDto.getBusinessTermType());
                            vo.setBusinessLicenseType(companyInfoDto.getBusinessLicenseType());
                            vo.setTermBeginTime(companyInfoDto.getTermBeginTime());
                            vo.setTermEndTime(companyInfoDto.getTermEndTime());
                            vo.setOrgAddress(companyInfoDto.getAddress());
                            vo.setOrgProvince(companyInfoDto.getProvince());
                            vo.setOrgCity(companyInfoDto.getCity());
                            vo.setOrgAddress(companyInfoDto.getAddress());
                            vo.setLegalName(companyInfoDto.getLegalName());
                        } else {
                            vo.setSubjectType("");
                            vo.setBusinessTermType("");
                            vo.setBusinessLicenseType(0);
                        }
                        rList.add(vo);
                    }
                    String excelName = fileName;
                    try {
                        String exportUrl = EasyPoiExportUtil.getExportUrl(rList, CustomerInfoExportVo.class, null, excelName, "xls");
                        this.exportService.success(id, exportUrl);
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("\u5bfc\u51fa\u5ba2\u5546\u7ba1\u7406\u5ba2\u6237-\u9519\u8bef1:{}", (Object)e.toString());
                        this.exportService.fail(id, "\u5bfc\u51fa\u5ba2\u5546\u7ba1\u7406\u5ba2\u6237-\u9519\u8bef1:" + e);
                        return;
                    }
                }
                this.exportService.fail(id, "\u5bfc\u51fa\u5ba2\u5546\u7ba1\u7406\u5ba2\u6237,\u6570\u636e\u4e3a\u7a7a");
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u5bfc\u51fa\u5ba2\u5546\u7ba1\u7406\u5ba2\u6237-\u9519\u8bef2:{}", (Object)e.toString());
                this.exportService.fail(id, "\u5bfc\u51fa\u5ba2\u5546\u7ba1\u7406\u5ba2\u6237-\u9519\u8bef2:" + e);
                return;
            }
        });
        return new RestResponse("0", "\u5bfc\u51fa\u5ba2\u5546\u7ba1\u7406\u5ba2\u6237\u64cd\u4f5c\u6210\u529f");
    }

    public RestResponse<Object> exportCustomerAddress(CustomerSearchExtThreeReqDto reqDto) {
        String fileName = "\u5ba2\u6237\u5730\u5740\u5217\u8868_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        Long id = this.exportService.init(fileName, ExportTypeEnum.CUSTOMER_ADDRESS);
        Long userId = this.context.userId();
        String organization = this.getHeaderOrgId();
        AssertUtil.isTrue((boolean)Objects.nonNull(organization), (String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3anull");
        reqDto.setMerchantId(Long.valueOf(organization.toString()));
        ArrayList orgInfoIdList = new ArrayList();
        HashMap<Long, CustomerExtRespDto> customerInfoMap = new HashMap<Long, CustomerExtRespDto>();
        String filter = JSON.toJSONString((Object)reqDto);
        int pageNums = 1;
        int pageSizes = 5000;
        Long totalCustomers = null;
        double totalPages = 0.0;
        while (totalCustomers == null || (double)pageNums <= totalPages) {
            PageInfo cusPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.customerExtThreeQueryApi.queryByPage(filter, Integer.valueOf(pageNums), Integer.valueOf(pageSizes)));
            if (totalCustomers == null && ObjectUtils.isNotEmpty((Object)cusPageInfo)) {
                totalCustomers = cusPageInfo.getTotal();
                totalPages = Math.ceil(Double.valueOf(totalCustomers.longValue()) / (double)pageSizes);
                logger.info("\u5ba2\u6237\u67e5\u8be2\u603b\u6570:{}, \u9700\u8981\u5206\u9875\u67e5\u8be2:{}\u6b21", (Object)totalCustomers, (Object)totalPages);
            }
            if (!ObjectUtils.isNotEmpty((Object)cusPageInfo) || !CollectionUtils.isNotEmpty((Collection)cusPageInfo.getList())) break;
            List customerList = cusPageInfo.getList();
            for (CustomerExtRespDto customer : customerList) {
                if (!ObjectUtils.isNotEmpty((Object)customer.getOrgInfoId())) continue;
                customerInfoMap.put(customer.getOrgInfoId(), customer);
            }
            List orgInfoIds = customerList.stream().map(CustomerRespDto::getOrgInfoId).filter(ObjectUtils::isNotEmpty).distinct().collect(Collectors.toList());
            orgInfoIdList.addAll(orgInfoIds);
            logger.info("\u7b2c{}\u9875\u67e5\u8be2\u5230{}\u4e2a\u5ba2\u6237ID", (Object)pageNums, (Object)orgInfoIds.size());
            ++pageNums;
        }
        logger.info("\u603b\u5171\u6536\u96c6\u5230{}\u4e2a\u5ba2\u6237ID\u7528\u4e8e\u5730\u5740\u67e5\u8be2", (Object)orgInfoIdList.size());
        if (CollectionUtils.isEmpty(orgInfoIdList)) {
            this.exportService.fail(id, "\u5bfc\u51fa\u5ba2\u6237\u5730\u5740\u5217\u8868,\u6ca1\u6709\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u5ba2\u6237");
            return new RestResponse("0", "\u5bfc\u51fa\u5ba2\u6237\u5730\u5740\u5217\u8868\u64cd\u4f5c\u6210\u529f");
        }
        ThreadPoolUtil.executorService.submit(() -> {
            String uuid = UUID.randomUUID().toString().replace("-", "");
            ServiceContext.getContext().set("yes.req.requestId", (Object)uuid);
            this.context.userId(userId);
            logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\uff1a{}, UUID:{}", (Object)fileName, (Object)uuid);
            try {
                AddressQueryReqDto queryReqDto = new AddressQueryReqDto();
                queryReqDto.setOrgInfoIds(orgInfoIdList);
                Long total = null;
                double num = 0.0;
                Integer pageNum = 1;
                Integer pageSize = 5000;
                ArrayList rList = Lists.newArrayList();
                while (total == null || (double)pageNum.intValue() <= num) {
                    logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2\u5ba2\u6237\u5730\u5740\u53c2\u6570:{}, UUID:{}", (Object)JSONObject.toJSONString((Object)queryReqDto), (Object)uuid);
                    PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.addressQueryApi.queryAddressByPagePost(queryReqDto, pageNum, pageSize));
                    if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                        logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2\u5ba2\u6237\u5730\u5740\u7ed3\u679c:{}, UUID:{}", (Object)pageInfo.getList().size(), (Object)uuid);
                    }
                    if (total == null) {
                        total = pageInfo.getTotal();
                        num = Math.ceil(Double.valueOf(total.longValue()) / (double)pageSize.intValue());
                        logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u521d\u59cb\u5316UUID:{}, \u67e5\u8be2\u5ba2\u6237\u5730\u5740\u603b\u6570:{}, \u4e00\u5171\u9700\u8981\u5206\u6279:{}\u6b21", new Object[]{uuid, total, num});
                    }
                    pageNum = pageNum + 1;
                    if (!CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) continue;
                    logger.info("\u5ba2\u6237\u5730\u5740\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{}, UUID:{}", (Object)pageInfo.getList().size(), (Object)uuid);
                    for (AddressRespDto address : pageInfo.getList()) {
                        AddressExportVo vo = new AddressExportVo();
                        CubeBeanUtils.copyProperties((Object)vo, (Object)address, (String[])new String[0]);
                        if (address.getOrgInfoId() != null && customerInfoMap.containsKey(address.getOrgInfoId())) {
                            CustomerExtRespDto customer = (CustomerExtRespDto)customerInfoMap.get(address.getOrgInfoId());
                            vo.setCustomerName(customer.getOrgName());
                            vo.setExternalCode(StringUtils.isBlank((CharSequence)customer.getExternalCode()) ? customer.getEasCode() : customer.getExternalCode());
                            vo.setCustomerCode(customer.getCode());
                            vo.setCustomerArea(customer.getRegionNames());
                            vo.setCustomerType(customer.getCustomerTypeName());
                            vo.setStatus(customer.getStatusName());
                            if (customer.getEffectiveStartTime() != null) {
                                vo.setStartTime(customer.getEffectiveStartTime());
                            }
                            if (customer.getEffectiveEndTime() != null) {
                                vo.setEndTime(customer.getEffectiveEndTime());
                            }
                            if (customer.getDeliverMethod() != null) {
                                vo.setDeliverMethod(this.getDeliverMethodName(customer.getDeliverMethod()));
                            }
                        }
                        if (address.getProvinceCode() != null) {
                            vo.setProvinceCode(address.getProvinceCode());
                        }
                        if (address.getCityCode() != null) {
                            vo.setCityCode(address.getCityCode());
                        }
                        if (address.getDistrictCode() != null) {
                            vo.setDistrictCode(address.getDistrictCode());
                        }
                        if (address.getAddressType() != null) {
                            vo.setAddressTypeCode(address.getAddressType());
                        }
                        vo.setIsDefault(address.getStatus() != null ? address.getStatus() : 0);
                        if (address.getStartTime() != null) {
                            vo.setAddressStartTime(address.getStartTime());
                        }
                        if (address.getEndTime() != null) {
                            vo.setAddressEndTime(address.getEndTime());
                        }
                        rList.add(vo);
                    }
                    pageInfo.getList().clear();
                    System.gc();
                }
                logger.info("\u5ba2\u6237\u5730\u5740\u67e5\u8be2\u6570\u636e\u8f6c\u6362\u7ed3\u679c\u5927\u5c0f:{}, UUID:{}", (Object)rList.size(), (Object)uuid);
                if (CollectionUtils.isNotEmpty((Collection)rList)) {
                    String excelName = "cube/" + fileName;
                    try {
                        logger.info("\u6267\u884c\u5ba2\u6237\u5730\u5740\u67e5\u8be2\u7ed3\u679c\u5bfc\u51fa\u5927\u5c0f\u4e3a:{}, UUID:{}", (Object)rList.size(), (Object)uuid);
                        String exportUrl = MyEasyPoiExportUtil.getExportUrl(rList, AddressExportVo.class, null, excelName, "xlsx");
                        this.exportService.success(id, exportUrl);
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("\u5bfc\u51fa\u5ba2\u6237\u5730\u5740\u5217\u8868-\u9519\u8bef:{}", (Object)e.toString());
                        this.exportService.fail(id, "\u5bfc\u51fa\u5ba2\u6237\u5730\u5740\u5217\u8868-\u9519\u8bef1:" + e);
                        return;
                    }
                }
                this.exportService.fail(id, "\u5bfc\u51fa\u5ba2\u6237\u5730\u5740\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u5bfc\u51fa\u5ba2\u6237\u5730\u5740\u5217\u8868-\u9519\u8bef2:{}", (Object)e.toString());
                this.exportService.fail(id, "\u5bfc\u51fa\u5ba2\u6237\u5730\u5740\u5217\u8868-\u9519\u8bef2:" + e);
                return;
            }
        });
        return new RestResponse("0", "\u5bfc\u51fa\u5ba2\u6237\u5730\u5740\u5217\u8868\u64cd\u4f5c\u6210\u529f");
    }

    public String getHeaderOrgId() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        return organizationId;
    }

    private String getDeliverMethodName(Integer deliverMethod) {
        if (deliverMethod == null) {
            return "";
        }
        switch (deliverMethod) {
            case 1: {
                return "\u5546\u5bb6\u53d1\u8d27";
            }
            case 2: {
                return "\u5382\u5bb6\u53d1\u8d27";
            }
            case 3: {
                return "\u9001\u8d27\u4e0a\u95e8";
            }
        }
        return "";
    }
}

