/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl.operation;

import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.abs.ReportExportAbstract;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.dto.request.ExchangeBalanceAccountExportReqDto;
import com.dtyunxi.tcbj.module.export.biz.vo.operation.ExchangeAccountVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeBalanceAccountReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.response.ExchangeBalanceAccountRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.query.IExchangeBalanceAccountQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExchangeAccountService
extends ReportExportAbstract<ExchangeBalanceAccountRespDto, ExchangeBalanceAccountExportReqDto, ExchangeAccountVo> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IExchangeBalanceAccountQueryApi exchangeBalanceAccountQueryApi;
    private static final String FILE_NAME_FORMAT = "[%s]-[%s]-\u6362\u8d2d\u989d\u5ea6-";

    @Override
    public ExportTypeEnum getExportType() {
        return ExportTypeEnum.PROMOTION_EXCHANGE_ACCOUNT;
    }

    @Override
    public PageInfo<ExchangeBalanceAccountRespDto> queryData(ExchangeBalanceAccountExportReqDto exchangeBalanceAccountExportReqDto) {
        ExchangeBalanceAccountReqDto exchangeBalanceAccountReqDto = new ExchangeBalanceAccountReqDto();
        BeanUtils.copyProperties((Object)((Object)exchangeBalanceAccountExportReqDto), (Object)exchangeBalanceAccountReqDto);
        return (PageInfo)RestResponseHelper.extractData((RestResponse)this.exchangeBalanceAccountQueryApi.queryByPage(exchangeBalanceAccountReqDto));
    }

    @Override
    public ExchangeBalanceAccountExportReqDto definePrams(ExchangeBalanceAccountExportReqDto exchangeBalanceAccountExportReqDto) {
        return exchangeBalanceAccountExportReqDto;
    }

    @Override
    public Gson buildGson() {
        return new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").create();
    }

    @Override
    public List<ExchangeAccountVo> getExportDtoList(List<ExchangeBalanceAccountRespDto> exportDtoList, Class<ExchangeAccountVo> vo) {
        ArrayList exchangeAccountVos = Lists.newArrayList();
        for (ExchangeBalanceAccountRespDto exchangeBalanceAccountRespDto : exportDtoList) {
            ExchangeAccountVo exchangeAccountVo = new ExchangeAccountVo();
            CubeBeanUtils.copyProperties((Object)exchangeAccountVo, (Object)exchangeBalanceAccountRespDto, (String[])new String[0]);
            exchangeAccountVo.setUpdateTime(DateUtil.getDateFormat((Date)exchangeBalanceAccountRespDto.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            exchangeAccountVos.add(exchangeAccountVo);
        }
        return exchangeAccountVos;
    }
}

