/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.utils;

import com.dtyunxi.app.ServiceContext;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AsyncExportRequestInterceptor
implements RequestInterceptor {
    private static String ORD_ID_ATTACHMENT = "yes.req.cus.b2b.organizationid";
    private static String CUS_ID_ATTACHMENT = "yes.req.cus.b2b.customerid";
    private static String ORD_ID_HEADER = "yes-req-cus-b2b-organizationid";
    private static String CUS_ID_HEADER = "yes-req-cus-b2b-customerid";
    private static String ASYNC = "yes.req.async.export";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void apply(RequestTemplate template) {
        String isAsyncExport = (String)ServiceContext.getContext().get(ASYNC);
        if ("1".equals(isAsyncExport)) {
            String token;
            String key;
            if (ObjectUtils.isNotEmpty((Object)ServiceContext.getContext().getAttachment(ORD_ID_ATTACHMENT))) {
                template.header(ORD_ID_ATTACHMENT, new String[]{String.valueOf(ServiceContext.getContext().getAttachment(ORD_ID_ATTACHMENT))});
            }
            if (ObjectUtils.isNotEmpty((Object)ServiceContext.getContext().getAttachment(CUS_ID_ATTACHMENT))) {
                template.header(CUS_ID_ATTACHMENT, new String[]{String.valueOf(ServiceContext.getContext().getAttachment(CUS_ID_ATTACHMENT))});
            }
            if (StringUtils.isNotBlank((CharSequence)(key = (String)ServiceContext.getContext().get("Application-Key")))) {
                template.header("Application-Key", new String[]{key});
            }
            if (StringUtils.isNotBlank((CharSequence)(token = (String)ServiceContext.getContext().get("Access-Token")))) {
                template.header("Access-Token", new String[]{token});
            }
        }
    }
}

