/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl.operation;

import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.abs.ReportExportAbstract;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.dto.request.ExchangeAdvanceExportReqDto;
import com.dtyunxi.tcbj.module.export.biz.vo.operation.ExchangeAdvanceExportVo;
import com.dtyunxi.yundt.cube.center.promotion.api.constants.ExchangeAdvanceStatusEnum;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.request.ExchangeBalanceAdvanceQueryReqDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.response.ExchangeBalanceAdvanceRespDto;
import com.dtyunxi.yundt.cube.center.promotion.api.query.IExchangeBalanceAdvanceQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ExchangeAdvanceExportService
extends ReportExportAbstract<ExchangeBalanceAdvanceRespDto, ExchangeAdvanceExportReqDto, ExchangeAdvanceExportVo> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IExchangeBalanceAdvanceQueryApi exchangeBalanceAdvanceQueryApi;

    @Override
    public ExportTypeEnum getExportType() {
        return ExportTypeEnum.EXCHANGE_ADVANCE;
    }

    @Override
    public PageInfo<ExchangeBalanceAdvanceRespDto> queryData(ExchangeAdvanceExportReqDto exchangeAdvanceExportReqDto) {
        ExchangeBalanceAdvanceQueryReqDto advanceQueryReqDto = new ExchangeBalanceAdvanceQueryReqDto();
        BeanUtils.copyProperties((Object)((Object)exchangeAdvanceExportReqDto), (Object)advanceQueryReqDto);
        return (PageInfo)RestResponseHelper.extractData((RestResponse)this.exchangeBalanceAdvanceQueryApi.queryByPage(advanceQueryReqDto));
    }

    @Override
    public ExchangeAdvanceExportReqDto definePrams(ExchangeAdvanceExportReqDto advanceExportReqDto) {
        return advanceExportReqDto;
    }

    @Override
    public Gson buildGson() {
        return new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").create();
    }

    @Override
    public List<ExchangeAdvanceExportVo> getExportDtoList(List<ExchangeBalanceAdvanceRespDto> exportDtoList, Class<ExchangeAdvanceExportVo> vo) {
        ArrayList advanceExportVos = Lists.newArrayList();
        for (ExchangeBalanceAdvanceRespDto advanceRespDto : exportDtoList) {
            ExchangeAdvanceExportVo advanceExportVo = new ExchangeAdvanceExportVo();
            advanceExportVo.setCustomerCode(advanceRespDto.getCustomerCode());
            advanceExportVo.setCustomerName(advanceRespDto.getCustomerName());
            advanceExportVo.setAdvanceNo(advanceRespDto.getAdvanceNo());
            advanceExportVo.setAdvanceTime(DateUtil.getDateFormat((Date)advanceRespDto.getAdvanceTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            advanceExportVo.setAdvanceAmount(advanceRespDto.getAdvanceAmount().toString());
            advanceExportVo.setAdvanceGrantTime(DateUtil.getDateFormat((Date)advanceRespDto.getAdvanceGrantTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            ExchangeAdvanceStatusEnum exchangeAdvanceStatusEnum = ExchangeAdvanceStatusEnum.forStatus((Integer)advanceRespDto.getStatus());
            advanceExportVo.setStatusName(Optional.ofNullable(exchangeAdvanceStatusEnum).map(ExchangeAdvanceStatusEnum::getValue).orElse(""));
            advanceExportVos.add(advanceExportVo);
        }
        return advanceExportVos;
    }
}

