/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl.operation;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.dto.request.AccountBillImportReqDto;
import com.dtyunxi.tcbj.module.export.biz.dto.request.BaseDefinedParamDto;
import com.dtyunxi.tcbj.module.export.biz.dto.request.BaseImportInfoReqDto;
import com.dtyunxi.tcbj.module.export.biz.impl.ImportService;
import com.dtyunxi.yundt.cube.center.credit.api.account.ICreditRepayPlanImportApi;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.response.CrAccountCustomerConfigRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.query.ICrAccountCustomerConfigExtQueryApi;
import com.dtyunxi.yundt.cube.center.credit.api.dto.request.CrAccountBillImportInfoReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="accountBillImportService")
public class AccountBillImportService
extends ImportService {
    @Resource
    private ICreditRepayPlanImportApi creditRepayPlanImportApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IShopExtQueryApi shopExtQueryApi;
    @Resource
    private ICrAccountCustomerConfigExtQueryApi crAccountCustomerConfigExtQueryApi;

    @Override
    public void definedImport(BaseDefinedParamDto baseDefinedParamDto, Object list, List<BaseImportInfoReqDto> errorList, Set<String> importDataUniquekeySet) {
        Long organizationId = baseDefinedParamDto.getOrganizationId();
        List shopBaseDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopExtQueryApi.queryShopListBySellerOrgId(organizationId));
        ShopBaseDto shopBaseDto = shopBaseDtos.stream().findFirst().orElse(null);
        if (shopBaseDto == null) {
            throw new BizException("\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        List accountBillImportReqDtos = (List)list;
        List customerCodes = accountBillImportReqDtos.stream().map(AccountBillImportReqDto::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toList());
        Map<Object, Object> customerRespDtoMap = Maps.newHashMap();
        HashMap customerConfigRespDtoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(customerCodes)) {
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerListByCodes(customerCodes));
            customerRespDtoMap = customerRespDtos.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity(), (e1, e2) -> e1));
            List customerConfigRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.crAccountCustomerConfigExtQueryApi.queryBycustomerCodes(customerCodes));
            ArrayList modelIds = Lists.newArrayList();
            for (CrAccountCustomerConfigRespDto customerConfigRespDto : customerConfigRespDtos) {
                customerConfigRespDtoMap.put(customerConfigRespDto.getCustomerCode(), customerConfigRespDto);
                modelIds.add(customerConfigRespDto.getId());
            }
        }
        ArrayList crAccountBillReqDtos = Lists.newArrayList();
        for (AccountBillImportReqDto accountBillImportReqDto : accountBillImportReqDtos) {
            CrAccountCustomerConfigRespDto crAccountCustomerConfigRespDto;
            CustomerRespDto customerRespDto;
            StringBuilder sb = new StringBuilder(80);
            if (StringUtil.isEmpty((String)accountBillImportReqDto.getCustomerCode())) {
                sb.append("\u5ba2\u6237\u7f16\u53f7\u4e3a\u7a7a\uff1b");
            }
            Date statementDate = null;
            if (StringUtils.isBlank((CharSequence)accountBillImportReqDto.getStatementDate())) {
                sb.append("\u8d77\u7b97\u65e5\u671f\u4e3a\u7a7a\uff1b");
            } else if (!super.isValidDateFormat(accountBillImportReqDto.getStatementDate())) {
                sb.append("\u8d77\u7b97\u65e5\u671f\u65f6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528yyyy-MM-dd\u683c\u5f0f\uff1b");
            } else {
                statementDate = DateUtil.parseDate((String)accountBillImportReqDto.getStatementDate(), (String)"yyyy-MM-dd");
            }
            Date lastPayBackTime = null;
            if (StringUtils.isBlank((CharSequence)accountBillImportReqDto.getLastPayBackTime())) {
                sb.append("\u5230\u671f\u65e5\u671f\u4e3a\u7a7a\uff1b");
            } else if (!super.isValidDateFormat(accountBillImportReqDto.getLastPayBackTime())) {
                sb.append("\u5230\u671f\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528yyyy-MM-dd\u683c\u5f0f\uff1b");
            } else {
                lastPayBackTime = DateUtil.parseDate((String)accountBillImportReqDto.getLastPayBackTime(), (String)"yyyy-MM-dd");
            }
            if (statementDate != null && lastPayBackTime != null && !statementDate.before(lastPayBackTime)) {
                sb.append("\u8d77\u7b97\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u5230\u671f\u65e5\u671f\uff1b");
            }
            BigDecimal billAmount = super.tryConverBigDecimalAndCheckScale(sb, accountBillImportReqDto.getBillAmount(), "\u8d26\u5355\u91d1\u989d", DEF_SCALE, false, false);
            BigDecimal alreadyRepaidAmount = super.tryConverBigDecimalAndCheckScale(sb, accountBillImportReqDto.getAlreadyRepaidAmount(), "\u5df2\u8fd8\u6b3e", DEF_SCALE, true, false);
            BigDecimal notYetAmount = super.tryConverBigDecimalAndCheckScale(sb, accountBillImportReqDto.getNotYetAmount(), "\u5f85\u8fd8\u6b3e", DEF_SCALE, true, false);
            if (billAmount != null && alreadyRepaidAmount != null && notYetAmount != null && billAmount.compareTo(alreadyRepaidAmount.add(notYetAmount)) != 0) {
                sb.append("\u5df2\u8fd8\u6b3e\u91d1\u989d\u52a0\u5f85\u8fd8\u6b3e\u91d1\u989d\u5fc5\u987b\u7b49\u4e8e\u8d26\u5355\u91d1\u989d\uff1b");
            }
            if ((customerRespDto = (CustomerRespDto)customerRespDtoMap.get(accountBillImportReqDto.getCustomerCode())) == null || !Objects.equals(customerRespDto.getMerchantId(), organizationId)) {
                sb.append("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff1b");
            }
            if ((crAccountCustomerConfigRespDto = (CrAccountCustomerConfigRespDto)customerConfigRespDtoMap.get(accountBillImportReqDto.getCustomerCode())) == null) {
                sb.append("\u5ba2\u6237\u672a\u8bbe\u7f6e\u8d26\u671f\uff1b");
            }
            if (StringUtils.isBlank((CharSequence)sb.toString())) {
                CrAccountBillImportInfoReqDto crAccountBillReqDto = new CrAccountBillImportInfoReqDto();
                crAccountBillReqDto.setStatementDate(statementDate);
                crAccountBillReqDto.setBillAmount(billAmount);
                crAccountBillReqDto.setCustomerName(customerRespDto.getName());
                crAccountBillReqDto.setCustomerCode(customerRespDto.getCode());
                crAccountBillReqDto.setModelId(crAccountCustomerConfigRespDto.getModelId());
                crAccountBillReqDto.setLastPayBackTime(lastPayBackTime);
                crAccountBillReqDto.setAlreadyRepaidAmount(alreadyRepaidAmount);
                crAccountBillReqDto.setNotYetAmount(notYetAmount);
                crAccountBillReqDto.setOrgInfoId(organizationId);
                crAccountBillReqDto.setCustomerId(customerRespDto.getId() + "");
                crAccountBillReqDto.setOrderNo(accountBillImportReqDto.getOrderNo());
                crAccountBillReqDto.setShopName(shopBaseDto.getName());
                crAccountBillReqDto.setShopId(shopBaseDto.getId() + "");
                this.judgmentCreditRepayPlanStatus(crAccountBillReqDto);
                crAccountBillReqDtos.add(crAccountBillReqDto);
                continue;
            }
            accountBillImportReqDto.setErrorMsg(sb.toString());
            errorList.add(accountBillImportReqDto);
        }
        if (CollectionUtil.isNotEmpty((Collection)crAccountBillReqDtos)) {
            this.creditRepayPlanImportApi.batchImportAccountBills((List)crAccountBillReqDtos);
        }
    }

    private void judgmentCreditRepayPlanStatus(CrAccountBillImportInfoReqDto crAccountBillReqDto) {
        BigDecimal alreadyRepaidAmount = crAccountBillReqDto.getAlreadyRepaidAmount();
        BigDecimal notYetAmount = crAccountBillReqDto.getNotYetAmount();
        if (BigDecimal.ZERO.compareTo(alreadyRepaidAmount) == 0) {
            crAccountBillReqDto.setStatus(Integer.valueOf(1));
        } else if (BigDecimal.ZERO.compareTo(alreadyRepaidAmount) < 0 && BigDecimal.ZERO.compareTo(notYetAmount) < 0) {
            crAccountBillReqDto.setStatus(Integer.valueOf(2));
        } else {
            crAccountBillReqDto.setStatus(Integer.valueOf(0));
        }
    }
}

