/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.rest;

import cn.hutool.core.io.FileUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.dto.request.ImportReqDto;
import com.dtyunxi.tcbj.module.export.biz.impl.ItemAuthImportService;
import com.dtyunxi.tcbj.module.export.biz.utils.ExcelFileUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5bfc\u5165\u7ec4\u4ef6\uff1a\u6279\u91cf\u5546\u54c1\u6388\u6743\u670d\u52a1"})
@RestController
@RequestMapping(value={"/v1/import/itemAuth"})
public class ItemAuthImportRest {
    private final Logger logger = LoggerFactory.getLogger(ItemAuthImportRest.class);
    @Resource
    private HttpServletRequest request;
    @Resource
    private ItemAuthImportService itemAuthImportService;

    @PostMapping(value={"/asyncItemAuthImport"})
    @ApiOperation(value="\u5546\u54c1\u6279\u91cf\u6388\u6743Excel\u5bfc\u5165", notes="\u5546\u54c1\u6279\u91cf\u6388\u6743Excel\u5bfc\u5165")
    RestResponse<String> asyncItemAuthImport(@RequestBody ImportReqDto reqDto) {
        String importFileUrl = reqDto.getFileUrl();
        if (StringUtil.isBlank((CharSequence)importFileUrl)) {
            throw new BizException("\u8bf7\u4e0a\u4f20\u8981\u5bfc\u5165\u7684excel\u6587\u4ef6");
        }
        if (!ExcelFileUtil.isExcel2003((String)importFileUrl) && !ExcelFileUtil.isExcel2007((String)importFileUrl)) {
            throw new BizException("\u8bf7\u4e0a\u4f20excel\u7c7b\u578b\u7684\u6587\u4ef6");
        }
        Long sellerId = null;
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getSellerIdList())) {
            sellerId = (Long)reqDto.getSellerIdList().get(0);
        }
        int fileLength = 0;
        try {
            URLConnection connection = new URL(importFileUrl).openConnection();
            fileLength = connection.getContentLength();
            this.logger.info("\u6587\u4ef6\u5927\u5c0f\uff1a{}", (Object)fileLength);
        }
        catch (IOException e) {
            throw new BizException("\u901a\u8fc7\u7f51\u7edc\u83b7\u53d6\u4e0a\u4f20\u7684OSS\u6587\u4ef6\u51fa\u9519");
        }
        boolean checkFileSize = ExcelFileUtil.checkFileSize((Long)Long.parseLong(fileLength + ""), (int)10, (String)"M");
        if (!checkFileSize) {
            throw new BizException("\u5bfc\u5165\u7684\u6587\u4ef6\u5927\u5c0f\u4e0d\u80fd\u5927\u4e8e10M");
        }
        try {
            String fileName = FileUtil.getName((String)importFileUrl);
            this.logger.info("\u5bfc\u5165\u7684\u6587\u4ef6\u540d\uff1a{}", (Object)fileName);
            String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
            this.logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
            if (StringUtil.isBlank((CharSequence)organizationId)) {
                throw new BizException("\u8bf7\u6c42\u5934\u7f3a\u5931[yes-req-cus-b2b-organizationId]");
            }
            this.itemAuthImportService.asyncItemAuthImport(importFileUrl, fileName, organizationId, sellerId);
        }
        catch (Exception e) {
            this.logger.info("\u5546\u54c1\u6279\u91cf\u6388\u6743Excel\u5bfc\u5165\u5931\u8d25{}", (Object)e.getMessage());
            throw new BizException(e.getMessage());
        }
        return new RestResponse((Object)"\u64cd\u4f5c\u5b8c\u6210\uff0c\u4e0a\u4f20\u7ed3\u679c\u8bf7\u4ece\u5bfc\u5165\u5217\u8868\u67e5\u770b");
    }
}

