/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.settlement.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.settlement.api.ISafeMobileApi;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.SafeMobileReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SafeMobileRespDto;
import com.dtyunxi.tcbj.center.settlement.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.settlement.api.query.ISafeMobileQueryApi;
import com.dtyunxi.tcbj.module.settlement.biz.service.ISafeMobileService;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SafeMobileServiceImpl
implements ISafeMobileService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ISafeMobileApi safeMobileApi;
    @Resource
    private ISafeMobileQueryApi safeMobileQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;

    @Override
    public RestResponse<Long> addOrModifySafeMobile(SafeMobileReqDto addReqDto) {
        this.logger.info("\u3010\u5b89\u5168\u624b\u673a\u3011\u65b0\u589e/\u4fee\u6539\u624b\u673a\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto));
        Long orgId = this.getUserOrgId();
        addReqDto.setOrgId(orgId);
        return this.safeMobileApi.addOrModifySafeMobile(addReqDto);
    }

    private Long getUserOrgId() {
        RestResponse currentUserOrgIdResp = this.customerExtQueryApi.queryCurrentUserOrgId();
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)currentUserOrgIdResp);
        AssertUtils.notNull((Object)orgId, (String)"\u5f53\u524d\u7528\u6237\u7684orgId\u4e3a\u7a7a\uff01");
        return orgId;
    }

    @Override
    public RestResponse<SafeMobileRespDto> queryById() {
        Long userOrgId = this.getUserOrgId();
        this.logger.info("\u3010\u5b89\u5168\u624b\u673a\u3011\u7528\u6237\u7ec4\u7ec7id={}", (Object)userOrgId);
        return this.safeMobileQueryApi.queryById(userOrgId);
    }
}

