/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.settlement.biz.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.tcbj.module.settlement.biz.utils.Authorization;
import com.dtyunxi.util.HttpUtil;
import com.dtyunxi.util.WeiXinApi;
import com.dtyunxi.vo.UserInfo;
import java.net.URLEncoder;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WeiXinUtil {
    private static Logger logger = LoggerFactory.getLogger(WeiXinUtil.class);
    public static final String QY_WEIXIN_ACCESS_TOKEN = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=CORPID&corpsecret=SECRECT";
    public static final String QY_WEIXIN_GETUSERINFO = "https://qyapi.weixin.qq.com/cgi-bin/user/get?access_token=ACCESS_TOKEN&userid=USERID";
    public static final String QY_WEIXIN_USERINFO_URL = "https://qyapi.weixin.qq.com/cgi-bin/user/getuserinfo?access_token=ACCESS_TOKEN&code=CODE";
    public static final String QY_CONVERT_TO_OPENID_URL = "https://qyapi.weixin.qq.com/cgi-bin/user/convert_to_openid?access_token=ACCESS_TOKEN";
    public static final String QY_CONVERT_TO_USERID_URL = "https://qyapi.weixin.qq.com/cgi-bin/user/convert_to_userid?access_token=ACCESS_TOKEN";
    public static final String ACCESS_TOKEN_INVALID = "42001";
    public static final String QY_WEIXIN_SUCCESS = "0";

    public static Authorization getAuthorization(String appId, String appSecret, String code) {
        logger.info("WX getAuthorization-req==>>>{},{},{}", new Object[]{appId, appSecret, code});
        String json = HttpUtil.sendGet((String)WeiXinApi.getOAuthTokenUrl((String)appId, (String)appSecret, (String)code));
        logger.info("WX getAuthorization==>>>{}", (Object)json);
        return (Authorization)JSON.parseObject((String)json, Authorization.class);
    }

    public static Authorization getMPAuthorization(String url) {
        logger.info("WX getMPAuthorization-req==>>>{}", (Object)url);
        String json = HttpUtil.sendGet((String)url);
        logger.info("WX getMPAuthorization==>>>{}", (Object)json);
        return (Authorization)JSON.parseObject((String)json, Authorization.class);
    }

    public static UserInfo getUserInfo(String openid, String token) {
        logger.info("WX getUserInfo-req==>>>{},{}", (Object)openid, (Object)token);
        String ticketJson = HttpUtil.sendGet((String)WeiXinApi.getOAuthUserinfoUrl((String)token, (String)openid));
        logger.info("WX getUserInfo==>>>{}", (Object)ticketJson);
        return (UserInfo)JSON.parseObject((String)ticketJson, UserInfo.class);
    }

    public static String getOAuthCodeUrl(String APPID, String redirectUrl, String scope, String state) {
        return String.format("https://open.weixin.qq.com/connect/qrconnect?appid=%s&redirect_uri=%s&response_type=%s&scope=%s&state=%s#wechat_redirect", APPID, WeiXinUtil.urlEnodeUTF8(redirectUrl), "code", scope, state);
    }

    public static String getBrowseOAuthCodeUrl(String APPID, String redirectUrl, String scope, String state) {
        return String.format("https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=%s&state=%s&connect_redirect=1#wechat_redirect", APPID, WeiXinUtil.urlEnodeUTF8(redirectUrl), scope, state);
    }

    public static String getQyOAuthCodeUrl(String APPID, String redirectUrl, String scope, String state) {
        return String.format("https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=%s&scope=%s&state=%s#wechat_redirect", APPID, WeiXinUtil.urlEnodeUTF8(redirectUrl), "code", scope, state);
    }

    public static Authorization getQyAuthorization(String appId, String appSecret) {
        String requestUrl = QY_WEIXIN_ACCESS_TOKEN.replace("CORPID", appId).replace("SECRECT", appSecret);
        String json = HttpUtil.sendGet((String)requestUrl);
        return (Authorization)JSON.parseObject((String)json, Authorization.class);
    }

    public static JSONObject getQyUserId(String accessToken, String code) {
        String requestUrl = QY_WEIXIN_USERINFO_URL.replace("ACCESS_TOKEN", accessToken).replace("CODE", code);
        String json = HttpUtil.sendGet((String)requestUrl);
        logger.info("WX getQyUserId==>>>{}", (Object)json);
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        return !QY_WEIXIN_SUCCESS.equals(jsonObject.getString("errcode")) ? null : jsonObject;
    }

    public static JSONObject getQyUserInfo(String accessToken, String userId) {
        String requestUrl = QY_WEIXIN_GETUSERINFO.replace("ACCESS_TOKEN", accessToken).replace("USERID", userId);
        String ticketJson = HttpUtil.sendGet((String)requestUrl);
        logger.info("WX QyUserInfo==>>>{}", (Object)ticketJson);
        JSONObject jsonObject = JSONObject.parseObject((String)ticketJson);
        return !QY_WEIXIN_SUCCESS.equals(jsonObject.getString("errcode")) ? null : jsonObject;
    }

    public static String getQyOpenId(String accessToken, String userId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userid", userId);
        String requestUrl = QY_CONVERT_TO_OPENID_URL.replace("ACCESS_TOKEN", accessToken);
        String json = HttpUtil.sendPost((String)requestUrl, (String)JSON.toJSONString(map));
        logger.info("WX getQyOpenId==>>>{}", (Object)json);
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        return !QY_WEIXIN_SUCCESS.equals(jsonObject.getString("errcode")) ? null : String.valueOf(jsonObject.getString("openid"));
    }

    public static String getQyUserIdByOpenId(String accessToken, String openId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("openid", openId);
        String requestUrl = QY_CONVERT_TO_USERID_URL.replace("ACCESS_TOKEN", accessToken);
        String json = HttpUtil.sendPost((String)requestUrl, (String)JSON.toJSONString(map));
        logger.info("WX getQyUserIdByOpenId==>>>{}", (Object)json);
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        return !QY_WEIXIN_SUCCESS.equals(jsonObject.getString("errcode")) ? null : String.valueOf(jsonObject.getString("userid"));
    }

    public static String urlEnodeUTF8(String str) {
        String result = str;
        try {
            result = URLEncoder.encode(str);
        }
        catch (Exception var3) {
            var3.printStackTrace();
        }
        return result;
    }
}

