/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.api.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum SourceTypeEnum {
    PICK(0, "\u914d\u8d27\u5bfb\u6e90"),
    REPLENISHMENT(1, "\u8865\u8d27\u5bfb\u6e90"),
    ORDER(2, "\u8ba2\u5355\u5bfb\u6e90");

    public final Integer code;
    public final String desc;
    public static final Map<Integer, SourceTypeEnum> CODE_LOOKUP;
    public static final Map<Integer, String> CODE_DESC_MAP;

    private SourceTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static SourceTypeEnum forCode(Integer code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<Integer, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        CODE_LOOKUP = Arrays.stream(SourceTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(SourceTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
    }
}

