/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.center.source.api.dto.request.OrderReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderAddrRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderItemRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceAssert;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.service.IOrderAddrService;
import com.dtyunxi.cube.center.source.biz.service.IOrderItemService;
import com.dtyunxi.cube.center.source.biz.service.IOrderService;
import com.dtyunxi.cube.center.source.dao.das.OrderDas;
import com.dtyunxi.cube.center.source.dao.eo.OrderEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderServiceImpl
implements IOrderService {
    private static final Logger logger = LoggerFactory.getLogger(OrderServiceImpl.class);
    @Resource
    private OrderDas orderDas;
    @Resource
    private IOrderItemService orderItemService;
    @Resource
    private IOrderAddrService orderAddrService;

    @Override
    public Long addOrder(OrderReqDto addReqDto) {
        OrderEo orderEo = new OrderEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)orderEo);
        this.orderDas.insert((BaseEo)orderEo);
        return orderEo.getId();
    }

    @Override
    public void modifyOrder(OrderReqDto modifyReqDto) {
        OrderEo orderEo = new OrderEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)orderEo);
        this.orderDas.updateSelective((BaseEo)orderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOrder(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.orderDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public OrderRespDto queryById(Long id) {
        OrderEo orderEo = (OrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.orderDas.filter().eq((Object)"id", (Object)id)).eq((Object)"dr", (Object)0)).one();
        if (orderEo == null) {
            return null;
        }
        OrderRespDto orderRespDto = new OrderRespDto();
        DtoHelper.eo2Dto((BaseEo)orderEo, (BaseVo)orderRespDto);
        return orderRespDto;
    }

    @Override
    public OrderDetailRespDto queryDetailById(Long id) {
        SourceAssert.notNull((Object)id, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5bfb\u6e90\u5355id"});
        OrderEo orderEo = (OrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.orderDas.filter().eq((Object)"id", (Object)id)).eq((Object)"dr", (Object)0)).one();
        logger.info("\u5bfb\u6e90\u5355Eo\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)orderEo));
        if (orderEo == null) {
            return null;
        }
        List<OrderItemRespDto> orderItemRespDtoList = this.orderItemService.queryByOrderId(id);
        OrderAddrRespDto orderAddrRespDto = this.orderAddrService.queryByOrderId(id);
        OrderDetailRespDto orderDetailRespDto = new OrderDetailRespDto();
        CubeBeanUtils.copyProperties((Object)orderDetailRespDto, (Object)orderEo, (String[])new String[0]);
        orderDetailRespDto.setOrderItemRespDtoList(orderItemRespDtoList);
        orderDetailRespDto.setOrderAddrRespDto(orderAddrRespDto);
        return orderDetailRespDto;
    }

    @Override
    public List<OrderRespDto> queryByLinkOrderNo(String linkOrderNo, String linkOrderType) {
        SourceAssert.notBlank((String)linkOrderNo, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5173\u8054\u5355\u636e"});
        OrderEo queryEo = new OrderEo();
        queryEo.setLinkOrderNo(linkOrderNo);
        queryEo.setLinkOrderType(linkOrderType);
        queryEo.setOrderByDesc("update_time");
        List orderEoList = this.orderDas.select((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)orderEoList)) {
            ArrayList<OrderRespDto> orderRespDtoList = new ArrayList<OrderRespDto>();
            CubeBeanUtils.copyCollection(orderRespDtoList, (Collection)orderEoList, OrderRespDto.class);
            return orderRespDtoList;
        }
        return null;
    }

    @Override
    public List<OrderRespDto> queryByLinkOrderNo(String linkOrderNo, String linkOrderType, String sgType) {
        SourceAssert.notBlank((String)linkOrderNo, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5173\u8054\u5355\u636e"});
        OrderEo queryEo = new OrderEo();
        queryEo.setLinkOrderNo(linkOrderNo);
        queryEo.setLinkOrderType(linkOrderType);
        queryEo.setSgType(sgType);
        List orderEoList = this.orderDas.select((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)orderEoList)) {
            ArrayList<OrderRespDto> orderRespDtoList = new ArrayList<OrderRespDto>();
            CubeBeanUtils.copyCollection(orderRespDtoList, (Collection)orderEoList, OrderRespDto.class);
            return orderRespDtoList;
        }
        return null;
    }

    @Override
    public PageInfo<OrderRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        OrderReqDto orderReqDto = (OrderReqDto)JSON.parseObject((String)filter, OrderReqDto.class);
        OrderEo orderEo = new OrderEo();
        DtoHelper.dto2Eo((BaseVo)orderReqDto, (BaseEo)orderEo);
        PageInfo eoPageInfo = this.orderDas.selectPage((BaseEo)orderEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, OrderRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public int optimisticModifyOrderEo(OrderEo orderEo, UpdateWrapper<OrderEo> updateWrapper, int idealCount, boolean needThrow) {
        logger.info("optimisticModifyOrderEo\u5165\u53c2orderEo={}\uff0cupdateWrapper={}\uff0cidealCount={}\uff0cneedThrow={}", new Object[]{JSON.toJSONString((Object)orderEo), JSON.toJSONString(updateWrapper), idealCount, needThrow});
        if (updateWrapper.isEmptyOfWhere()) {
            throw new BizException("-1", "\u66f4\u65b0\u6761\u4ef6\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        this.orderDas.setUpdateSystemFields((BaseEo)orderEo);
        int optCount = this.orderDas.getMapper().update((Object)orderEo, updateWrapper);
        if (needThrow && optCount != idealCount) {
            throw new BizException("-1", "\u66f4\u65b0\u5bfb\u6e90\u5355\u72b6\u6001\u5931\u8d25");
        }
        return optCount;
    }
}

