/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.center.source.api.dto.request.ClueWarehouseGroupRuleDeliveryReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueWarehouseGroupRuleDeliveryRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceAssert;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.service.IClueWarehouseGroupRuleDeliveryService;
import com.dtyunxi.cube.center.source.dao.das.ClueWarehouseGroupRuleDeliveryDas;
import com.dtyunxi.cube.center.source.dao.eo.ClueWarehouseGroupRuleDeliveryEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClueWarehouseGroupRuleDeliveryServiceImpl
implements IClueWarehouseGroupRuleDeliveryService {
    @Resource
    private ClueWarehouseGroupRuleDeliveryDas clueWarehouseGroupRuleDeliveryDas;

    @Override
    public Long addClueWarehouseGroupRuleDelivery(ClueWarehouseGroupRuleDeliveryReqDto addReqDto) {
        ClueWarehouseGroupRuleDeliveryEo clueWarehouseGroupRuleDeliveryEo = new ClueWarehouseGroupRuleDeliveryEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)clueWarehouseGroupRuleDeliveryEo);
        this.clueWarehouseGroupRuleDeliveryDas.insert((BaseEo)clueWarehouseGroupRuleDeliveryEo);
        return clueWarehouseGroupRuleDeliveryEo.getId();
    }

    @Override
    public void modifyClueWarehouseGroupRuleDelivery(ClueWarehouseGroupRuleDeliveryReqDto modifyReqDto) {
        ClueWarehouseGroupRuleDeliveryEo clueWarehouseGroupRuleDeliveryEo = new ClueWarehouseGroupRuleDeliveryEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)clueWarehouseGroupRuleDeliveryEo);
        this.clueWarehouseGroupRuleDeliveryDas.updateSelective((BaseEo)clueWarehouseGroupRuleDeliveryEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeClueWarehouseGroupRuleDelivery(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.clueWarehouseGroupRuleDeliveryDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ClueWarehouseGroupRuleDeliveryRespDto queryById(Long id) {
        ClueWarehouseGroupRuleDeliveryEo clueWarehouseGroupRuleDeliveryEo = (ClueWarehouseGroupRuleDeliveryEo)this.clueWarehouseGroupRuleDeliveryDas.selectByPrimaryKey(id);
        ClueWarehouseGroupRuleDeliveryRespDto clueWarehouseGroupRuleDeliveryRespDto = new ClueWarehouseGroupRuleDeliveryRespDto();
        DtoHelper.eo2Dto((BaseEo)clueWarehouseGroupRuleDeliveryEo, (BaseVo)clueWarehouseGroupRuleDeliveryRespDto);
        return clueWarehouseGroupRuleDeliveryRespDto;
    }

    @Override
    public List<ClueWarehouseGroupRuleDeliveryRespDto> queryByClueIdList(Set<Long> clueIdList) {
        SourceAssert.notEmpty(clueIdList, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u7b56\u7565id\u96c6\u5408"});
        List clueWarehouseGroupEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.clueWarehouseGroupRuleDeliveryDas.filter().in((Object)"sg_clue_id", clueIdList)).eq((Object)"dr", (Object)0)).list(Integer.valueOf(10000));
        if (CollectionUtils.isEmpty((Collection)clueWarehouseGroupEoList)) {
            return null;
        }
        ArrayList<ClueWarehouseGroupRuleDeliveryRespDto> dtoList = new ArrayList<ClueWarehouseGroupRuleDeliveryRespDto>();
        DtoHelper.eoList2DtoList((Collection)clueWarehouseGroupEoList, dtoList, ClueWarehouseGroupRuleDeliveryRespDto.class);
        return dtoList;
    }

    @Override
    public PageInfo<ClueWarehouseGroupRuleDeliveryRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ClueWarehouseGroupRuleDeliveryReqDto clueWarehouseGroupRuleDeliveryReqDto = (ClueWarehouseGroupRuleDeliveryReqDto)JSON.parseObject((String)filter, ClueWarehouseGroupRuleDeliveryReqDto.class);
        ClueWarehouseGroupRuleDeliveryEo clueWarehouseGroupRuleDeliveryEo = new ClueWarehouseGroupRuleDeliveryEo();
        DtoHelper.dto2Eo((BaseVo)clueWarehouseGroupRuleDeliveryReqDto, (BaseEo)clueWarehouseGroupRuleDeliveryEo);
        PageInfo eoPageInfo = this.clueWarehouseGroupRuleDeliveryDas.selectPage((BaseEo)clueWarehouseGroupRuleDeliveryEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ClueWarehouseGroupRuleDeliveryRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void modifyClueWarehouseGroupRuleDeliveryBySelect(ClueWarehouseGroupRuleDeliveryEo updateEo, ClueWarehouseGroupRuleDeliveryEo selectEo) {
        UpdateWrapper updateWrapper = new UpdateWrapper((Object)selectEo);
        if (updateWrapper.isEmptyOfWhere()) {
            throw new BizException("-1", "\u66f4\u65b0\u6761\u4ef6\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        this.clueWarehouseGroupRuleDeliveryDas.getMapper().update((Object)updateEo, (Wrapper)updateWrapper);
    }
}

