/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.center.source.api.dto.request.ClueWarehouseGroupRuleReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueWarehouseGroupRuleRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceAssert;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.service.IClueWarehouseGroupRuleService;
import com.dtyunxi.cube.center.source.dao.das.ClueWarehouseGroupRuleDas;
import com.dtyunxi.cube.center.source.dao.eo.ClueWarehouseGroupRuleEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClueWarehouseGroupRuleServiceImpl
implements IClueWarehouseGroupRuleService {
    @Resource
    private ClueWarehouseGroupRuleDas clueWarehouseGroupRuleDas;

    @Override
    public Long addClueWarehouseGroupRule(ClueWarehouseGroupRuleReqDto addReqDto) {
        ClueWarehouseGroupRuleEo clueWarehouseGroupRuleEo = new ClueWarehouseGroupRuleEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)clueWarehouseGroupRuleEo);
        this.clueWarehouseGroupRuleDas.insert((BaseEo)clueWarehouseGroupRuleEo);
        return clueWarehouseGroupRuleEo.getId();
    }

    @Override
    public int addClueWarehouseGroupRuleList(List<? extends ClueWarehouseGroupRuleReqDto> addReqDtoList) {
        ArrayList clueWarehouseGroupRuleEoList = new ArrayList();
        DtoHelper.dtoList2EoList(addReqDtoList, clueWarehouseGroupRuleEoList, ClueWarehouseGroupRuleEo.class);
        return this.clueWarehouseGroupRuleDas.insertBatch(clueWarehouseGroupRuleEoList);
    }

    @Override
    public void modifyClueWarehouseGroupRule(ClueWarehouseGroupRuleReqDto modifyReqDto) {
        ClueWarehouseGroupRuleEo clueWarehouseGroupRuleEo = new ClueWarehouseGroupRuleEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)clueWarehouseGroupRuleEo);
        this.clueWarehouseGroupRuleDas.updateSelective((BaseEo)clueWarehouseGroupRuleEo);
    }

    @Override
    public void modifyClueWarehouseGroupRuleBySelect(ClueWarehouseGroupRuleEo updateEo, ClueWarehouseGroupRuleEo selectEo) {
        UpdateWrapper updateWrapper = new UpdateWrapper((Object)selectEo);
        if (updateWrapper.isEmptyOfWhere()) {
            throw new BizException("-1", "\u66f4\u65b0\u6761\u4ef6\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        this.clueWarehouseGroupRuleDas.getMapper().update((Object)updateEo, (Wrapper)updateWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeClueWarehouseGroupRule(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.clueWarehouseGroupRuleDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ClueWarehouseGroupRuleRespDto queryById(Long id) {
        ClueWarehouseGroupRuleEo clueWarehouseGroupRuleEo = (ClueWarehouseGroupRuleEo)this.clueWarehouseGroupRuleDas.selectByPrimaryKey(id);
        if (clueWarehouseGroupRuleEo == null) {
            return null;
        }
        ClueWarehouseGroupRuleRespDto clueWarehouseGroupRuleRespDto = new ClueWarehouseGroupRuleRespDto();
        DtoHelper.eo2Dto((BaseEo)clueWarehouseGroupRuleEo, (BaseVo)clueWarehouseGroupRuleRespDto);
        return clueWarehouseGroupRuleRespDto;
    }

    @Override
    public PageInfo<ClueWarehouseGroupRuleRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ClueWarehouseGroupRuleReqDto clueWarehouseGroupRuleReqDto = (ClueWarehouseGroupRuleReqDto)JSON.parseObject((String)filter, ClueWarehouseGroupRuleReqDto.class);
        ClueWarehouseGroupRuleEo clueWarehouseGroupRuleEo = new ClueWarehouseGroupRuleEo();
        DtoHelper.dto2Eo((BaseVo)clueWarehouseGroupRuleReqDto, (BaseEo)clueWarehouseGroupRuleEo);
        PageInfo eoPageInfo = this.clueWarehouseGroupRuleDas.selectPage((BaseEo)clueWarehouseGroupRuleEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ClueWarehouseGroupRuleRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<ClueWarehouseGroupRuleRespDto> queryByClueIdList(Set<Long> clueIdList) {
        SourceAssert.notEmpty(clueIdList, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u7b56\u7565id\u96c6\u5408"});
        List clueWarehouseGroupEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.clueWarehouseGroupRuleDas.filter().in((Object)"sg_clue_id", clueIdList)).eq((Object)"dr", (Object)0)).ne((Object)"rule_score_proportion", (Object)0)).list(Integer.valueOf(10000));
        if (CollectionUtils.isEmpty((Collection)clueWarehouseGroupEoList)) {
            return null;
        }
        ArrayList<ClueWarehouseGroupRuleRespDto> dtoList = new ArrayList<ClueWarehouseGroupRuleRespDto>();
        DtoHelper.eoList2DtoList((Collection)clueWarehouseGroupEoList, dtoList, ClueWarehouseGroupRuleRespDto.class);
        return dtoList;
    }
}

