/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.center.source.api.constant.SourceStatusEnum;
import com.dtyunxi.cube.center.source.api.dto.request.CancelSourceOrderReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.OrderItemResultReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.OrderReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.SaleOrderOldBatchMatchReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.SourceOrderResultReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderItemResultRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.SourceOrderResultRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.SourceOrderTestResultRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceAssert;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.api.vo.SourceOrderResultMessageVo;
import com.dtyunxi.cube.center.source.biz.service.IOrderAddrService;
import com.dtyunxi.cube.center.source.biz.service.IOrderItemResultService;
import com.dtyunxi.cube.center.source.biz.service.IOrderItemService;
import com.dtyunxi.cube.center.source.biz.service.IOrderOptService;
import com.dtyunxi.cube.center.source.biz.service.IOrderService;
import com.dtyunxi.cube.center.source.biz.service.SourceOrderOperation;
import com.dtyunxi.cube.center.source.biz.service.calculator.SourceOrderExecutor;
import com.dtyunxi.cube.center.source.biz.service.calculator.SourceOrderGroupRuleCalculator;
import com.dtyunxi.cube.center.source.biz.service.impl.WarehouseDataQuery;
import com.dtyunxi.cube.center.source.biz.utils.NoGenerateUtil;
import com.dtyunxi.cube.center.source.biz.vo.SourceOrderExecuteResultVo;
import com.dtyunxi.cube.center.source.dao.eo.OrderEo;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.report.api.inventory.IDgLogicWarehouseApi;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehouseDto;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderOptServiceImpl
implements IOrderOptService {
    private static final Logger logger = LoggerFactory.getLogger(OrderOptServiceImpl.class);
    @Resource
    private ILockService lockService;
    @Resource
    private IOrderOptService orderOptService;
    @Resource
    private IOrderService orderService;
    @Resource
    private IOrderItemService orderItemService;
    @Resource
    private IOrderAddrService orderAddrService;
    @Resource
    private IOrderItemResultService orderItemResultService;
    @Resource
    private SourceOrderOperation sourceOrderOperation;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IDgLogicWarehouseApi dgLogicWarehouseApi;
    @Resource
    private WarehouseDataQuery warehouseDataQuery;
    @Resource
    private NoGenerateUtil noGenerateUtil;
    @Resource
    private SourceOrderExecutor sourceOrderExecutor;
    @Value(value="${center.source.execute.testFlag:false}")
    private boolean isTest = false;
    @Resource
    private SourceOrderGroupRuleCalculator sourceOrderGroupRuleCalculator;

    @Override
    public RestResponse<SourceOrderResultRespDto> addSourceOrder(SourceOrderResultReqDto addReqDto) {
        this.baseParamCheck(addReqDto);
        SourceOrderResultRespDto sourceOrderResultRespDto = (SourceOrderResultRespDto)RestResponseHelper.extractData(this.orderOptService.idempotentAddSourceOrder(addReqDto));
        if (SourceStatusEnum.WAIT_SOURCE.getCode().equals(sourceOrderResultRespDto.getSgStatus()) || SourceStatusEnum.SOURCING.getCode().equals(sourceOrderResultRespDto.getSgStatus())) {
            logger.info("\u3010\u6267\u884c\u5bfb\u6e90\u3011addReqDto={}", (Object)JSON.toJSONString((Object)sourceOrderResultRespDto));
            if (this.isTest) {
                this.testOperationSourceOrder(sourceOrderResultRespDto.getId());
                sourceOrderResultRespDto = this.testBuildResult(sourceOrderResultRespDto.getId());
            } else {
                sourceOrderResultRespDto = this.sourceOrderOperation.operationSourceOrder(sourceOrderResultRespDto.getId());
            }
        }
        return new RestResponse((Object)sourceOrderResultRespDto);
    }

    private void baseParamCheck(SourceOrderResultReqDto addReqDto) {
        addReqDto.getOrderItemReqDtoList().forEach(dto -> {
            SourceAssert.notBlank((String)dto.getItemSkuCode(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5546\u54c1sku"});
            SourceAssert.notNull((Object)dto.getItemNum(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5546\u54c1\u6570\u91cf"});
        });
        SourceAssert.notBlank((String)addReqDto.getLinkOrderNo(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5173\u8054\u5355\u636e\u53f7"});
        SourceAssert.notBlank((String)addReqDto.getLinkOrderType(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5173\u8054\u5355\u636e\u7c7b\u578b"});
        SourceAssert.notBlank((String)addReqDto.getLinkOrderChannelCode(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5173\u8054\u8ba2\u5355\u6e20\u9053code"});
        SourceAssert.notNull((Object)addReqDto.getLinkOrderChannelId(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5173\u8054\u8ba2\u5355\u6e20\u9053id"});
        SourceAssert.notNull((Object)addReqDto.getLinkOrderCustomerId(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5173\u8054\u5ba2\u6237id"});
        SourceAssert.notBlank((String)addReqDto.getOrderAddrReqDto().getCityCode(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u6536\u8d27\u5730\u5740-\u5e02\u7f16\u7801"});
        SourceAssert.notBlank((String)addReqDto.getOrderAddrReqDto().getProvinceCode(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u6536\u8d27\u5730\u5740-\u7701\u7f16\u7801"});
    }

    private void testOperationSourceOrder(Long sgOrderId) {
        OrderDetailRespDto orderDetailRespDto = this.orderService.queryDetailById(sgOrderId);
        LinkedList<OrderItemResultReqDto> orderItemResultReqDtoList = new LinkedList<OrderItemResultReqDto>();
        if (orderDetailRespDto.getOrderItemRespDtoList().size() > 3) {
            DgLogicInventoryDto csRelWarehouseRespDto = this.testQueryAndSetOrgWarehouseInfo(orderDetailRespDto.getLinkOrderLogicWarehouseId());
            if (csRelWarehouseRespDto != null) {
                orderDetailRespDto.getOrderItemRespDtoList().forEach(dto -> {
                    OrderItemResultReqDto orderItemResultReqDto = new OrderItemResultReqDto();
                    CubeBeanUtils.copyProperties((Object)orderItemResultReqDto, (Object)dto, (String[])new String[0]);
                    orderItemResultReqDto.setId(null);
                    if (dto.getItemNum().compareTo(BigDecimal.ONE) > 0) {
                        orderItemResultReqDto.setDeliveryItemNum(dto.getItemNum().subtract(BigDecimal.ONE));
                        OrderItemResultReqDto orderItemResultReqDtoOther = new OrderItemResultReqDto();
                        CubeBeanUtils.copyProperties((Object)orderItemResultReqDtoOther, (Object)dto, (String[])new String[0]);
                        orderItemResultReqDtoOther.setId(null);
                        orderItemResultReqDtoOther.setDeliveryItemNum(BigDecimal.ONE);
                        orderItemResultReqDtoOther.setDeliveryLogicWarehouseId(csRelWarehouseRespDto.getId());
                        orderItemResultReqDtoOther.setDeliveryLogicWarehouseCode(csRelWarehouseRespDto.getWarehouseCode());
                        orderItemResultReqDtoOther.setDeliveryLogicWarehouseName(csRelWarehouseRespDto.getWarehouseName());
                        orderItemResultReqDtoOther.setDeliveryItemBatchNo(dto.getItemBatchNo());
                        orderItemResultReqDtoOther.setLinkItemSkuCode(dto.getItemSkuCode());
                        orderItemResultReqDtoList.add(orderItemResultReqDtoOther);
                    }
                    orderItemResultReqDto.setDeliveryLogicWarehouseId(orderDetailRespDto.getLinkOrderLogicWarehouseId());
                    orderItemResultReqDto.setDeliveryLogicWarehouseCode(orderDetailRespDto.getLinkOrderLogicWarehouseCode());
                    orderItemResultReqDto.setDeliveryLogicWarehouseName(orderDetailRespDto.getLinkOrderLogicWarehouseName());
                    orderItemResultReqDto.setDeliveryItemBatchNo(dto.getItemBatchNo());
                    orderItemResultReqDto.setLinkItemSkuCode(dto.getItemSkuCode());
                    orderItemResultReqDtoList.add(orderItemResultReqDto);
                });
            } else {
                this.testNormalSource(orderDetailRespDto, orderItemResultReqDtoList);
            }
        } else {
            this.testNormalSource(orderDetailRespDto, orderItemResultReqDtoList);
        }
        this.orderItemResultService.addOrderItemResultList(orderItemResultReqDtoList);
        OrderEo updateEo = new OrderEo();
        updateEo.setId(sgOrderId);
        updateEo.setSgStatus(SourceStatusEnum.SOURCE_SUCCESS.getCode());
        OrderEo queryEo = new OrderEo();
        queryEo.setId(sgOrderId);
        UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
        updateWrapper.in((Object)"sg_status", Arrays.asList(SourceStatusEnum.SOURCING, SourceStatusEnum.WAIT_SOURCE));
        this.orderService.optimisticModifyOrderEo(updateEo, (UpdateWrapper<OrderEo>)updateWrapper, 1, true);
        this.sendSourceResultMessageBySgOrderId(sgOrderId);
    }

    private void testNormalSource(OrderDetailRespDto orderDetailRespDto, List<OrderItemResultReqDto> orderItemResultReqDtoList) {
        orderDetailRespDto.getOrderItemRespDtoList().forEach(dto -> {
            OrderItemResultReqDto orderItemResultReqDto = new OrderItemResultReqDto();
            CubeBeanUtils.copyProperties((Object)orderItemResultReqDto, (Object)dto, (String[])new String[0]);
            orderItemResultReqDto.setDeliveryItemNum(dto.getItemNum());
            orderItemResultReqDto.setDeliveryLogicWarehouseId(orderDetailRespDto.getLinkOrderLogicWarehouseId());
            orderItemResultReqDto.setDeliveryLogicWarehouseCode(orderDetailRespDto.getLinkOrderLogicWarehouseCode());
            orderItemResultReqDto.setDeliveryLogicWarehouseName(orderDetailRespDto.getLinkOrderLogicWarehouseName());
            orderItemResultReqDtoList.add(orderItemResultReqDto);
        });
    }

    private DgLogicInventoryDto testQueryAndSetOrgWarehouseInfo(Long warehouseId) {
        SourceAssert.notNull((Object)warehouseId, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u4ed3\u5e93id"});
        DgLogicWarehouseDto logicWarehouseDetailRespDto = (DgLogicWarehouseDto)RestResponseHelper.extractData((RestResponse)this.dgLogicWarehouseApi.get(warehouseId));
        logger.info("\u3010\u67e5\u8be2\u4ed3\u5e93\u57fa\u672c\u4fe1\u606f\u3011{}", (Object)JSON.toJSONString((Object)logicWarehouseDetailRespDto));
        SourceAssert.notNull((Object)logicWarehouseDetailRespDto, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u4ed3\u5e93\u57fa\u672c\u4fe1\u606f"});
        List<DgLogicInventoryDto> newRelWarehouseRespDtos = this.warehouseDataQuery.queryCsLogicWarehousePageRespDtoListByOrganizationId(logicWarehouseDetailRespDto.getOrganizationCode());
        if (CollectionUtils.isNotEmpty(newRelWarehouseRespDtos)) {
            return newRelWarehouseRespDtos.get(0);
        }
        return null;
    }

    private void sendSourceResultMessageBySgOrderId(Long sgOrderId) {
        try {
            OrderDetailRespDto orderDetailRespDto = this.orderService.queryDetailById(sgOrderId);
            List<OrderItemResultRespDto> orderItemResultRespDtoList = this.orderItemResultService.queryByOrderId(orderDetailRespDto.getId());
            if (CollectionUtils.isEmpty(orderItemResultRespDtoList)) {
                throw SourceExceptionCode.SOURCE_EXECUTE_RESULT_EMPTY.buildBizException();
            }
            MessageVo messageVo = new MessageVo();
            SourceOrderResultMessageVo sourceOrderResultMessageVo = new SourceOrderResultMessageVo();
            CubeBeanUtils.copyProperties((Object)sourceOrderResultMessageVo, (Object)orderDetailRespDto, (String[])new String[0]);
            sourceOrderResultMessageVo.setOrderItemResultRespDtoList(orderItemResultRespDtoList);
            messageVo.setData((Object)sourceOrderResultMessageVo);
            this.commonsMqService.sendSingleMessage("SOURCE_ORDER_SOURCING_EXECUTE_END_TAG", (Object)messageVo);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private SourceOrderResultRespDto testBuildResult(Long sgOrderId) {
        OrderDetailRespDto orderDetailRespDto = this.orderService.queryDetailById(sgOrderId);
        List<OrderItemResultRespDto> orderItemResultRespDtoList = this.orderItemResultService.queryByOrderId(orderDetailRespDto.getId());
        if (CollectionUtils.isEmpty(orderItemResultRespDtoList)) {
            throw SourceExceptionCode.SOURCE_EXECUTE_RESULT_EMPTY.buildBizException();
        }
        SourceOrderResultRespDto sourceOrderResultRespDto = new SourceOrderResultRespDto();
        CubeBeanUtils.copyProperties((Object)sourceOrderResultRespDto, (Object)orderDetailRespDto, (String[])new String[0]);
        sourceOrderResultRespDto.setOrderItemResultRespDtoList(orderItemResultRespDtoList);
        return sourceOrderResultRespDto;
    }

    @Override
    public RestResponse<Void> abolishSourceOrder(Long sgOrderId) {
        SourceAssert.notNull((Object)sgOrderId, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5bfb\u6e90\u5355id"});
        OrderRespDto orderRespDto = this.orderService.queryById(sgOrderId);
        this.checkSourceOrderStatus(orderRespDto, SourceStatusEnum.valueOf((String)orderRespDto.getSgStatus()), SourceStatusEnum.SOURCE_SUCCESS);
        OrderEo updateEo = new OrderEo();
        updateEo.setId(sgOrderId);
        updateEo.setSgStatus(SourceStatusEnum.ABOLISH.getCode());
        OrderEo queryEo = new OrderEo();
        queryEo.setId(sgOrderId);
        UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
        updateWrapper.in((Object)"sg_status", Collections.singletonList(SourceStatusEnum.SOURCE_SUCCESS));
        this.orderService.optimisticModifyOrderEo(updateEo, (UpdateWrapper<OrderEo>)updateWrapper, 1, true);
        return new RestResponse();
    }

    @Override
    public RestResponse<Void> cancelSourceOrder(Long sgOrderId) {
        SourceAssert.notNull((Object)sgOrderId, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5bfb\u6e90\u5355id"});
        OrderRespDto orderRespDto = this.orderService.queryById(sgOrderId);
        this.checkSourceOrderStatus(orderRespDto, SourceStatusEnum.valueOf((String)orderRespDto.getSgStatus()), SourceStatusEnum.WAIT_SOURCE, SourceStatusEnum.SOURCING);
        OrderEo updateEo = new OrderEo();
        updateEo.setId(sgOrderId);
        updateEo.setSgStatus(SourceStatusEnum.CANCEL.getCode());
        OrderEo queryEo = new OrderEo();
        queryEo.setId(sgOrderId);
        UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
        updateWrapper.in((Object)"sg_status", Arrays.asList(SourceStatusEnum.WAIT_SOURCE, SourceStatusEnum.SOURCING));
        this.orderService.optimisticModifyOrderEo(updateEo, (UpdateWrapper<OrderEo>)updateWrapper, 1, true);
        return new RestResponse();
    }

    @Override
    public RestResponse<Void> cancelSourceOrder(CancelSourceOrderReqDto cancelSourceOrderReqDto) {
        Long sgOrderId = cancelSourceOrderReqDto.getSgOrderId();
        SourceAssert.notNull((Object)sgOrderId, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5bfb\u6e90\u5355id"});
        OrderRespDto orderRespDto = this.orderService.queryById(sgOrderId);
        this.checkSourceOrderStatus(orderRespDto, SourceStatusEnum.valueOf((String)orderRespDto.getSgStatus()), SourceStatusEnum.WAIT_SOURCE, SourceStatusEnum.SOURCING);
        OrderEo updateEo = new OrderEo();
        updateEo.setId(sgOrderId);
        updateEo.setSgStatus(SourceStatusEnum.CANCEL.getCode());
        updateEo.setSgFailResultDesc(cancelSourceOrderReqDto.getCancelRemark());
        OrderEo queryEo = new OrderEo();
        queryEo.setId(sgOrderId);
        UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
        updateWrapper.in((Object)"sg_status", Arrays.asList(SourceStatusEnum.WAIT_SOURCE, SourceStatusEnum.SOURCING));
        this.orderService.optimisticModifyOrderEo(updateEo, (UpdateWrapper<OrderEo>)updateWrapper, 1, true);
        return new RestResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<SourceOrderResultRespDto> idempotentAddSourceOrder(SourceOrderResultReqDto addReqDto) {
        Mutex lock = null;
        SourceOrderResultRespDto sourceOrderResultRespDto = null;
        try {
            if (Objects.nonNull(addReqDto.getId())) {
                sourceOrderResultRespDto = this.buildSourceOrderResultRespDto(this.orderService.queryById(addReqDto.getId()));
            } else {
                List<OrderRespDto> orderRespDtoList = this.orderService.queryByLinkOrderNo(addReqDto.getLinkOrderNo(), null);
                if (CollectionUtils.isNotEmpty(orderRespDtoList)) {
                    sourceOrderResultRespDto = this.matchSourceOrderRespDto(orderRespDtoList, addReqDto);
                    if (SourceStatusEnum.SOURCE_SUCCESS.getCode().equals(sourceOrderResultRespDto.getSgStatus())) {
                        this.orderOptService.abolishSourceOrder(sourceOrderResultRespDto.getId());
                        sourceOrderResultRespDto = this.idempotentAddSourceOrderInsert(addReqDto);
                    } else if (SourceStatusEnum.SOURCE_FAIL.getCode().equals(sourceOrderResultRespDto.getSgStatus()) || SourceStatusEnum.ABOLISH.getCode().equals(sourceOrderResultRespDto.getSgStatus()) || SourceStatusEnum.CANCEL.getCode().equals(sourceOrderResultRespDto.getSgStatus())) {
                        sourceOrderResultRespDto = this.idempotentAddSourceOrderInsert(addReqDto);
                    }
                } else {
                    sourceOrderResultRespDto = this.idempotentAddSourceOrderInsert(addReqDto);
                }
            }
        }
        finally {
            this.lockService.unlock(lock);
        }
        return new RestResponse((Object)sourceOrderResultRespDto);
    }

    @Override
    public RestResponse<Void> retrySource(Long sgOrderId) {
        this.sourceOrderOperation.operationSourceOrder(sgOrderId);
        return new RestResponse();
    }

    @Override
    public RestResponse<SourceOrderTestResultRespDto> sourceOptCheck(OrderDetailRespDto orderDetailRespDto) {
        SourceOrderExecuteResultVo sourceOrderExecuteResultVo = this.sourceOrderExecutor.executeSourcing(orderDetailRespDto);
        SourceOrderTestResultRespDto sourceOrderTestResultRespDto = new SourceOrderTestResultRespDto();
        CubeBeanUtils.copyProperties((Object)sourceOrderTestResultRespDto, (Object)sourceOrderExecuteResultVo.getSourceOrderResultRespDto(), (String[])new String[0]);
        sourceOrderTestResultRespDto.setSourceLogDetailRespDtoList(sourceOrderExecuteResultVo.getSourceExecuteContextVo().getSourceLogDetailRespDtoList());
        return new RestResponse((Object)sourceOrderTestResultRespDto);
    }

    private SourceOrderResultRespDto idempotentAddSourceOrderInsert(SourceOrderResultReqDto addReqDto) {
        OrderReqDto orderReqDto = new OrderReqDto();
        CubeBeanUtils.copyProperties((Object)orderReqDto, (Object)addReqDto, (String[])new String[0]);
        orderReqDto.setId(null);
        orderReqDto.setSgOrderNo(this.noGenerateUtil.generateNo("XY", 6));
        orderReqDto.setSgStatus(SourceStatusEnum.WAIT_SOURCE.getCode());
        Long orderId = this.orderService.addOrder(orderReqDto);
        List<Object> orderRespDtoList = this.orderService.queryByLinkOrderNo(addReqDto.getLinkOrderNo(), addReqDto.getLinkOrderType());
        if (CollectionUtils.isNotEmpty(orderRespDtoList) && CollectionUtils.isNotEmpty(orderRespDtoList = orderRespDtoList.stream().filter(orderRespDto -> SourceStatusEnum.WAIT_SOURCE.getCode().equals(orderRespDto.getSgStatus()) || SourceStatusEnum.SOURCING.getCode().equals(orderRespDto.getSgStatus())).filter(orderRespDto -> !orderRespDto.getId().equals(orderId)).collect(Collectors.toList()))) {
            throw SourceExceptionCode.SOURCE_EXECUTE_REPEAT_INSERT.buildBizException();
        }
        SourceOrderResultRespDto sourceOrderResultRespDto = new SourceOrderResultRespDto();
        CubeBeanUtils.copyProperties((Object)sourceOrderResultRespDto, (Object)orderReqDto, (String[])new String[0]);
        sourceOrderResultRespDto.setId(orderId);
        addReqDto.getOrderAddrReqDto().setSgOrderId(orderId);
        addReqDto.getOrderAddrReqDto().setSgOrderNo(orderReqDto.getSgOrderNo());
        addReqDto.getOrderAddrReqDto().setId(null);
        this.orderAddrService.addOrderAddr(addReqDto.getOrderAddrReqDto());
        addReqDto.getOrderItemReqDtoList().forEach(orderItemReqDto -> {
            orderItemReqDto.setId(null);
            orderItemReqDto.setSgOrderId(orderId);
            orderItemReqDto.setSgOrderNo(orderReqDto.getSgOrderNo());
        });
        this.orderItemService.batchAddOrderItem(addReqDto.getOrderItemReqDtoList());
        return sourceOrderResultRespDto;
    }

    private SourceOrderResultRespDto matchSourceOrderRespDto(List<OrderRespDto> orderRespDtoList, SourceOrderResultReqDto addReqDto) {
        SourceOrderResultRespDto finallyOrderDetailRespDto = null;
        SourceOrderResultRespDto failOrderDetailRespDto = null;
        for (OrderRespDto orderRespDto : orderRespDtoList) {
            if (Objects.nonNull(addReqDto.getId()) && !Objects.equals(orderRespDto.getId(), addReqDto.getId())) continue;
            switch (SourceStatusEnum.valueOf((String)orderRespDto.getSgStatus())) {
                case WAIT_SOURCE: 
                case SOURCING: {
                    finallyOrderDetailRespDto = this.buildSourceOrderResultRespDto(orderRespDto);
                    finallyOrderDetailRespDto.setLinkOrderChannelWarehouseId(addReqDto.getLinkOrderChannelWarehouseId());
                    finallyOrderDetailRespDto.setLinkOrderChannelWarehouseCode(addReqDto.getLinkOrderChannelWarehouseCode());
                    finallyOrderDetailRespDto.setLinkOrderChannelWarehouseName(addReqDto.getLinkOrderChannelWarehouseName());
                    break;
                }
                case SOURCE_SUCCESS: {
                    finallyOrderDetailRespDto = this.supplementSourceOrderResultRespDtoByLinkOrderNo(orderRespDto);
                    finallyOrderDetailRespDto.setLinkOrderChannelWarehouseId(addReqDto.getLinkOrderChannelWarehouseId());
                    finallyOrderDetailRespDto.setLinkOrderChannelWarehouseCode(addReqDto.getLinkOrderChannelWarehouseCode());
                    finallyOrderDetailRespDto.setLinkOrderChannelWarehouseName(addReqDto.getLinkOrderChannelWarehouseName());
                    break;
                }
                case CANCEL: 
                case SOURCE_FAIL: {
                    failOrderDetailRespDto = this.buildSourceOrderResultRespDto(orderRespDto);
                    failOrderDetailRespDto.setLinkOrderChannelWarehouseId(addReqDto.getLinkOrderChannelWarehouseId());
                    failOrderDetailRespDto.setLinkOrderChannelWarehouseCode(addReqDto.getLinkOrderChannelWarehouseCode());
                    failOrderDetailRespDto.setLinkOrderChannelWarehouseName(addReqDto.getLinkOrderChannelWarehouseName());
                }
            }
            if (!Objects.nonNull(finallyOrderDetailRespDto)) continue;
            break;
        }
        if (Objects.isNull(finallyOrderDetailRespDto) && Objects.nonNull(failOrderDetailRespDto)) {
            return failOrderDetailRespDto;
        }
        return finallyOrderDetailRespDto;
    }

    private SourceOrderResultRespDto supplementSourceOrderResultRespDtoByLinkOrderNo(OrderRespDto orderRespDto) {
        SourceOrderResultRespDto sourceOrderResultRespDto = new SourceOrderResultRespDto();
        CubeBeanUtils.copyProperties((Object)sourceOrderResultRespDto, (Object)orderRespDto, (String[])new String[0]);
        List<OrderItemResultRespDto> orderItemResultRespDtoList = this.orderItemResultService.queryByOrderId(sourceOrderResultRespDto.getId());
        if (CollectionUtils.isEmpty(orderItemResultRespDtoList)) {
            throw SourceExceptionCode.SOURCE_EXECUTE_RESULT_EMPTY.buildBizException();
        }
        sourceOrderResultRespDto.setOrderItemResultRespDtoList(orderItemResultRespDtoList);
        return sourceOrderResultRespDto;
    }

    private SourceOrderResultRespDto buildSourceOrderResultRespDto(OrderRespDto orderRespDto) {
        SourceOrderResultRespDto sourceOrderResultRespDto = new SourceOrderResultRespDto();
        CubeBeanUtils.copyProperties((Object)sourceOrderResultRespDto, (Object)orderRespDto, (String[])new String[0]);
        return sourceOrderResultRespDto;
    }

    private void checkSourceOrderStatus(OrderRespDto pcpOrderReqDto, SourceStatusEnum nowStatus, SourceStatusEnum ... allowStatus) {
        SourceStatusEnum status;
        logger.info("checkSourceOrderStatus\uff0c{}\u5f53\u524d\u72b6\u6001={},\u5141\u8bb8\u901a\u8fc7\u72b6\u6001={}", new Object[]{pcpOrderReqDto.getId(), nowStatus, JSON.toJSONString((Object)allowStatus)});
        if (allowStatus == null) {
            throw SourceExceptionCode.CHECK_ORDER_STATUS_NOT_ALLOW.buildBizException(new String[]{nowStatus.desc});
        }
        boolean inAllow = false;
        SourceStatusEnum[] sourceStatusEnumArray = allowStatus;
        int n = sourceStatusEnumArray.length;
        for (int i = 0; i < n && !(inAllow = (status = sourceStatusEnumArray[i]) == nowStatus); ++i) {
        }
        if (!inAllow) {
            throw SourceExceptionCode.CHECK_ORDER_STATUS_NOT_ALLOW.buildBizException(new String[]{nowStatus.desc});
        }
    }

    @Override
    public RestResponse<List<OrderItemResultRespDto>> saleOrderOldBatchMatch(SaleOrderOldBatchMatchReqDto reqDto) {
        List<OrderItemResultRespDto> orderItemResultRespDtos = this.sourceOrderGroupRuleCalculator.saleOrderOldBatchMatch(reqDto);
        return new RestResponse(orderItemResultRespDtos);
    }
}

