/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.calculator.impl;

import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.center.source.api.constant.ClueSuitSelectTypeEnum;
import com.dtyunxi.cube.center.source.api.constant.ClueSuitTypeEnum;
import com.dtyunxi.cube.center.source.api.constant.EnableEnum;
import com.dtyunxi.cube.center.source.api.constant.SourceFindOptTypeEnum;
import com.dtyunxi.cube.center.source.api.constant.SourceSplitLogicFlagEnum;
import com.dtyunxi.cube.center.source.api.constant.SourceStatusEnum;
import com.dtyunxi.cube.center.source.api.constant.SourceTypeEnum;
import com.dtyunxi.cube.center.source.api.dto.request.DismantleWhiteReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueActRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueSuitAttributeRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.DismantleWhiteRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderItemRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderItemResultRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.SourceOrderResultRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceAssert;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.service.IClueService;
import com.dtyunxi.cube.center.source.biz.service.IClueSuitAttributeService;
import com.dtyunxi.cube.center.source.biz.service.IClueWarehouseGroupRuleDeliveryService;
import com.dtyunxi.cube.center.source.biz.service.IDismantleWhiteService;
import com.dtyunxi.cube.center.source.biz.service.IPhysicsWarehouseDisableService;
import com.dtyunxi.cube.center.source.biz.service.ISaleOrderZtService;
import com.dtyunxi.cube.center.source.biz.service.ISplitStockRecordService;
import com.dtyunxi.cube.center.source.biz.service.calculator.SourceOrderExecutorStep;
import com.dtyunxi.cube.center.source.biz.service.calculator.SourceOrderGroupCalculator;
import com.dtyunxi.cube.center.source.biz.service.impl.WarehouseDataQuery;
import com.dtyunxi.cube.center.source.biz.utils.SourceExecuteUtils;
import com.dtyunxi.cube.center.source.biz.vo.SourceExecuteContextVo;
import com.dtyunxi.cube.center.source.biz.vo.SourceOrderExecuteResultVo;
import com.dtyunxi.cube.center.source.dao.eo.SaleOrderZtEo;
import com.dtyunxi.cube.center.source.dao.eo.SplitStockRecordEo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.IntransitCargoRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.data.api.IPcpDictApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsChannelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehousePageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseQualityEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryTotalDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehouseDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SourceOrderExecutorStepImpl
implements SourceOrderExecutorStep {
    private static final Logger logger = LoggerFactory.getLogger(SourceOrderExecutorStepImpl.class);
    private static final Set<String> ALL_MATCH_CODE_SET = new HashSet<String>();
    @Value(value="${center.source.execute.cargoEscheatage:0102}")
    private String cargoEscheatage = "0102";
    @Resource
    private WarehouseDataQuery warehouseDataQuery;
    @Resource
    private IClueSuitAttributeService clueSuitAttributeService;
    @Resource
    private IPhysicsWarehouseDisableService physicsWarehouseDisableService;
    @Resource
    private IDismantleWhiteService dismantleWhiteService;
    @Resource
    private IPcpDictApi pcpDictApi;
    @Resource
    private IClueService clueService;
    @Resource
    private SourceOrderGroupCalculator sourceOrderGroupCalculator;
    @Resource
    private IClueWarehouseGroupRuleDeliveryService clueWarehouseGroupRuleDeliveryService;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private ISplitStockRecordService splitStockRecordService;
    @Resource
    private ISaleOrderZtService saleOrderZtService;

    @Override
    public SourceExecuteContextVo buildContextStep(OrderDetailRespDto orderDetailRespDto) {
        SourceExecuteContextVo sourceExecuteContextVo = this.buildSourceExecuteContextVo(orderDetailRespDto);
        try {
            DgLogicInventoryDto csLogicWarehouseDetailRespDto = null;
            if (Objects.nonNull(sourceExecuteContextVo.getOrderDetailRespDto().getLinkOrderLogicWarehouseId())) {
                csLogicWarehouseDetailRespDto = this.warehouseDataQuery.queryCsLogicWarehousePageRespDtoByWarehouseId(sourceExecuteContextVo.getOrderDetailRespDto().getLinkOrderLogicWarehouseId());
                sourceExecuteContextVo.setDefaultCsLogicWarehouseDetailRespDto(csLogicWarehouseDetailRespDto);
            }
            String organizationCode = sourceExecuteContextVo.getOrderDetailRespDto().getOrganizationCode();
            if (StringUtils.isNotEmpty((CharSequence)orderDetailRespDto.getStoragePlace())) {
                List<CsLogicWarehouseRespDto> csLogicWarehouseRespDtos = this.warehouseDataQuery.queryLogicWarehouseRefByvirtualWarehouseCode(orderDetailRespDto.getStoragePlace());
                SourceAssert.notEmpty(csLogicWarehouseRespDtos, (SourceExceptionCode)SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_EMPTY, (String[])new String[]{"\u4f9b\u8d27\u4ed3\u5bf9\u5e94\u903b\u8f91\u4ed3", orderDetailRespDto.getStoragePlace()});
                sourceExecuteContextVo.setRdcLogicWarehousePageRespDtoList(csLogicWarehouseRespDtos);
                logger.info("\u6307\u5b9aRDC\u4e0b\u7684\u903b\u8f91\u4ed3\u96c6\u5408={}", JSON.toJSON(csLogicWarehouseRespDtos));
                if (Objects.equals(orderDetailRespDto.getSgSourceCanSplit(), 0)) {
                    Set<String> ztCodeSet = csLogicWarehouseRespDtos.stream().filter(dto -> Objects.equals(dto.getWarehouseClassify(), CsWarehouseClassifyEnum.IN_TRANSIT.getCode())).map(CsLogicWarehouseRespDto::getWarehouseCode).collect(Collectors.toSet());
                    sourceExecuteContextVo.setCurrentZtLogicCodeSet(ztCodeSet);
                }
            }
            CsChannelWarehouseRespDto channelWarehouseRespDto = this.warehouseDataQuery.queryChannelWarehouseRespDtoByWarehouseId(sourceExecuteContextVo.getOrderDetailRespDto().getLinkOrderChannelWarehouseId());
            logger.info("[\u6e20\u9053\u4ed3\u4fe1\u606f]\uff1a{}", (Object)JSON.toJSONString((Object)channelWarehouseRespDto));
            sourceExecuteContextVo.setCsChannelWarehouseRespDto(channelWarehouseRespDto);
            List<ChannelWarehouseRespDto> channelWarehouseRespDtos = this.warehouseDataQuery.queryChannelWarehouseByChannelCode(sourceExecuteContextVo.getOrderDetailRespDto().getLinkOrderChannelWarehouseCode());
            if (CollectionUtils.isEmpty(channelWarehouseRespDtos)) {
                throw SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_ERROR.buildBizException(new String[]{"\u5171\u4eab\u4e2d\u5fc3\u6e20\u9053\u4ed3"});
            }
            ChannelWarehouseRespDto shareChannelWarehouseRespDto = channelWarehouseRespDtos.get(0);
            sourceExecuteContextVo.setShareChannelWarehouseRespDto(shareChannelWarehouseRespDto);
            List logicWarehouseList = shareChannelWarehouseRespDto.getLogicWarehouseList();
            if (CollectionUtils.isEmpty((Collection)logicWarehouseList)) {
                throw SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_ERROR.buildBizException(new String[]{"\u5171\u4eab\u4e2d\u5fc3\u6e20\u9053\u4ed3\u5173\u8054\u7684\u903b\u8f91\u4ed3\u4fe1\u606f"});
            }
            Set<String> ztCodeSet = logicWarehouseList.stream().filter(dto -> Objects.equals(dto.getWarehouseClassify(), CsWarehouseClassifyEnum.IN_TRANSIT.getCode())).map(CsLogicWarehouseRespDto::getWarehouseCode).collect(Collectors.toSet());
            sourceExecuteContextVo.setCurrentChannelZtLogicCodeSet(ztCodeSet);
            logger.info("\u5728\u9014\u4ed3\u7c7b\u578b\u903b\u8f91\u4ed3\u96c6\u5408:{}", (Object)JSON.toJSONString(ztCodeSet));
            if (StringUtils.isEmpty((CharSequence)orderDetailRespDto.getStoragePlace()) || Objects.equals(orderDetailRespDto.getSgSourceCanSplit(), 1)) {
                sourceExecuteContextVo.setCurrentZtLogicCodeSet(ztCodeSet);
            }
            sourceExecuteContextVo.setPhysicsWarehouseDisableRespDtoList(this.physicsWarehouseDisableService.queryList());
            List dictDtoList = (List)RestResponseHelper.extractData((RestResponse)this.pcpDictApi.queryByGroupCode("COMMON_CONFIG"));
            sourceExecuteContextVo.setDictDtoMap(dictDtoList.stream().collect(Collectors.toMap(DictDto::getCode, v1 -> v1, (v1, v2) -> v1)));
        }
        catch (BizException e) {
            throw e;
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), (Throwable)exception);
            throw SourceExceptionCode.NORMAL_EXCEPTION.buildBizException(new String[]{"\u6784\u5efa\u5bfb\u6e90\u57fa\u7840\u6570\u636e\u5931\u8d25" + exception.getMessage()});
        }
        return sourceExecuteContextVo;
    }

    @Override
    public Set<Long> matchSourceClueListStep(SourceExecuteContextVo sourceExecuteContextVo) {
        HashSet<String> matchCodeList = new HashSet<String>(ALL_MATCH_CODE_SET);
        matchCodeList.add(this.buildSuitMatchCode(ClueSuitSelectTypeEnum.SELECT.getCode(), ClueSuitTypeEnum.HIT_ORDER_TYPE.getCode(), sourceExecuteContextVo.getOrderDetailRespDto().getLinkOrderType()));
        matchCodeList.add(this.buildSuitMatchCode(ClueSuitSelectTypeEnum.SELECT.getCode(), ClueSuitTypeEnum.HIT_CUSTOMER.getCode(), sourceExecuteContextVo.getOrderDetailRespDto().getLinkOrderCustomerId()));
        matchCodeList.add(this.buildSuitMatchCode(ClueSuitSelectTypeEnum.SELECT.getCode(), ClueSuitTypeEnum.HIT_CHANNEL.getCode(), sourceExecuteContextVo.getOrderDetailRespDto().getLinkOrderChannelId()));
        matchCodeList.add(this.buildSuitMatchCode(ClueSuitSelectTypeEnum.SELECT.getCode(), ClueSuitTypeEnum.HIT_WAREHOUSE.getCode(), sourceExecuteContextVo.getOrderDetailRespDto().getLinkOrderLogicWarehouseId()));
        matchCodeList.add(this.buildSuitMatchCode(ClueSuitSelectTypeEnum.SELECT.getCode(), ClueSuitTypeEnum.HIT_ORGANIZATION.getCode(), sourceExecuteContextVo.getOrderDetailRespDto().getOrganizationId()));
        matchCodeList.add(this.buildSuitMatchCode(ClueSuitSelectTypeEnum.SELECT.getCode(), ClueSuitTypeEnum.HIT_CHANNEL_WAREHOUSE.getCode(), sourceExecuteContextVo.getOrderDetailRespDto().getLinkOrderChannelWarehouseId()));
        matchCodeList.add(this.buildSuitMatchCode(ClueSuitSelectTypeEnum.SELECT.getCode(), ClueSuitTypeEnum.HIT_VIRTUAL_WAREHOUSE.getCode(), sourceExecuteContextVo.getOrderDetailRespDto().getStoragePlace()));
        List<ClueSuitAttributeRespDto> matchClueIdList = this.clueSuitAttributeService.queryListByMatchSuitCodeList(matchCodeList);
        SourceAssert.notEmpty(matchClueIdList, (SourceExceptionCode)SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_EMPTY, (String[])new String[]{"\u5bfb\u6e90\u7b56\u7565", sourceExecuteContextVo.getOrderDetailRespDto().getLinkOrderNo()});
        Map<Long, List<ClueSuitAttributeRespDto>> clueSuitMap = matchClueIdList.stream().collect(Collectors.groupingBy(ClueSuitAttributeRespDto::getSgClueId));
        HashSet<Long> matchClueIdSet = new HashSet<Long>();
        clueSuitMap.forEach((k, v) -> {
            if (this.matchAllSuitCode((List<ClueSuitAttributeRespDto>)v)) {
                matchClueIdSet.add((Long)k);
            }
        });
        sourceExecuteContextVo.setMatchClueIdSet(matchClueIdSet);
        return matchClueIdSet;
    }

    @Override
    public SourceOrderResultRespDto calculationSourceResultStep(SourceExecuteContextVo sourceExecuteContextVo) {
        SourceOrderResultRespDto sourceOrderResultRespDto;
        block2: {
            if (CollectionUtils.isEmpty(sourceExecuteContextVo.getMatchClueIdSet())) {
                SourceOrderResultRespDto sourceOrderResultRespDto2 = this.buildFailSourceOrderResultRespDto(sourceExecuteContextVo.getOrderDetailRespDto());
                SourceExecuteUtils.completionSourceOrderResultRespDtoByFailMsg(SourceFindOptTypeEnum.CAL_WAREHOUSE_GROUP, sourceExecuteContextVo, sourceOrderResultRespDto2, "\u5339\u914d\u4e0d\u5230\u5bfb\u6e90\u7b56\u7565");
                return sourceOrderResultRespDto2;
            }
            logger.info("\u3010\u521d\u7b5b\u83b7\u53d6\u5230\u7b56\u7565\u96c6\u5408id\u3011matchClueIdSet={}", (Object)JSON.toJSONString(sourceExecuteContextVo.getMatchClueIdSet()));
            List<ClueActRespDto> clueActRespDtoList = this.clueService.queryOrderByClueIdList(sourceExecuteContextVo.getMatchClueIdSet());
            if (CollectionUtils.isEmpty(clueActRespDtoList)) {
                SourceOrderResultRespDto sourceOrderResultRespDto3 = this.buildFailSourceOrderResultRespDto(sourceExecuteContextVo.getOrderDetailRespDto());
                SourceExecuteUtils.completionSourceOrderResultRespDtoByFailMsg(SourceFindOptTypeEnum.CAL_WAREHOUSE_GROUP, sourceExecuteContextVo, sourceOrderResultRespDto3, "\u67e5\u627e\u4e0d\u5230\u5bfb\u6e90\u7b56\u7565\u6570\u636e");
                return sourceOrderResultRespDto3;
            }
            sourceExecuteContextVo.setClueActRespDtoList(clueActRespDtoList);
            sourceOrderResultRespDto = null;
            Iterator<ClueActRespDto> iterator = clueActRespDtoList.iterator();
            if (!iterator.hasNext()) break block2;
            ClueActRespDto clueActRespDto = iterator.next();
            sourceExecuteContextVo.setCurrentClueActRespDto(clueActRespDto);
            SourceExecuteUtils.saveOrderResourceLog(SourceFindOptTypeEnum.HIT_CLUE, sourceExecuteContextVo, SourceFindOptTypeEnum.HIT_CLUE.getDesc() + " " + "\u3010" + clueActRespDto.getClueCode() + "\u3011");
            sourceOrderResultRespDto = this.sourceOrderGroupCalculator.calculationSourceGroup(sourceExecuteContextVo);
            SourceAssert.notNull((Object)sourceOrderResultRespDto, (SourceExceptionCode)SourceExceptionCode.SOURCE_EXECUTE_CLUE_EXECUTE_RESULT_ERROR, (String[])new String[]{clueActRespDto.getClueCode(), "\u6267\u884c\u7ed3\u679c\u4e3a\u7a7a"});
        }
        return sourceOrderResultRespDto;
    }

    @Override
    public SourceOrderExecuteResultVo matchNotSplitOrderWhiteListStep(SourceExecuteContextVo sourceExecuteContextVo, SourceOrderResultRespDto sourceOrderResultRespDto) {
        Map<Long, List<OrderItemResultRespDto>> itemGroupMap;
        SourceOrderExecuteResultVo sourceOrderExecuteResultVo = new SourceOrderExecuteResultVo();
        sourceOrderExecuteResultVo.setSourceExecuteContextVo(sourceExecuteContextVo);
        sourceOrderExecuteResultVo.setSourceOrderResultRespDto(sourceOrderResultRespDto);
        if (sourceOrderResultRespDto.getSgStatus().equals(SourceStatusEnum.SOURCE_SUCCESS.getCode()) && (itemGroupMap = sourceOrderResultRespDto.getOrderItemResultRespDtoList().stream().collect(Collectors.groupingBy(OrderItemResultRespDto::getDeliveryLogicWarehouseId))).size() > 1) {
            this.doAddSplitStock(sourceExecuteContextVo);
            if (StringUtils.isEmpty((CharSequence)sourceExecuteContextVo.getOrderDetailRespDto().getStoragePlace()) && !Objects.equals(sourceExecuteContextVo.getOrderDetailRespDto().getSourceType(), SourceTypeEnum.REPLENISHMENT.getCode()) && Objects.equals(0, sourceExecuteContextVo.getOrderDetailRespDto().getSgSourceCanSplit())) {
                SourceExecuteUtils.completionSourceOrderResultRespDtoByFailMsg(SourceFindOptTypeEnum.ORDER_SPILT_CHECK, sourceExecuteContextVo, sourceOrderResultRespDto, "\u539f\u5355\u4e0d\u5141\u8bb8\u62c6\u5355");
                return sourceOrderExecuteResultVo;
            }
            if ("YYJ".equals(sourceExecuteContextVo.getOrderDetailRespDto().getLinkOrderChannelCode())) {
                SourceExecuteUtils.completionSourceOrderResultRespDtoByFailMsg(SourceFindOptTypeEnum.ORDER_SPILT_CHECK, sourceExecuteContextVo, sourceOrderResultRespDto, "\u539f\u5355\u4e0d\u5141\u8bb8\u62c6\u5355");
                return sourceOrderExecuteResultVo;
            }
            int orderNum = itemGroupMap.size();
            String linkOrderNo = sourceExecuteContextVo.getOrderDetailRespDto().getLinkOrderNo();
            logger.info("\u62c6\u5206\u8ba2\u5355{},\u5546\u54c1\u884c\u6570\u91cf:{}", (Object)linkOrderNo, (Object)orderNum);
            BizSaleOrderRespDto bizSaleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(sourceExecuteContextVo.getOrderDetailRespDto().getLinkOrderNo()));
            if (StringUtils.isNotEmpty((CharSequence)bizSaleOrderRespDto.getMainOrderNo())) {
                SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
                saleOrderQueryReqDto.setMainOrderNo(bizSaleOrderRespDto.getMainOrderNo());
                saleOrderQueryReqDto.setNotOrderStatusList((List)Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.OBSOLETE.getCode(), SaleOrderStatusEnum.SPLIT.getCode()}));
                List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByParamList(saleOrderQueryReqDto));
                logger.info("\u83b7\u53d6\u4e3b\u5355\u4e0b\u7684\u6240\u6709\u6709\u6548\u5b50\u5355(\u9664\u5df2\u4f5c\u5e9f\u548c\u88ab\u62c6\u5206\u72b6\u6001)size={}", (Object)saleOrderRespDtos.size());
                if (CollectionUtils.isNotEmpty((Collection)saleOrderRespDtos)) {
                    List childOrderList = saleOrderRespDtos.stream().filter(dto -> !Objects.equals(dto.getSaleOrderNo(), linkOrderNo)).collect(Collectors.toList());
                    logger.info("\u6392\u67e5\u5bfb\u6e90\u5355\u53f7\u540e\u5269\u4f59\u6570\u91cf={}", (Object)saleOrderRespDtos.size());
                    int childOrderNum = childOrderList.size();
                    orderNum += childOrderNum;
                }
            }
            logger.info("\u5bfb\u6e90\u62c6\u5355\u540e\u539f\u5355\u6709\u6548\u603b\u6570\u91cf={}", (Object)orderNum);
            if (Objects.equals(EnableEnum.ENABLE.getCode(), sourceExecuteContextVo.getCurrentClueActRespDto().getClueDismantleEnable()) && sourceExecuteContextVo.getCurrentClueActRespDto().getClueDismantleCount() < orderNum) {
                SourceExecuteUtils.completionSourceOrderResultRespDtoByFailMsg(SourceFindOptTypeEnum.ORDER_SPILT_CHECK, sourceExecuteContextVo, sourceOrderResultRespDto, "\u62c6\u5355\u6570\u91cf\u8d85\u8fc7\u7b56\u7565\u914d\u7f6e");
                return sourceOrderExecuteResultVo;
            }
            DismantleWhiteReqDto dismantleWhiteReqDto = new DismantleWhiteReqDto();
            dismantleWhiteReqDto.setCustomerId(sourceExecuteContextVo.getOrderDetailRespDto().getLinkOrderCustomerId());
            List<DismantleWhiteRespDto> dismantleWhiteRespDtoList = this.dismantleWhiteService.queryList(dismantleWhiteReqDto);
            if (CollectionUtils.isNotEmpty(dismantleWhiteRespDtoList)) {
                SourceExecuteUtils.completionSourceOrderResultRespDtoByFailMsg(SourceFindOptTypeEnum.ORDER_SPILT_CHECK, sourceExecuteContextVo, sourceOrderResultRespDto, "\u5339\u914d\u5230\u4e0d\u62c6\u5355\u767d\u540d\u5355\uff0c\u4e0d\u5141\u8bb8\u62c6\u5355");
                return sourceOrderExecuteResultVo;
            }
        }
        return sourceOrderExecuteResultVo;
    }

    private SourceExecuteContextVo buildSourceExecuteContextVo(OrderDetailRespDto orderDetailRespDto) {
        SourceExecuteContextVo contextVo = new SourceExecuteContextVo();
        contextVo.setOrderDetailRespDto(orderDetailRespDto);
        ArrayList<OrderItemRespDto> surplusOrderItemRespDtoList = new ArrayList<OrderItemRespDto>();
        CubeBeanUtils.copyCollection(surplusOrderItemRespDtoList, (Collection)orderDetailRespDto.getOrderItemRespDtoList(), OrderItemRespDto.class);
        surplusOrderItemRespDtoList.forEach(e -> e.setOrigItemNum(e.getItemNum()));
        contextVo.setSurplusOrderItemRespDtoList(surplusOrderItemRespDtoList);
        return contextVo;
    }

    private SourceOrderResultRespDto buildFailSourceOrderResultRespDto(OrderDetailRespDto orderDetailRespDto) {
        SourceOrderResultRespDto sourceOrderResultRespDto = new SourceOrderResultRespDto();
        CubeBeanUtils.copyProperties((Object)sourceOrderResultRespDto, (Object)orderDetailRespDto, (String[])new String[0]);
        sourceOrderResultRespDto.setSgStatus(SourceStatusEnum.SOURCE_FAIL.getCode());
        return sourceOrderResultRespDto;
    }

    private String buildSuitMatchCode(String selectType, String suitType, Object key) {
        return selectType + "_" + suitType + "_" + key;
    }

    private boolean matchAllSuitCode(List<ClueSuitAttributeRespDto> clueSuitAttributeRespDtoList) {
        Map<String, List<ClueSuitAttributeRespDto>> clueSuitAttributeRespDtoMap = clueSuitAttributeRespDtoList.stream().collect(Collectors.groupingBy(ClueSuitAttributeRespDto::getSgSuitType));
        List<ClueSuitAttributeRespDto> hisChannel = clueSuitAttributeRespDtoMap.get(ClueSuitTypeEnum.HIT_CHANNEL.getCode());
        List<ClueSuitAttributeRespDto> hisCustomer = clueSuitAttributeRespDtoMap.get(ClueSuitTypeEnum.HIT_CUSTOMER.getCode());
        List<ClueSuitAttributeRespDto> hisWareHouse = clueSuitAttributeRespDtoMap.get(ClueSuitTypeEnum.HIT_WAREHOUSE.getCode());
        List<ClueSuitAttributeRespDto> hisOrderType = clueSuitAttributeRespDtoMap.get(ClueSuitTypeEnum.HIT_ORDER_TYPE.getCode());
        List<ClueSuitAttributeRespDto> hisOrganiztion = clueSuitAttributeRespDtoMap.get(ClueSuitTypeEnum.HIT_ORGANIZATION.getCode());
        List<ClueSuitAttributeRespDto> hisChannelWarehouse = clueSuitAttributeRespDtoMap.get(ClueSuitTypeEnum.HIT_CHANNEL_WAREHOUSE.getCode());
        List<ClueSuitAttributeRespDto> hisVirtualWarehouse = clueSuitAttributeRespDtoMap.get(ClueSuitTypeEnum.HIT_VIRTUAL_WAREHOUSE.getCode());
        return !CollectionUtils.isEmpty(hisChannel) && !CollectionUtils.isEmpty(hisCustomer) && !CollectionUtils.isEmpty(hisWareHouse) && !CollectionUtils.isEmpty(hisOrderType) && !CollectionUtils.isEmpty(hisOrganiztion) && !CollectionUtils.isEmpty(hisChannelWarehouse) && !CollectionUtils.isEmpty(hisVirtualWarehouse);
    }

    private void doAddSplitStock(SourceExecuteContextVo sourceExecuteContextVo) {
        logger.info("\u8bb0\u5f55\u5bfb\u6e90\u62c6\u5355\u7ed3\u679c\u5206\u6790---------------------");
        String reqId = ServiceContext.getContext().getAttachment("yes.req.requestId");
        ServiceContext context = ServiceContext.getContext();
        CompletableFuture.runAsync(() -> {
            MDC.put((String)"yes.req.requestId", (String)reqId);
            context.getAttachments().forEach((k, v) -> ServiceContext.getContext().setAttachment(k, v));
            try {
                this.saveSplitStockInfo(sourceExecuteContextVo);
            }
            catch (Exception e) {
                logger.info("\u8bb0\u5f55\u5bfb\u6e90\u62c6\u5355\u7ed3\u679c\u5206\u6790\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        });
    }

    private void saveSplitStockInfo(SourceExecuteContextVo sourceExecuteContextVo) {
        List<DgLogicInventoryTotalDto> csLogicInventoryTotalRespDtos;
        OrderDetailRespDto orderDetailRespDto = sourceExecuteContextVo.getOrderDetailRespDto();
        List orderItemRespDtoList = orderDetailRespDto.getOrderItemRespDtoList();
        Set skuCodeSet = orderItemRespDtoList.stream().map(OrderItemRespDto::getItemSkuCode).collect(Collectors.toSet());
        List<CsLogicWarehouseRespDto> rdcLogicWarehousePageRespDtoList = sourceExecuteContextVo.getRdcLogicWarehousePageRespDtoList();
        List<Object> targeLogicWarehouseList = Lists.newArrayList();
        ArrayList djLogicWarehouseList = Lists.newArrayList();
        ArrayList ztLogicWarehouseList = Lists.newArrayList();
        ArrayList ztHgLogicWarehouseList = Lists.newArrayList();
        ArrayList ztHgBLogicWarehouseList = Lists.newArrayList();
        HashSet<String> warehouseCodeSet = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(rdcLogicWarehousePageRespDtoList)) {
            List<String> logicWarehouseCodeList = rdcLogicWarehousePageRespDtoList.stream().map(CsLogicWarehouseRespDto::getWarehouseCode).collect(Collectors.toList());
            targeLogicWarehouseList = this.warehouseDataQuery.queryCsLogicWarehousePageRespDtoListByCodeList(logicWarehouseCodeList);
            targeLogicWarehouseList = targeLogicWarehouseList.stream().filter(dto -> Objects.equals(dto.getCargoEscheatageId(), orderDetailRespDto.getOrganizationCode()) && Objects.equals(dto.getWarehouseQuality(), CsLogicWarehouseQualityEnum.QUALIFIED.getCode()) && Objects.equals(dto.getWarehouseClassify(), CsWarehouseClassifyEnum.LOGIC.getCode())).collect(Collectors.toList());
        }
        logger.info("\u76ee\u6807\u4ed3\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)targeLogicWarehouseList));
        if (CollectionUtils.isNotEmpty((Collection)targeLogicWarehouseList)) {
            this.getLogicWarehouseRespDtos((List<DgLogicWarehouseDto>)targeLogicWarehouseList, djLogicWarehouseList, warehouseCodeSet, ztLogicWarehouseList, ztHgLogicWarehouseList, ztHgBLogicWarehouseList);
        }
        Map<Object, Object> stockNumMap = new HashMap();
        if (!warehouseCodeSet.isEmpty() && CollectionUtils.isNotEmpty(csLogicInventoryTotalRespDtos = this.warehouseDataQuery.queryZtInventoryBalanceByRuleVo(Lists.newArrayList(warehouseCodeSet), Lists.newArrayList(skuCodeSet)))) {
            stockNumMap = csLogicInventoryTotalRespDtos.stream().collect(Collectors.groupingBy(DgLogicInventoryTotalDto::getSkuCode));
        }
        Map itemSkuGroupMap = orderItemRespDtoList.stream().collect(Collectors.toMap(OrderItemRespDto::getItemSkuCode, Function.identity(), (k1, k2) -> {
            k1.setItemNum(k1.getItemNum().add(k2.getItemNum()));
            return k1;
        }));
        Collection orderItemList = itemSkuGroupMap.values();
        ArrayList addEoList = Lists.newArrayList();
        for (OrderItemRespDto orderItemRespDto : orderItemList) {
            List logicStockList = (List)Optional.ofNullable(stockNumMap.get(orderItemRespDto.getItemSkuCode())).orElse(Lists.newArrayList());
            SplitStockRecordEo splitStockRecordEo = this.getSplitStockRecordEo(orderDetailRespDto, orderItemRespDto);
            if (CollectionUtils.isNotEmpty((Collection)targeLogicWarehouseList)) {
                DgLogicWarehouseDto csLogicWarehousePageRespDto = (DgLogicWarehouseDto)targeLogicWarehouseList.get(0);
                splitStockRecordEo.setSgLogicWarehouseId(csLogicWarehousePageRespDto.getId());
                splitStockRecordEo.setSgLogicWarehouseCode(csLogicWarehousePageRespDto.getWarehouseCode());
                splitStockRecordEo.setSgLogicWarehouseName(csLogicWarehousePageRespDto.getWarehouseName());
                this.setStockNumInfo(djLogicWarehouseList, ztLogicWarehouseList, logicStockList, splitStockRecordEo, csLogicWarehousePageRespDto, ztHgLogicWarehouseList, ztHgBLogicWarehouseList);
                this.calculationStockFlag(splitStockRecordEo);
            }
            addEoList.add(splitStockRecordEo);
        }
        this.splitStockRecordService.addSplitStockRecordBatch(addEoList);
    }

    private void getLogicWarehouseRespDtos(List<DgLogicWarehouseDto> targeLogicWarehouseList, List<DgLogicWarehouseDto> djLogicWarehouseList, Set<String> warehouseCodeSet, List<LogicWarehouseRespDto> ztLogicWarehouseList, List<DgLogicWarehouseDto> ztHgLogicWarehouseList, List<DgLogicWarehouseDto> ztHgBLogicWarehouseList) {
        DgLogicWarehouseDto csLogicWarehousePageRespDto = targeLogicWarehouseList.get(0);
        warehouseCodeSet.add(csLogicWarehousePageRespDto.getWarehouseCode());
        Set targePhysiceWarehouseCodeSet = targeLogicWarehouseList.stream().map(DgLogicWarehouseDto::getPhysicsWarehouseCode).collect(Collectors.toSet());
        List<DgLogicWarehouseDto> dgLogicWarehouseDtos = this.warehouseDataQuery.queryLogicWarehouseByPhysicsCodes(Lists.newArrayList(targePhysiceWarehouseCodeSet));
        Map<Object, Object> physiceByLogicMap = new HashMap();
        if (CollectionUtils.isNotEmpty(dgLogicWarehouseDtos)) {
            physiceByLogicMap = dgLogicWarehouseDtos.stream().collect(Collectors.groupingBy(DgLogicWarehouseDto::getPhysicsWarehouseCode));
        }
        for (String physiceWarehouseCode : targePhysiceWarehouseCodeSet) {
            if (physiceByLogicMap.isEmpty() || !physiceByLogicMap.containsKey(physiceWarehouseCode)) {
                logger.info("\u7269\u7406\u4ed3:{}\u4e0b\u7684\u903b\u8f91\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)physiceWarehouseCode);
                continue;
            }
            List csLogicWarehousePageRespDtos = (List)physiceByLogicMap.get(physiceWarehouseCode);
            List djLogicWarehouseDtoList = csLogicWarehousePageRespDtos.stream().filter(dto -> Objects.equals(dto.getCargoEscheatageId(), this.cargoEscheatage) && Objects.equals(dto.getWarehouseQuality(), CsLogicWarehouseQualityEnum.WAIT_INSPECTION.getCode())).collect(Collectors.toList());
            djLogicWarehouseList.addAll(djLogicWarehouseDtoList);
            warehouseCodeSet.addAll(djLogicWarehouseDtoList.stream().map(DgLogicWarehouseDto::getWarehouseCode).collect(Collectors.toSet()));
            List ztHgLogicWarehouseDtos = csLogicWarehousePageRespDtos.stream().filter(dto -> Objects.equals(dto.getWarehouseQuality(), CsLogicWarehouseQualityEnum.QUALIFIED.getCode())).filter(dto -> Objects.equals(dto.getWarehouseType(), CsWarehouseTypeEnum.TCBJ_B.getCode()) || Objects.equals(dto.getWarehouseType(), CsWarehouseTypeEnum.TCBJ_C.getCode())).filter(dto -> Objects.equals(dto.getWarehouseClassify(), CsWarehouseClassifyEnum.LOGIC.getCode()) || Objects.equals(dto.getWarehouseClassify(), CsWarehouseClassifyEnum.IN_TRANSIT.getCode())).collect(Collectors.toList());
            ztHgLogicWarehouseList.addAll(ztHgLogicWarehouseDtos);
            warehouseCodeSet.addAll(ztHgLogicWarehouseDtos.stream().map(DgLogicWarehouseDto::getWarehouseCode).collect(Collectors.toSet()));
            List ztHgBLogicWarehouseDtos = csLogicWarehousePageRespDtos.stream().filter(dto -> Objects.equals(dto.getWarehouseQuality(), CsLogicWarehouseQualityEnum.QUALIFIED.getCode())).filter(dto -> Objects.equals(dto.getWarehouseType(), CsWarehouseTypeEnum.TCBJ_B.getCode())).filter(dto -> Objects.equals(dto.getWarehouseClassify(), CsWarehouseClassifyEnum.LOGIC.getCode()) || Objects.equals(dto.getWarehouseClassify(), CsWarehouseClassifyEnum.IN_TRANSIT.getCode())).collect(Collectors.toList());
            ztHgBLogicWarehouseList.addAll(ztHgBLogicWarehouseDtos);
            warehouseCodeSet.addAll(ztHgBLogicWarehouseDtos.stream().map(DgLogicWarehouseDto::getWarehouseCode).collect(Collectors.toSet()));
        }
        if (StringUtils.isNotEmpty((CharSequence)csLogicWarehousePageRespDto.getWarehouseCode())) {
            ztLogicWarehouseList.addAll(this.warehouseDataQuery.queryZtWarehouseBylogicCode(Lists.newArrayList((Object[])new String[]{csLogicWarehousePageRespDto.getWarehouseCode()})));
            Set ztCodeSet = ztLogicWarehouseList.stream().map(LogicWarehouseRespDto::getWarehouseCode).collect(Collectors.toSet());
            warehouseCodeSet.addAll(ztCodeSet);
            logger.info("\u6839\u636e\u76ee\u6807\u4ed3\u67e5\u8be2\u5728\u9014\u4ed3:{},{}", (Object)csLogicWarehousePageRespDto.getWarehouseCode(), JSON.toJSON(ztCodeSet));
        }
    }

    private void setStockNumInfo(List<DgLogicWarehouseDto> djLogicWarehouseList, List<LogicWarehouseRespDto> ztLogicWarehouseList, List<DgLogicInventoryTotalDto> logicStockList, SplitStockRecordEo splitStockRecordEo, DgLogicWarehouseDto csLogicWarehousePageRespDto, List<DgLogicWarehouseDto> ztHgLogicWarehouseList, List<DgLogicWarehouseDto> ztHgBLogicWarehouseList) {
        List sgLogicStockList = logicStockList.stream().filter(dto -> dto.getWarehouseCode().equals(csLogicWarehousePageRespDto.getWarehouseCode())).collect(Collectors.toList());
        logger.info("\u76ee\u6807\u903b\u8f91\u4ed3\u53ef\u7528\u5e93\u5b58\u4fe1\u606f=={}", (Object)JSON.toJSONString(sgLogicStockList));
        if (CollectionUtils.isNotEmpty(sgLogicStockList)) {
            BigDecimal sgLogicStockNum = sgLogicStockList.stream().map(DgLogicInventoryTotalDto::getAvailable).reduce(BigDecimal.ZERO, BigDecimal::add);
            splitStockRecordEo.setSgLogicStockNum(sgLogicStockNum);
        }
        if (CollectionUtils.isNotEmpty(djLogicWarehouseList)) {
            List djLogicWarehouseCodeList = djLogicWarehouseList.stream().map(DgLogicWarehouseDto::getWarehouseCode).collect(Collectors.toList());
            logger.info("\u5f85\u68c0\u4ed3\u7f16\u7801=={}", (Object)JSON.toJSONString(djLogicWarehouseCodeList));
            List djLogicStockList = logicStockList.stream().filter(dto -> djLogicWarehouseCodeList.contains(dto.getWarehouseCode())).collect(Collectors.toList());
            logger.info("\u5f85\u68c0\u4ed3\u53ef\u7528\u5e93\u5b58\u4fe1\u606f=={}", (Object)JSON.toJSONString(djLogicStockList));
            if (CollectionUtils.isNotEmpty(djLogicStockList)) {
                BigDecimal djLogicStockNum = djLogicStockList.stream().map(DgLogicInventoryTotalDto::getAvailable).reduce(BigDecimal.ZERO, BigDecimal::add);
                splitStockRecordEo.setSgDjStockNum(djLogicStockNum);
            }
        }
        if (CollectionUtils.isNotEmpty(ztLogicWarehouseList)) {
            List ztLogicWarehouseCodeList = ztLogicWarehouseList.stream().map(LogicWarehouseRespDto::getWarehouseCode).collect(Collectors.toList());
            logger.info("\u5728\u9014\u4ed3\u7f16\u7801=={}", (Object)JSON.toJSONString(ztLogicWarehouseCodeList));
            List ztLogicStockList = logicStockList.stream().filter(dto -> ztLogicWarehouseCodeList.contains(dto.getWarehouseCode())).collect(Collectors.toList());
            logger.info("\u5728\u9014\u4ed3\u53ef\u7528\u5e93\u5b58\u4fe1\u606f=={}", (Object)JSON.toJSONString(ztLogicStockList));
            if (CollectionUtils.isNotEmpty(ztLogicStockList)) {
                BigDecimal ztLogicStockNum = ztLogicStockList.stream().map(DgLogicInventoryTotalDto::getAvailable).reduce(BigDecimal.ZERO, BigDecimal::add);
                splitStockRecordEo.setSgZtStockNum(ztLogicStockNum);
            }
        }
        if (CollectionUtils.isNotEmpty(ztHgLogicWarehouseList)) {
            List ztHgLogicWarehouseCodeList = ztHgLogicWarehouseList.stream().map(DgLogicWarehouseDto::getWarehouseCode).collect(Collectors.toList());
            logger.info("\u540c\u7269\u7406\u4ed3\u4e0b\u903b\u8f91\u4ed3\u5728\u9014\u5408\u683c\u4ed3\u7f16\u7801=={}", (Object)JSON.toJSONString(ztHgLogicWarehouseCodeList));
            List ztHgLogicStockList = logicStockList.stream().filter(dto -> ztHgLogicWarehouseCodeList.contains(dto.getWarehouseCode())).collect(Collectors.toList());
            logger.info("\u540c\u7269\u7406\u4ed3\u4e0b\u903b\u8f91\u4ed3\u5728\u9014\u5408\u683c\u4ed3\u53ef\u7528\u5e93\u5b58\u4fe1\u606f=={}", (Object)JSON.toJSONString(ztHgLogicStockList));
            if (CollectionUtils.isNotEmpty(ztHgLogicStockList)) {
                BigDecimal ztHgLogicStockNum = ztHgLogicStockList.stream().map(DgLogicInventoryTotalDto::getAvailable).reduce(BigDecimal.ZERO, BigDecimal::add);
                splitStockRecordEo.setLogicZtHgStockNum(ztHgLogicStockNum);
            }
        }
        if (CollectionUtils.isNotEmpty(ztHgBLogicWarehouseList)) {
            List ztHgBLogicWarehouseCodeList = ztHgBLogicWarehouseList.stream().map(DgLogicWarehouseDto::getWarehouseCode).collect(Collectors.toList());
            logger.info("\u540c\u7269\u7406\u4ed3\u4e0b\u903b\u8f91\u4ed3\u5728\u9014\u5408\u683cB\u4ed3\u7f16\u7801=={}", (Object)JSON.toJSONString(ztHgBLogicWarehouseCodeList));
            List ztHgBLogicStockList = logicStockList.stream().filter(dto -> ztHgBLogicWarehouseCodeList.contains(dto.getWarehouseCode())).collect(Collectors.toList());
            logger.info("\u540c\u7269\u7406\u4ed3\u4e0b\u903b\u8f91\u4ed3\u5728\u9014\u5408\u683cB\u4ed3\u53ef\u7528\u5e93\u5b58\u4fe1\u606f=={}", (Object)JSON.toJSONString(ztHgBLogicStockList));
            if (CollectionUtils.isNotEmpty(ztHgBLogicStockList)) {
                BigDecimal ztHgBLogicStockNum = ztHgBLogicStockList.stream().map(DgLogicInventoryTotalDto::getAvailable).reduce(BigDecimal.ZERO, BigDecimal::add);
                splitStockRecordEo.setLogicZtHgBStockNum(ztHgBLogicStockNum);
            }
        }
    }

    private void calculationStockFlag(SplitStockRecordEo splitStockRecordEo) {
        BigDecimal sgLogicStockNum = splitStockRecordEo.getSgLogicStockNum() == null ? BigDecimal.ZERO : splitStockRecordEo.getSgLogicStockNum();
        BigDecimal sgDjStockNum = splitStockRecordEo.getSgDjStockNum() == null ? BigDecimal.ZERO : splitStockRecordEo.getSgDjStockNum();
        BigDecimal sgZtStockNum = splitStockRecordEo.getSgZtStockNum() == null ? BigDecimal.ZERO : splitStockRecordEo.getSgZtStockNum();
        BigDecimal logicZtHgStockNum = splitStockRecordEo.getLogicZtHgStockNum() == null ? BigDecimal.ZERO : splitStockRecordEo.getLogicZtHgStockNum();
        BigDecimal logicZtHgBStockNum = splitStockRecordEo.getLogicZtHgBStockNum() == null ? BigDecimal.ZERO : splitStockRecordEo.getLogicZtHgBStockNum();
        BigDecimal logicZtNum = sgLogicStockNum.add(sgZtStockNum);
        Integer logicZtStockFlag = logicZtNum.compareTo(splitStockRecordEo.getItemNum()) >= 0 ? SourceSplitLogicFlagEnum.YES.code : SourceSplitLogicFlagEnum.NO.code;
        splitStockRecordEo.setLogicZtStockFlag(logicZtStockFlag);
        BigDecimal logicDjNum = sgLogicStockNum.add(sgDjStockNum);
        Integer logicDjStockFlag = logicDjNum.compareTo(splitStockRecordEo.getItemNum()) >= 0 ? SourceSplitLogicFlagEnum.YES.code : SourceSplitLogicFlagEnum.NO.code;
        splitStockRecordEo.setLogicDjStockFlag(logicDjStockFlag);
        BigDecimal logicZtDjNum = sgLogicStockNum.add(sgDjStockNum).add(sgZtStockNum);
        Integer logicZtDjStockFlag = logicZtDjNum.compareTo(splitStockRecordEo.getItemNum()) >= 0 ? SourceSplitLogicFlagEnum.YES.code : SourceSplitLogicFlagEnum.NO.code;
        splitStockRecordEo.setLogicZtDjStockFlag(logicZtDjStockFlag);
        Integer logicZtHgStockFlag = logicZtHgStockNum.compareTo(splitStockRecordEo.getItemNum()) >= 0 ? SourceSplitLogicFlagEnum.YES.code : SourceSplitLogicFlagEnum.NO.code;
        splitStockRecordEo.setLogicZtHgStockFlag(logicZtHgStockFlag);
        Integer logicZtHgBStockFlag = logicZtHgBStockNum.compareTo(splitStockRecordEo.getItemNum()) >= 0 ? SourceSplitLogicFlagEnum.YES.code : SourceSplitLogicFlagEnum.NO.code;
        splitStockRecordEo.setLogicZtHgBStockFlag(logicZtHgBStockFlag);
    }

    private SplitStockRecordEo getSplitStockRecordEo(OrderDetailRespDto orderDetailRespDto, OrderItemRespDto orderItemRespDto) {
        SplitStockRecordEo splitStockRecordEo = new SplitStockRecordEo();
        splitStockRecordEo.setSgOrderNo(orderDetailRespDto.getSgOrderNo());
        splitStockRecordEo.setOrganizationId(orderDetailRespDto.getOrganizationId());
        splitStockRecordEo.setOrganizationCode(orderDetailRespDto.getOrganizationCode());
        splitStockRecordEo.setOrganizationName(orderDetailRespDto.getOrganizationName());
        splitStockRecordEo.setSaleOrderNo(orderDetailRespDto.getLinkOrderNo());
        splitStockRecordEo.setPlatformOrderNo(orderDetailRespDto.getLinkPlatformOrderNo());
        splitStockRecordEo.setOrderType(orderDetailRespDto.getLinkOrderType());
        splitStockRecordEo.setSkuCode(orderItemRespDto.getItemSkuCode());
        splitStockRecordEo.setItemName(orderItemRespDto.getItemName());
        splitStockRecordEo.setItemNum(orderItemRespDto.getItemNum());
        splitStockRecordEo.setSgLogicStockNum(BigDecimal.ZERO);
        splitStockRecordEo.setSgDjStockNum(BigDecimal.ZERO);
        splitStockRecordEo.setSgZtStockNum(BigDecimal.ZERO);
        splitStockRecordEo.setLogicZtHgStockNum(BigDecimal.ZERO);
        splitStockRecordEo.setLogicZtHgBStockNum(BigDecimal.ZERO);
        splitStockRecordEo.setLogicDjStockFlag(SourceSplitLogicFlagEnum.FAIL.code);
        splitStockRecordEo.setLogicZtStockFlag(SourceSplitLogicFlagEnum.FAIL.code);
        splitStockRecordEo.setLogicZtDjStockFlag(SourceSplitLogicFlagEnum.FAIL.code);
        splitStockRecordEo.setLogicZtHgStockFlag(SourceSplitLogicFlagEnum.FAIL.code);
        splitStockRecordEo.setLogicZtHgBStockFlag(SourceSplitLogicFlagEnum.FAIL.code);
        splitStockRecordEo.setIsOnline(orderDetailRespDto.getIsOnline());
        return splitStockRecordEo;
    }

    @Override
    public void saveSourceZtNumStep(SourceExecuteContextVo sourceExecuteContextVo, SourceOrderResultRespDto sourceOrderResultRespDto) {
        if (!sourceExecuteContextVo.isZtStatusFlag()) {
            logger.info("\u672a\u5f00\u542f\u5728\u9014\u53ef\u552e\u6570\u5bfb\u6e90{}", (Object)sourceExecuteContextVo.getOrderDetailRespDto().getLinkOrderNo());
            return;
        }
        if (!sourceOrderResultRespDto.getSgStatus().equals(SourceStatusEnum.SOURCE_SUCCESS.getCode())) {
            logger.info("\u5bfb\u6e90\u5931\u8d25\u4e0d\u8bb0\u5f55\u5728\u9014\u6570{}", (Object)sourceExecuteContextVo.getOrderDetailRespDto().getLinkOrderNo());
            return;
        }
        sourceOrderResultRespDto.setIntransitPreemptFlag(Boolean.TRUE);
    }

    private SaleOrderZtEo getSaleOrderZtEo(SourceOrderResultRespDto sourceOrderResultRespDto, Map<String, CsLogicWarehousePageRespDto> logicMap, OrderItemResultRespDto orderItemResultRespDto) {
        SaleOrderZtEo addEo = new SaleOrderZtEo();
        addEo.setOrganizationId(sourceOrderResultRespDto.getOrganizationId());
        addEo.setOrganizationCode(sourceOrderResultRespDto.getOrganizationCode());
        addEo.setOrganizationName(sourceOrderResultRespDto.getOrganizationName());
        addEo.setSaleOrderNo(sourceOrderResultRespDto.getLinkOrderNo());
        addEo.setPlatformOrderNo(sourceOrderResultRespDto.getLinkPlatformOrderNo());
        addEo.setIsOnline(sourceOrderResultRespDto.getIsOnline());
        addEo.setOrderItemId(orderItemResultRespDto.getLinkOrderItemId());
        addEo.setLogicWarehouseCode(orderItemResultRespDto.getDeliveryLogicWarehouseCode());
        addEo.setLogicWarehouseName(orderItemResultRespDto.getDeliveryLogicWarehouseName());
        addEo.setPhysicsWarehouseCode(logicMap.get(orderItemResultRespDto.getDeliveryLogicWarehouseCode()).getSubordinatePhysicsWarehouseCode());
        addEo.setLogicWarehouseName(logicMap.get(orderItemResultRespDto.getDeliveryLogicWarehouseCode()).getSubordinatePhysicsWarehouseName());
        addEo.setItemName(orderItemResultRespDto.getItemName());
        addEo.setSkuCode(orderItemResultRespDto.getLinkItemSkuCode());
        addEo.setLogicNum(orderItemResultRespDto.getDeliveryItemNum());
        return addEo;
    }

    private Map<String, IntransitCargoRespDto> getStringIntransitCargoRespDtoMap(SourceExecuteContextVo sourceExecuteContextVo) {
        List<IntransitCargoRespDto> intransitCargoRespDtoList = sourceExecuteContextVo.getIntransitCargoRespDtoList();
        return intransitCargoRespDtoList.stream().collect(Collectors.toMap(dto -> dto.getLogicWarehouseCode() + "_" + dto.getCargoCode(), v1 -> v1, (v1, v2) -> {
            String carLicenseNo;
            v1.setNum(v1.getNum().add(v2.getNum()));
            if (v1.getPlanArriveTime().compareTo(v2.getPlanArriveTime()) < 0) {
                v1.setPlanArriveTime(v2.getPlanArriveTime());
            }
            if (StringUtils.isEmpty((CharSequence)(carLicenseNo = v1.getCarLicenseNo())) && StringUtils.isNotEmpty((CharSequence)v2.getCarLicenseNo())) {
                carLicenseNo = v2.getCarLicenseNo();
            }
            if (StringUtils.isNotEmpty((CharSequence)v2.getCarLicenseNo()) && !carLicenseNo.contains(v2.getCarLicenseNo()) && StringUtils.isNotEmpty((CharSequence)carLicenseNo)) {
                carLicenseNo = carLicenseNo + "," + v2.getCarLicenseNo();
            }
            v1.setCarLicenseNo(carLicenseNo);
            String transferOrderNo = v1.getTransferOrderNo();
            if (StringUtils.isEmpty((CharSequence)transferOrderNo) && StringUtils.isNotEmpty((CharSequence)v2.getTransferOrderNo())) {
                transferOrderNo = v2.getTransferOrderNo();
            }
            if (StringUtils.isNotEmpty((CharSequence)v2.getTransferOrderNo()) && !transferOrderNo.contains(v2.getTransferOrderNo()) && StringUtils.isNotEmpty((CharSequence)transferOrderNo)) {
                transferOrderNo = transferOrderNo + "," + v2.getTransferOrderNo();
            }
            v1.setTransferOrderNo(transferOrderNo);
            return v1;
        }));
    }

    static {
        ALL_MATCH_CODE_SET.add(ClueSuitSelectTypeEnum.ALL.getCode() + "_" + ClueSuitTypeEnum.HIT_WAREHOUSE + "_" + ClueSuitSelectTypeEnum.ALL.getCode());
        ALL_MATCH_CODE_SET.add(ClueSuitSelectTypeEnum.ALL.getCode() + "_" + ClueSuitTypeEnum.HIT_ORDER_TYPE + "_" + ClueSuitSelectTypeEnum.ALL.getCode());
        ALL_MATCH_CODE_SET.add(ClueSuitSelectTypeEnum.ALL.getCode() + "_" + ClueSuitTypeEnum.HIT_CUSTOMER + "_" + ClueSuitSelectTypeEnum.ALL.getCode());
        ALL_MATCH_CODE_SET.add(ClueSuitSelectTypeEnum.ALL.getCode() + "_" + ClueSuitTypeEnum.HIT_CHANNEL + "_" + ClueSuitSelectTypeEnum.ALL.getCode());
        ALL_MATCH_CODE_SET.add(ClueSuitSelectTypeEnum.ALL.getCode() + "_" + ClueSuitTypeEnum.HIT_ORGANIZATION + "_" + ClueSuitSelectTypeEnum.ALL.getCode());
        ALL_MATCH_CODE_SET.add(ClueSuitSelectTypeEnum.ALL.getCode() + "_" + ClueSuitTypeEnum.HIT_CHANNEL_WAREHOUSE + "_" + ClueSuitSelectTypeEnum.ALL.getCode());
        ALL_MATCH_CODE_SET.add(ClueSuitSelectTypeEnum.ALL.getCode() + "_" + ClueSuitTypeEnum.HIT_VIRTUAL_WAREHOUSE + "_" + ClueSuitSelectTypeEnum.ALL.getCode());
    }
}

