/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.dtyunxi.cube.center.source.api.dto.request.WarehouseDeliveryThresholdReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.WarehouseDeliveryThresholdRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceAssert;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.service.IWarehouseDeliveryThresholdService;
import com.dtyunxi.cube.center.source.dao.das.WarehouseDeliveryThresholdDas;
import com.dtyunxi.cube.center.source.dao.eo.WarehouseDeliveryThresholdEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WarehouseDeliveryThresholdServiceImpl
implements IWarehouseDeliveryThresholdService {
    @Resource
    private WarehouseDeliveryThresholdDas warehouseDeliveryThresholdDas;

    @Override
    public Long addWarehouseDeliveryThreshold(WarehouseDeliveryThresholdReqDto addReqDto) {
        this.checkParam(addReqDto);
        WarehouseDeliveryThresholdEo eo = (WarehouseDeliveryThresholdEo)((ExtQueryChainWrapper)this.warehouseDeliveryThresholdDas.filter().eq((Object)"physics_warehouse_code", (Object)addReqDto.getPhysicsWarehouseCode())).one();
        if (eo != null) {
            throw new BizException("\u8be5\u4ed3\u5e93\u53d1\u8d27\u9608\u503c\u5df2\u5b58\u5728");
        }
        WarehouseDeliveryThresholdEo warehouseDeliveryThresholdEo = new WarehouseDeliveryThresholdEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)warehouseDeliveryThresholdEo);
        this.warehouseDeliveryThresholdDas.insert((BaseEo)warehouseDeliveryThresholdEo);
        return warehouseDeliveryThresholdEo.getId();
    }

    @Override
    public void modifyWarehouseDeliveryThreshold(WarehouseDeliveryThresholdReqDto modifyReqDto) {
        SourceAssert.notNull((Object)modifyReqDto.getId(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u4e3b\u952eid"});
        this.checkParam(modifyReqDto);
        WarehouseDeliveryThresholdEo eo = (WarehouseDeliveryThresholdEo)this.warehouseDeliveryThresholdDas.selectByPrimaryKey(modifyReqDto.getId());
        SourceAssert.notNull((Object)eo, (SourceExceptionCode)SourceExceptionCode.ID_FALL, (String[])new String[0]);
        WarehouseDeliveryThresholdEo warehouseDeliveryThresholdEo = new WarehouseDeliveryThresholdEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)warehouseDeliveryThresholdEo);
        warehouseDeliveryThresholdEo.setId(eo.getId());
        this.warehouseDeliveryThresholdDas.updateSelective((BaseEo)warehouseDeliveryThresholdEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeWarehouseDeliveryThreshold(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.warehouseDeliveryThresholdDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public WarehouseDeliveryThresholdRespDto queryById(Long id) {
        WarehouseDeliveryThresholdEo warehouseDeliveryThresholdEo = (WarehouseDeliveryThresholdEo)this.warehouseDeliveryThresholdDas.selectByPrimaryKey(id);
        if (warehouseDeliveryThresholdEo == null) {
            return null;
        }
        WarehouseDeliveryThresholdRespDto warehouseDeliveryThresholdRespDto = new WarehouseDeliveryThresholdRespDto();
        DtoHelper.eo2Dto((BaseEo)warehouseDeliveryThresholdEo, (BaseVo)warehouseDeliveryThresholdRespDto);
        return warehouseDeliveryThresholdRespDto;
    }

    @Override
    public List<WarehouseDeliveryThresholdRespDto> queryByWarehouseCodes(List<String> warehouseCodes) {
        List resultList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.warehouseDeliveryThresholdDas.filter().in((Object)"physics_warehouse_code", warehouseCodes)).eq((Object)"dr", (Object)0)).list(Integer.valueOf(10000));
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            ArrayList<WarehouseDeliveryThresholdRespDto> respDtoList = new ArrayList<WarehouseDeliveryThresholdRespDto>();
            CubeBeanUtils.copyCollection(respDtoList, (Collection)resultList, WarehouseDeliveryThresholdRespDto.class);
            return respDtoList;
        }
        return null;
    }

    @Override
    public PageInfo<WarehouseDeliveryThresholdRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        WarehouseDeliveryThresholdReqDto warehouseDeliveryThresholdReqDto = (WarehouseDeliveryThresholdReqDto)JSON.parseObject((String)filter, WarehouseDeliveryThresholdReqDto.class);
        LambdaQueryWrapper<WarehouseDeliveryThresholdEo> wrapper = this.queryWrapper(warehouseDeliveryThresholdReqDto);
        IPage page = this.warehouseDeliveryThresholdDas.getMapper().selectPage((IPage)new Page((long)pageNum.intValue(), (long)pageSize.intValue()), wrapper);
        PageInfo eoPageInfo = new PageInfo(page.getRecords());
        eoPageInfo.setPageNum(pageNum.intValue());
        eoPageInfo.setPageSize(pageSize.intValue());
        eoPageInfo.setPages((int)page.getPages());
        eoPageInfo.setTotal(page.getTotal());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, WarehouseDeliveryThresholdRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSave(List<WarehouseDeliveryThresholdReqDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List eoList = ((ExtQueryChainWrapper)this.warehouseDeliveryThresholdDas.filter().in((Object)"physics_warehouse_code", (Collection)list.stream().map(WarehouseDeliveryThresholdReqDto::getPhysicsWarehouseCode).collect(Collectors.toList()))).list(Integer.valueOf(list.size()));
        ArrayList insertEoList = Lists.newArrayList();
        ArrayList updateEoList = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)eoList)) {
            DtoHelper.dtoList2EoList(list, (Collection)insertEoList, WarehouseDeliveryThresholdEo.class);
        } else {
            Map eoMap = eoList.stream().collect(Collectors.toMap(WarehouseDeliveryThresholdEo::getPhysicsWarehouseCode, Function.identity(), (k1, k2) -> k1));
            list.stream().forEach(i -> {
                String physicsWarehouseCode = i.getPhysicsWarehouseCode();
                WarehouseDeliveryThresholdEo eo = new WarehouseDeliveryThresholdEo();
                if (eoMap.containsKey(physicsWarehouseCode)) {
                    eo = (WarehouseDeliveryThresholdEo)eoMap.get(physicsWarehouseCode);
                    eo.setThreshold(i.getThreshold());
                    updateEoList.add(eo);
                } else {
                    DtoHelper.dto2Eo((BaseVo)i, (BaseEo)eo);
                    insertEoList.add(eo);
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)insertEoList)) {
            this.warehouseDeliveryThresholdDas.insertBatch((List)insertEoList);
        }
        if (CollectionUtils.isNotEmpty((Collection)updateEoList)) {
            updateEoList.forEach(i -> this.warehouseDeliveryThresholdDas.updateSelective((BaseEo)i));
        }
    }

    private LambdaQueryWrapper<WarehouseDeliveryThresholdEo> queryWrapper(WarehouseDeliveryThresholdReqDto reqDto) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (reqDto != null) {
            if (Objects.nonNull(reqDto.getId())) {
                wrapper.eq(BaseEo::getId, (Object)reqDto.getId());
            }
            if (StringUtils.isNotEmpty((CharSequence)reqDto.getPhysicsWarehouseCode())) {
                wrapper.like(WarehouseDeliveryThresholdEo::getPhysicsWarehouseCode, (Object)("%" + reqDto.getPhysicsWarehouseCode() + "%"));
            }
            if (CollectionUtils.isNotEmpty((Collection)reqDto.getPhysicsWarehouseCodes())) {
                wrapper.in(WarehouseDeliveryThresholdEo::getPhysicsWarehouseCode, (Collection)reqDto.getPhysicsWarehouseCodes());
            }
            wrapper.eq(BaseEo::getDr, (Object)0);
            wrapper.orderByDesc(BaseEo::getCreateTime);
        }
        return wrapper;
    }

    private void checkParam(WarehouseDeliveryThresholdReqDto addReqDto) {
        SourceAssert.notNull((Object)addReqDto.getPhysicsWarehouseCode(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u7269\u7406\u4ed3\u5e93\u7f16\u53f7"});
        SourceAssert.notNull((Object)addReqDto.getThreshold(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u53d1\u8d27\u9608\u503c"});
        SourceAssert.lessThanZero((BigDecimal)addReqDto.getThreshold(), (SourceExceptionCode)SourceExceptionCode.THRESHOLD_GT_ZERO, (String[])new String[0]);
    }
}

