/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.track.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.center.track.api.dto.request.TransactionReqDto;
import com.dtyunxi.cube.center.track.api.dto.response.TransactionRespDto;
import com.dtyunxi.cube.center.track.biz.service.ITransactionNodeService;
import com.dtyunxi.cube.center.track.biz.service.ITransactionService;
import com.dtyunxi.cube.center.track.dao.das.TransactionDas;
import com.dtyunxi.cube.center.track.dao.eo.TransactionEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TransactionServiceImpl
implements ITransactionService {
    @Resource
    private TransactionDas transactionDas;
    @Resource
    private ITransactionNodeService transactionNodeService;

    @Override
    public Long addTransaction(TransactionReqDto addReqDto) {
        TransactionEo transactionEo = new TransactionEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)transactionEo);
        if (transactionEo.getOverTransactionId() == null) {
            Long id = this.getId();
            transactionEo.setId(id);
            transactionEo.setOverTransactionId(id);
        }
        this.transactionDas.insert((BaseEo)transactionEo);
        return transactionEo.getId();
    }

    @Override
    public void modifyTransaction(TransactionReqDto modifyReqDto) {
        TransactionEo transactionEo = new TransactionEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)transactionEo);
        this.transactionDas.updateSelective((BaseEo)transactionEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeTransaction(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.transactionDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public TransactionRespDto queryById(Long id) {
        TransactionEo transactionEo = (TransactionEo)this.transactionDas.selectByPrimaryKey(id);
        TransactionRespDto transactionRespDto = new TransactionRespDto();
        DtoHelper.eo2Dto((BaseEo)transactionEo, (BaseVo)transactionRespDto);
        this.transactionNodeService.queryById(id);
        return transactionRespDto;
    }

    @Override
    public PageInfo<TransactionRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        TransactionReqDto transactionReqDto = (TransactionReqDto)JSON.parseObject((String)filter, TransactionReqDto.class);
        TransactionEo transactionEo = new TransactionEo();
        DtoHelper.dto2Eo((BaseVo)transactionReqDto, (BaseEo)transactionEo);
        PageInfo eoPageInfo = this.transactionDas.selectPage((BaseEo)transactionEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, TransactionRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    private Long getId() {
        Long tenantCode = ServiceContext.getContext().getRequestTenantCode();
        Long workerId = IdGenrator.getWorkerId();
        return IdGenrator.nextId((long)workerId, (long)tenantCode);
    }
}

