package com.dtyunxi.finance.api;

import com.dtyunxi.finance.api.dto.request.TransportModeReqDto;
import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * 承运方式服务接口
 *
 * @author 天泽
 * @since 2022-10-26
 */
@Api(tags = {"承运方式服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-ITransportModeApi",
        name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
        path = "/v1/transport/mode",
        url = "${com.dtyunxi.finance.api:}"
)
public interface ITransportModeApi {

    /**
     * 新增承运方式
     *
     * @param addReqDto 承运方式请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增承运方式", notes = "新增承运方式")
    RestResponse<Long> addTransportMode(@RequestBody TransportModeReqDto addReqDto);

    /**
     * 修改承运方式
     *
     * @param modifyReqDto 承运方式请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改承运方式", notes = "修改承运方式")
    RestResponse<Void> modifyTransportMode(@RequestBody TransportModeReqDto modifyReqDto);

    /**
     * 删除承运方式
     *
     * @param ids        承运方式删除数据ID
     * @param instanceId 实例ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除承运方式", notes = "删除承运方式")
    RestResponse<Void> removeTransportMode(@PathVariable("ids") String ids);


    /**
     * 启用禁用
     *
     * @param modifyReqDto 启用禁用
     * @return 处理结果
     */
    @PutMapping("enableDisable")
    @ApiOperation(value = "启用禁用", notes = "启用禁用")
    RestResponse<Void> enableDisable(@RequestBody TransportModeReqDto modifyReqDto);
}
