package com.dtyunxi.finance.api.dto.response;

import java.util.Date;
import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;

import com.dtyunxi.dto.BaseRespDto;
import lombok.Data;

import javax.persistence.Column;

/**
* 保险公司投保设置Eo对象
*
* @author longde
* @since 2022-07-15
*/
@Data
@ApiModel(value = "InsuranceSettingsRespDto", description = "保险公司投保设置Eo对象")
public class InsuranceSettingsRespDto extends BaseRespDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  保险公司编码（唯一，当名称变化则新生成唯一编码，修改时编码不变化）
    */
    @ApiModelProperty(name = "insuranceCode", value = "保险公司编码（唯一，当名称变化则新生成唯一编码，修改时编码不变化）")
    private String insuranceCode;
    /**
    *  保险公司名称（唯一，不能重复；需保存历史修改记录；修改时名称需重新校验是否与其他公司名称冲突）
    */
    @ApiModelProperty(name = "insuranceName", value = "保险公司名称（唯一，不能重复；需保存历史修改记录；修改时名称需重新校验是否与其他公司名称冲突）")
    private String insuranceName;
    /**
    *  费率（在0至1之间，保存3位小数通常，最高允许4位）
    */
    @ApiModelProperty(name = "insuranceRate", value = "费率（在0至1之间，保存3位小数通常，最高允许4位）")
    private BigDecimal insuranceRate;
    /**
    *  组织id
    */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;
    /**
    *  备注，前端页显示，填写一些说明信息或修改信息
    */
    @ApiModelProperty(name = "remark", value = "备注，前端页显示，填写一些说明信息或修改信息")
    private String remark;

    /**
     *  物流公司id
     */
    @ApiModelProperty(name = "logisticsId", value = "物流公司id")
    private List<Long> logisticsId;

    /**
     *  创建时间
     */
    @ApiModelProperty(name = "createTime", value = "创建时间")
    private Date createTime;
    /**
     *  修改时间
     */
    @ApiModelProperty(name = "updateTime", value = "修改时间")
    private Date updateTime;

    /**
     *  修改历史
     */
    @ApiModelProperty(name = "InsuranceSettingsLog", value = "修改历史")
    private List<InsuranceSettingsLogRespDto> modifyRecords;


}
