package com.dtyunxi.finance.api.exception.constant;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.math.BigDecimal;
import java.util.Date;

@Getter
@AllArgsConstructor
public enum SortingContractFieldEnum {

    PHYSICAL_WAREHOUSE_CODE("physicalWarehouseCode", "仓库编码", String.class, String.class, "getPhysicalWarehouseCode", "setPhysicalWarehouseCode"),
    PHYSICAL_WAREHOUSE_NAME("physicalWarehouseName", "仓库名称", String.class, String.class, "getPhysicalWarehouseName", "setPhysicalWarehouseName"),
    LARGE_BOX_PRICE("largeBoxPrice", "大箱单价", String.class, BigDecimal.class, "getLargeBoxPrice", "setLargeBoxPrice"),
    SMALL_BOX_PRICE("smallBoxPrice", "小箱单价", String.class, BigDecimal.class, "getSmallBoxPrice", "setSmallBoxPrice"),
    SINGLE_PRODUCT_PRICE("singlePrice", "单品单价", String.class, BigDecimal.class, "getSinglePrice", "setSinglePrice"),
    SALE_ORDER_CREATE_START_TIME("saleOrderCreateStartTime", "有效时间开始日期", String.class, Date.class, "getSaleOrderCreateStartTime", "setSaleOrderCreateStartTime"),
    SALE_ORDER_CREATE_END_TIME("saleOrderCreateEndTime", "有效时间结束日期", String.class, Date.class, "getSaleOrderCreateEndTime", "setSaleOrderCreateEndTime"),
    STATUS("status", "状态", String.class, Integer.class, "getStatus", "setStatus"),
    CONTRACT_NAME("ContractName", "合同名称", String.class, Integer.class, "getContractName", "setContractName"),
    REMARK("remark", "备注", String.class, String.class, "getRemark", "setRemark"),;
    private String fieldName;
    private String fieldDesc;
    private Class classOfDto;
    private Class classOfEo;
    private String getMethodName;
    private String setMethodName;

}
