package com.dtyunxi.finance.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
* 承运方式Eo对象
*
* @author 天泽
* @since 2022-10-26
*/
@ApiModel(value = "TransportModeReqDto", description = "承运方式Eo对象")
public class TransportModeReqDto extends RequestDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  物流商类型 1-物流 2-快递
    */
    @ApiModelProperty(name = "type", value = "物流商类型 1-物流 2-快递")
    private Long type;
    /**
    *  物流商编码
    */
    @ApiModelProperty(name = "code", value = "物流商编码")
    private String code;
    /**
    *  承运方式
    */
    @ApiModelProperty(name = "transportMode", value = "承运方式")
    private String transportMode;
    /**
    *  状态0启用 1禁用
    */
    @ApiModelProperty(name = "status", value = "状态0启用 1禁用")
    private String status;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setType(Long type){
    this.type = type;
    }
    public Long getType(){
    return this.type;
    }
    public void setCode(String code){
    this.code = code;
    }
    public String getCode(){
    return this.code;
    }
    public void setTransportMode(String transportMode){
    this.transportMode = transportMode;
    }
    public String getTransportMode(){
    return this.transportMode;
    }
    public void setStatus(String status){
    this.status = status;
    }
    public String getStatus(){
    return this.status;
    }
}
