package com.dtyunxi.finance.api.dto.request.logistic;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Pattern;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TemplateCommonDto", description = "指定区域公用Dto")
public class TemplateCommonDto extends BaseVo {

    @ApiModelProperty(name = "templateId",value = "物流费设置模板id")
    private String templateId;//'物流费设置模板id',

    @ApiModelProperty(name = "type",value = "幅度类型 0：统一月份 1：淡旺季")
    private Integer type;//'幅度类型 0：统一月份 1：淡旺季',

    @ApiModelProperty(name = "province",value = "省份")
    private String province;// '省份',

    @ApiModelProperty(name = "city",value = "城市")
    private String city;//'城市',

    @ApiModelProperty(name = "area",value = "区/县")
    private String area;//'区/县',

    @ApiModelProperty(name = "day",value = "预计到达天数")
    @Pattern(regexp = "^[1-9]\\d*$",message = "预计到达天数为正整数")
    private Integer day;//'预计到达天数',
}
