package com.dtyunxi.finance.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.finance.api.dto.entity.BasePageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

/**
* 财务关账设置Eo对象
*
* @author mc
* @since 2022-11-02
*/
@ApiModel(value = "CloseAccSettingReqDto", description = "财务关账设置Eo对象")
@Getter
@Setter
public class CloseAccSettingReqDto extends BasePageDto {
    /**
    *  
    */
    @ApiModelProperty(name = "id", value = "")
    private Long id;
    /**
    *  配置编码
    */
    @ApiModelProperty(name = "code", value = "配置编码")
    private String code;
    /**
    *  销售组织id
    */
    @ApiModelProperty(name = "organizationId", value = "销售组织id")
    private Long organizationId;
    /**
     *  销售组织id
     */
    @ApiModelProperty(name = "organizationIdSet", value = "销售组织id集合")
    private Set<Long> organizationIdSet;
    /**
    *  销售组织编码
    */
    @ApiModelProperty(name = "organizationCode", value = "销售组织编码")
    private String organizationCode;
    /**
     *  销售组织编码集合
     */
    @ApiModelProperty(name = "organizationCodeSet", value = "销售组织编码集合")
    private Set<String> organizationCodeSet;
    /**
    *  销售组织名称
    */
    @ApiModelProperty(name = "organizationName", value = "销售组织名称")
    private String organizationName;
    /**
    *  状态
    */
    @ApiModelProperty(name = "status", value = "状态")
    private Integer status;
    /**
    *  关账时间
    */
    @ApiModelProperty(name = "closeTime", value = "关账时间")
    private Date closeTime;

    /**
     *  关账时间开始
     */
    @ApiModelProperty(name = "closeTimeStart", value = "关账时间开始")
    private Date closeTimeStart;
    /**
     *  关账时间开始
     */
    @ApiModelProperty(name = "closeTimeEnd", value = "关账时间结束")
    private Date closeTimeEnd;
    /**
     *  创建时间开始
     */
    @ApiModelProperty(name = "createTimeStart", value = "创建时间开始")
    private Date createTimeStart;

    @ApiModelProperty(name = "createTimeEnd", value = "创建时间结束")
    private Date createTimeEnd;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

}
