package com.dtyunxi.finance.api.exception;

import com.dtyunxi.cube.commons.exceptions.BizException;
import lombok.Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

import java.util.Map;

/**
 * @Author 云焕
 * @Description
 * @Date 2022/7/17 11:30
 * @Param
 * @return
 */
@Data
public class FinanceException extends BizException {

    private static Logger logger = LoggerFactory.getLogger(FinanceException.class);
    private String errorCode;
    private String errorMsg;


    public FinanceException(String errorCode, String errorMsg) {
        super(errorMsg);
        logger.info("code:{},message:{}",errorCode,errorMsg);
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }

    public static void  throwException(FinanceExceptionEnum accountExEnum)throws FinanceException {
        String code = accountExEnum.getCode();
        String message = accountExEnum.getMessage();
        logger.info("code:{},message:{}",code,message);
        throw new FinanceException(code,message);
    }

    /***
     * 抛出动态自定义信息
     * @param accountExEnum
     * @param message
     * @throws FinanceException
     */
    public static void  throwException(FinanceExceptionEnum accountExEnum, String message)throws FinanceException {
        String code = accountExEnum.getCode();
        logger.info("code:{},message:{}",code,message);
        throw new FinanceException(code,message);
    }


    /***
     * 抛出动态自定义信息
     * @param FinanceExceptionEnum
     * @param message
     */
    public static void  throwCustomException(FinanceExceptionEnum FinanceExceptionEnum,String message)throws FinanceException{
        String code = FinanceExceptionEnum.getCode();
        String exceptionMessage = FinanceExceptionEnum.getMessage();
        logger.info("code:{},message:{}",code,message);
        throw new FinanceException(code,message + exceptionMessage);
    }
}
